/*-----------------------------------------------------------------
  All code is provided for EDUCATIONAL purposes ONLY. There is no
  warranty and no support.

  thermostat2 by Jack Botner

  main.h
-----------------------------------------------------------------*/
#ifndef _MAIN_H_
#define _MAIN_H_

#include "common.h"

#define INIT_TIMER0			( 256 - 250 )
#define INIT_TIMER1			( 65536 - 31250 )
#define INIT_TIMER2			( 256 - 250 )

#define SET_TEMP_DELTA   	5		// effect of up and down buttons on temperature
#define SYSTEM_DELAY_SEC 	5		// delay system response to user input

#define MAX_CHECKS       	6		// number of tests before a switch is debounced

// Hysteresis constants (tenths degrees C) are the amount above and below the
// set temperature that the furnace or A/C will run. The wider the range, the
// longer the unit runs and the greater the temperature variation. There is a
// balance between comfort and efficient operation of the unit. There is also
// some dependency on the thermal mass of the temperature sensor; less mass
// requires greater hysteresis and vice-versa. There is also some dependency on
// the ability of the unit to change the temperature over time. These are
// initial values, which can be changed via customization.
#define HYSTERESIS_HEAT     6       // 10ths degrees C of hysteresis
#define HYSTERESIS_COOL     3

// System modes bits
#define MODE_FAN_ON			0
#define MODE_HEAT_ON		1
#define MODE_COOL_ON		2

// Events bits
#define EVENT_UPDATE_LCD		0
#define EVENT_ANALYZE_STATE		1
#define EVENT_CONVERT_TEMP		2
#define EVENT_UPDATE_EEPROM		3
#define EVENT_BUTTON_PRESSED	4
#define EVENT_ENCODER_UP		5
#define EVENT_ENCODER_DOWN		6
#define EVENT_READ_RTC			7
#define EVENT_SET_RTC			8

// Debounced switches bits
#define ENC_SWITCH_A			0
#define ENC_SWITCH_B			1
#define ENC_SWITCH_PB			2

// Rotary encoder port defines
#define ENCODER_PORT			PIND
#define ENCODER_A				PD6
#define ENCODER_B				PD5
#define ENCODER_PB				PD7

// LED port defines
#define LED_PORT				PORTB
#define LED_PIN					PINB
#define YEL_LED_PIN				PB1
#define WHT_LED_PIN				PB2
#define GRN_LED_PIN				PB3

// Relay port defines
#define RELAY_PORT				PORTD
#define RELAY_HEAT				PD0
#define RELAY_COOL				PD1
#define RELAY_FAN				PD2

// EEPROM stuff
typedef struct _MY_EEPROM_DATA
{
  uint16_t	uiSetTemp10C_Heat;			// last set temperature (heat)
  uint16_t	uiSetTemp10C_Cool;			// last set temperature (cool)
  uint8_t	ucSystemMode;				// system mode flags
  uint8_t	ucHysteresis_Heat;			// heat hysteresis, 10ths degrees C
  uint8_t	ucHysteresis_Cool;			// cool hysteresis, 10ths degrees C
}
MY_EEPROM_DATA;

// Functions

uint8_t pgm_clock_query(void);
void	program_clock(void);
void	program_hysteresis(void);
void	program_mode(void);
void	program_fan(void);

#endif  //_MAIN_H_
