/*-----------------------------------------------------------------
  LED_Milliohmmeter Copyright (c) 2008 by Jack Botner

  led.c

  To display numbers on a 4 digit LED display. Since no segment
  encoder chip is used, we have to do the encoding of each digit
  ourself.
-----------------------------------------------------------------*/
#include <avr/io.h>
#include <util/delay.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "led.h"

/*-----------------------------------------------------------------
  ledOutputNumber(...)

  Outputs a number to the led display. Clearing the port turns
  the corresponding segment on.

  Input: a single numeric digit, range 0..9 (ascii or binary, only
         the low-order nibble is processed.) Also the value of x'0f'
         which means blank the display.
-----------------------------------------------------------------*/

// Bit positions in the table of segments
#define SEG_A   0
#define SEG_B   1
#define SEG_C   2
#define SEG_D   3
#define SEG_E   4
#define SEG_F   5
#define SEG_G   6

void ledOutputNumber( uint8_t ucNumber )
{
  // Segment A = bit 0, and so on, for each digit 0..9
  static const uint8_t ucDigTab[10] =
  {
        0b00111111, 0b00000110, 0b01011011, 0b01001111, 0b01100110,
        0b01101101, 0b01111101, 0b00000111, 0b11111111, 0b01100111
  };

  uint8_t ucNibble, ucSegments;

  ucNibble = ucNumber & 0x0f;
  ucSegments = ( ucNibble > 9 ) ? 0 : ucDigTab[ucNibble];

  if ( test_bit( ucSegments, SEG_A ) )
    set_bit( SEG_A_PORT, SEG_A_BIT );
  else
    clear_bit( SEG_A_PORT, SEG_A_BIT );

  if ( test_bit( ucSegments, SEG_B ) )
    set_bit( SEG_B_PORT, SEG_B_BIT );
  else
    clear_bit( SEG_B_PORT, SEG_B_BIT );

  if ( test_bit( ucSegments, SEG_C ) )
    set_bit( SEG_C_PORT, SEG_C_BIT );
  else
    clear_bit( SEG_C_PORT, SEG_C_BIT );

  if ( test_bit( ucSegments, SEG_D ) )
    set_bit( SEG_D_PORT, SEG_D_BIT );
  else
    clear_bit( SEG_D_PORT, SEG_D_BIT );

  if ( test_bit( ucSegments, SEG_E ) )
    set_bit( SEG_E_PORT, SEG_E_BIT );
  else
    clear_bit( SEG_E_PORT, SEG_E_BIT );

  if ( test_bit( ucSegments, SEG_F ) )
    set_bit( SEG_F_PORT, SEG_F_BIT );
  else
    clear_bit( SEG_F_PORT, SEG_F_BIT );

  if ( test_bit( ucSegments, SEG_G ) )
    set_bit( SEG_G_PORT, SEG_G_BIT );
  else
    clear_bit( SEG_G_PORT, SEG_G_BIT );
}

/*---------------------------------------------------------------------
  ledSelectDigit(...)
  
  Selects a digit of the led display, by turning on the requested
  driver transistor.
  
  Input: a single numeric digit, range 0..3. 0 drives the high order
         digit, 3 drives the low order digit.
---------------------------------------------------------------------*/
void ledSelectDigit( uint8_t cDigit )
{
  if ( !cDigit )
    set_bit( PORTC, PC1 );
  else
    clear_bit( PORTC, PC1 );

  if ( cDigit == 1 )
    set_bit( PORTC, PC2 );
  else
    clear_bit( PORTC, PC2 );

  if ( cDigit == 2 )
    set_bit( PORTC, PC3 );
  else
    clear_bit( PORTC, PC3 );

  if ( cDigit == 3 )
    set_bit( PORTC, PC4 );
  else
    clear_bit( PORTC, PC4 );
}

