/*---------------------------------------------------------------------
  Module: rtc.h
---------------------------------------------------------------------*/
#ifndef _RTC_H_
#define _RTC_H_

// Ports connected to NJU6355

#define RTC_TRIS    trisc
#define RTC_PORT    portc
#define RTC_CLK     0x05
#define RTC_DATA    0x07
#define RTC_IO      0x06
#define RTC_CE      0x04


// Real Time Clock parameters

typedef struct _RTCparms
{
  unsigned char rtc_year;
  unsigned char rtc_month;
  unsigned char rtc_day;
  unsigned char rtc_dayweek;
  unsigned char rtc_hours;
  unsigned char rtc_mins;
  unsigned char rtc_secs;
}
RTCPARMS;

// Functions

void rtc_init( void );
void rtc_read( void );
void rtc_write( void );

#endif  //_RTC_H_