/*--------------------------------------------------------------------
  All code is provided for EDUCATIONAL purposes ONLY. There is no
  warranty and no support. Licensed under the MIT license - see
  http://www.qsl.net/ve3lny/MIT%20License.html
-------------------------------------------------------------------*/
#include <avr/io.h>
#include "common.h"
#include "led.h"

uint8_t uiDecimal_digit=0;

/*---------------------------------------------------------------------
  ledSelectDigit(...)

  Selects a digit of the led display. Ports PB5, PA2 and PB4 drive each
  digit of the LED display, where PB4 drives the high order digit and
  PB5 drives the low order digit.

  Input: a single numeric digit, range 0..2. 0 drives the high order
         digit, 2 drives the low order digit. To turn off all digits,
         pass a number > 2.
---------------------------------------------------------------------*/
void ledSelectDigit( char cDigit )
{

  switch ( cDigit )
  {
    case 0:
      clear_bit( PORTB, PB5 );
	  if ( !uiDecimal_digit)
        clear_bit( PORTB, PB3 );		// DP on
      break;
    case 1:
      clear_bit( PORTA, PA2 );
	  if ( uiDecimal_digit == 1 )
        clear_bit( PORTB, PB3 );		// DP on
      break;
    case 2:
      clear_bit( PORTB, PB4 );
	  if ( uiDecimal_digit == 2 )
        clear_bit( PORTB, PB3 );		// DP on
      break;
    case NO_DIGIT:
      set_bit( PORTB, PB5 );
      set_bit( PORTA, PA2 );
      set_bit( PORTB, PB4 );
      set_bit( PORTB, PB3 );			// DP off
  }
}

/*---------------------------------------------------------------------
  ledOutputNumber(...)

  Outputs a number to the led display. Ports PA4..PA7 are connected
  to the A-B-C-D inputs of a 74LS47 which decodes the number and
  activates the corresponding segments of the bank of LEDs. 

  Input: a single numeric digit, range 0..9 (ascii or binary, only the
         low-order nibble is processed.)
---------------------------------------------------------------------*/
void ledOutputNumber( char cNumber )
{
  // Output the digit as BCD on PA4..PA7

  if ( test_bit( cNumber, 0 ) )
    set_bit( PORTA, PA4 );
  else
    clear_bit( PORTA, PA4 );

  if ( test_bit( cNumber, 1 ) )
    set_bit( PORTA, PA5 );
  else
    clear_bit( PORTA, PA5 );

  if ( test_bit( cNumber, 2 ) )
    set_bit( PORTA, PA6 );
  else
    clear_bit( PORTA, PA6 );

  if ( test_bit( cNumber, 3 ) )
    set_bit( PORTA, PA7 );
  else
    clear_bit( PORTA, PA7 );
}
