/*--------------------------------------------------------------------
  led.c  by Jack Botner
--------------------------------------------------------------------*/
#include <avr/io.h>
#include "main.h"

extern volatile uint8_t ucPowerState;		// power: 0=off, 1=on

/*---------------------------------------------------------------------
  ledOutputNumber(...)

  Outputs a number to the led display. Ports PA1..PA7 are connected
  to the A..G segments of the LED display. Clearing the port turns
  the corresponding segment on. If in the power off state, the
  display is blanked.

  Input: a single numeric digit, range 0..9 (ascii or binary, only the
         low-order nibble is processed.)
---------------------------------------------------------------------*/
void ledOutputNumber( char cNumber )
{
  // Segment A = bit 0, and so on, for each digit 0..9
  static const uint8_t ucDigTab[10] =
  {
	0b00111111, 0b00000110, 0b01011011, 0b01001111, 0b01100110,
	0b01101101, 0b01111101, 0b00000111, 0b11111111, 0b01100111
  };

  uint8_t	ucNibble, ucSegments;

  if ( !ucPowerState )
  {
    set_bit( PORTA, PA1 );      // all off
    set_bit( PORTA, PA2 );
    set_bit( PORTA, PA3 );
    set_bit( PORTA, PA4 );
    set_bit( PORTA, PA5 );
    set_bit( PORTA, PA6 );
    set_bit( PORTA, PA7 );
	return;
  }

  ucNibble = (uint8_t) cNumber & 0x0f;
  ucSegments = ( ucNibble > 9 ) ? 0 : ucDigTab[ucNibble];

  if ( test_bit( ucSegments, SEG_A ) )
    clear_bit( PORTA, PA1 );
  else
    set_bit( PORTA, PA1 );

  if ( test_bit( ucSegments, SEG_B ) )
    clear_bit( PORTA, PA2 );
  else
    set_bit( PORTA, PA2 );

  if ( test_bit( ucSegments, SEG_C ) )
    clear_bit( PORTA, PA3 );
  else
    set_bit( PORTA, PA3 );

  if ( test_bit( ucSegments, SEG_D ) )
    clear_bit( PORTA, PA4 );
  else
    set_bit( PORTA, PA4 );

  if ( test_bit( ucSegments, SEG_E ) )
    clear_bit( PORTA, PA5 );
  else
    set_bit( PORTA, PA5 );

  if ( test_bit( ucSegments, SEG_F ) )
    clear_bit( PORTA, PA6 );
  else
    set_bit( PORTA, PA6 );

  if ( test_bit( ucSegments, SEG_G ) )
    clear_bit( PORTA, PA7 );
  else
    set_bit( PORTA, PA7 );
}
