/*-----------------------------------------------------------------
  interrupt.c  by Jack Botner

  This module contains the interrupt handler.
-----------------------------------------------------------------*/
#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include "main.h"

extern volatile uint8_t  ucEventFlags;		// event flags

/*-----------------------------------------------------------------
  ISR(TIMER1_OVF_vect)

  Timer 1 overflow interrupt handler. Generates 2ms interrupts for
  timing purposes. 

  System clock frequency = 4 mHz
  System clock period = 250 ns
  Prescaler = 32
  Timer count period = 16 us
  Counts = 250
  Interrupt period = 2 ms
-----------------------------------------------------------------*/
ISR(TIMER1_OVF_vect)
{
  static volatile uint8_t ucPwmCtr=0;

  // switch debouncing 2 ms  
  set_bit( ucEventFlags, EVENT_DEBOUNCE_IO );

  // Refresh the LED 2 ms
  set_bit( ucEventFlags, EVENT_REFRESH_LED );

  // Generate a 100 ms event for pwm management.

  ++ucPwmCtr;
  if ( ucPwmCtr == 50 )		// 50 x 2ms
  {
	set_bit( ucEventFlags, EVENT_100MS_PWM );
	ucPwmCtr = 0;
  }

  TCNT1 = INIT_TIMER1;		// reset the timer1 counter
}

