unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Math, ExtCtrls;

type
  TForm1 = class(TForm)
    SG: TStringGrid;
    Frq: TEdit;
    Label1: TLabel;
    FQ: TStringGrid;
    Speed: TComboBox;
    Smod: TComboBox;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Calculate;
    procedure Recalc;
    procedure FrqChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedChange(Sender: TObject);
    procedure SmodChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormCreate(Sender: TObject);
begin
  with SG do
  begin
    Cells[0,0] := '. .';
    Cells[1,0] := ' TH1';
    Cells[2,0] := '  V /';
    Cells[3,0] := '.%';
    Cells[4,0] := 'SMOD';
  end;
  with FQ do
  begin
    Cells[0,0] := ' TH1';
    Cells[1,0] := '  Fosc';
    Cells[2,0] := '.  5%';
  end;
    Speed.Items.Add('38400');
    Speed.Items.Add('19200');
    Speed.Items.Add('9600');
    Speed.Items.Add('4800');
    Speed.Items.Add('2400');
    Speed.Items.Add('1200');
    Speed.Items.Add('600');
    Speed.Items.Add('300');
    Speed.Items.Add('110');
    Speed.ItemIndex:= 1;
    Smod.Items.Add('SMOD=0');
    Smod.Items.Add('SMOD=1');
    Smod.ItemIndex:= 1;
    Frq.Text:= '11056';
    Calculate;
    Recalc;

end;

procedure TForm1.Calculate;
var X, Y, i, k, Fosc, Code, SMOD: Integer;
    V, V0, N: Real;
begin
    Val(Frq.Text, Fosc, Code);
    k:= 1;
    for SMOD:= 0 to 1 do begin
        V:= 38.4;
        for i:=1 to 7 do begin
            Y:= round(Fosc*power(2,SMOD)/(32*12*V));
            X:= 256-Y;
            if Y<>0 then begin
                V0:= Fosc*power(2,SMOD)/(32*12*Y);
                N:= (V-V0)/V*100;
                SG.Cells[0,k]:= '  ' + IntToStr(round(V*1000));
                SG.Cells[1,k]:= '  ' + IntToHex(X,2);
                SG.Cells[2,k]:= '  ' + FloatToStrF(V0*1000,ffFixed,7,2);
                SG.Cells[3,k]:= '  ' + FloatToStrF(N,ffFixed,2,2);
                SG.Cells[4,k]:= '  ' + IntToStr(SMOD);
            end else SG.Cells[0,k]:= '  ' + IntToStr(round(V*1000));
        V:= V/2; inc(k);
        end;
    end;
end;

Procedure TForm1.Recalc;
var V,SM,Code,i: integer;
    F: real;
Label Finish;
begin
    for i:= 1 to 255 do for V:= 0 to 2 do begin FQ.Cells[V,i]:='' end;
    Val(Speed.Text, V, Code);
    SM:= Smod.ItemIndex;
    for i:= 1 to 255 do begin
        F:= i*32/power(2,SM)*12*(V/1000);
        if F>24000 then goto Finish;
        FQ.Cells[0,i]:= '  ' + IntToHex(256-i,2);
        FQ.Cells[1,i]:= ' ' + FloatToStrF(F,ffFixed,5,2);
        FQ.Cells[2,i]:= FloatToStrF(F*0.95,ffFixed,5,2) + '-' +
                        FloatToStrF(F*1.05,ffFixed,5,2)

   end;
Finish:
end;

procedure TForm1.FrqChange(Sender: TObject);
begin
    Calculate;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
    Application.Terminate;
end;

procedure TForm1.SpeedChange(Sender: TObject);
begin
    Recalc;
end;

procedure TForm1.SmodChange(Sender: TObject);
begin
    Recalc;
end;

end.
