#ifndef __WTIME_H
#define __WTIME_H

#include <windows>

#ifndef _QWORD_DEFINED
typedef DWORDLONG QWORD;
#define _QWORD_DEFINED
#endif

// Enhanced FILETIME stucture with encapsulated API functions,
// compare operators and type conversions
struct WFileTime : public FILETIME
{
   // Get current time function
   void GetUTC()
   {
      GetSystemTimeAsFileTime(this);
   }

   // Time compare operators
   bool operator ==(CONST WFileTime &wft) const
   {
      return !CompareFileTime(this, &wft);
   }

   bool operator >(CONST WFileTime &wft) const
   {
      return CompareFileTime(this, &wft) > 0;
   }

   bool operator >=(CONST WFileTime &wft) const
   {
      return CompareFileTime(this, &wft) >= 0;
   }

   bool operator <(CONST WFileTime &wft) const
   {
      return CompareFileTime(this, &wft) < 0;
   }

   bool operator <=(CONST WFileTime &wft) const
   {
      return CompareFileTime(this, &wft) <= 0;
   }

   // Convert to DOS FAT date and time
   BOOL ToDOS(LPWORD lpFatDate, LPWORD lpFatTime) const
   {
      return FileTimeToDosDateTime(this, lpFatDate, lpFatTime);
   }

   BOOL ToLocal(LPFILETIME lpft) const
   {
      return FileTimeToLocalFileTime(this, lpft);
   }

   BOOL ToUTC(LPFILETIME lpft) const
   {
      return LocalFileTimeToFileTime(this, lpft);
   }

   // Type conversions
   operator QWORD() const
   {
      return *(QWORD*)this;
   }

   // Constructors
   WFileTime(FILETIME &ft)
   {
      *(FILETIME*)this = ft;
   }

   WFileTime(CONST SYSTEMTIME &st)
   {
      SystemTimeToFileTime(&st, this);
   }

   // Construct from QWORD value
   WFileTime(QWORD qw)
   {
      *(QWORD*)this = qw;
   }

   // Construct from DOS FAT date and time
   WFileTime(WORD wFatDate, WORD wFatTime)
   {
      DosDateTimeToFileTime(wFatDate, wFatTime, this);
   }

   // Empty constructor
   WFileTime()
   {
      *(QWORD*)this = 0;
   }
};

// Enhanced SYSTEMTIME stucture with encapsulated API functions and type
// conversions
struct WSystemTime : public SYSTEMTIME
{
   // Get/set current time functions
   void GetLocal()
   {
      GetLocalTime(this);
   }

   void GetUTC()
   {
      GetSystemTime(this);
   }

   BOOL SetLocal() const
   {
      return SetLocalTime(this);
   }

   BOOL SetUTC() const
   {
      return SetSystemTime(this);
   }

   // Special for Windows NT
   BOOL GetUTCAsTzSpecificLocal(LPTIME_ZONE_INFORMATION lpTimeZoneInformation,
      LPSYSTEMTIME lpUniversalTime)
   {
      return SystemTimeToTzSpecificLocalTime(lpTimeZoneInformation,
         lpUniversalTime, this);
   }

   // Constructors
   WSystemTime(SYSTEMTIME &st)
   {
      *(SYSTEMTIME*)this = st;
   }

   WSystemTime(CONST FILETIME &ft)
   {
      FileTimeToSystemTime(&ft, this);
   }

   WSystemTime()
   {
      ZeroMemory(this, sizeof(SYSTEMTIME));
   }
};

// Enhanced TIME_ZONE_INFORMATION stucture with encapsulated API functions
struct WTimeZoneInformation : public TIME_ZONE_INFORMATION
{
   operator TIME_ZONE_INFORMATION() const
   {
      return *(TIME_ZONE_INFORMATION*)this;
   }

   DWORD Get()
   {
      return GetTimeZoneInformation(this);
   }

   BOOL Set() const
   {
      return SetTimeZoneInformation(this);
   }
};

#endif
