#ifndef _WCOMM_H
#define _WCOMM_H

#include <windows>

// Enhanced DCB stucture with encapsulated API functions
struct WDCB : public DCB
{
   // Get/set functions
   BOOL Get(HANDLE hComm)
   {
      return GetCommState(hComm, this);
   }

   BOOL Set(HANDLE hComm)
   {
      return SetCommState(hComm, this);
   }

   // Convert pointer to DCB
   WDCB(DCB &dcb)
   {
      *(DCB*)this = dcb;
   }

   // Fill data members using MODE command line style parameter string
   BOOL Build(LPCTSTR lpDef)
   {
      ZeroMemory(this, sizeof(DCB));
      DCBlength = sizeof(DCB);   // Init length member
      return BuildCommDCB(lpDef, this);
   }

   // Empty stucture constructor
   WDCB()
   {
      ZeroMemory(this, sizeof(DCB));
      DCBlength = sizeof(DCB);   // Init length member
   }

   // Construct from MODE command line style parameter string
   WDCB(LPCTSTR lpDef)
   {
      Build(lpDef);
   }

   // Construct from file handle
   WDCB(HANDLE hComm)
   {
      Get(hComm);
   }
};

// Enhanced COMMPROP stucture with encapsulated API functions
struct WCommProp : public COMMPROP
{
   // Get/set functions
   BOOL Get(HANDLE hComm)
   {
      ZeroMemory(this, sizeof(COMMPROP));
      return GetCommProperties(hComm, this);
   }

   // Convert pointer to COMMPROP
   WCommProp(COMMPROP &cp)
   {
      *(COMMPROP*)this = cp;
   }

   // Empty stucture constructor
   WCommProp()
   {
      ZeroMemory(this, sizeof(COMMPROP));
   }

   // Construct from file handle
   WCommProp(HANDLE hComm)
   {
      Get(hComm);
   }
};

// Enhanced COMMTIMEOUTS stucture with encapsulated API functions
struct WCommTimeouts : public COMMTIMEOUTS
{
   // Get/set functions
   BOOL Get(HANDLE hComm)
   {
      return GetCommTimeouts(hComm, this);
   }

   BOOL Set(HANDLE hComm)
   {
      return SetCommTimeouts(hComm, this);
   }

   // Construct from COMMCONFIG
   WCommTimeouts(COMMTIMEOUTS &ct)
   {
      *(COMMTIMEOUTS*)this = ct;
   }

   // Construct from file handle
   WCommTimeouts(HANDLE hComm)
   {
      Get(hComm);
   }

   WCommTimeouts()
   {
      ZeroMemory(this, sizeof(WCommTimeouts));
   }
};

// Enhanced COMMCONFIG stucture with encapsulated API functions
struct WCommConfig : public COMMCONFIG
{
   // Get/set functions
   BOOL Get(HANDLE hComm)
   {
      ZeroMemory(this, sizeof(COMMCONFIG));
      dwSize = sizeof(COMMCONFIG);
      return GetCommConfig(hComm, this, &dwSize);
   }

   BOOL Set(HANDLE hComm)
   {
      return SetCommConfig(hComm, this, sizeof(COMMCONFIG));
   }

   BOOL Get(LPCSTR lpszName)
   {
      ZeroMemory(this, sizeof(COMMCONFIG));
      dwSize = sizeof(COMMCONFIG);
      return GetDefaultCommConfig(lpszName, this, &dwSize);
   }

   BOOL Set(LPCSTR lpszName)
   {
      return SetDefaultCommConfig(lpszName, this, sizeof(COMMCONFIG));
   }

   // Construct from COMMCONFIG
   WCommConfig(COMMCONFIG &cc)
   {
      *(COMMCONFIG*)this = cc;
   }

   // Empty stucture constructor
   WCommConfig()
   {
      ZeroMemory(this, sizeof(COMMCONFIG));
   }

   // Construct from file handle
   WCommConfig(HANDLE hComm)
   {
      Get(hComm);
   }

   // Construct from device name
   WCommConfig(LPCSTR lpszName)
   {
      Get(lpszName);
   }
};

#endif
