//---------------------------------------------------------------------------
#define VCL_FULL
#include <vcl.h>

#include <vcl/registry.hpp>

#include <filever.h>

#pragma hdrstop

#include "lrevents_CplApplet.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//---------------------------------------------------------------------------

void ShowCplAppletForm(HWND hwndOwner)
{
  TfrmCplApplet *frmCplApplet = new TfrmCplApplet(hwndOwner);
  frmCplApplet->ShowModal();
  delete frmCplApplet;
}
//---------------------------------------------------------------------------
void TfrmCplApplet::RefreshTimesList()
{
 lstTimes->Clear();
 rbDefaultSound->Checked = false;
 rbNoSound->Checked = false;
 rbSoundFile->Checked = false;

 char cBuf[6];
 for( DWORD dwIndex = 0; ; dwIndex++ )
 {
  DWORD dwBufSize = sizeof(cBuf);
  LONG lRet = RegEnumValue(RegAppKey->CurrentKey, dwIndex, cBuf, &dwBufSize, NULL,
       NULL, NULL, NULL);

  if( lRet == ERROR_NO_MORE_ITEMS )
      break;

  if( lRet == ERROR_INSUFFICIENT_BUFFER )
      continue;

  if( dwBufSize == 5 )
      if( cBuf[2] == ':' )
          lstTimes->Items->Add(cBuf);
 }

 lstTimesClick(lstTimes);
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::FormCreate(TObject *Sender)
{
  Top = (Screen->Height - Height) >> 1;
  Left = Top;

  RegAppKey = new TRegistry;
  RegAppKey->RootKey = HKEY_LOCAL_MACHINE;
  RegAppKey->OpenKey("Software\\SM6XMK\\LightRepeater", true);

  bitRestorePathClick(NULL);
  RefreshTimesList();
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::FormDestroy(TObject *Sender)
{
  PlaySound(NULL, NULL, SND_PURGE);
  delete RegAppKey;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::lstTimesClick(TObject *Sender)
{
  txtNewTimeHour->Text = "";
  txtNewTimeMinute->Text = "";
  txtSoundFile->Text = "";

  if( lstTimes->ItemIndex < 0 )
  {
    grpSound->Visible = false;
    btnNewEvent->Enabled = false;
    btnDeleteEvent->Enabled = false;
    return;
  }

  grpSound->Visible = true;
  btnDeleteEvent->Enabled = true;

  AnsiString astr = RegAppKey->ReadString(lstTimes->Items->Strings[lstTimes->ItemIndex]);
  if( astr == NULL )
  {
    rbDefaultSound->Checked = true;
    return;
  }
  if( astr.IsEmpty() )
  {
    rbDefaultSound->Checked = true;
    return;
  }
  if( astr == ":" )
  {
    rbNoSound->Checked = true;
    return;
  }
  rbSoundFile->Checked = true;
  txtSoundFile->Text = astr;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::bitRestorePathClick(TObject *Sender)
{
  txtVoicePath->Text = RegAppKey->ReadString("VoicePath");
  if( Sender )
    txtVoicePath->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::bitPathOKClick(TObject *Sender)
{
 RegAppKey->WriteString("VoicePath", txtVoicePath->Text);
 txtVoicePath->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::txtVoicePathEnter(TObject *Sender)
{
 bitPathOK->Default = true;
 bitRestorePath->Cancel = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::txtVoicePathExit(TObject *Sender)
{
 bitPathOK->Default = false;
 bitRestorePath->Cancel = false;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::btnDeleteEventClick(TObject *Sender)
{
 RegAppKey->DeleteValue(lstTimes->Items->Strings[lstTimes->ItemIndex]);
 RefreshTimesList();
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::txtNewTimeEnter(TObject *Sender)
{
 btnNewEvent->Default = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::txtNewTimeExit(TObject *Sender)
{
 btnNewEvent->Default = false;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::NewTime(TObject *Sender)
{
 int iNewHour = txtNewTimeHour->Text.ToIntDef(-1);
 int iNewMinute = txtNewTimeMinute->Text.ToIntDef(-1);

 if( (iNewHour > 23) | (iNewHour < 0) | (iNewMinute > 59) | (iNewMinute < 0) )
 {
     btnNewEvent->Enabled = false;
     return;
 }

 if( Sender != btnNewEvent )
 {
     btnNewEvent->Enabled = true;
     return;
 }

 char cHourBuf[6];
 wsprintf(cHourBuf, "%02i:%02i", iNewHour, iNewMinute);

 AnsiString astr = RegAppKey->ReadString(cHourBuf);
 if( astr.IsEmpty() )
     RegSetValueEx(RegAppKey->CurrentKey, cHourBuf, 0, REG_SZ, (LPBYTE)"", 1);
 else
     RegAppKey->WriteString(cHourBuf, astr);

 RefreshTimesList();

 for( int c = 0; c < lstTimes->Items->Count; c++ )
 {
  if( lstTimes->Items->Strings[c] != cHourBuf )
      continue;

  lstTimes->ItemIndex = c;
 }

 lstTimesClick(lstTimes);
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::btnLoadSoundFileNameClick(TObject *Sender)
{
 OPENFILENAME ofn;
 char cFileBuf[MAX_PATH+1];
 ofn.hwndOwner = Handle;
 ofn.lStructSize = sizeof(ofn);
 ofn.lpstrFilter = "Wave files\x0*.wav\x0";
 ofn.lpstrCustomFilter = NULL;
 ofn.nFilterIndex = 0;
 ofn.lpstrFile = lstrcpyn(cFileBuf, txtSoundFile->Text.c_str(), sizeof(cFileBuf));
 ofn.nMaxFile = sizeof(cFileBuf);
 ofn.lpstrFileTitle = NULL;
 ofn.lpstrInitialDir = NULL;
 ofn.lpstrTitle = "Select sound file";
 ofn.Flags = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
 ofn.lpstrDefExt = "wav";
 if( !GetOpenFileName(&ofn) )
     return;

 txtSoundFile->Text = cFileBuf;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::SelectSoundEnter(TObject *Sender)
{
 bitSaveSound->Default = true;
 bitUndoSound->Cancel = true;
 if( Sender == rbSoundFile )
 {
     rbSoundFile->Checked = true;
     txtSoundFile->SetFocus();
 }
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::SelectSoundExit(TObject *Sender)
{
 bitSaveSound->Default = false;
 bitUndoSound->Cancel = false;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::bitUndoSoundClick(TObject *Sender)
{
 lstTimesClick(lstTimes);
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::txtSoundFileChange(TObject *Sender)
{
 if( txtSoundFile->Text.IsEmpty() )
     btnTestSound->Enabled = false;
 else
 {
     btnTestSound->Enabled = true;
     rbSoundFile->Checked = true;
 }
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::bitSaveSoundClick(TObject *Sender)
{
 if( rbDefaultSound->Checked )
     RegSetValueEx(RegAppKey->CurrentKey, lstTimes->Items->Strings[lstTimes->ItemIndex].c_str(), 0, REG_SZ, (LPBYTE)"", 1);

 if( rbNoSound->Checked )
     RegSetValueEx(RegAppKey->CurrentKey, lstTimes->Items->Strings[lstTimes->ItemIndex].c_str(), 0, REG_SZ, (LPBYTE)":", 2);

 if( rbSoundFile->Checked )
     RegAppKey->WriteString(lstTimes->Items->Strings[lstTimes->ItemIndex], txtSoundFile->Text);

 lstTimesClick(lstTimes);
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::btnAboutClick(TObject *Sender)
{
 char cModuleFileName[MAX_PATH] = "";
 GetModuleFileName(GetModuleHandle("lrevents.cpl"), cModuleFileName, sizeof(cModuleFileName));
 FileVerInfo fvi(cModuleFileName);
 char *pcDescr = (char*)fvi.QueryValue();
 if( !pcDescr )
        pcDescr = "About LightRepeater";

 MessageBox(Handle,
     "Repeater controlling software.\n\r"
     "Copyright (C) 2001  SM6XMK, Olof Lagerkvist\n\r"
     "Visit the LightRepeater project's homepage: http://www.qsl.net/sm6xmk/apps/LightRepeater/\n\r"
     "\n\r"
     "This program is free software; you can redistribute it and/or modify it. See COPYING.TXT for details.\n\r"
     "\n\r"
     "This program is distributed in the hope that it will be "
     "useful, but WITHOUT ANY WARRANTY; without even the "
     "implied warranty of MERCHANTABILITY or FITNESS FOR A "
     "PARTICULAR PURPOSE.",
          pcDescr,
          MB_ICONINFORMATION );
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::btnTestSoundClick(TObject *Sender)
{
 PlaySound(txtSoundFile->Text.c_str(), NULL, SND_ASYNC|SND_NODEFAULT);
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::rbNoSoundFileClick(TObject *Sender)
{
 txtSoundFile->Text = "";
}
//---------------------------------------------------------------------------

void __fastcall TfrmCplApplet::btnLoadVoicePathClick(TObject *Sender)
{
   char cDirName[MAX_PATH] = "";

   BROWSEINFO bif;
   bif.hwndOwner = Handle;
   bif.pidlRoot = NULL;
   bif.pszDisplayName = cDirName;
   bif.lpszTitle = "Select folder where voice synthesis files are stored";
   bif.ulFlags = BIF_RETURNONLYFSDIRS;
   bif.lpfn = NULL;

   LPITEMIDLIST pItemIDList = SHBrowseForFolder(&bif);
   if( !pItemIDList )
      return;

   if( !SHGetPathFromIDList(pItemIDList, cDirName) )
   {
      MessageBox(Handle, "Selected folder is not a file folder.", NULL,
                         MB_ICONEXCLAMATION);
      return;
   }

   txtVoicePath->Text = cDirName;
}
//---------------------------------------------------------------------------

