/* LightRepeater Control Panel Applet
 *
 * LightRepeater v 1.0 by SM6XMK, Olof Lagerkvist
 * Send comments and suggestions to sm6xmk@qsl.net
 *
 * Latest version available at http://www.qsl.net/sm6xmk/apps/LightRepeater/
 *
 * Use this Control Panel applet to setup repeater announcements at sheduled
 * times.
 *
 *  SM6XMK LightRepeater, Repeater control software
 *  Copyright (C) 2001  SM6XMK, Olof Lagerkvist
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>

#include <cpl.h>

#pragma hdrstop
//---------------------------------------------------------------------------
//   Important note about DLL memory management when your DLL uses the
//   static version of the RunTime Library:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library MEMMGR.LIB to both the DLL project and
//   any other projects that use the DLL.  You will also need to use MEMMGR.LIB
//   if any other projects which use the DLL will be perfomring new or delete
//   operations on any non-TObject-derived classes which are exported from the
//   DLL. Adding MEMMGR.LIB to your project will change the DLL and its calling
//   EXE's to use the BORLNDMM.DLL as their memory manager.  In these cases,
//   the file BORLNDMM.DLL should be deployed along with your DLL.
//
//   To avoid using BORLNDMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//
//   If your DLL uses the dynamic version of the RTL, you do not need to
//   explicitly add MEMMGR.LIB as this will be done implicitly for you
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
USEFORM("lrevents_CplApplet.cpp", frmCplApplet);
USERES("lrevents.res");
//---------------------------------------------------------------------------
void ShowCplAppletForm(HWND hwndOwner);
//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE, DWORD, LPVOID)
{
  return 1;
}
//---------------------------------------------------------------------------
EXTERN_C LONG APIENTRY __export CPlApplet(

    HWND hwndCPl,	// handle to Control Panel window
    UINT uMsg,	        // message
    LONG lParam1,	// first message parameter
    LONG lParam2 	// second message parameter
   )
{
  try
  {
    switch( uMsg )
    {
      case CPL_DBLCLK:
        ShowCplAppletForm(hwndCPl);
        return 0;
      case CPL_EXIT:
        return 0;
      case CPL_GETCOUNT:
        return 1;
      case CPL_INIT:
        Application->Initialize();
        return 1;
      case CPL_INQUIRE:
      {
        LPCPLINFO lpcpli = (LPCPLINFO)lParam2;
        lpcpli->idIcon = 1;
        lpcpli->idName = 101;
        lpcpli->idInfo = 102;
        lpcpli->lData = 0;
        return 0;
      }
      case CPL_STOP:
        return 0;
      default:
        return 1;
    }
  }
	catch(Exception &exception)
	{
    Application->ShowException(&exception);
    return 0;
	}
}

