        KFT-1 & KFT-2 HANDBOOK                               Version 1.3                                                                                        E>                                   INDEX                                    <E                                                                                        1.0 INTRODUCTION                                                                2.0 ELECTRICAL SPECIFICATIONS                                                   3.0 CONNECTIONS                                                                 4.0 MECHANICAL                                                                  5.0 PROGRAMMING PRINCIPLES                                                        5.1 Slow Encode Mode                                                            5.2 International Group Decoder Tone Set Selection                              5.3 Programming Method                                                        6.0 PROGRAMMABLE FEATURES AND FACILITIES                                          6.1 Programmable Parameters - Summary                                           6.2 Non-Programmable Parameters - Summary                                     7.0 PROGRAMMABLE PARAMETERS - DESCRIPTION                                         7.1 Tone Set                                                                    7.2 Tone Period                                                                 7.3 Group Format                                                                  7.3.1 "Extended" Group Call Format                                              7.3.2 International Group Call Format                                           7.3.3 Group Address Decoding                                                    7.3.4 Group Address Encoding                                                  7.4 Lead In Delay                                                               7.5 Lead In Tone                                                                7.6 Rx Decode Format                                                            7.7 Rx Decode Code                                                              7.8 Remote Reset                                                                7.9 Decode Alert Timing                                                         7.10 Rx Tone Blanking                                                           7.11 Power-up Mute State                                                        7.12 Timed Mute Reset                                                           7.13 Tx Call Format                                                               7.13.1 5-Tone Format                                                            7.13.2 5-Tone Plus 6th-Tone Status Format (Encode Only)                         7.13.3 6-Tone Format (Encode Only)                                              7.13.4 7-Tone Format (Encode Only)                                            7.14 7-Tone Gap                                                                 7.15 Tx Call Code                                                               7.16 Tx Call Protocol                                                             7.16.1 Normal Protocol                                                          7.16.2 Autocall Protocol                                                      7.17 Tx Time Out Timer                                                          7.18 Auxiliary Code                                                             7.19 Multiple Sequence                                                          7.20 Tx Acknowledge Code Format                                                 7.21 Tx ANI Code                                                                7.22 Tx ANI Mode                                                                  7.22.1 Leading Edge ANI                                                         7.22.2 Trailing Edge ANI                                                        7.22.3 Random ANI                                                               7.22.4  ANI Combinations                                                      7.23  Key Beeps                                                       P>                                                                                                                                                              E>  1.0 INTRODUCTION                                                          <E                                                                                        The  KFT-x  Series  are  low  profile  CMOS  Selcall en/decoders                designed  for use within the Kenwood TK-330/230 Portables and the               TK-805/705  Mobiles.  They  are  full-featured  products  with                  selection of facilities via a programmer and non-volatile memory                on  the  module.                                                                                                                                                Two  versions (KFT-1 and KFT-2) are available. The KFT-1 version                is  intended for the portable radios, where space is restricted.                It provides group call decoding to the Extended Group Format. It                also  provides  group  call  decoding to the International Group                Format  utilising  a  Group  Tone  decode signal provided by the                radio.                                                                                                                                                          The  KFT-2 version is intended for the mobile radios, where more                space  is  available.  This  version  implements  on-board  both                International  and Extended Group Formats. To this end the KFT-2                is  factory-fitted  with  a  hybrid  Group  Tone Decoder module.                                                                                                The  KPG-2  Programming  Interface and associated KPG-3D Product                Support  Disk  provide  a  convenient  method of programming the                module  from  the  parallel  printer  port  of an IBM-compatible                personal  computer.                                                                                                                                                                                                                     E>  2.0 ELECTRICAL SPECIFICATIONS                                             <E                                                                                        OPERATING VOLTAGE                            5.5 to 17 volts                    OPERATING CURRENT                          <  6 ma for KFT-1                                                               < 11 ma for KFT-2                    OPERATING TEMPERATURE                     -30 to +80 Deg. C.                    INPUT SENSITIVITY                                > 25 mV RMS                    DECODER INPUT IMPEDANCE                          >   50K Ohm                    FREQUENCY ACCURACY                                  +/- 0.2%                    DECODE BANDWIDTH                     Automatically optimized                    ENCODE O/P IMPEDANCE                     < 300 Ohms @ Encode                                                           > 100 KOhms @ Standby                    ENCODE O/P LEVEL                    (unloaded)   > 200mV RMS                    CMOS INPUTS:  Input leakage current            +/- 1 uA max.                                  High-level voltage                  3.5 V min.                                  Low-level voltage                   1.5 V max.                                                                                                    CMOS OUTPUTS: Output-high voltage       4.0 V @ -2.2 mA typ.                                                            3.5 V @ -3.3 mA typ.                                                            3.0 V @ -4.0 mA typ.                                                                                                                  Output-low voltage        0.4 V @ +2.8 mA typ.                                                            0.8 V @ +4.5 mA typ.                                                                                                    The  above  specifications  apply  at 25 degrees Celcius ambient                temperature.                                                            P>                                                                              E>  3.0 CONNECTIONS                                                           <E                                                                                        The  KFT-x  interface  requires a total of 16 connections which                 are provided as one 12-way, and one 4-way, solder-in cable                      connectors.  Because the connections in the portable and                        mobile radios are different, the connection details below refer                 to the PL1 and PL2 connectors on the board.  Consult the schematic              diagram for further information.                                                                                                                        E>     [VIN PL1.8]                                                            <E                                                                                        5.5  to  17  volt  positive  power  supply.  At no time must the                voltage drop below 5.5 volts or a module reset will occur.                                                                                                                                                                              E>     [GND PL1.10]                                                           <E                                                                                        0 volt power supply return.                                                                                                                                                                                                             E>     [TX ON PL1.4]                                                          <E                                                                                        Active-low CMOS output, used to enable the transmitter.                                                                                                         Low = Transmitter ENABLED                                                                                                                               E>     [MUTE CTRL PL1.1]                                                      <E                                                                                        Active-high  CMOS  output, used to mute the audio channel of the                receiver.                                                                                                                                                       High = Audio QUIET                                                                                                                                      E>     [TONE OUT PL2.3]                                                       <E                                                                                        200  mV RMS (unloaded) encode tone output. Output impedance is <                300  Ohms  when  generating  tones  and  > 100 KOhms in standby.                Provision must be made in the radio for deviation adjustment. To                assist  in this, the link marked "X" on the KFT-1 may be bridged                to extend each tone period to 10 seconds.                                                                                                                                                                                               E>     [LED PL1.2]                                                            <E                                                                                        Active-low  CMOS output. Used to drive an external current-boost                transistor for the decode status LED.  Indications are:                                                                                                                 KFT-x "Open"                               Output active                        KFT-x "Quiet"                            Output inactive                        Selcall decoded         5 volt p-p square-wave, flashing                                                                                                Low = LED ON                                                                                                                                                                                                                            P>                                                                              E>     [ALERT PL2.4]                                                          <E                                                                                        CMOS  output providing square-wave audible alert tones. Low when                not producing  alert tones.  External provision must be made for                DC isolation and level adjustment.                                                                                                                                                                                                      E>     [SIG IN PL2.2]                                                         <E                                                                                        Audio  signal  input.  Must  be  > 25  mV  RMS for  satisfactory                performance.  Input impedance is > 50 KOhms.                                                                                                                                                                                            E>     [PTT IN PL1.9]                                                         <E                                                                                        Active-low CMOS input, from press-to-talk (PTT) logic.                                                                                                          Low = PTT switch PRESSED                                                                                                                                                                                                                E>     [QUIET/OPEN PL1.5]                                                     <E                                                                                        Active-low  CMOS  input,  from   Quiet/Open   logic.  The  KFT-1                implements  2-button Selcall operation, with separate inputs for                Open/Quiet  switching  (monitoring)  and Selcall initiation (see                TXCALL below).                                                                                                                                                  Low = OPEN/QUIET switch PRESSED                                                                                                                                                                                                         E>     [TXCALL PL1.6]                                                         <E                                                                                        Active-low CMOS input, from Selcall transmit logic.  Initiates                  the transmission of an encode sequence.                                                                                                                         Low = TXCALL switch PRESSED                                                                                                                                                                                                             E>     [BUSY IN PL1.7]                                                        <E                                                                                        Active-high CMOS input, from channel-busy logic.                                                                                                                High = Channel BUSY                                                                                                                                                                                                                     E>     [MIC MUTE PL1.3]                                                       <E                                                                                        Active-high CMOS output, used to disable the microphone during a                Selcall transmission.                                                                                                                                           High = Microphone DISABLED                                                                                                                                                                                                              P>                                                                              E>     [/GRP DEC PL2.1]                                                       <E                                                                                        Active-low  CMOS input from an external international group tone                decoder, to be used only with the KFT-1 to provide international                Group  Tone  Decoding  capability. This input has an on-board 47                KOhm  pull-up  resistor  to  +5V.                                                                                                                               This input requires a series of active-low pulses from the group                tone  decoder,  beginning  as  soon  as  the group tone has been                correctly  decoded  and  continuing  while  the  group  tone  is                present.  The  pulses  should  be low for 2 msec +/- 10%, with a                repetition  period  of  4  msec  +/-  10%.                                                                                                                      Care  must be taken that the group tone decoder is reliable, and                that  no  spurious  negative-going  pulses  are generated during                decoding  of  selcall sequences. If a spurious group tone decode                signal  is  recognised  by  the  KFT-1  during  a single-address                sequence,  the  KFT-1 will expect Repeat and Group tones for the                remainder  of the sequence. Since these will not be present, the                sequence  will  not  be  recognised.                                                                                                                            Active Low Pulse = Group Tone DETECTED  (2msec repeated @ 4msec)                                                                                                Note  that  during  read-back and programming of the module this                connection  will  be  driven  by  a  5 volt p-p  (approximately)                waveform of 10 KOhmn nominal source impedance.                                                                                                                         [NOTE:]  The mobile radio, or wiring loom, must be                                       designed such that this signal is [NOT]                                         connected  when  the KFT-2 is plugged                                           into the radio.                                                                                                                         E>     [VDATA PL1.11]                                                         <E                                                                                        Active-high  CMOS  serial  data  input  to  the  on-board  shift                register  used  for  setting  of 1 or 2 variable transmit tones.                This  may  be  a  shared  data  line  subject to the constraints                detailed in the description of VCLOCK (see below).                                                                                                              High = "1", Low = "0"                                                                                                                                                  [NOTE:]  The loading of this data must be  completed                                    [BEFORE] commencing the Selcall transmission.                                                                                                    These  variable tones are referred to as H and I, with tone H to                be  transmitted  before  tone I in the sequence. The programming                software  will  allow these tones to be assigned anywhere in the                transmit  tone  sequence, including the status tone.                    P>                                                                                      Each of the 16 available tones is represented by a 4-bit code as                follows:                                                                                                                                                E>           [Tone]          [Code]                                           <E                0             0000      (MSB...LSB)                                             1             0001                                                              2             0010                                                              3             0011                                                              4             0100                                                              5             0101                                                              6             0110                                                              7             0111                                                              8             1000                                                              9             1001                                                              A             1010      (Group Tone)                                            B             1011                                                              C             1100      (Reset Tone)                                            D             1101                                                              E             1110      (Repeat Tone)                                           F             1111                                                                                                                                      The  4-bit  codes  for variable tones H and I are to be combined                into  an 8-bit byte, with H in the most-significant 4 bits and I                in  the  least-significant  4  bits.   For  example,   the  byte                corresponding to H = tone-4 and I = tone-D is:                                                                                                                          MSB    0 1 0 0 1 1 0 1    LSB                                                          \------/\------/                                                                   H=4     I=D                                                                                                                                   This  byte  is  to  be shifted by the radio's processor into the                shift register most-significant bit first, least-significant bit                last.  Eight  bits  must  always be shifted, even where only one                digit  in  the  sequence  is  to be variable. In this case the I                digit, in the least-significant 4 bits, should be used. The data                in  the most-significant 4 bits will be ignored. The timing with                respect to the shift clock is detailed below.                                                                                                                   If the radio is also required to send Group Calls then the radio                must  be  capable  of  sending  the  code for Group Tone (A), in                addition to digits 0 to 9.                                                                                                                                                                                                              E>     [VCLOCK PL1.2]                                                         <E                                                                                        CMOS  clock  input to the on-board shift register. The positive-                going  edge  of  this  signal is used as the timing reference to                shift  the  serial  data  on VDATA into the register. This clock                line  must  be  dedicated  to  this function to prevent spurious                data from being shifted in.                                                                                                                                     The data on VDATA must be valid at least 25 nanoseconds prior to                the  rising edge of VCLOCK, and must remain valid for at least 5                nanoseconds  afterwards.  Data  becomes  valid  at  the register        P>      outputs  40  nanoseconds  after  the  rising edge of VCLOCK. The                maximum clock frequency is 20 Mhz,  with a 20 nanosecond minimum                pulse width (positive).                                                                                                                                                                                                                 E>  4.0 MECHANICAL                                                            <E                                                                                        Dimensions:     KFT-1        41mm x 20mm x 4mm    (Portable)                                    KFT-2        46mm x 20mm x 7.8mm  (Mobile)                                                                                                                      Refer to the product diagram  which shows board                                 protrusion and space  for  tubular crystal, and                                 dimension information.                                                                                                                                          The -2  version  is identical to the /01 except                                 for extra  area  for  connections  to the group                                 decode hybrid, and fitment of the hybrid itself.                                                                                                                                                                        E>  5.0 PROGRAMMING PRINCIPLES                                                <E                                                                                        A  number  of plated-through holes are provided on the KFT-x PCB                to  allow  access  for  programming  of the module by the  KPG-2                Programming Interface.                                                                                                                                          The  KPG-2  Programming Interface and associated Product Support                disk  are  used  to program the module from the parallel printer                port  of an IBM-compatible personal computer. The type number of                the  disk  is  KPG-3D. It contains the programming software, and                the KFT-1 & KFT-2 Handbook which may be printed to the screen or                printer.                                                                                                                                                        Two facilities can be selected by solder bridging:                                                                                                              (a)  Slow encode (10 seconds per tone) for test and deviation                        adjustment.                                                                                                                                                (b)  Tone set selection  for  the  International  Group  Tone                        Decoder on the KFT-2.                                                                                                                              E>      5.1  Slow Encode Mode                                                 <E                                                                                        A  Tone  Period  of  10  seconds may be selected by bridging the                solder  lands  labelled  'X'  on  the  KFT-x PCB This feature is                provided  to  facilitate  deviation  and  frequency  checking                   procedures  when  servicing  the  radio.                                                                                                                E>      5.2  International Group Decoder Tone Set Selection                   <E                                                                                        One  parameter  on  the  KFT-2 which is not programmable via the                KPG-2  programming  unit  is  the Tone Set for the International                Group  Decoder hybrid. This must be set by solder-bridges on the                KFT-2  PCB  labelled  TS 0 - 2.                                         P>                                                                                      The Group-Tone Tone Set selection is as follows:                                                                                                        E>                [TS0]   [TS1]   [TS2]   [TONE SET]  [GROUP TONE]            <E                                                                                                    0       0       0        EEA         1055                                       1       0       0        ZVEI1       2800                                       0       1       0        ZVEI2        885                                       1       1       0        PZVEI        970                                       0       0       1        CCIR        2400                                       1       0       1        NATEL       1995                                       0       1       1        EIA         2151                                       1       1       1        DZVEI        825                                                                                                                       0 = Bridge                                                                      1 = Leave un-bridged                                                                                                                                NOTE:  This  is  a  hardware selection and is independent of the                Tone  Set chosen when programming the KFT-x module, however this                is  normally  set  to  the  Tone  Set  programmed into the KFT-2                module.  This ensures that the standard Group Tone (A) is always                used  for  the  chosen  Tone  Set.                                                                                                                      E>      5.3  Programming Method                                               <E                                                                                        The  KPG-2  Programming  Interface  enables a KFT-x module to be                accurately  aligned  onto  a  set  of  contact probes. A captive                sliding  spacer allows the locating cavity to correctly position                the  shorter  KFT-1  module.  When the KFT-x module is correctly                positioned, the lid of the KPG-2 may be closed and latched. This                action  also  applies  power  to  the  KFT-x.                                                                                                                   The Product Support Disk may then be used to read and/or program                the  module.  The  programmable  parameters are displayed on the                computer  screen  as  a  scrollable list. The currently selected                parameter  is highlighted, and may be changed if required before                programming  the  module.                                                                                                                                       Complete  sets  of  parameters  may  be saved to setup files for                later  recall.  An  on-screen  help  window may be enabled which                presents  information  on the currently highlighted parameter. A                number  of reference screens are provided via the function keys,                and  this  handbook  may  be  printed  to the screen or printer.                                                                                                                                                                                If a Connection Error message is encountered, please ensure that                the  cable from the KPG-2 is correctly plugged into the parallel                printer  port of the computer. Also ensure that the underside of                the  KFT-x  module  is  clean,  and that satisfactory contact is                being  made  with  the  KPG-2  pins.                                                                                                                            If  the  Connection  Error  persists  use  another known working                module  to  check  whether  the  programming interface is set up                correctly.                                                              P>                                                                              E>  6.0 PROGRAMMABLE FEATURES AND FACILITIES                                  <E                                                                                E>      6.1 Programmable Parameters - Summary                                 <E                                                                                           The software  allows the following features to be programmed.                The  default   settings,  as  delivered  from  manufacture,  are                underlined.  Further explanations are provided in Section 4.                                                                                                       Parameter             Selectable Values                                                                                                                         TONE SET              EEA, ZVEI1, ZVEI2, PZVEI, [CCIR], NATEL,                                             EIA, DZVEI                                           TONE PERIOD           [20], 33, 40, 70, 100 mS                                  GROUP FORMAT          Extended, [International]                                 LEAD IN DELAY         [500mS]   20mS to  200mS in  20mS steps;                                                 200, 240, 300, 340, 400, 440 mS;                                                500mS to 1000mS in 100mS steps;                                                1000mS to 2500mS in 500mS steps.                  LEAD IN TONE          [Z](None), One of 0,1,2,3,4,5,6,7,8,9                                                     & tones A,B,C,D,E,F                                                                                                             RXDECODE CODE         [10000]   Each digit selectable to one of                                                      0,1,2,3,4,5,6,7,8,9                        REMOTE RESET          [Off], On                                                 DECODE ALERT TIMING    Continuous, 2 sec,[20 sec]                               RX TONE BLANKING      [Off], On                                                 POWER-UP MUTE STATE   [Quiet], Open                                             TIMED MUTE RESET       Off,[On](see below for details)                                                                                                          TXCALL FORMAT         [5 tone], 5 tone + 6th-tone Status,                                                       6 tone, 7 tone No gap,                                                          7 tone 1 TP gap, 7 tone 2 TP gap                                                                                                TXCALL CODE           [10000]   Up to 7 digits depending on                                                     format, each digit                                                              selectable to one of                                                            0,1,2,3,4,5,6,7,8,9,A,C,E,H,I                   TXCALL PROTOCOL       [Normal], Autocall                                        TX TIMEOUT TIMER      [Off], 15, 30, 45, 60, 120, 180, 240 seconds                                                                                              AUXILIARY CODE        [10000]   Each digit selectable to one of                                                 0,1,2,3,4,5,6,7,8,9                             MULTIPLE SEQUENCE     [Off], On                                                                                                                                 TXACK CODE FORMAT     [Off], Beep, TxCall, RxDecode, Auxiliary code             TXANI CODE            TxCall, [RxDecode], Auxiliary                             TXANI MODE            [Off], Leading, Trailing, Random,                                                         and Combinations                                KEY BEEPS             [On], Off                                      P>                                                                              E>      6.2 Non-Programmable Parameters - Summary                             <E                                                                                           The  following  parameters  are  preset  by  the  programming                software  to conform to the signal polarity specifications found                in the KFT-1 Product Specification. These can not be modified by                the  user.                                                                                                                                                         TXON           Active-low    Low = Transmitter ENABLED                          MUTE CTRL      Active-high   High = Audio QUIET                                 LED            Active-low    Low = LED ON                                       ALERT          Active-high   Low when no alert tone                             PTT IN         Active-low    Low = PTT switch PRESSED                           QUIET/OPEN     Active-low    Low = QUIET/OPEN switch PRESSED                    TXCALL         Active-low    Low = TXCALL switch PRESSED                        BUSY IN        Active-high   High = Channel BUSY                                MIC MUTE       Active-high   High = Microphone DISABLED                         /GRP DEC       Active-low    Low pulses = Group tone DETECTED                   VDATA          Active-high   High = "1", Low = "0"                              VCLOCK         Active-high   Rising-edge is timing ref.                                                                                                                                                                              E>     7.0 PROGRAMMABLE PARAMETERS - DESCRIPTION                              <E                                                                                        The  KFT-x supports all International Tone Sequential signalling                standards.                                                                                                                                                      A  Tone  Sequential  signal is comprised of a number of tones of                equal  length  being  transmitted one after the other. Each tone                represents  a  decimal  digit.  In  a five tone system there are                100,000  individual numbers which may be used as unit addresses.                                                                                                To  eliminate  ambiguity in the decode process, each transmitted                tone  must  be  different  in frequency from the preceding tone.                Where  two (2) equal digits follow each other in a tone sequence                the  second  digit  is replaced by a "Repeat" tone. This is done                automatically  by  the  KFT-x  module,  for  all  International                 Signalling  Tone  Sets.                                                                                                                                                        e.g.   10222  will be sent as 102R2                                             and    12222  will be sent as 12R2R                                                                                                              The  existence  of  Repeat  tones is transparent to the user but                must  be  understood  by  the  radio  technician.                                                                                                       E>      7.1 Tone Set                                                          <E                                                                                           There are a number of Internationally used Tone Sets.  A Tone                set defines  the audio  frequencies  representing  each  decimal                digit.   Other tone  frequencies  which  are not  assigned to  a                decimal digit are also defined and these have special functions.        P>                                                                                         The available Tone Sets are listed below:                                                                                                                       Tonesets     EEA ZVEI-1 ZVEI-2 PZVEI  CCIR  NATEL  EIA  DZVEI                   =============================================================                   Tone No:                                                                           0         1981  2400  2400  2400   1981  1633    600  2200                      1         1124  1060  1060  1060   1124   631    741   970                      2         1197  1160  1160  1160   1197   697    882  1060                      3         1275  1270  1270  1270   1275   770   1023  1160                      4         1358  1400  1400  1400   1358   852   1164  1270                      5         1446  1530  1530  1530   1446   941   1305  1400                      6         1540  1670  1670  1670   1540  1040   1446  1530                      7         1640  1830  1830  1830   1640  1209   1587  1670                      8         1747  2000  2000  2000   1747  1336   1728  1830                      9         1860  2200  2200  2200   1860  1477   1869  2000                                                                                                   A Group      1055  2800   885   970   2400  1995   2151   825                   B             930   810   810   810    930   571   2433   740                   C Reset      2400   970   740  2800   2247  2205   2010  2600                   D             991   885   680   885    991  2437   2292   885                   E Repeat     2110  2600   970  2600   2110  1805    459  2400                   F            2247   680  2600   680   1055  2694   1091   680                                                                                                   Tone Period  40mS  70mS  70mS  70mS   100mS 70mS   33mS  70mS                                                                                                                                                                        E>      7.2 Tone Period                                                       <E                                                                                           Each Tone  Set has  an associated  Tone Period  (shown in the                above  table)   which  is   defined  as  part  of  the  relevant                International Signalling Specification.                                                                                                                            The KFT-x  however allows any of the above Tone Periods to be                used with any Tone Set.                                                                                                                                            KENWOOD recommends the use  of the CCIR Tone Set with a 20 mS                Tone  Period.     This   choice  combines  exceptional  decoding                performance with high speed.                                                                                                                            E>        [NOTE:]                                                             <E                                                                                           The tones  may also  be generated  for a  Tone Period  of  10                seconds by bridging the solder lands labelled  'X'  on the KFT-x                PCB    This  feature  is  provided  to  facilitate  deviation                   and frequency checking procedures when servicing the radio.                                                                                                                                                                             E>      7.3 Group Format                                                      <E                                                                                           Group Calling  is the  ability to call a group of radios in a                fleet simultaneously.                                                                                                                                              When a  group sequence  is decoded, the KFT-x will unmute the                radio and sound a short audible alarm (three short beeps).              P>                                                                                                                                                              E>         7.3.1 "Extended" Group Call Format                                 <E                                                                                        This  format may be used where a KFT-1 module is used without an                external  International  Group  Tone  decoder. As it is intended                that  the  portable  radios will provide the International Group                Tone  decoding  function  and  signal the KFT-1 accordingly, the                International  Group  Call  format  would  normally  be  used.                                                                                                     When the Extended  Group Call  format is selected, an encoded                Group  Call  has  the first 'G' tone in the sequence extended to                3TP  to  allow  sufficient  time for the decoder to confirm that                it's next address tone is NOT present and then attempt to decode                a  'G' tone. Once a 'G' tone is decoded the decoder will abandon                looking  for  it's  own RXDECODE Code and will attempt to decode                group  tones  (or REPEAT tones where appropriate), until a valid                sequence is completed.                                                                                                                                             The following timing diagram shows the decisions taken by the                decoder:                                                                                                                                                                                                                                                            Decode Tones 1 to 3                                                            <-------------->                                                                                                                                                          Tone 4 not found                                                                     <---->                                                                                                                                                          Listen for G-R sequence                                                               <---------->                                                                                                                               .----.----.----.-----------.----.                                           ----| R1 | R2 | R3 |    'G'    | 'R'|---                                            '----'----'----'-----------'----'                                                                                                                               ^----^----^----^-----------^----^                                                 1TP  1TP  1TP     3TP      1TP                                                                                                                                                                                                The "Extended"  Group tone formats are shown below:                                                                                                            [Group Sequence (Groups of 10)]                                                                                                                                  Example: A Group call "1257G" will call all units from 12570                    to 12579.                                                                                                                                                                                "1"  "2"  "5"  "7"      "G"                                          .----.----.----.----.-----------.                                   ,----LID----| R1 | R2 | R3 | R4 |    'G'    |-LOG-,                           --'           '----'----'----'----'-----------'     '----                                                                                                         ^-----//----^----^----^----^----^-----------^-----^                               0-2.5Secs   1TP  1TP  1TP  1TP     3TP      1TP                                                                                                  P>                                                                                                                                                                        [Group Sequence (Groups of 100)]                                                                                                                                 Example: A Group call "125GG" will call all units from 12500                    to 12599.                                                                                                                                                                       "1"  "2"  "5"      "G"     "G"                                                .----.----.----.-----------.----.                                   ,----LID----| R1 | R2 | R3 |    'G'    | 'R'|-LOG-,                           --'           '----'----'----'-----------'----'     '--                           ^-----//----^----^----^----^-----------^----^-----^                               0-2.5Secs   1TP  1TP  1TP     3TP      1TP  1TP                                                                                                                                                                                                                                                                            [Group Sequence (Groups of 1,000)]                                                                                                                               Example: A Group call "12GGG" will call all units from 12000                    to 12999.                                                                                                                                                                       "1"  "2"     "G"      "G"  "G"                                                .----.----.-----------.----.----.                                   ,----LID----| R1 | R2 |    'G'    | 'R'| 'G'|-LOG-,                           --'           '----'----'-----------'----'----'     '----                                                                                                         ^-----//----^----^----^-----------^----^----^-----^                               0-2.5Secs   1TP  1TP     3TP      1TP  1TP  1TP                                                                                                                                                                                                                                                                            [Group Sequence (Groups of 10,000)]                                                                                                                              Example: A  Group call "1GGGG" will call all units from 10000                to 19999.                                                                                                                                                                          "1"     "G"      "G"  "G"  "G"                                                .----.-----------.----.----.----.                                   ,----LID----| R1 |    'G'    | 'R'| 'G'| 'R'|-LOG-,                           --'           '----'-----------'----'----'----'     '----                                                                                                         ^-----//----^----^-----------^----^----^----^-----^                               0-2.5Secs   1TP     3TP      1TP  1TP  1TP  1TP                                                                                                                                                                                             NOTE: the  first tone  in a  group sequence  must always be a                numerical value  i.e.   the code GRGRG is not allowed.  Also, as                shown above,  the first "G" tone must be followed by a string of                either Repeat  or Group  tones.  The code 1GR7G, for example, is                not allowed.                                                                                                                                            P>                                                                              E>         7.3.2 International Group Call Format                              <E                                                                                           In addition  to  being able  to  decode  Group  Calls  to the                "Extended" format the KFT-x modules can decode group calls which                conform  with  the International signalling conventions as well.                Groups  of  tens, hundreds, thousands, and tens of thousands can                be decoded.                                                                                                                                                        The  following  example  shows  a  typical  group  call  tone                sequence which conforms to the International format.                                                                                                              [Example: A group Call of 125GG]will call all units coded from                12500 to 12599                                                                                                                                                                            "1"  "2"  "5"  "G"  "G"                                                       .----.----.----.----.----.                                          ,----LID----| R1 | R2 | R3 |'G' | 'R'|-LOG-,                                ----'           '----'----'----'----'----'     '--                                                                                                                  ^-----//----^----^----^----^----^----^-----^                                      0-2.5Secs   1TP  1TP  1TP  1TP  1TP  1TP                                                                                                                            INTERNATIONAL GROUP CALL FORMAT                                                                                                                  NOTE: the  first tone  in a  group sequence  must always be a                numerical value  i.e.   the code  GRGRG is not allowed.  Also as                shown above  the first  "G" tone must be followed by a string of                either Repeat  or Group  tones.  The code 1GR7G, for example, is                not allowed.                                                                                                                                                                                                                            E>         7.3.3 Group Address Decoding                                       <E                                                                                           The KPG-3D programming software provides a choice between two                Group Call  formats, "Extended"  or  "International",  and would                normally be used in the "International" mode.                                                                                                                      The KFT-x  will respond to either  the  "Extended"  or to the                "International" format  depending  on the selection  made during                programming.                                                                                                                                                       The KFT-x  cannot be  programmed to respond to a unique Group                Call address.   It  will  respond  to  calls  of  the  following                formats:                                                                                                                                                                                R1   G   G   G   G                                                              R1  R1   G   G   G                                                              R1  R2  R3   G   G                                                              R1  R2  R3  R4   G                                                                                                                         where  R1  to R4 used here are the first 4 tones in the                         RXDECODE address.                                                                                                                                    P>                                                                              E>         7.3.4 Group Address Encoding                                       <E                                                                                           When including  a Group  tone  in  a  transmit  sequence  the                duration of the Group tone will be extended to 3 Tone Periods if                the "Extended" format is selected. If the "International" format                is selected then the Group tone will be transmitted for one Tone                Period  only.  Ensure  that  tones  following the Group tone are                alternating Repeat and Group tones, as detailed above.                                                                                                                                                                                  E>      7.4 Lead In Delay                                                     <E                                                                                           The "Lead  in Delay"  parameter specifies  for how  long  the                transmitter  will   be  enabled  before  the  tone  sequence  is                generated.     This  parameter   is  necessary   to  allow   the                transmission link  to settle.  (This parameter is also sometimes                referred to as the Link Establishment Time.)                                                                                                                                                                                                                                  .----.----.----.----.----.                           TONE       ,------//-------| T1 | T2 | T3 | T4 | T5 |-LOG-,                     SEQUENCE   |               '----'----'----'----'----'     |                            ----'                                              '--                             ^-------//-------^----^----^----^----^----^----^                                       LID        1TP  1TP  1TP  1TP  1TP  1TP                              ----,                                               ,--                     PTT     |                                               |                      OUTPUT   '-----------------------------------------------'                                                                                                               ^                                               ^                               |                                               |                               Start Transmission               End transmission                                                                                                                                                                                                   LID = Lead In Delay (20mS to 2500mS)                                             TP = Tone Period                                                                                                                                        TIMING DIAGRAM SHOWING  LID / PTT RELATIONSHIP                                                                                                           The transmission medium may be a direct radio frequency link,                include one  or  more  radio  repeaters,  a  land  line  or  any                combination of  such voice frequency bearers.  The length of the                Lead In Delay required will depend on the system application.                                                                                                      The Lead  In Delay  is set  to 500mS  ex-factory but  may  be                programmed to a selected range of values between 20mS and 2500mS.                                                                                                                                                                       E>      7.5 Lead In Tone                                                      <E                                                                                           The KFT-x  may be  programmed to  transmit  a  tone  for  the                duration of  the Lead in Delay.  This tone may serve a number of                different purposes depending on the application.                        P>                                                                                         In pocket  pagers which  use 5  tone sequential  signalling a                Lead in  Tone is  used to  "wake up"  the  pagers.    The  pager                normally runs  in a  battery saving  mode and  only samples  the                received audio  occasionally.  When the Lead in Tone is detected                the pager  stays on  for an extended period of time, long enough                to decode a possible selective call sequence.                                                                                                                      The Lead  In Tone may also be used to "settle" AGC amplifiers                (found in  repeaters/links), so  that the  Selcall tone sequence                following the Lead in Tone does not become distorted.                                                                                                              The LIT  may also  be used  to access tone based repeaters as                found in some European countries.  This is accomplished by using                the Lead in Tone as an "Extended" first tone.                                                                                                                                                                                                               ,-------//------,        .---.---.---.---.---.                         TONE   --| Lead in Tone  |--------|T1 |T2 |T3 |T4 |T5 |---,                     SEQUENCE '------//-------'        '---'---'---'---'---'   '--                                                                                                            ^------//-------^--------^---^---^---^---^---^---^                                LID TIME        3TP     1TP 1TP 1TP 1TP 1TP 1TP                            ---,                                                ,--                   PTT      |                                                |                     OUTPUT   '------------------------------------------------'                                                                                                                          LEAD IN TONE FORMAT                                                                                                                        NOTE:  The gap between the LIT and the tone sequence is fixed                at 3 Tone Periods.  In the case of no tone (silence) selection,                 this gap will NOT be present.                                                                                                                                                                                                           E>      7.6 Rx Decode Format                                                  <E                                                                                           The Rx Decode format may be illustrated as:                                                                                                                                      .----.----.----.----.----.                                           ,----LID---| T1 | T2 | T3 | T4 | T5 |-LOG-,                                 ----'          '----'----'----'----'----'     '----                                                                                                                 ^-----//---^----^----^----^----^----^----^                                                   1TP  1TP  1TP  1TP  1TP  1TP                                                                                                                  Where  LID = Lead in Delay which is the time for which the                                   radio's transmitter is enabled before the tone                                  sequence is sent.                                                          Tn = Tone  n.  Each tone has a duration  of one Tone                                 Period (TP)                                                          and LOG  = Lead Out Gap, which is the time for which the                                   transmitter remains enabled  after the tone                                     burst has been transmitted.                                                                                                            P>                                                                              E>      7.7 Rx Decode Code                                                    <E                                                                                           Any five  digits may  be used  when coding  a unit's address,                giving 100,000  combinations.  Certain types of number sequences                are to  be avoided.   Progressive  sequences  in  increasing  or                decreasing arrangements  such as  12345 or 98765 etc. may result                in false decodes on certain speech patterns or heterodynes etc.                                                                                                    It is advisable to use two widely spaced tones for R1 and R2,                such as  1 and  0 for  CCIR Tone Set, or 1 and 9 in the EIA Tone                Set.   These two  tones allow  the remaining  numbers to  be any                combination as  they act  as a  buffer against accidental decode                responses.                                                                                                                                                         The technique  of  pre-selecting  some  of  the  tones  in  a                sequence to guard against false decoding is referred to as "pre-                coding"                                                                                                                                                                                                                                 E>      7.8 Remote Reset                                                      <E                                                                                           Once a  call is  dispatched, the  called party's  radio  will                normally  have  a  flashing LED and an audible beep operating to                indicate  that  a call has been received. There may be a need in                some systems to reset (cancel) calls already dispatched. In this                case  a second message is sent to an individual vehicle or group                of vehicles who had been called, to reset the decoder(s) back to                the QUIET state and cancel all alerts in progress.                                                                                                                 The remote reset tone sequence has the following format:                                                                                                                                                                                                           ,---,---,---,---,---,---,                                           ,----LID----| 1 | 2 | 3 | 4 | 5 | 6 |---,                                     --'           '---'---'---'---'---'---'   '---                                                ^---^---^---^---^---^---^                                                       |                   |   |                                                       '-------------------'---'                                                          RXDECODE CODE     RESET                                                                           TONE                                                                                                                    NOTE: The  reset tone  may also  be appended  to a Group call                sequence in order to reset a group of mobiles.                                                                                                                                                                                          E>      7.9 Decode Alert Timing                                               <E                                                                                           There are 3 types of programmable audible alert modes:                                                                                                          1.  2 seconds alert (6 short beeps)                                             2.  20 seconds alert                                                            3.  Continuous alert                                                                                                                                         These alert  types occur  only after  an  individual  address           P>      decode.                                                                                                                                                            An Alert  in progress  is cancelled immediately on activation                of  the  PTT,  TX Call or Quiet/Open inputs to the KFT-x module,                except in the case of a 2-second alert timing selection.                                                                                                           After a  Group call  decode 3 short beeps are produced.  This                feature is fixed and cannot be altered.                                                                                                                                                                                                 E>      7.10 Rx Tone Blanking                                                 <E                                                                                           When tone  blanking is  enabled the  MUTE CTRL  output of the                KFT-x module  will temporarily  disable the  audio mute  control                output whenever  it decodes  the first  2 decodable  tones.  The                following tones  will not  be heard at all.  Since the tones are                decoded well  within the  tone period  programmed only the first                tone and part of the second tone will actually be heard.                                                                                                           This blanking function is only active for sequences beginning                with the same two tones as the KFT-x is programmed to decode.                                                                                                   In  systems  where  longer Tone Periods are used (eg CCIR/100ms)                the  tone blanking function becomes more attractive because only                the first tone and a small fraction of the second tone are heard                before  the  tone  blanking  function  becomes  active.                                                                                                                                                                                                                     .---.---.---.---.---.                                    TONE SEQUENCE     -----| 1 | 2 | 3 | 4 | 5 |------                                                     '---'---'---'---'---'                                                                               ^---^                                                                            1TP                                 MUTE CONTROL O/P             ,-----------------,                                                             |                 |                                                  -----------'                 '------                                                                                                                    TONE BLANKING TIMING FOR 20 mS SYSTEM                                                                                                                                                                                                                                                                                            .-----.-----.-----.-----.-----.                                    TONE    -----|  1  |  2  |  3  |  4  |  5  |----------                          SEQUENCE     '-----'-----'-----'-----'-----'                                                                               ^-----^                                                                                      1TP                     MUTE O/P            ,-----------------------------,                                                 |                             |                                      -----------'                             '-----                                                                                                                    TONE BLANKING TIMING FOR 100mS SYSTEM                                                                                                                                                                                    P>                                                                              E>      7.11 Power-up Mute State                                              <E                                                                                        The  MUTE  CTRL  output can be programmed to automatically enter                either  the  Quiet  or  Open  state  after  power-up.                                                                                                   E>      7.12 Timed Mute Reset                                                 <E                                                                                           When a  selective call  sequence is decoded the radio's audio                mute gate will be enabled and channel traffic can be heard.  The                radio's audio  mute gate  can also  be enabled by activating the                QUIET/OPEN control.                                                                                                                                                The KFT-x module can be programmed to automatically return to                the QUIET state after 20 seconds.                                                                                                                               NOTE:  This does NOT mean that the alert condition is cancelled.                       The radio will be in the QUIET state, but the LED will                          still be flashing to indicate the alert.  The alert tone                        may also be heard, depending on the programmed settings                         and the radio's audio configuration.                                                                                                                        The 20-second  period  is restarted  every time  the operator                uses his  PTT switch.   The  20 second  period starts  from  the                release of  the PTT  switch.   The 20  second  counter  is  also                paused  by  the presence  of an  active signal at the BUSY input                and resumes  countdown  when  the  BUSY  input  returns  to  the                inactive state.                                                                                                                                                    If the  Timed Mute  Reset function  is NOT  selected then the                radio's audio  mute gate  will  stay  OPEN  until  the  operator                returns it  to the  QUIET state,  by operation of the Quiet/Open                switch.                                                                                                                                                 E>      7.13 Tx Call Format                                                   <E                                                                                E>         7.13.1 5-Tone Format                                               <E                                                                                           There are  a number  of different  tone  formats  but  each                  is derived from the following basic 5-tone format:                                                                                                                                  .----.----.----.----.----.                                           ,----LID---| T1 | T2 | T3 | T4 | T5 |-LOG-,                                 ----'          '----'----'----'----'----'     '----                                                                                                                 ^-----//---^----^----^----^----^----^----^                                                   1TP  1TP  1TP  1TP  1TP  1TP                                                                                                                  Where  LID = Lead in Delay which is the time for which the                                  radio's transmitter is enabled before the tone                                  sequence is sent.                                                           Tn = Tone  n.  Each tone has a duration  of one Tone                                Period (TP)                                                           and LOG  = Lead Out Gap, which is the time for which the                                  transmitter remains enabled  after the tone                                     burst has been transmitted.                                                                                                             P>                             5-TONE ENCODE FORMAT                                                                                                                                                                                             E>         7.13.2 5-Tone Plus 6th-Tone Status Format (Encode Only)            <E                                                                                           A sixth tone may be added to a 5 tone sequence as a status in                the following  manner.                                                                                                                                                                                                                                    .-----.-----.-----.-----.-----.   GAP  .---------.                         -----|  1  |  2  |  3  |  4  |  5  |---//---| STATUS  |----                          '-----'-----'-----'-----'-----'        '---------'                                                                                                              ^----^----^----^----^----^----^--------^---------^                               1TP  1TP  1TP  1TP  1TP  1TP    2TP       2TP                                  |                             |        |         |                              '--------------v--------------'        '----v----'                                        Address Range                 Status                                                                           Digit                                                                                                                   5 TONE PLUS 6th TONE STATUS ENCODE FORMAT                                                                                                               Note:  the   full  addressing   range  of  100,000  is  still                available.                                                                                                                                                      Any  of  the  16  tones  in the Tone Set may be used as a status                tone.  Automatic  repeat  tone insertion applies for the first 5                tones  in  the  sequence  but  NOT ACROSS the gap, as this would                result in incorrect decoder operation.                                                                                                                             The manual for the radio must be consulted to ensure that the                status tone number  selected  can in fact be sent by the radio's                processor to the KFT-x, in cases  where the status tone is to be                a variable digit.                                                                                                                                       E>         7.13.3 6-Tone Format (Encode Only)                                 <E                                                                                           The KFT-x  may also  be  programmed  to  generate  a  6  tone                sequence having the following format.                                                                                                                                                                                                                                 ,---,---,---,---,---,---,                                           ,----LID----| 1 | 2 | 3 | 4 | 5 | 6 |---,                                     --'           '---'---'---'---'---'---'   '---                                                ^---^---^---^---^---^---^                                                        1TP 1TP 1TP 1TP 1TP 1TP                                                                                                                                        6 TONE ENCODE FORMAT                                                                                                                         This format  is used  in special  systems applications.    In                particular it  is useful  to address  other units programmed for                Remote Reset  operation which requires a 6th tone.  In this case                the 6th tone is, by convention, the Reset Tone, "C".                    P>                                                                              E>         7.13.4 7-Tone Format (Encode Only)                                 <E                                                                                           The 7-Tone format consists of an initial 5-tone sequence, gap                of 0,  1, or 2 TP, and a concluding 2-tone sequence.  The last 2                digits may  be used  for such  purposes as identification of the                calling party.                                                                                                                                                                                                                                          .-----.-----.-----.-----.-----.        .-----.-----.                       -----|  1  |  2  |  3  |  4  |  5  |---//---|  6  |  7  |----                        '-----'-----'-----'-----'-----'        '-----'-----'                                                                                                            ^----^----^----^----^----^----^--------^-----^-----^                             1TP  1TP  1TP  1TP  1TP  1TP   0,1,2  | 1TP   1TP                              |                             |   TP   |         |                              '--------------v--------------'----v---'----v----'                                       First 5 Digits           GAP    Last 2                                                                          Digits                                                                                                                             7 TONE ENCODE FORMAT                                                                                                                E>      7.14 7-Tone Gap                                                       <E                                                                                           When the 7-Tone Format has been selected, the gap between the                first 5 and last 2 tones may be set to 0, 1 or 2 Tone Periods.                                                                                                     In  the  case  of  zero-length  gap,  automatic  repeat  tone                insertion will occur along the entire 7 tone sequence.                                                                                                             In  the  case  of  a  1  or  2  TP gap, automatic repeat tone                insertion will NOT occur ACROSS the gap, as this would result in                incorrect  system  operation, but WILL occur for the first five,                and  last  two  digits.                                                                                                                                         For example:                                                                                                                                                             [Input]                  [Output]                                                                                                                                1000000                  10R0R0R     No Gap                                     10000--00                10R0R--0R   Gap = 1 or 2                                                                                                               1200000                  120R0R0     No Gap                                     12000--00                120R0--0R   Gap = 1 or 2                                                                                                                                                                             E>      7.15 Tx Call Code                                                     <E                                                                                           The Tx Call code consists of two parts; a 5-tone Primary Code                and an  optional Secondary code.  The Secondary code is used for                the 5-tone plus 6th-tone Status, 6-tone, and 7-tone formats.                                                                                                       The Primary  code may contain the digits 0 to 9 and the Group                tone (A).                                                               P>                                                                                         The Secondary  code may  contain the  digits 0  to 9, and the                Group (A), Reset (C) and Repeat (E) tones. In the case of 5-Tone                plus  6th-tone Status format, tones 0 - 9 and A - F may be used.                                                                                                   Also, the  variable digits H and I may be programmed into any                position  in  the  Tx  Call  code,  irrespective of the selected                format.                                                                                                                                                            If only one digit  is  to be  variable, the I digit [MUST] be                used for correct radio operation.                                                                                                                              [NOTE:]   The area  allocated on  the screen  for entry of the                   TxCall code will vary to represent the TxCall Format selected.                                                                                          E>      7.16 Tx Call Protocol                                                 <E                                                                                E>         7.16.1 Normal Protocol                                             <E                                                                                           When the Normal mode is selected, the following will occur                   on a TXCALL command:                                                                                                                                               a.  If in the QUIET state, or if the channel is BUSY,                               sound an audible alert and do not send the TXCALL code.                     b.  If in the OPEN state, and not BUSY, send the TXCALL code.                                                                                        E>         7.16.2 Autocall Protocol                                           <E                                                                                           When the Autocall function is selected as the TXCALL protocol                the KFT-x  module responds  in the  following way  to  a  TXCALL                command:                                                                                                                                                           a.  Send immediately if the channel is not busy.                                    (The call is sent regardless of the Mute Control State)                     b.  Postpone transmission if channel is busy.                                   c.  When channel  becomes clear,  process a postponed call (if                      any) after a delay.  The delay time,  between 3.33 seconds                      to 6.66 seconds, is randomly derived by the  KFT-x  module                      to prevent clashing calls.                                                  d.  If the channel  becomes busy again during the random delay                      period, then  the  random timer is reset. When the channel                      again becomes  available, the  random delay is entered and                      the call is sent at the end  of  this delay. This cycle of                      random retries  will  continue  until a successful call is                      achieved.                                                                                                                                                After  successfully  sending  the  call,  the  KFT-x waits for 4                seconds  for  an  acknowledgement  sequence.  During  this time,                receipt  of  a  normal  call  will  NOT  result in any visual or                audible alert to the user. the mute state of the radio will also                not  be  affected.                                                                                                                                              Note  that  operation of the PTT or QUIET/OPEN switches during a                pending  Autocall  (i.e  channel BUSY) will cancel the Autocall.                When  the  channel again becomes clear, a call sequence will NOT        P>      be  sent.                                                                                                                                                          Autocall operation is important in Tx Lockout applications.                                                                                                     "TX Override" may be  implemented  in  cases  where  the call               [MUST]  be  sent  regardless  of  the  channel  BUSY condition by                disabling  the  BUSY signal either within the radio's processor,                or by connecting it permanently to a low logic level (OV).                                                                                              E>      7.17 Tx Time Out Timer                                                <E                                                                                           The KFT-x  has a  built in  Transmit Time Out Timer function.                The time  limit can  be set  to 15,  30, 45, 60, 120, 180 or 240                Secs.                                                                                                                                                              A continuous  warning tone  will sound  on expiry of the time                out period.                                                                                                                                                        6 seconds  before time out a warning beep also sounds.  After                time out,  or if  PTT is  released immediately  after a  warning                beep, the transmitter is disabled for  6 seconds.  If PTT is not                released  before  the   6  second  lockout   time  expires,  the                transmitter  will  remain disabled indefinitely. Upon release of                PTT  during the 6 second lockout period, subsequent operation of                PTT [OR] TXCALL  will  NOT  result in  transmission  until the 6                second  period  has  expired.  For  transmission  to  occur, the                transition  of  the PTT to the active state must occur after the                expiry  of  the  lockout  period.  This  allows  other  users an                opportunity to access the channel.                                                                                                                                 The Time  Out Timer function has the added feature that, when                Trailing edge  ANI is used, an ANI message is sent at the end of                any transmission which reaches the allowed time limit.                                                                                                          The  Time  Out  Timer  is  suspended  during  selcall  sequence                 encoding.  This  means  that  when  ANI  is enabled, the maximum                transmitter  ON time will be extended by the duration of the ANI                transmission. This becomes more significant for Leading ANI with                long  Lead In Delay, Random ANI with longer settings of TOT, and                longer  settings  of  Tone  Period.                                                                                                                                                                                                     E>      7.18 Auxiliary Code                                                   <E                                                                                           An  Auxiliary  tone  sequence  of  5  tones  may  be  set  up                independently of  the TXCALL  code or  the RXDECODE  code.  This                Auxiliary code  may then be nominated for use as an ANI code, as                a REPEATER ACCESS code, and/or an Acknowledge code.                                                                                                     P>                                                                              E>      7.19 Multiple Sequence                                                <E                                                                                        When  the  Multiple  Sequence  feature  is  selected  then  the                 Auxiliary  Code  will  be  used  as  a prefix to all TXCALL code                transmissions.  The  dual  tone  sequence which results uses the                Auxiliary  code  to,  for  example, provide access to a repeater                which  is  guarded  by a tone sequential decoder, and the TXCALL                code  that  follows  is  retransmitted  through  the repeater to                provide  the  normal  Call  function.                                                                                                                           For  example,  a  TXCALL  transmission with Repeater Access will                have  the  following  format:                                                                                                                                                                                                                              ,---,---,---,---,---,         .---.---.---.---.---.                     -LID----| 1 | 2 | 3 | 4 | 5 |---------| 1 | 2 | 3 | 4 | 5 |--                           '---'---'---'---'---'         '---'---'---'---'---'                             ^---^---^---^---^---^---------^---^---^---^---^---^                              1TP                    3TP                                                                                                                                     |                   |         |                   |                             '---------v---------'         '---------v---------'                             Multiple Sequence Code             TXCALL Code                                                                                                       Note  that  the Multiple Sequence code will also be added to ANI                sequences if ANI is enabled. This applies to Random and Trailing                ANI  sequences  as well as any Leading ANI sequence, if present.                                                                                                The  Multiple  Sequence  code  is  [NOT],  however,  added  to                  acknowledge  sequences.                                                                                                                                 E>      7.20 Tx Acknowledge Code Format                                       <E                                                                                           The KFT-x  may be  programmed to automatically re-transmit an                acknowledgement sequence back to the calling party after a valid                decode.  The Acknowledge sequence may take several forms:                                                                                                          a.  OFF - no acknowledgement                                                    b.  BEEP acknowledgement - a tone of 7 TP duration                              c.  RXDECODE code acknowledgement                                               d.  TXCALL code acknowledgement                                                 e.  AUXILIARY code acknowledgement                                                                                                                              The acknowledge sequence is sent regardless of the BUSY or                   Mute Control state of the radio.                                                                                                                                The Multiple Sequence Code, when enabled, will not be appended                  to the acknowledge sequence.  See "Multiple Sequence Code".                                                                                             P>                                                                              E>      7.21 Tx ANI Code                                                      <E                                                                                           An ANI code is a tone sequence sent out during a normal voice                transmission which  identifies the radio currently transmitting.                The KFT-x  module supports  various types  of ANI  formats.  The                TXANI code may be programmed to be any of the following codes:                                                                                                     a.  TXCALL Code.                                                                b.  RXDECODE Code                                                               c.  AUXILIARY Code                                                                                                                                                                                                                   E>      7.22 Tx ANI Mode                                                      <E                                                                                           The timing  of the  transmitted ANI  sequence, in relation to                operation of  the PTT  switch, may  be  programmed  to  be  Off,                Leading, Trailing,  Random, or  any combination  of these.   The                operation, advantages  and disadvantages  of  these  options  is                detailed below.                                                                                                                                                                                                                         E>         7.22.1 Leading Edge ANI                                            <E                                                                                           Leading Edge  ANI is  where the  ANI tone sequence is sent at                the start of every transmission. The programmed Lead in Delay is                automatically appended  to the  start of  every Leading Edge ANI                transmission of this type.                                                                                                                                         Advantage: Immediate  identification of  the party  using the                channel.                                                                                                                                                           Disadvantages: First  syllable(s) of  voice  traffic  at  the                start of each "over" may be truncated by the ANI transmission.                                                                                                                                                                          E>         7.22.2 Trailing Edge ANI                                           <E                                                                                           Trailing Edge  ANI is  where the ANI tone sequence is sent at                the end of every transmission. There is often no need for a long                Lead in Delay with  this type of ANI,  and so a 2 TP silent Lead                in Delay precedes the ANI sequence.                                                                                                                                Advantage: The  ANI  transmission  does  not  interfere  with                normal voice  traffic.   There is  no need  for a  long Lead  in                Delay.                                                                                                                                                             Disadvantage: The  calling party will not be identified until                the end of the first "over".                                                                                                                                                                                                            E>         7.22.3 Random ANI                                                  <E                                                                                           Where neither  Leading or  Trailing Edge ANI is sufficient to                trap the  identity of  nuisance callers,  Random  ANI  is  used.                Random ANI is also very useful for identifying microphones which        P>      have their PTT switch permanently pressed.                                                                                                                         In Random  ANI mode  the ANI  tone sequence  is sent  at some                random time during each 10 second time period of a transmission.                If a  radio operator  speaks for less than 10 seconds and a tone                sequence has  not  occurred  by  the  time  the  PTT  switch  is                released, then  the ANI sequence will be immediately appended to                the end of the transmission.                                                                                                                                       The Random ANI sequence will occur  at  least  once between 2                and 10 seconds from the  start  of each  10  second period.  The                first 10 second period commences when PTT becomes active.                                                                                                          All Random ANI sequences  are preceded  by a 2 TP silent Lead                In Delay.                                                                                                                                                          In this  type of ANI the precise time of transmission of each                tone sequence  is not  predictable, and  therefore a user cannot                easily devise a way of defeating the system.                                                                                                                                                                                            E>         7.22.4  ANI Combinations                                           <E                                                                                           Any combination of Leading, Random and/or Trailing ANI may                   be selected to suit particular system requirements.                                                                                                                                                                                     E>      7.23  Key Beeps                                                       <E                                                                                           When this feature is ON, an audible tone will be generated                   on activation of the TXCALL, QUIET/OPEN and PTT switches.                       The following tones are produced:                                                                                                                                  QUIET/OPEN switch:                                                                  Change to QUIET state    Low frequency beep                                     Change to OPEN state     High frequency beep                                                                                                                TXCALL switch:               Medium frequency beep                                                                                                              PTT switch:                                                                         QUIET or BUSY state      Interrupted beep                                                                                                                                                                                                                                                                        E>      -----------------------  END OF DOCUMENT  ----------------------      <E                                                                                                                                                                               Doc. S1500            KPG3D.HB            22-02-90               