;
;
;
;   AVR-Video V6.2  40x25
;   Jan Baare 30.09.06
;
;   ATMEGA-8 16MHZ
;
;
;Serielles ASCII-Video Terminalprogramm fr ATMEGA8 und Fernsehgert
; - 25 Zeilen mit je 40 Zeichen
; - PAL-kompatibles BAS Videosignal
; - Betrieb an jedem SW- oder Farbfernsehgert mit
;   Video-IN bzw. BAS-IN Anschluss oder ber SCART
; - RS-232 Eingang mit TTL-Pegel
; - einstellbare Baudrate 300 bis 19800 Baud
; - ASCII Zeichensatz
; - Steuerzeichen CR, LF, FF
; - Cursorpositionierung, Scrollen
;
; - Luft auf dem ATMEGA-8 mit 16 MHz.
; - keine externen Bauteile ausser drei Widerstnden
;   zur Pegelanpassung des Videosignales.
;
;Dieses Programm muss in den ATMEGA8 geflasht werden.
;Es muss die Fuse-Einstellung fr 16MHZ Quarz gewhlt werden.
;
;PortB1 (Pin15) und PortB3 (Pin17) verbinden.
;An PortB1 (Pin15) einen Widerstand 150 Ohm anschliessen.
;An PortD6 (Pin12) einen Widerstand 560 Ohm anschliesen
;AN GND (Pin22) einen Widerstand mit 1K Ohm anschliessen
;die freien Enden dieser drei Widerstnde verbinden ergibt das Video Signal.
;
;Der RSR232 Eingang wird an Rxd (Pin2) mit TTL-Pegel angeschlossen.
;Der RSR232 Ausgang TxD wird nicht benutzt.
;
;Die Baudrate kann ber drei Jumper an PortD2-4 (Pin4,5,6) eingestellt werden.
;Wenn nichts angeschlossen wird (Pins offen),ist 9600 Baud eingestellt.
;Die gewhlte Baudrate wird nach dem Einschalten bernommen,
;und wird auf dem Bldschirm angezeigt.
;Es werden die Parameter 8 Bits, 1 Stopbit, no Parity verwendet.
;
;Baudrateneinstellung:

;Pin 6 5 4  Baud
;---------------
;    1 1 1  9600
;    1 1 0 19800
;    1 0 1  4800
;    1 0 0  2400
;    0 1 1  1200
;    0 1 0   300
;    0 0 1  9600
;    0 0 0  9600
;
;
;
;Folgende Steuerzeichen knnen genutzt werden:
;
;Zeichen Taste  Code-HEX  Code-DEZ  Funktion
;--------------------------------------------
; CR     Ctrl-M    0D        13     Cursor auf Anfang der Zeile setzen
; LF     Ctrl-J    0A        10     Cursor eine Zeile tiefer setzen
; FF     Ctrl-L    0C        12     Bildschirm lschen
; SO     Ctrl-N    0E        14     Cursor auf Spalte X setzen.
;                                     X ist das nchste Zeichen und muss kleiner 36dez sein
; SI     Ctrl-O    0F        15     Cursor auf Zeile Y setzen.
;                                     Y ist das nchste Zeichen und muss kleiner 24dez sein
;
;
;
;Dieses Programm ist ein reines Experiment
;Benutzung erfolgt auf eigene Gefahr
;Ich bernehme keine Gewhr fr Funktion oder mgliche Schden
;
;Alle Rechte vorbehalten. Jan Baare 30.09.06
;
;

.LISTMAC

.NOLIST
.INCLUDE <m8def.inc>
.LIST

.DEF zero     = R2   
.DEF curpl    = R3   ;Cursorpos. in Charbuf
.DEF curph    = R4   ;
.DEF xlsi     = R5	 ;XI(Interrupt) Save
.DEF xhsi     = R6 
.DEF ssreg    = R7  ;Status Reg Save
.DEF ibupw    = R8  ;Input Buffer Pointer Write
.DEF ibupr    = R9  ;dito Read
.DEF curbuf   = R10 ;Cursor Buffer
.DEF t0rlv    = R11 ;
.DEF spipbein = R12
.DEF spipbaus = R13
.DEF spiein   = r14
.DEF spiaus   = r15

.DEF mpa      = R16  ;Akku A
.DEF mpb      = R17  ;     B
.DEF mpc      = R18  ;     C
.DEF zz       = R19  ;Zeilenzhler
.DEF fz       = R20  ;Framezhler
.DEF scroll   = R21  ;Scroll Flag / Count
.DEF clrs     = R22  ;CLS Flag /Count
.DEF posc     = R23  ;Position Char
.DEF cgp      = R24  ;
.DEF ticks    = R25  ;15625Hz Ticker

.EQU timval = 127    ;Timer
.EQU txtl  = 25      ;Anzahl Text Lines
.EQU preql = 2       ;Pre Vsync Equalizing Lines
.EQU vsyncl  = 3     ;Vertical Sync Lines
.EQU poeql = 2       ;Post Vsync Equalizing Lines
.EQU vidl  = txtl    ;Video Lines
.EQU ubll  = 50      ;upper blank lines
.EQU lbll  = 30      ;lower blank lines
.EQU cpl   = 40      ;Chars per line
.EQU ssv   = 56      ;Schwarzschulter vorne
.EQU lpc   = 9       ;lines per Char
.EQU CBSize= cpl*vidl;Charbufsize
.EQU InBufSize = 16  ;ser.InputBuffer


.DSEG
;.ORG 0x60
Charbuf: .byte CBSize     ;ASCII Zeichenspeicher
inbuf:   .byte inbufsize  ;Eingangsbuffer fr RSR232
                      

.CSEG

.macro endint
;Ende der Interruptverarbeitung
;damit werden die Zeilen-INTs beendet
;muss vor dem nchsten Timer-Int erreicht werden 
          out SREG,ssreg     ;Restore StatusReg
          reti               ;und ab nach Hause
.endmacro

.macro synclo
    cbi portd,6
.endmacro

.macro synchi
    sbi portd,6
.endmacro


;Interrupt Vector Table
        rjmp RESET           ;Reset Handler
        rjmp RESET           ;EXT_INT0 ; IRQ0 Handler
        rjmp RESET           ;EXT_INT1 ; IRQ1 Handler
        rjmp RESET           ;TIM2_COMP ; Timer2 Compare Handler
        rjmp RESET           ;TIM2_OVF ; Timer2 Overflow Handler
        rjmp RESET           ;TIM1_CAPT ; Timer1 Capture Handler
        rjmp RESET           ;TIM1_COMPA ; Timer1 CompareA Handler
        rjmp RESET           ;TIM1_COMPB ; Timer1 CompareB Handler
        rjmp RESET           ;TIM1_OVF ; Timer1 Overflow Handler
        rjmp hsync           ;TIM0_OVF ; Timer0 Overflow Handler
        rjmp RESET           ;SPI_STC ; SPI Transfer Complete Handler
        rjmp RESET           ;USART_RXC ; USART RX Complete Handler
        rjmp RESET           ;USART_UDRE ; UDR Empty Handler
        rjmp RESET           ;USART_TXC ; USART TX Complete Handler
        rjmp RESET           ;ADC_CC ; ADC Conversion Complete Handler
        rjmp RESET           ;EE_RDY ; EEPROM Ready Handler
        rjmp RESET           ;ANA_COMP ; Analog Comparator Handler
        rjmp RESET           ;TWSI ; Two-wire Serial Interface Handler
        rjmp RESET           ;SPM_RDY ; Store Program Memory Ready Handler


RESET:  ldi mpa,high(RAMEND) ;SP setzen
        out SPH,mpa
        ldi mpa,low(RAMEND)
        out SPL,mpa


;Init IO-Ports
        ldi mpa,0           
        mov zero,mpa
        ldi mpa,0x00
        ldi mpa,0b00101100
        mov spipbein,mpa
        ldi mpa,0b00100110
        mov spipbaus,mpa
        ldi mpa,0x50
        mov spiein,mpa
        ldi mpa,0x30
        mov spiaus,mpa
        out ddrb,spipbaus    ;PortB0 Output, B1-B7 Input
        ldi mpa,0x0
        out portb,mpa

        ldi mpa,0            ;PortC 0-7 Input
        out portc,mpa
        ldi mpa,0x40         ;PortD6 Output, D0-D5 und D7 Input
        out ddrd,mpa
        ldi mpa,0xff         ;Pullups einschalten
        out portc,mpa
        out portd,mpa
        cbi portd,6          ;Video Out auf LO, Sync Out bleibt HI

        ;SPI auf double Clk
        ldi mpa,1
        out spsr,mpa

;Zeichenspeicher mit Leerzeichen fllen
        ldi XH,HIGH(Charbuf)
        ldi XL, LOW(Charbuf)
        ldi mpc,' '
        ldi mpa,txtl
ldtst1: ldi mpb,cpl
ldtst2: st X+,mpc
        dec mpb
        brne ldtst2
        dec mpa
        brne ldtst1


;Starttext eintragen
        ldi ZH,HIGH(Initxt<<1)
        ldi ZL, LOW(Initxt<<1)
        ldi XH,HIGH(Charbuf)
        ldi XL, LOW(Charbuf)
        ldi mpa,cpl*3
inil1:  lpm mpc,Z+
        st X+,mpc
        dec mpa
        brne inil1
     

;RSR232 Input Buffer lschen
        ldi XH,HIGH(inbuf)
        ldi XL, LOW(inbuf)
        ldi mpa,InBufSize
inbufc: st X+,zero
        dec mpa
        brne inbufc


;Init USART
;Baudratenjumper einlesen und auswerten
;  und Baudrate anzeigen
        ;IO-Port lesen,
        ;Baudratenwerte aus Tabelle holen 
        in mpa,PIND
        andi mpa,0b00011100  ;nur die Bits 2-4 interessieren
        lsl mpa              ;Tabellenzeile ist 8 Bytes lang
        ldi ZH,HIGH(Baudtab<<1) ;auf Anfang der Tabelle
        ldi ZL, LOW(Baudtab<<1)
        add ZL,mpa           ;Baudratennr. mal acht dazu
        adc ZH,zero
        lpm mpa,Z+           ;Baudratenwerte fr USART holen
        lpm mpb,Z+
        ;USART Baudrate setzen
        out UBRRH,mpb
        out UBRRL,mpa
        ;Baudrate auf Screen anzeigen
        ldi XH,HIGH(Charbuf+cpl*2);Position auf Bildschirm
        ldi XL, LOW(Charbuf+cpl*2)
        ldi mpb,6            ;6 Zeichen
baudl:  lpm mpa,Z+           ;  holen
        st X+,mpa            ;  und im Charbuffer speichern
        dec mpb
        brne baudl           
        ;USART einstellen und starten
baud2:  ldi mpa,0x10         ;Receiver enable
        out UCSRB,mpa
        ldi mpa,0x86         ;8-Bit, 1 Stopbit, no Parity
        out UCSRC,mpa


;Init TIMER0
        ldi mpa,2
        out tccr0,mpa        ;timer 0 vorteiler auf clk/8
        ldi mpa,0-timval    ;timer0 reload value 63us
        mov t0rlv,mpa        ;wird noch fter gebraucht
        out tcnt0,t0rlv
        in mpa,timsk         ;Timer interrupt mask
        ori mpa,1 
        out timsk,mpa        ;timer 0 interrupt enable

;Register vorbelegen / lschen
        clr ibupr
        clr ibupw
        ldi mpa,' '
        mov curbuf,mpa
        ldi XH,HIGH(Charbuf+cpl*4)
        ldi XL, LOW(Charbuf+cpl*4)
        mov curph,XH             
        mov curpl,XL		
        clr scroll          ;kein Scrollen
        clr clrs            ;kein Cls
        clr posc            ;keine CursorPos Sequenz aktiv
        ldi ZH,HIGH(preq)   ;Starten mit VSync-Zeilen
        ldi ZL, LOW(preq)
        ldi zz,preql        ;Anzahl Zeilen

        sei                 ;Int Enable


;Das Hauptprogamm
;Okay, ist nicht viel, aber schn bersichtlich
mloop:  nop
        rjmp mloop
;Ende Hauptprogramm 
;was sonst noch zu tun ist, luft im Interrupt 


;Baudratenwerte fr USART
;  und Texte fr Anzeige
Baudtab:
 .DB 0x67,0x00," 9600 "   ;000  
 .DB 0x67,0x00," 9600 "   ;001  
 .DB 0x04,0x0D,"  300 "   ;010   
 .DB 0x40,0x03," 1200 "   ;011  
 .DB 0xA0,0x01," 2400 "   ;100 
 .DB 0xCF,0x00," 4800 "   ;101   
 .DB 0x33,0x00,"19200 "   ;110 
 .DB 0x67,0x00," 9600 "   ;111  


;Begrssungstext
Initxt:
 .DB "AVR TV-Terminal 6.2          JB 30.09.06"
 .DB "                                        "
 .DB "      8,n,1                             "


;Horizontal-Sync, damit startet jede Zeile
;wird alle 64us per Timer0-Int aufgerufen
;erzeugt das H-Sync Signal
;Startet den 64us Timer neu
;Holt, falls ntig, ein neues Zeichen vom USART
;und legt es im Input-Buffer ab
  hsync:        
          nop                ;Laufzeitausgleich     
          synclo             ;Syncsignal Lo setzen
          out tcnt0,t0rlv 
          in ssreg,SREG      ;Statusreg retten
          mov xhsi,XH        ;X retten
          mov xlsi,XL

          ldi mpb,24         ;normale Hsynczeit
          in mpa,UCSRA       ;USART Status
          andi mpa,0x80      ;Neuer Char da ?
          breq hsync1        ;Nee
          in mpa,UDR         ;USART Data holen
          ldi XH,HIGH(inbuf) ;X auf Start Input Buffer
          ldi XL, LOW(inbuf) 
          add XL,ibupw       ;Write-Pointer dazu
          adc XH,zero
          st X,mpa           ;neuen Char ablegen
          inc ibupw          ;Pointer weitersetzen
          ldi mpa,InBufSize-1;Pointer wraparound
          and ibupw,mpa
          subi mpb,4         ;Zeitausgleich fr Hsync 
          nop                ;  falls neuer Char da war
          nop
hsync1:   mov XH,xhsi        ;Restore X
          mov XL,xlsi
hsync2:   dec mpb            ;Restliche HSync-Zeit vertrdeln
          brne hsync2
          ijmp               ;Ende Hsync


;Leerzeilen mit den Ausgleichsimpulsen
preq:   synchi                ;Syncsignal wieder auf HI
        ldi mpa,144           ;1/2 Zeile abwarten
preqb:  dec mpa 
        brne preqb
        ;Hsync Impuls auf 1/2 Zeile
        cbi portd,6          ;Sync auf LO
        ldi mpa,24
preqc:  dec mpa
        brne preqc          
        sbi portd,6          ;Sync zuck auf HI

        dec zz               ;noch mehr Zeilen ?
        brne preqd           ;ja
        ldi ZH,HIGH(vsync)   ;danach kommt Vsync
        ldi ZL,LOW(vsync)
        ldi zz,vsyncl        ;Anzahl setzen
preqd:  endint               ;das wars



;Vertical Sync
;damit fngt jedes Bild an
vsync: ;1/2 Zeile minus HSync-Zeit abwarten, Sync bleibt noch LO
        ldi mpa,120 
vs1a:   dec mpa
        brne vs1a
        ;inv. Hsync-Impuls auf 1/2 Vsync-Zeile
        sbi portd,6         ;Sync auf HI
        ldi mpa,24          ;4,75us
vs1b:   dec mpa
        brne vs1b
        synclo              ;Sync auf LO
        ldi mpa,142         ;  fr den Rest der Zeile
vs1c:   dec mpa
        brne vs1c
        synchi              ;Sync zurck auf HI
        dec zz              ;noch mehr Vsync-Zeilen ?
        brne vs1d           ;  ja
        ldi ZH,HIGH(poeq)   ;danach kommen die
        ldi ZL,LOW(poeq)    ;  hinteren Ausgleichs-Zeilen
        ldi zz,poeql        ;Anzahl setzen
vs1d:   endint            


;Leerzeilen mit den Ausgleichsimpulsen
poeq:   synchi              ;Syncsignal wieder auf HI
        ldi mpa,144         ;1/2 Zeile abwarten
poeqb:  dec mpa 
        brne poeqb
        ;Hsync Impuls auf 1/2 Zeile
        synclo              ;Sync auf LO
        ldi mpa,24
poeqc:  dec mpa
        brne poeqc          
        synchi              ;Sync zuck auf HI

        dec zz              ;noch mehr Zeilen ?
        brne poeqd          ; ja
        ldi ZH,HIGH(leero)  ;danach kommen Leerzeilen
        ldi ZL,LOW(leero)
        ldi zz,ubll         ;Anzahl setzen
poeqd:  endint              ;das wars




;Obere Leerzeilen
;Hier ist der Terminalprogrammteil mit
;untergebracht, weil hier viel Zeit brig ist
leero:  synchi               ;Syncsignal wieder auf HI
        rcall term           ;Terminalteil ausfhren 

leeroa: dec zz               ;noch mehr Leerzeilen ?
        brne leerob          ;  ja
        ldi ZH,HIGH(dline)   ;als nchstes kommen 
        ldi ZL, LOW(dline)   ;  Display Lines   
        ldi zz,lpc           ;Zeilen pro Zeichen
        ldi fz,vidl          ;Anzahl Video-Zeilen
        ldi YH,HIGH(Charbuf) ;Init Character-Bufferpointer
        ldi YL, LOW(Charbuf)
        ldi cgp,High(chargenx<<1)
leerob: endint               




;Hier ist die eigentliche Video-Darstellung
dline:  synchi        ;Syncsignal wieder auf HI
        ;Schwarzschulter abwarten
        ldi mpa,ssv 
dlineb: dec mpa
        brne dlineb
        ;Pixeldaten fr 40 Chars rausschieben
        mov XH,YH
        mov XL,YL
        mov ZH,cgp
        inc cgp
        ldi mpc,cpl
dlinelp:
        ld ZL,x+
        lpm mpb,Z
        out spcr,spiaus
        out ddrb,spipbaus
        out spcr,spiein 
        out spdr,mpb
        out ddrb,spipbein
        andi mpb,0x02
        out portb,mpb
        nop
        dec mpc
        brne dlinelp
        nop
        nop
        nop
        nop
        nop
        nop
        out portb,zero      
        out spcr,spiaus
        out ddrb,spipbaus
 

        dec zz               ;alle Zeilen fertig ?
        brne dlined          ;  nee
        dec fz               ;waren das alle Frames ?
        brne dlinec          ;  nee, da kommen noch mehr
        ldi ZH,HIGH(leeru)  ;Ok, dann machen wir weiter
        ldi ZL, LOW(leeru)  ;  mit den unteren Leerzeilen
        ldi zz,lbll          ;Anzahl Leerzeilen
        endint               ;Zurck
        ;noch ein Frame, also vorher neue Pixel bereitstellen
dlinec: ldi ZH,HIGH(dline)   ;weitere video lines
        ldi ZL, LOW(dline)
        ldi zz,lpc           ;Zeilen pro Zeichen
        adiw YH:YL,cpl       ;Chars per line
        ldi cgp,High(chargenx<<1)
        endint
dlined: ldi ZH,HIGH(dline)   ;restore wg.
        ldi ZL, LOW(dline)	 ;  Wiederholung letzte Zeile
        cpi zz,1
        brne dlinee
        dec cgp   
dlinee: endint               




;Untere Leerzeilen
leeru:  synchi          ;Syncsignal wieder auf HI
        rcall term           ;Terminalteil ausfhren
        dec zz               ;noch mehr Zeilen ?
        brne leerua          ;  ja
        ldi ZH,HIGH(preq)  ;Bild Ende
        ldi ZL,LOW(preq)   ;  jetzt kommt der nchste VSync
        ldi zz,preql       ;Anzahl Vsync Zeilen
		inc ticks			 ;50Hz Ticker
leerua: endint               



;Der Terminalprogrammteil
term:   ori clrs,0           ;sind wir am Bildschirm-Lschen ?
        brne clrscr          ;  ja
        cpi scroll,1         ;sind wir am Scrollen ?
        brlo charw           ;  nee
        ;also scrollen
        breq scrlpb          ;letzte Scrollzeile, also neue Leerzeile
        mov XH,curph         ;akt. Cursorposition im Charbuffer
        mov XL,curpl
        st X,curbuf          ;Restore Char auf Cursorposition
        dec scroll           ;nchste Scroll-Portion
        ldi mpa,txtl         ;gescrollt wird von unten nach oben
        sub mpa,scroll       ;  
        ldi mpb,cpl          ;eine Zeile scrollen
        mul mpb,mpa          ;akt. Portion mal Portionsgrsse
                             ;   = Scroll-Startposition im Buffer
        ldi YH,HIGH(Charbuf) ;Anfang Buffer
        ldi YL, LOW(Charbuf)  
        ldi XH,HIGH(Charbuf+cpl);Anfang zweite Zeile
        ldi XL, LOW(Charbuf+cpl)
        add YL,r0            ;plus Scrollstartposition
        adc YH,r1
        add XL,r0            ;auch plus Scrollstart
        adc XH,r1
scrlp:  ld mpa,X+            
        st Y+,mpa
        dec mpb
        brne scrlp           ;fertig
        
scrlpa: mov XH,curph         ;X wieder auf akt. Cursorpos.
        mov XL,curpl
        ;Cursor blinken lassen
        ldi mpa,'_'
        sbrc ticks,4         ;ca. 2Hz
        ldi mpa,' '
        st X,mpa
        ret          ;zurck zum INT-Handler

        ;letzte Zeile auf Bildschirm lschen
scrlpb: clr scroll           ;Scrollen ist fertig
        ldi YH,HIGH(Charbuf+cbsize-cpl);Pointer auf letzte Zeile
        ldi YL, LOW(Charbuf+cbsize-cpl);  im Character Buffer 
        ldi mpb,cpl           ;1 Zeile lschen
        ldi mpa,' '          ;Lschen = Leerzeichen eintragen 
        mov curbuf,mpa       ;akt. Cursorpos lchen
scrlpc: st Y+,mpa            ;ein Zeichen lschen
        dec mpb
        brne scrlpc
        rjmp scrlpa          ;fertig


;Bildschirm lschen 
clrscr: ldi mpb,cpl          ;eine Zeile
        dec clrs             ;nchstes Mal die nchste Zeile
        mul mpb,clrs         ;errechen Offset zum Lschen
        
        ldi YH,HIGH(Charbuf) ;Start Zeichenspeicher
        ldi YL, LOW(Charbuf)
        mov curph,YH         ;   wird neue Cursorposition
        mov curpl,YL         ;      nach dem lschen
        add YL,r0            ;Start + Offset   
        adc YH,r1
        ldi mpa,' '          ;Lschen = Leerzeichen eintragen
        ldi mpb,cpl          ;eine Zeile lschen
clrlp:  st Y+,mpa            ;lschen
        dec mpb
        brne clrlp
        mov curbuf,mpa       ;Cursorbuffer auch lschen
        ;Cursor blinken lassen
        ldi mpa,'_'
        sbrc ticks,4         ;ca. 2 Hz
        ldi mpa,' '
        mov XH,curph
        mov XL,curpl
        st X,mpa             ;auf akt. Cursorposition
        ret                  ;zurck zum INT-Handler



;nchstes Zeichen aus Input Buffer holen
;(wenn noch eins da ist)
charw:  mov XH,curph         ;Pointer in Charbuf
        mov XL,curpl         ;  schon mal vorsorglich holen
        ldi YH,HIGH(inbuf)   ;RSR232-Input Buffer   
        ldi YL, LOW(inbuf) 
        add YL,ibupr         ;Bufferpointer-Read    
        adc YH,zero
        ld mpa,Y             ;Bufferinhalt lesen
        ori mpa,0            ;Char da ?
        breq charwb          ;  Nein
        ;ja, da ist eins
        ldi mpb,0     
        st Y,mpb             ;Platz im Buffer lschen 
        inc ibupr            ;Bufferpointer weitersetzen
        ldi mpb,InBufSize-1        
        and ibupr,mpb        ;Bufferpointer wraparound


       ;Char auswerten
        cpi posc,'X'         ;sind wir in einer X-Cursorpos-Sequenz ?
        breq charXPz         ;  ja
        cpi posc,'Y'         ;sind wir in einer Y-Cursorpos-Sequenz ?
        breq charYPa         ;  ja

        cpi mpa,0x0c         ;ist es FF ?
        breq char0c          ;Ja
        cpi mpa,0x0a         ;ist es LF ?
        breq char0a
        cpi mpa,0x0d         ;ist es CR ?
        breq char0d
        cpi mpa,0x0e         ;ist es SO Ctrl-N ?
        breq charYP
        cpi mpa,0x0f         ;ist es SI Ctrl-O ?
        breq charXP

        ;Es ist ein darstellbares Zeichen
        st X+,mpa           ;ab in den Zeichenspeicher damit
        ;sind wir em Bildschirmende ?
charwa: cpi XH,HIGH(Charbuf+cbsize)
        brlo charwc          ; nein sicher nicht
        cpi XL,LOW(Charbuf+cbsize)
        brlo charwc          ; nein
        ;ja, dann mssen wir scrollen
        ldi scroll,txtl+1        ;txtl Zeilen scrollen + Leerzeile
        ldi XH,HIGH(Charbuf+CBSize-cpl) ;neue Cursorposition wird 
        ldi XL, LOW(Charbuf+CBSize-cpl) ;  Anfang letzte Zeile sein

charwc: ld curbuf,X          ;save Char auf Cursorposition
        ;Cursor blinken lassen
charwb: ldi mpa,'_'          ;--abwechselnd Unterstrich
        sbrc ticks,4         ;ca. 2Hz Blinkfrequenz
        ldi mpa,' '          ;--oder Leerzeichen
        st X,mpa             ;in den Zeichenspeicher auf Cursorpos.
        mov curph,XH
        mov curpl,XL
        ret          ;Zurck zum INT-Handler


;LF Cursor eine Zeile tiefer setzen
char0a: st X,curbuf          ;Restore Char auf akt. Cursorpos
        cpi XH,HIGH(Charbuf+cbsize-cpl);schon in der letzten Zeile ?
        brlo char0aa         ;  nein
        cpi XL,LOW(Charbuf+cbsize-cpl)
        brlo char0aa         ;  nein
        ldi scroll,txtl+1    ;  ja, dann scrollen
        rjmp charwb 
char0aa:adiw XH:XL,cpl        ;akt.Position + ZeichenproZeile
                             ;  = eine Zeile tiefer
        rjmp charwa                  



;CR Cursor auf Anfang der Zeile setzen
char0d: st X,curbuf          ;Restore Char auf akt. Cursorpos
        sbiw XH:XL,Charbuf/2 ;Berechne abs. Cursorpos im Buffer 
        sbiw XH:XL,Charbuf/2 ;  also ohne Mem-Offset
        mov mpb,XH
        mov mpc,XL
        ;berechne die atk. Cursor-Spalten Nr. 
char0da:sbiw XH:XL,cpl        ;Primitive Methode um den Rest
        brcc char0da         ;   von Division / cpl zu erhalten
        subi XL,0-cpl         ;     egal, hier ist Zeit genug
        clr XH
        sub mpc,XL           ;Cursorspaltennr. von 
        sbci mpb,0           ;   Cursorposition abziehen
        mov XH,mpb           ;   ergibt Cursor auf Anfang Zeile
        mov XL,mpc
        adiw XH:XL,Charbuf/2 ;Und den Speicher-Offset wieder dazu
        adiw XH:XL,Charbuf/2
        rjmp charwa          ;fertig



;FF Bildschirm-Lschen auslsen
char0c: ldi clrs,txtl       ;alle Text-Zeilen lschen
        rjmp charwb



charxpz: rjmp charXPa        ;Zwischenstation



;Cursorpositionierungssequenz Y starten
charYP: ldi posc,'Y'
        rjmp charwb

charYPa:clr posc             ;Ende Corsorpos. Sequenz
        cpi mpa,txtl         ;neue Cursorposition > letzte Zeile
        brsh charwb          ;  ja -> ignorieren
        st X,curbuf          ;Restore Char auf Cursorpos
        ;berechne die akt. Cursor-Spalten Nr. 
        sbiw XH:XL,Charbuf/2 ;Berechne abs. Cursorpos im Buffer  
        sbiw XH:XL,Charbuf/2 ;  ohne Mem-Offset
charYPb:sbiw XH:XL,cpl       ;und nochmal die simple Division
        brcc charYPb         ;   weil sie so gut klappt
        subi XL,0-cpl        
        clr XH              
        ldi mpb,cpl           ;Anzahl Zeichen pro Zeile
        mul mpa,mpb          ;  mal neue Zeilennr.
        add XL,r0            ;    plus Spaltennr.
        adc XH,r1            
        adiw XH:XL,Charbuf/2 ;und noch dem MEM-Offset
        adiw XH:XL,Charbuf/2 
        rjmp charwc          ;setze neue Cursorpos.



;Cursorpositionierungssequenz X starten
charXP: ldi posc,'X'
        rjmp charwb

;Cursor auf Spalte mpa setzen
charXPa:clr posc             ;Ende Corsorpos. Sequenz
        cpi mpa,cpl           ;neue Cursorposition > cpl ?
        brsh charwb          ;  ja -> igorieren
        st X,curbuf          ;Restore Char auf aktueller Cursorpos
        ;berechne die Startadresse der Zeile wo der Cursor drin steht 
        sbiw XH:XL,Charbuf/2 ;Berechne abs. Cursorpos im Buffer
        sbiw XH:XL,Charbuf/2 ;  ohne Mem-Offset
        mov mpb,XH           ;sichern
        mov mpc,XL
charXPb:sbiw XH:XL,cpl        ;Jaja, wieder die ALDI-Division
        brcc charXPb          
        subi XL,0-cpl          
        clr XH                 
        sub mpc,XL            
        sbci mpb,0
        ;neue X-Position auf Startadresse draufaddieren
        add mpc,mpa          ;neue xpos
        adc mpb,zero
        mov XH,mpb
        mov XL,mpc
        adiw XH:XL,Charbuf/2 ;MEM-Offset wieder drauf
        adiw XH:XL,Charbuf/2
        rjmp charwc          ;Cursor steht auf neuer Position



 ;Charactergenerator

.ORG 0xC00
chargenx:
.ORG 0xC00 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000 ;00
.ORG 0xC80 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xD00 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xD80 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xE00 .DB 0b00000000, 0b00001000, 0b00001110, 0b00001110
.ORG 0xE80 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF00 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF80 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC02 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000 ;04
.ORG 0xC82 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000 
.ORG 0xD02 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xD82 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xE02 .DB 0b00001000, 0b00001000, 0b00001111, 0b00001110
.ORG 0xE82 .DB 0b00001000, 0b00001000, 0b00001000, 0b00001000
.ORG 0xF02 .DB 0b00001000, 0b00001000, 0b00001000, 0b00001000
.ORG 0xF82 .DB 0b00001000, 0b00001000, 0b00001000, 0b00001000

.ORG 0xC04 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000 ;08
.ORG 0xC84 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xD04 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xD84 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xE04 .DB 0b01111000, 0b01111000, 0b01111110, 0b01111110
.ORG 0xE84 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF04 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF84 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC06 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000 ;0C
.ORG 0xC86 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xD06 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xD86 .DB 0b00000000, 0b00001000, 0b00000000, 0b00001000
.ORG 0xE06 .DB 0b01111000, 0b01111000, 0b01111110, 0b01111110
.ORG 0xE86 .DB 0b00001000, 0b00001000, 0b00001000, 0b00001000
.ORG 0xF06 .DB 0b00001000, 0b00001000, 0b00001000, 0b00001000
.ORG 0xF86 .DB 0b00001000, 0b00001000, 0b00001000, 0b00001000

.ORG 0xC08 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;00
.ORG 0xC88 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD08 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD88 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE08 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE88 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF08 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF88 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC0A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;04
.ORG 0xC8A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD0A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD8A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE0A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE8A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF0A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF8A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC0C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;08
.ORG 0xC8C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD0C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD8C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE0C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE8C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF0C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF8C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC0E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;0C
.ORG 0xC8E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD0E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD8E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE0E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE8E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF0E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF8E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC10 .DB 0b00000000, 0b00010000, 0b00101000, 0b00101000 ;20
.ORG 0xC90 .DB 0b00000000, 0b00010000, 0b00101000, 0b00101000
.ORG 0xD10 .DB 0b00000000, 0b00010000, 0b00101000, 0b01111100
.ORG 0xD90 .DB 0b00000000, 0b00010000, 0b00000000, 0b00101000
.ORG 0xE10 .DB 0b00000000, 0b00000000, 0b00000000, 0b01111100
.ORG 0xE90 .DB 0b00000000, 0b00000000, 0b00000000, 0b00101000
.ORG 0xF10 .DB 0b00000000, 0b00010000, 0b00000000, 0b00101000
.ORG 0xF90 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC12 .DB 0b00010000, 0b01100000, 0b00110000, 0b00110000 ;24
.ORG 0xC92 .DB 0b00111100, 0b01100100, 0b01001000, 0b00010000
.ORG 0xD12 .DB 0b01010000, 0b00001000, 0b01010000, 0b00100000
.ORG 0xD92 .DB 0b00111000, 0b00010000, 0b00100000, 0b00000000
.ORG 0xE12 .DB 0b00010100, 0b00100000, 0b01010100, 0b00000000
.ORG 0xE92 .DB 0b01111000, 0b01001100, 0b01001000, 0b00000000
.ORG 0xF12 .DB 0b00010000, 0b00001100, 0b00110100, 0b00000000
.ORG 0xF92 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC14 .DB 0b00001000, 0b00100000, 0b00000000, 0b00000000 ;28
.ORG 0xC94 .DB 0b00010000, 0b00010000, 0b00010000, 0b00010000
.ORG 0xD14 .DB 0b00100000, 0b00001000, 0b01010100, 0b00010000
.ORG 0xD94 .DB 0b00100000, 0b00001000, 0b00111000, 0b01111100
.ORG 0xE14 .DB 0b00100000, 0b00001000, 0b01010100, 0b00010000
.ORG 0xE94 .DB 0b00010000, 0b00010000, 0b00010000, 0b00010000
.ORG 0xF14 .DB 0b00001000, 0b00100000, 0b00000000, 0b00000000
.ORG 0xF94 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC16 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;2C
.ORG 0xC96 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000100
.ORG 0xD16 .DB 0b00000000, 0b00000000, 0b00000000, 0b00001000
.ORG 0xD96 .DB 0b00000000, 0b01111100, 0b00000000, 0b00010000
.ORG 0xE16 .DB 0b00110000, 0b00000000, 0b00000000, 0b00100000
.ORG 0xE96 .DB 0b00010000, 0b00000000, 0b00110000, 0b01000000
.ORG 0xF16 .DB 0b00100000, 0b00000000, 0b00110000, 0b00000000
.ORG 0xF96 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC18 .DB 0b00111000, 0b00010000, 0b00111000, 0b01111100 ;30
.ORG 0xC98 .DB 0b01000100, 0b00110000, 0b01000100, 0b01001000
.ORG 0xD18 .DB 0b01001100, 0b00010000, 0b00000100, 0b00010000
.ORG 0xD98 .DB 0b01010100, 0b00010000, 0b00001000, 0b00001000
.ORG 0xE18 .DB 0b01100100, 0b00010000, 0b00010000, 0b00000100
.ORG 0xE98 .DB 0b01000100, 0b00010000, 0b00100000, 0b01000100
.ORG 0xF18 .DB 0b00111000, 0b00111000, 0b01111100, 0b00111000
.ORG 0xF98 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC1A .DB 0b00001000, 0b01111100, 0b00011100, 0b01111100 ;34
.ORG 0xC9A .DB 0b00011000, 0b01000000, 0b00100000, 0b00000100
.ORG 0xD1A .DB 0b00101000, 0b01111000, 0b01000000, 0b00001000
.ORG 0xD9A .DB 0b01001000, 0b00000100, 0b01111000, 0b00010000
.ORG 0xE1A .DB 0b01111100, 0b00000100, 0b01000100, 0b00100000
.ORG 0xE9A .DB 0b00001000, 0b01000100, 0b01000100, 0b00100000
.ORG 0xF1A .DB 0b00001000, 0b00111000, 0b00111000, 0b00100000
.ORG 0xF9A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC1C .DB 0b00111000, 0b00111000, 0b00000000, 0b00000000 ;38
.ORG 0xC9C .DB 0b01000100, 0b01000100, 0b00110000, 0b00110000
.ORG 0xD1C .DB 0b01000100, 0b01000100, 0b00110000, 0b00110000
.ORG 0xD9C .DB 0b00111000, 0b00111100, 0b00000000, 0b00000000
.ORG 0xE1C .DB 0b01000100, 0b00000100, 0b00110000, 0b00110000
.ORG 0xE9C .DB 0b01000100, 0b00001000, 0b00110000, 0b00010000
.ORG 0xF1C .DB 0b00111000, 0b00110000, 0b00000000, 0b00100000
.ORG 0xF9C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC1E .DB 0b00001000, 0b00000000, 0b00100000, 0b00111000 ;3C
.ORG 0xC9E .DB 0b00010000, 0b00000000, 0b00010000, 0b01000100
.ORG 0xD1E .DB 0b00100000, 0b01111100, 0b00001000, 0b00000100
.ORG 0xD9E .DB 0b01000000, 0b00000000, 0b00000100, 0b00001000
.ORG 0xE1E .DB 0b00100000, 0b01111100, 0b00001000, 0b00010000
.ORG 0xE9E .DB 0b00010000, 0b00000000, 0b00010000, 0b00000000
.ORG 0xF1E .DB 0b00001000, 0b00000000, 0b00100000, 0b00010000
.ORG 0xF9E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC20 .DB 0b00111000, 0b00111000, 0b01111000, 0b00111000 ;40
.ORG 0xCA0 .DB 0b01000100, 0b01000100, 0b01000100, 0b01000100
.ORG 0xD20 .DB 0b00000100, 0b01000100, 0b01000100, 0b01000000
.ORG 0xDA0 .DB 0b00110100, 0b01000100, 0b01111000, 0b01000000
.ORG 0xE20 .DB 0b01010100, 0b01111100, 0b01000100, 0b01000000
.ORG 0xEA0 .DB 0b01010100, 0b01000100, 0b01000100, 0b01000100
.ORG 0xF20 .DB 0b00111000, 0b01000100, 0b01111000, 0b00111000
.ORG 0xFA0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC22 .DB 0b01111000, 0b01111100, 0b01111100, 0b00111000 ;44
.ORG 0xCA2 .DB 0b01000100, 0b01000000, 0b01000000, 0b01000100
.ORG 0xD22 .DB 0b01000100, 0b01000000, 0b01000000, 0b01000000
.ORG 0xDA2 .DB 0b01000100, 0b01111000, 0b01111000, 0b01011100
.ORG 0xE22 .DB 0b01000100, 0b01000000, 0b01000000, 0b01000100
.ORG 0xEA2 .DB 0b01000100, 0b01000000, 0b01000000, 0b01000100
.ORG 0xF22 .DB 0b01111000, 0b01111100, 0b01000000, 0b00111100
.ORG 0xFA2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC24 .DB 0b01000100, 0b00111000, 0b00011100, 0b01000100 ;48
.ORG 0xCA4 .DB 0b01000100, 0b00010000, 0b00001000, 0b01001000
.ORG 0xD24 .DB 0b01000100, 0b00010000, 0b00001000, 0b01010000
.ORG 0xDA4 .DB 0b01111100, 0b00010000, 0b00001000, 0b01100000
.ORG 0xE24 .DB 0b01000100, 0b00010000, 0b00001000, 0b01010000
.ORG 0xEA4 .DB 0b01000100, 0b00010000, 0b01001000, 0b01001000
.ORG 0xF24 .DB 0b01000100, 0b00111000, 0b00110000, 0b01000100
.ORG 0xFA4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC26 .DB 0b01000000, 0b01000100, 0b01000100, 0b00111000 ;4C
.ORG 0xCA6 .DB 0b01000000, 0b01101100, 0b01000100, 0b01000100
.ORG 0xD26 .DB 0b01000000, 0b01010100, 0b01100100, 0b01000100
.ORG 0xDA6 .DB 0b01000000, 0b01010100, 0b01010100, 0b01000100
.ORG 0xE26 .DB 0b01000000, 0b01000100, 0b01001100, 0b01000100
.ORG 0xEA6 .DB 0b01000000, 0b01000100, 0b01000100, 0b01000100
.ORG 0xF26 .DB 0b01111100, 0b01000100, 0b01000100, 0b00111000
.ORG 0xFA6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC28 .DB 0b00111000, 0b00111000, 0b01111000, 0b00111100 ;50
.ORG 0xCA8 .DB 0b01000100, 0b01000100, 0b01000100, 0b01000000
.ORG 0xD28 .DB 0b01000100, 0b01000100, 0b01000100, 0b01000000
.ORG 0xDA8 .DB 0b01111000, 0b01000100, 0b01111000, 0b00111000
.ORG 0xE28 .DB 0b01000000, 0b01010100, 0b01010000, 0b00000100
.ORG 0xEA8 .DB 0b01000000, 0b01001000, 0b01001000, 0b00000100
.ORG 0xF28 .DB 0b01000000, 0b00110100, 0b01000100, 0b01111000
.ORG 0xFA8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC2A .DB 0b01111100, 0b01000100, 0b01000100, 0b01000100 ;54
.ORG 0xCAA .DB 0b00010000, 0b01000100, 0b01000100, 0b01000100
.ORG 0xD2A .DB 0b00010000, 0b01000100, 0b01000100, 0b01000100
.ORG 0xDAA .DB 0b00010000, 0b01000100, 0b01000100, 0b01010100
.ORG 0xE2A .DB 0b00010000, 0b01000100, 0b01000100, 0b01010100
.ORG 0xEAA .DB 0b00010000, 0b01000100, 0b00101000, 0b01010100
.ORG 0xF2A .DB 0b00010000, 0b00111000, 0b00010000, 0b00101000
.ORG 0xFAA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC2C .DB 0b01000100, 0b01000100, 0b01111100, 0b01110000 ;58
.ORG 0xCAC .DB 0b01000100, 0b01000100, 0b00000100, 0b01000000
.ORG 0xD2C .DB 0b00101000, 0b01000100, 0b00001000, 0b01000000
.ORG 0xDAC .DB 0b00010000, 0b00101000, 0b00010000, 0b01000000
.ORG 0xE2C .DB 0b00101000, 0b00010000, 0b00100000, 0b01000000
.ORG 0xEAC .DB 0b01000100, 0b00010000, 0b01000000, 0b01000000
.ORG 0xF2C .DB 0b01000100, 0b00010000, 0b01111100, 0b01110000
.ORG 0xFAC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC2E .DB 0b01000100, 0b00011100, 0b00010000, 0b00000000 ;5C
.ORG 0xCAE .DB 0b00101000, 0b00000100, 0b00101000, 0b00000000
.ORG 0xD2E .DB 0b01111100, 0b00000100, 0b01000100, 0b00000000
.ORG 0xDAE .DB 0b00010000, 0b00000100, 0b00000000, 0b00000000
.ORG 0xE2E .DB 0b01111100, 0b00000100, 0b00000000, 0b00000000
.ORG 0xEAE .DB 0b00010000, 0b00000100, 0b00000000, 0b00000000
.ORG 0xF2E .DB 0b00010000, 0b00011100, 0b00000000, 0b01111100
.ORG 0xFAE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC30 .DB 0b00011000, 0b00000000, 0b01000000, 0b00000000 ;60
.ORG 0xCB0 .DB 0b00011000, 0b00000000, 0b01000000, 0b00000000
.ORG 0xD30 .DB 0b00001100, 0b00111000, 0b01011000, 0b00111000
.ORG 0xDB0 .DB 0b00000000, 0b00000100, 0b01100100, 0b01000000
.ORG 0xE30 .DB 0b00000000, 0b00111100, 0b01000100, 0b01000000
.ORG 0xEB0 .DB 0b00000000, 0b01000100, 0b01100100, 0b01000100
.ORG 0xF30 .DB 0b00000000, 0b00111100, 0b01111000, 0b00111000
.ORG 0xFB0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC32 .DB 0b00000100, 0b00000000, 0b00011000, 0b00000000 ;64
.ORG 0xCB2 .DB 0b00000100, 0b00000000, 0b00100000, 0b00111100
.ORG 0xD32 .DB 0b00110100, 0b00111000, 0b00100000, 0b01000100
.ORG 0xDB2 .DB 0b01001100, 0b01000100, 0b01110000, 0b01000100
.ORG 0xE32 .DB 0b01000100, 0b01111100, 0b00100000, 0b00111100
.ORG 0xEB2 .DB 0b01000100, 0b01000000, 0b00100000, 0b00000100
.ORG 0xF32 .DB 0b00111100, 0b00111000, 0b00100000, 0b00111000
.ORG 0xFB2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC34 .DB 0b01000000, 0b00010000, 0b00001000, 0b01000000 ;68
.ORG 0xCB4 .DB 0b01000000, 0b00000000, 0b00000000, 0b01000000
.ORG 0xD34 .DB 0b01000000, 0b00110000, 0b00011000, 0b01001000
.ORG 0xDB4 .DB 0b01011000, 0b00010000, 0b00001000, 0b01010000
.ORG 0xE34 .DB 0b01100100, 0b00010000, 0b00001000, 0b01100000
.ORG 0xEB4 .DB 0b01000100, 0b00010000, 0b01001000, 0b01010000
.ORG 0xF34 .DB 0b01000100, 0b00111000, 0b00110000, 0b01001000
.ORG 0xFB4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC36 .DB 0b00110000, 0b00000000, 0b00000000, 0b00000000 ;6C
.ORG 0xCB6 .DB 0b00010000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD36 .DB 0b00010000, 0b01101000, 0b01011000, 0b00111000
.ORG 0xDB6 .DB 0b00010000, 0b01010100, 0b01100100, 0b01000100
.ORG 0xE36 .DB 0b00010000, 0b01010100, 0b01000100, 0b01000100
.ORG 0xEB6 .DB 0b00010000, 0b01000100, 0b01000100, 0b01000100
.ORG 0xF36 .DB 0b00111000, 0b01000100, 0b01000100, 0b00111000
.ORG 0xFB6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC38 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;70
.ORG 0xCB8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD38 .DB 0b01111000, 0b00110100, 0b01011000, 0b00111000
.ORG 0xDB8 .DB 0b01000100, 0b01001100, 0b01100100, 0b01000000
.ORG 0xE38 .DB 0b01111000, 0b00111100, 0b01000000, 0b00111000
.ORG 0xEB8 .DB 0b01100000, 0b00000100, 0b01000000, 0b00000100
.ORG 0xF38 .DB 0b01000000, 0b00000100, 0b01000000, 0b01111000
.ORG 0xFB8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC3A .DB 0b00100000, 0b00000000, 0b00000000, 0b00000000 ;74
.ORG 0xCBA .DB 0b00100000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD3A .DB 0b01110000, 0b01000100, 0b01000100, 0b01000100
.ORG 0xDBA .DB 0b00100000, 0b01000100, 0b01000100, 0b01000100
.ORG 0xE3A .DB 0b00100000, 0b01000100, 0b01000100, 0b01010100
.ORG 0xEBA .DB 0b00100100, 0b01001100, 0b00101000, 0b01010100
.ORG 0xF3A .DB 0b00011000, 0b00110100, 0b00010000, 0b00101000
.ORG 0xFBA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC3C .DB 0b00000000, 0b00000000, 0b00000000, 0b00001000 ;78
.ORG 0xCBC .DB 0b00000000, 0b00000000, 0b00000000, 0b00010000
.ORG 0xD3C .DB 0b01000100, 0b01000100, 0b01111100, 0b00010000
.ORG 0xDBC .DB 0b00101000, 0b01000100, 0b00001000, 0b00100000
.ORG 0xE3C .DB 0b00010000, 0b00111100, 0b00010000, 0b00010000
.ORG 0xEBC .DB 0b00101000, 0b00000100, 0b00100000, 0b00010000
.ORG 0xF3C .DB 0b01000100, 0b00111000, 0b01111100, 0b00001000
.ORG 0xFBC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC3E .DB 0b00010000, 0b00100000, 0b00000000, 0b00000000 ;7C
.ORG 0xCBE .DB 0b00010000, 0b00010000, 0b00010000, 0b00010000
.ORG 0xD3E .DB 0b00010000, 0b00010000, 0b00001000, 0b00100000
.ORG 0xDBE .DB 0b00010000, 0b00001000, 0b01111100, 0b01111100
.ORG 0xE3E .DB 0b00010000, 0b00010000, 0b00001000, 0b00100000
.ORG 0xEBE .DB 0b00010000, 0b00010000, 0b00010000, 0b00010000
.ORG 0xF3E .DB 0b00010000, 0b00100000, 0b00000000, 0b00000000
.ORG 0xFBE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC40 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;80
.ORG 0xCC0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD40 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDC0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE40 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEC0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF40 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFC0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC42 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;84
.ORG 0xCC2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD42 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDC2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE42 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEC2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF42 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFC2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC44 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;88
.ORG 0xCC4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD44 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDC4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE44 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEC4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF44 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFC4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC46 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;8C
.ORG 0xCC6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD46 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDC6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE46 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEC6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF46 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFC6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC48 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;90
.ORG 0xCC8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD48 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDC8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE48 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEC8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF48 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFC8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC4A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;94
.ORG 0xCCA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD4A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDCA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE4A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xECA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF4A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFCA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC4C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;98
.ORG 0xCCC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD4C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDCC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE4C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xECC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF4C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFCC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC4E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;9C
.ORG 0xCCE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD4E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDCE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE4E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xECE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF4E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFCE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC50 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;A0
.ORG 0xCD0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD50 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDD0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE50 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xED0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF50 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFD0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC52 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;A4
.ORG 0xCD2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD52 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDD2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE52 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xED2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF52 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFD2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC54 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;A8
.ORG 0xCD4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD54 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDD4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE54 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xED4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF54 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFD4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC56 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;AC
.ORG 0xCD6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD56 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDD6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE56 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xED6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF56 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFD6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC58 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;B0
.ORG 0xCD8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD58 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDD8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE58 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xED8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF58 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFD8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC5A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;B4
.ORG 0xCDA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD5A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDDA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE5A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEDA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF5A .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFDA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC5C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;B8
.ORG 0xCDC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD5C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDDC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE5C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEDC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF5C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFDC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC5E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;BC
.ORG 0xCDE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD5E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDDE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE5E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEDE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF5E .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFDE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC60 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;C0
.ORG 0xCE0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD60 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDE0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE60 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEE0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF60 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFE0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC62 .DB 0b01000100, 0b00000000, 0b00000000, 0b00000000 ;C4
.ORG 0xCE2 .DB 0b00111000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD62 .DB 0b01000100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDE2 .DB 0b01000100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE62 .DB 0b01111100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEE2 .DB 0b01000100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF62 .DB 0b01000100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFE2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC64 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;C8
.ORG 0xCE4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD64 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDE4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE64 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEE4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF64 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFE4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC66 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;CC
.ORG 0xCE6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD66 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDE6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE66 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEE6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF66 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFE6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC68 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;D0
.ORG 0xCE8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD68 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDE8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE68 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEE8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF68 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFE8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC6A .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000 ;D4
.ORG 0xCEA .DB 0b00000000, 0b00000000, 0b00111000, 0b00000000
.ORG 0xD6A .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000
.ORG 0xDEA .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000
.ORG 0xE6A .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000
.ORG 0xEEA .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000
.ORG 0xF6A .DB 0b00000000, 0b00000000, 0b00111000, 0b00000000
.ORG 0xFEA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC6C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;D8
.ORG 0xCEC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD6C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDEC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE6C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEEC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF6C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFEC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC6E .DB 0b01000100, 0b00000000, 0b00000000, 0b00000000 ;DC
.ORG 0xCEE .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD6E .DB 0b01000100, 0b00000000, 0b00000000, 0b00111000
.ORG 0xDEE .DB 0b01000100, 0b00000000, 0b00000000, 0b01000100
.ORG 0xE6E .DB 0b01000100, 0b00000000, 0b00000000, 0b01111000
.ORG 0xEEE .DB 0b01000100, 0b00000000, 0b00000000, 0b01000100
.ORG 0xF6E .DB 0b00111000, 0b00000000, 0b00000000, 0b01111000
.ORG 0xFEE .DB 0b00000000, 0b00000000, 0b00000000, 0b01000000

.ORG 0xC70 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;E0
.ORG 0xCF0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD70 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDF0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE70 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEF0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF70 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFF0 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC72 .DB 0b00101000, 0b00000000, 0b00000000, 0b00000000 ;E4
.ORG 0xCF2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD72 .DB 0b00111000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDF2 .DB 0b00000100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE72 .DB 0b00111100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEF2 .DB 0b01000100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF72 .DB 0b00111100, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFF2 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC74 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;E8
.ORG 0xCF4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD74 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDF4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE74 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEF4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF74 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFF4 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC76 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;EC
.ORG 0xCF6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD76 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDF6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE76 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEF6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF76 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFF6 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC78 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;F0
.ORG 0xCF8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD78 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDF8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE78 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEF8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF78 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFF8 .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC7A .DB 0b00000000, 0b00000000, 0b00101000, 0b00000000 ;F4
.ORG 0xCFA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD7A .DB 0b00000000, 0b00000000, 0b00111000, 0b00000000
.ORG 0xDFA .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000
.ORG 0xE7A .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000
.ORG 0xEFA .DB 0b00000000, 0b00000000, 0b01000100, 0b00000000
.ORG 0xF7A .DB 0b00000000, 0b00000000, 0b00111000, 0b00000000
.ORG 0xFFA .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC7C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000 ;F8
.ORG 0xCFC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xD7C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xDFC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xE7C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xEFC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xF7C .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000
.ORG 0xFFC .DB 0b00000000, 0b00000000, 0b00000000, 0b00000000

.ORG 0xC7E .DB 0b00101000, 0b00000000, 0b00000000, 0b01111100 ;FC
.ORG 0xCFE .DB 0b00000000, 0b00000000, 0b00000000, 0b01111100
.ORG 0xD7E .DB 0b01000100, 0b00000000, 0b01000000, 0b01111100
.ORG 0xDFE .DB 0b01000100, 0b00000000, 0b00000000, 0b01111100
.ORG 0xE7E .DB 0b01000100, 0b00000000, 0b01000000, 0b01111100
.ORG 0xEFE .DB 0b01001100, 0b00000000, 0b00000000, 0b01111100
.ORG 0xF7E .DB 0b00110100, 0b00000000, 0b00000000, 0b01111100
.ORG 0xFFE .DB 0b00000000, 0b00000000, 0b00000000, 0b01111100


;ENDE
