/*
   Modbus powerswitch control master v1.1 rgk2020
   version for Arduino Mega2560-board

   registers: regs[0] = digital (msbyte =power setting, lsb=control lines)
              regs[1] = PA supply voltage
              regs[2] = I_dr1 driver FETs drain currents 
              regs[3] = I_dr2
              regs[4] = I_dr3
              regs[5] = I_pa1 output FETs drain currents 
              regs[6] = I_pa2
              regs[7] = I_pa3
              regs[8] = I_pa4
              regs{9] = I_pa5
              regs[10] = forward power
              regs[11] = reverse power
              regs[12] = temperature register

              digital register bits:
              b0 = Mains relais
              b1 = driver bias
              b2 = pa bias
              b3 = blower on/off
              b4 = coax relay tx/rx
              b5~7 tbd
*/

#include <SimpleModbusMaster.h>
#include <LiquidCrystal.h>
#include "strings.h"

//////////////////// Port information ///////////////////
#define baud 38400
#define timeout 1000
#define polling 200 // the scan rate
#define retry_count 10

// used to toggle the receive/transmit pin on the RS485 driver
#define TxEnablePin 22
// The total amount of available memory on the master to store data
#define TOTAL_NO_OF_REGISTERS 13

//buttons

#define LEFT        11
#define UP          10
#define DWN         8
#define RIGHT       9
#define ENTER       12
#define MENU        6
#define EXIT        7
#define PTT         5 
#define LED_1       51//PA Stand by, mains, power switched on
#define LED_2       52//PA running, bias enabled
#define LED_3       53//PA delivers more than 1 W RF (measured)
#define lcd_rw      41
#define power_corr_A 39
#define power_corr_B 3650
#define swr_corr     36



unsigned long tijd_old = 0;
const unsigned long interval = 2000;
byte connection;
byte digital = 0;
int power;
byte stand[5];
bool TX = false;
byte state_cntr =0; //state machine level
byte state_old;
char inData[10];
int index;
boolean started = false;
boolean ended = false;
byte PA_err=0;
int keuze = 0;

// This is the easiest way to create new packets
// Add as many as you want. TOTAL_NO_OF_PACKETS
// is automatically updated.
enum
{
  PACKET1,
  PACKET2,
  TOTAL_NO_OF_PACKETS // leave this last entry
};

// Create an array of Packets to be configured
Packet packets[TOTAL_NO_OF_PACKETS];


// Masters register array
unsigned int regs[TOTAL_NO_OF_REGISTERS];

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(49, 48, 47, 46, 45, 44);



void setup() {

  // Initialize each packet
  modbus_construct(&packets[PACKET1], 3, PRESET_MULTIPLE_REGISTERS, 0, 1, 0);//write to slave    regs[0]
  modbus_construct(&packets[PACKET2], 3, READ_HOLDING_REGISTERS, 1, 12, 1);//read from slave     regs[1] / regs[12]


  pinMode(ENTER,INPUT_PULLUP);
  pinMode(EXIT,INPUT_PULLUP);
  pinMode(PTT,INPUT_PULLUP);
  pinMode(MENU,INPUT_PULLUP);
  pinMode(UP,INPUT_PULLUP);
  pinMode(DWN,INPUT_PULLUP);
  pinMode(LEFT,INPUT_PULLUP);
  pinMode(RIGHT,INPUT_PULLUP); 
  pinMode(LED_1,OUTPUT);
  pinMode(LED_2,OUTPUT);
  pinMode(LED_3,OUTPUT); 
  pinMode(lcd_rw,OUTPUT);


  // Initialize the Modbus Finite State Machine
  modbus_configure(&Serial1, baud, SERIAL_8N2, timeout, polling, retry_count, TxEnablePin, packets, TOTAL_NO_OF_PACKETS, regs);
  Serial.begin(9600);

  power = 0;
  regs[0] = word(235,digital);
  modbus_update();
  digitalWrite(lcd_rw,LOW);//LCD R/W lijn op 0 zetten (compatibiliteit met codeVision AVR)
  digitalWrite(LED_1,LOW);
  digitalWrite(LED_2,LOW);
  digitalWrite(LED_3,LOW);
  lcd.begin(20, 4);
  lcd_update();
}

void loop() {
  unsigned long tijd;
  float itotaal;
  char buffer[21];
  int err;
  static byte p_act=0;
 
  modbus_update();
  
  err = packets[PACKET1].failed_requests;
  if(err>1){
    lcd.setCursor(0,0);
    lcd.print("RS485 error with PA ");
  }
  else{
   lcd_update(); 
  }

// state machine
  if(TX == true){
      digitalWrite(LED_1,HIGH);
      switch(state_cntr){
        case 0: {
                 p_act=0;//start with minimum power 
                 digital =9;//mains relay ON en blower ON
                 regs[0] = word(235-p_act, digital);
                 break;
                }
        case 1: {
                 digital = 13;// PA bias on
                 regs[0] = word(235-p_act, digital);
                 break;        
                }
        case 2: {
                 digitalWrite(LED_2,HIGH);
                 digital = 15;//driver bias on
                 regs[0] = word(235-p_act, digital);
                 break;        
                }
        case 3: {
                 p_act++;
                 if(p_act > power)p_act=power; 
                 regs[0] = word(235-p_act,digital); 
                }
      }
  tijd = millis();
  if (tijd - tijd_old >= interval)
    {
      state_cntr++;
      if(state_cntr >3)state_cntr = 3;
      tijd_old = tijd;
    }   
  }

  if(TX == false){
    digitalWrite(LED_2,LOW);
    p_act=0;
    if(state_cntr>0){
      switch(state_cntr){
        case 3:{
          state_cntr=2;
        }
        case 2:{
          digital = 13;
          break;
        }
        case 1:{
          digital = 9;
          break;
        }
      }
  tijd = millis();    
  if (tijd - tijd_old >= interval)
    {
      if(state_cntr ==1 && highByte(regs[12])>30){
        state_cntr++;//let blower run until <30 degrees C.
      }
      state_cntr--;
      if(state_cntr ==0) digitalWrite(LED_1,LOW);
      if(state_cntr <0)state_cntr = 0;
      tijd_old = tijd;
    }
  }
  else digital=0;
  regs[0] = word(235-p_act, digital);
  }



  if(digitalRead(PTT)==0){          //Toggle de transmit Status bit  
      TX = !TX;
      while(digitalRead(PTT)==1);
      delay(50);
      while(digitalRead(PTT)==0);
      }
//    *** bewaking bedrijfscondities  ***
  if(highByte(regs[12])<60){
    TX==false;//temperature shutdown(T>60 degr.    
  }


  if (digitalRead(UP) == 0) {
    power++;
    if( power>235 )power=235;
    delay(100);
//  while(digitalRead(UP)==0);    
  }

  if (digitalRead(DWN) == 0) {
    power--;
    if( power<0 )power=0;
    delay(100);
//  while(digitalRead(DWN)==0);    
  }
  if(digitalRead(MENU)==0){
  display_status();
  lcd_update();
  }
}//loop ends here

// *********** Functies  *************

void lcd_update(void){
  unsigned long watts;
  float vswr;
  float temp;
  lcd.setCursor(0,0);
    lcd.print(F("QO100  Tx-Controller"));
    if(state_cntr==0){
      lcd.setCursor(0,1);
      lcd.print("    < PA off >      ");
    }
    if(state_cntr==1){
      
      lcd.setCursor(0,1);
       if(TX==false && highByte(regs[12])>30){
         lcd.print("< PA Cooling down > ");
       }
       else lcd.print(" < PA stand by >    ");
    }
    lcd.setCursor(0,2);
    lcd.print("RF att setting:  ");
    if(power<100)lcd.print(" ");
    if(power<10)lcd.print(" ");     
    lcd.print(power);
    if(state_cntr>1){
      lcd.setCursor(0,1);
      lcd.print("     PA running    ");
      lcd.setCursor(0,3);
      lcd.print("Pwr: ");
      Serial.print("regs10fwd: ");
      Serial.println(regs[10]);
      Serial.print("regs11refl: ");
      Serial.println(regs[11]);
      watts = regs[10] - power_corr_A;//zero corr
      if (watts < 0)watts = 0;
      watts *= watts;
      watts /= power_corr_B;
      if(watts > 250.0)watts=250.0;
      if(watts<100)lcd.print(" ");
      if(watts<10)lcd.print(" ");   
      lcd.print(watts);
      lcd.print("W");
      if(watts>1){//detect rf power and show on led3
        digitalWrite(LED_3,HIGH);
      }
      else{
        digitalWrite(LED_3,LOW);
      }
      lcd.print("  SWR: ");
      vswr = float (regs[10] - power_corr_A) + float (regs[11] - swr_corr);
      temp = float (regs[10] - power_corr_A) - float (regs[11] - swr_corr);
      vswr /= temp;
       if ((regs[10] - power_corr_A) < 20) vswr = 1.00;
       if(vswr>10.0)vswr=10.0;
       if(vswr<1.0)vswr=1.0;
       lcd.print(vswr);
     }
     if(state_cntr<2){
      lcd.setCursor(0,3);
      lcd.print("prss PTT to transmit");
     }
}


void display_status(void){
  char buffer[25];
  do{
  lcd.setCursor(0,2);
  if(digitalRead(DWN)==0){
    keuze++;
    while(digitalRead(DWN)==0);
    if(keuze>2)keuze=0;
  }
  if(digitalRead(UP)==0){
    keuze--;
    while(digitalRead(UP)==0);
    if(keuze<0)keuze=2;
  }
  strcpy_P(buffer, (char*)pgm_read_word(&(menu_table[keuze])));
  lcd.print(buffer);
  lcd.setCursor(0,3);
  lcd.print("press <ENTER> to see");
  }
  while(digitalRead(ENTER)==1);
  switch(keuze){
    case 0:
          {
            //driver currents I1 ~ I3
            show_drcurrents();
            break; 
          }
    case 1:
          {
            //final stage currents I1 ~I5
            show_final();
            break;       
          }
    case 2:
          {
            //supply volts and temp
            show_voltages();
            break;      
          }
  }
  lcd_update();
}

void show_drcurrents(){
  int i;
  float icorr;
  int pos=0;
  do{
     lcd.setCursor(0,2);
     lcd.print("I-Driver Stage <1-3>");
     if(digitalRead(RIGHT)==0){
      pos++;
      if(pos>2)pos=0;
      while(digitalRead(RIGHT)==0);
     }
     if(digitalRead(LEFT)==0){
      pos--;
      if(pos<0)pos=2;
      while(digitalRead(LEFT)==0);
     }
     i = regs[pos+2];
     icorr = i / 37.8;
     if(icorr<0)icorr=0;
     lcd.setCursor(0,3);
     lcd.print("Id Fet ");
     lcd.print(pos+1);
     lcd.print(": ");
     lcd.print(icorr);
     lcd.print(" A    ");      
     modbus_update();      
    }       
  while (digitalRead(EXIT) == 1);
  while (digitalRead(EXIT) == 0);    
}

void show_final(){
  int i;
  float icorr;
  int pos=0;
  do{
     lcd.setCursor(0,2);
     lcd.print("I-final Stage  <1-5>");
     if(digitalRead(RIGHT)==0){
      pos++;
      if(pos>4)pos=0;
      while(digitalRead(RIGHT)==0);
     }
     if(digitalRead(LEFT)==0){
      pos--;
      if(pos<0)pos=4;
      while(digitalRead(LEFT)==0);
     }
     i = regs[pos+5];
     icorr = i / 37.8;
     if(icorr<0)icorr=0;
     lcd.setCursor(0,3);
     lcd.print("Id Fet ");
     lcd.print(pos+1);
     lcd.print(": ");
     lcd.print(icorr);
     lcd.print(" A    ");      
     modbus_update();
       
    }       
  while (digitalRead(EXIT) == 1);
  while (digitalRead(EXIT) == 0);    
}


void show_voltages(){
   unsigned int v = regs[1];
   float volt = v * 0.0323;
   do{
     lcd.setCursor(0,2);
     lcd.print("Supp Voltage: ");
     lcd.print(volt);
     lcd.print("V ");
     lcd.setCursor(0, 3);
     lcd.print("Temperature: ");
     lcd.print(highByte(regs[12]));
     lcd.print((char)178);//graden teken op lcd
     lcd.print("C   ");
     modbus_update();
   }
   while (digitalRead(EXIT) == 1);
   while (digitalRead(EXIT) == 0);   
}
