/* Nicam ontvangst met de Micronas Multi-standard sound processor MSP3415G
 *  versie 1.0
 *  rgk mei 2018
 */


//defines voor de chip addressering
#define MSP_ADDR    0x40
#define CTRL    0x00
#define WR_FP   0x10
#define RD_FP   0x11
#define WR_DFP  0x12
#define RD_DFP  0x13


#define MODUS     0x0030
#define STANDARD  0x0020
#define SPEAKER_VOL 0x0000
#define SPEAKER_SOURCE 0x0008
#define FM_PRESCALE 0x000E
#define NICAM_PRESCALE 0x0010
#define ACB_REG 0x0013

#define STATUS        0x00110200  //Status register audio reception
#define STANDARD_RES  0x0011007E  //standard result register demodulator


// defines voor de instellingen
#define BG      0x0008  //standard select register settings
#define I       0x000A
#define AUTO    0x0001


// routines voor communicatie met de chip
void MSP_RESET(void){
    Wire.beginTransmission(MSP_ADDR);
    Wire.write(0x00);
    Wire.write(0x80);
    Wire.write(0x00);
    Wire.endTransmission();
    
    Wire.beginTransmission(MSP_ADDR);
    Wire.write(0x00);
    Wire.write(0x00);
    Wire.write(0x00);
    Wire.endTransmission();        
}

  byte MSP_LOAD(byte subadr, int reg, int data){
  byte ack;
  Wire.beginTransmission(MSP_ADDR);
  Wire.write(subadr);// FP/DFP subaddr
  Wire.write(highByte(reg));
  Wire.write(lowByte(reg));
  Wire.write(highByte(data));
  Wire.write(lowByte(data));
  ack=Wire.endTransmission();
  return ack;
  }

int MSP_READ(unsigned long addr){
  int data;
  Wire.requestFrom(MSP_ADDR,2,addr,3,true);
  byte hi=Wire.read();//lees high byte van i2c
  byte lo=Wire.read();//lees low byte van i2c
  data=word(hi,lo);
  return data;
  }

void set_standard(unsigned int STD ){
  MSP_LOAD(WR_FP, MODUS, 0x3001);
  MSP_LOAD(WR_DFP, SPEAKER_SOURCE,0x0320);
  MSP_LOAD(WR_DFP, FM_PRESCALE, 0x2403);
  MSP_LOAD(WR_DFP, NICAM_PRESCALE, 0x5A00);
  MSP_LOAD(WR_FP, STANDARD, STD);
}
