/*
* diseqc protocol communicatie
* voor gebruik in de Veron A24 ATV ontvanger
* versie 1.0
* 
*/

#define TRUE    1
#define FALSE   0


//PortD.0 is de 22kHz output pin

static volatile bool start=FALSE;      //start commando diseqc versturen
static volatile byte len_dsq;    //aantal diseqc bytes te versturen
static volatile byte data_dsq[4];//data array tbv diseqc commando te versturen



//de timer interrupt genereert pulsjes van 22kHz en verstuurt daarmee de data
ISR(TIMER1_COMPA_vect){
  static bool enable_toggle;//true = 22khz output, false = rustpauze
  static char bitteller; //aantal bits per byte + parity
  static char byteteller;//aantal te versturen bytes
  static byte pulsteller;//teller voor de flanken van het 22KHz signaal
  static byte parity;  //teller om parity uit te rekenen
  static bool databit; //te versturen bit
  static byte send_dsq;//0=idle,1=initialisatie byte tx, 2=versturen data+parity

  if(start){
    byteteller=len_dsq;
    send_dsq=1;
    start=FALSE;
  }
  if(send_dsq==1)//initialisatie byte versturen
  {
    bitteller=8;// MSB eerst
    PORTD &=~(1<<0); //clear PORTD.0 = 22khz toggle pin > start met een 0
    pulsteller=0;
    parity=0;
    send_dsq=2;
  }
  if(send_dsq==2)// ga naar volgende state: transmitting
  {
    databit = data_dsq[len_dsq-byteteller]>>(bitteller-1)&0x01;
    if(pulsteller==0)enable_toggle=TRUE;
    if(pulsteller==22)
    {
      if(bitteller==0){
        enable_toggle = parity;// een "even" paritybit manifesteert zich hier als "odd"
      }
      else
      if(databit)enable_toggle = FALSE;
    }
    if(pulsteller==44)enable_toggle = FALSE;
    if(enable_toggle)PORTD ^=(1<<0);
    pulsteller++;

    if(pulsteller==66)// einde bit zenden
    {
      if(databit)parity++;// eenen tellen
      pulsteller=0;
      bitteller--; 
    }
  }
  if(bitteller==0)parity &=0x01;//parity bepalen
  if(bitteller<0)send_dsq=0;


  if(byteteller>1 & send_dsq==0){//als de byteteller 0 is dan is het klaar, alle bytes zijn dan weg
    byteteller--;
    send_dsq=1;
  }
}
