/*
 * deze headerfile definieert de struct voor de bandsettings en vult de EEprom
 * met zinnige default waarden.
 * De vul functie wordt alleen gebruikt als de eeprom leeg is.
 * freq > werkelijke frequentie
 * max > max freq voor de gekozen band
 * min > min freq voor de gekozen band
 * audio_sc_freq > audio subcarrier freq
 * LO  > de local oscillator freq voor de gekozen band
 * video_gain > video gain
 * Control_register:  b0=V_POL  video polariteit
 *                    b1=V_BW   RF tuner bandbreedte
 *                    b2=LO_POL LO boven of ondermenging
 *                    b3=HV     LNB polariteit ontvangst
 *                    b4=band_0 band_in_use bit 0
 *                    b5=band_1 band_in_use bit 1
 *                    b6=LNB_0  LNB ingang keuze bit0
 *                    b7=LNB_1  LNB ingang keuze bit1
 *                                          
 */


#include <EEPROM.h>
#include "EEPROMAnything.h"

// eeprom memory locaties
#define EE_defaults     0x00
#define EE_band_in_use  0x01
#define EE_fav_nr       0x02
#define EE_address      0x03
#define EE_favorites    0x50
#define EE_favnames     0x100
#define EE_mode         0x200

  struct band
  {
    int freq;
    int maximum;
    int minimum;
    int LO;
    int audio_sc_freq;
    byte video_gain;
    byte control_register;
  };
  

void fill_struct(void){
  struct band filler;
  filler.freq = 1285;
  filler.maximum = 1300;
  filler.minimum = 1240;
  filler.LO = 0;
  filler.audio_sc_freq = 600;
  filler.video_gain = 100;
  filler.control_register = 0;
  EEPROM_writeAnything(EE_address, filler);//locatie band 23 settings


  filler.freq = 2387;
  filler.maximum = 2400;
  filler.minimum = 2320;
  filler.LO = 3650;
  filler.audio_sc_freq = 600;
  filler.video_gain = 100;
  filler.control_register = 0x13;
  EEPROM_writeAnything((EE_address+0x10), filler);//locatie band 13 settings  


  filler.freq = 5780;
  filler.maximum = 5850;
  filler.minimum = 5650;
  filler.LO = 4800;
  filler.audio_sc_freq = 600;
  filler.video_gain = 100;
  filler.control_register = 0x23;
  EEPROM_writeAnything((EE_address+0x20), filler);//locatie band 6 settings


  filler.freq = 10400;
  filler.maximum = 10500;
  filler.minimum = 10000;
  filler.LO = 9225;
  filler.audio_sc_freq = 600;
  filler.video_gain = 80;
  filler.control_register = 0x30;
  EEPROM_writeAnything((EE_address+0x30), filler);//locatie band 3 settings  

//vullen favorieten geheugen met default kanaal PI6ATR
  byte x;
  for(x=0;x<10;x++){
  filler.freq = 1285;
  filler.maximum = 1300;
  filler.minimum = 1240;
  filler.LO = 0;
  filler.audio_sc_freq = 600;
  filler.video_gain = 100;
  filler.control_register = 0;
  EEPROM_writeAnything((EE_favorites+(x*0x10)), filler);
  }
//default karakter string memory voor favorieten namen
  char channel[10][12] = {"Memory 1   ","Memory 2   ","Memory 3   ","Memory 4   ","Memory 5   ","Memory 6   ","Memory 7   ","Memory 8   ","Memory 9   ","Memory 10  ",};
  EEPROM_writeAnything(EE_favnames,channel);
  
}




   
