/*
  RGK dec 2017
  Test versie ATV Rx 23_13_6_3. Versie met structs en eprom gebruik.
  Alle instellingen staan per band in een struct zie banden.h De zender kent een struct "actual" waar
  de settings van de gekozen band in staan.
  De bandkeuze is een variabele: band_in _use.
  De (globale) variabelen freq en power zijn in het hoofd(operations) scherm te wijzigen, dit wordt niet
  opgeslagen. Alle andere parameters moeten via het menu worden gewijzigd. Deze instellingen worden wel in
  de eeprom per band apart opgeslagen.

  wijz 31-1-2018  automatische hardware herkenning op basis van I2C ack
                  toevoeging 4-voudige LNB switch
                  toevoeging I2C diagnostic mode
                  teksten in engels
  wijz 13-3-2018  diseqc ondersteuning 
  wijz 3-6-2018   NICAM ondersteuning
  wijz 25-8-2019  Favorieten keuze toegevoegd
  wijz 15-4-2020  Favorieten bugs opgelost
                 
  I2C diagnose:
  Tijdens het opstarten de MENU toets vasthouden, na de welkomstekst komt de melding HF conf: met 
  daarachter een getal. Dit getal geeft binair aan welke i2c chips gevonden zijn:
  b0=philips tuner
  b1=digitale potmeter
  b2=TDA6160 audio demodulator
  b3=PCF8574 functie?
  b4=MSP3415 NICAM decoder Add-on
  Een 0 geeft aan dat de chip een Ack geeft (OK is), een 1 geeft aan dat er geen Ack komt, de chip is
  dan stuk, niet goed aangesloten of afwezig.               

 *** pinbezetting nano ***
  Diseqc 22kHz hangt aan D0
  H/V schakelspanning hangt aan D1
  Rot_A aan pin D2
  Rot_B aan pin D3
  Rot_enter aan pin D4
  toets escape hangt aan D5 (= band omschakeling geworden)
  toets MENU hangt aan D6
  LCD data lijnen aan D7 t/m D10
  SPI MOSI hangt aan D11
  MSP_reset lijn hangt aan D12
  SPI SCK hangt aan D13
  LCD RS hangt aan A0
  LCD Enable hangt aan A1
  video polsw hangt aan A2
  SPI chipselect lijn hangt aan A3
  I2C Scl hangt aan A4
  I2C Sda hangt aan A5
  A6 vrij (kan alleen als analoge ingang worden gebruikt!)
  RSSI tunerblik hangt aan A7

*/

#if 1   //stukje voodoo code
__asm volatile ("nop");
#endif
#include <LiquidCrystal.h>
#include <Wire.h>
#include <SPI.h>
#include "banden.h"
#include "strings.h"
#include "diseqc.h"
#include "nicam.h"


// **** Volgende regel bepaalt of de diseqc commando's gegeven moeten worden ***
//      Deze regel voorzien van // om de diseqc uit te zetten

#define DSQ

// defines algemeen rgk
#define Rot_A       2
#define Rot_B       3
#define Rot_enter   4
#define ESC         5
#define MENU        6
#define SP5055      0x61
#define PCF8574     0x20
#define AD5246      0x2E
#define VIDEO_POL   A2
#define AGC         A7
#define SCK         13
#define MOSI        11
#define LNB_VOLT    1
#define PLL         A3
#define MSP_resetPin  12

//control register bitjes toewijzing
#define V_POL   0
#define V_BW    1
#define LO_POL  2
#define HV      3
// bit 4 en 5 = band_in_use b0 en b1
#define LNB_0   6
#define LNB_1   7

//hardware configuratie register bitjes toewijzing
#define TUNER   0
#define LNBSW   3
#define NICAM   4

// gebruikte GLOBALE variabelen
unsigned int RX_freq;
unsigned int RX_freq_old;
byte rotary;
byte up;
byte band_in_use;
struct band actual;
byte hw_conf_reg = 0;
char channel[10][12];
bool focus;//keuze tussen "frequentie mode" of "favorieten mode", false=freq mode



// aan welke pinnen hangt het LCD display:
LiquidCrystal lcd(A0, A1, 7, 8, 9, 10); //nano  bordje rgk

//***********************************************************************************

void setup() {
  byte ack;
// Serial.begin(9600);//LET OP Serial aan = diseqc buiten werking
// set up timer1 voor diseqc
  cli();
  TCCR1A = 0;
  TCCR1B = 0;
  TCNT1 = 0;
  OCR1A = 363;// voor 22kHz frequentie opwekking
  TCCR1B |=(1<<WGM12);
  TCCR1B |=(1<<CS10);// prescaler timer1 op 1 > clockfrequentie T1 = 16 MHz
  TIMSK1 |=(1<<OCIE1A);
  sei();
  DDRD |= 0x01;
// set up LCD display 16*2 regels
  lcd.begin(16, 2);
// set up I2C communicatie
  Wire.begin();
// External Interrupt 0 service routine
  attachInterrupt(digitalPinToInterrupt(Rot_A), read_rot, FALLING);
// pinnetjes
  pinMode(Rot_A, INPUT_PULLUP);
  pinMode(Rot_B, INPUT_PULLUP);
  pinMode(Rot_enter, INPUT_PULLUP);
  pinMode(MENU, INPUT_PULLUP);
  pinMode(ESC, INPUT_PULLUP);
  pinMode(MOSI, OUTPUT); //MOSI lijn
  pinMode(SCK, OUTPUT);//SPI Clock
  pinMode(VIDEO_POL, OUTPUT);
  pinMode(LNB_VOLT, OUTPUT);

/* HW reset MSP chip 
 *  De pin D12 krijgt bij gebruik van een Sharp tuner de functie van 
 *  SPI MISO lijn. Hoewel de MISO lijn niet nodig is bij de tuner besturing
 *  kan deze pin dan toch niet meer voor andere doeleinden worden gebruikt.
 *  De onderstaande resetfunctie moet dan ook altijd  eerst worden uitgevoerd en daarna
 *  de SPI initialisatie.
 */
  pinMode(MSP_resetPin, OUTPUT);
  digitalWrite(MSP_resetPin,LOW);
  delay(100);
  digitalWrite(MSP_resetPin,HIGH);

//Eeprom vullen met default waarden als ie nog leeg is
  if (EEPROM.read(EE_defaults) != 0x50) {
    EEPROM.write(EE_defaults, 0x50
    );
    EEPROM.write(EE_band_in_use, 0); //0=23cm,1=13cm,2=6cm,3=3cm
    EEPROM.write(EE_fav_nr, 1);
    EEPROM.write(EE_mode,0);//0=frequency mode
    fill_struct();//functie vult een lege eeprom (staat in banden.h)
  }
  
// ***   I2C hardware herkenning, vullen van het hw_conf_reg  ***

// als ack=0 > philips tuner aanwezig, anders Sharp (SPI)gebruiken
  Wire.beginTransmission(SP5055);
  ack = Wire.endTransmission();
  if(ack > 0){
    SPI.begin();
    hw_conf_reg |=1;
  }

// als ack=0 > digitale potmeter AD5246  OK.
  Wire.beginTransmission(AD5246);
  ack = Wire.endTransmission();
  if(ack > 0){
    hw_conf_reg |=2;
  }

// als ack=0 > audio chip TDA6160-2X OK.
  Wire.beginTransmission(0x22);
  ack = Wire.endTransmission();
  if(ack > 0){
    hw_conf_reg |=4;
  }

// vervallen en vervangen door diseqc sturing
// als ack=0 > viervoudige LNB switch aanwezig met PCF8574 
//  Wire.beginTransmission(PCF8574);
//  ack = Wire.endTransmission();
//  if(ack > 0){
//    hw_conf_reg |=8; 
//  }

  #ifndef DSQ// helaas is er geen manier dit automatisch te bepalen
    hw_conf_reg |=8;
  #endif

// als ack=0 > Nicam add-on board met MSP3415G aanwezig
  Wire.beginTransmission(MSP_ADDR);
  ack = Wire.endTransmission();
  if(ack > 0){
    hw_conf_reg |=0x10; 
  }

// ontvanger in de laatstgebruikte stand zetten
  band_in_use = EEPROM.read(EE_band_in_use);
  loadActual();
  focus = EEPROM.read(EE_mode);
  focus &=0x01;
  EEPROM_readAnything(EE_favnames,channel);

// Welkomstekst op het LCD
  lcd.print("  ATV Receiver");
  lcd.setCursor(0, 1);
  lcd.print(" VERON Afd A24");
  delay(2000);//welkomstekst showtime 2 sec
  
// i2C hardware detectie/diagnose   
  if(digitalRead(MENU)==0){
    HW_STATUS();
    while (digitalRead(MENU) == 0);
  }

//als nicamchip aanwezig, dan initialiseren en configureren
  if(bitRead(hw_conf_reg,NICAM) == 0){
     MSP_RESET();
     set_standard(AUTO);
     MSP_LOAD(WR_DFP, SPEAKER_VOL, 0x7300);// zet volume op 0dB 
  }  

  show(RX_freq);
  delay(100);

}

//************************************************************************************

void loop() {
static int keuze;
static long tijd;
static long dsq_old = 0;
static byte favoriet;//favorieten kanaalnummer
static byte favoriet_old;
static int dsq_interval = 1000; // diseqc herhaaltimer
static int muted=0;//nicam autosearch timer
static int standaard=0x0001;//msp tv system standard

char buffer[17];
  tijd=millis();
  favoriet = EEPROM.read(EE_fav_nr);
  if (digitalRead(MENU) == 0 && focus == false) {
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print( "**  MENU < > **");
    do {
        keuze = rot_update(keuze, 0, 8);
       lcd.setCursor(0, 1);
       strcpy_P(buffer, (char*)pgm_read_word(&(menu_table[keuze])));
        lcd.print(buffer);
        }
    while (digitalRead(Rot_enter) == 1);
    while (digitalRead(Rot_enter) == 0);
    switch (keuze) {
      case 0: {
          set_audio();
          show(RX_freq);
          break;
        }
      case 1: {
          set_LO();
          show(RX_freq);
          break;
        }
      case 2: {
          set_video();
          show(RX_freq);
          break;
        }
      case 3: {
          set_Vidpol();
          show(RX_freq);
          break;
        }
      case 4: {
          set_Vidbw();
          show(RX_freq);
          break;
        }
      case 5: {
          set_LNBvolt();
          show(RX_freq);
          break;
        }
      case 6: {
          set_LNBPORT();
          show(RX_freq);
          break;
        }
      case 7: {
          standaard = set_NICAM();
          show(RX_freq);
          break;
        }
      case 8: {
          set_voorkeurtoetsen();
          show(RX_freq);
          break;
        }             
    }
    while (digitalRead(MENU) == 0);
  }
  lcd.setCursor(0, 0);
  strcpy_P(buffer, (char*)pgm_read_word(&(band_table[band_in_use])));
  lcd.print(buffer);

  
  if(digitalRead(Rot_enter)==0){      //Toggle focus tussen freq en favorieten mode
    focus = !focus;
    if(focus)loadFav(favoriet-1);
    else{
        band_in_use = EEPROM.read(EE_band_in_use);
         loadActual();
    }
    update_LCD(focus,favoriet);
    EEPROM.write(EE_mode,focus);
    while(digitalRead(Rot_enter)==0);  
    }

    if(focus){
      favoriet = rot_update(favoriet,1,10);
      if(favoriet !=favoriet_old){
        update_LCD(focus,favoriet);
        favoriet_old = favoriet;
        EEPROM.write(EE_fav_nr, favoriet);
        }
    }
    else{
    RX_freq = rot_update(RX_freq, actual.minimum, actual.maximum);
    if (RX_freq != RX_freq_old) {
    set_tuner(RX_freq);
    RX_freq_old = RX_freq;
    actual.freq = RX_freq;
    saveActual();
    update_LCD(focus,favoriet);
      }
    }


  
  if (digitalRead(ESC) == 0 && focus == false) {
    band_in_use += 1;
    if (band_in_use > 3) band_in_use = 0;
    loadActual();
    update_LCD(focus,favoriet);
  }
  while (digitalRead(ESC) == 0);
  delay(5);

// DiSeqC herhaal timer  
  if(tijd-dsq_old > dsq_interval){
    if(bitRead(hw_conf_reg,LNBSW) == 0){
      byte lnb = actual.control_register >>6;
      set_lnbswitch(lnb);
    }
    dsq_old = tijd;
  }
// NICAM autosearch routine

  if(bitRead(hw_conf_reg,NICAM) == 0)
  { 
    if(muted>0)
      {
        muted--;
        if(muted==0)
          {
            MSP_LOAD(WR_DFP, SPEAKER_VOL,0x7300);//unmute
          }
      }
    else
      {
        if(MSP_READ(STATUS)==6)
          {
            MSP_LOAD(WR_DFP, SPEAKER_VOL,0x0000);//mute
            set_standard(standaard);
            muted=100;
          }
      }
    set_mspLEDs();//statusledje voor ontvangst van nicam en/of fm carrier  
  }
//  Serial.println(muted);

} // einde Main Loop

// ***********   rgk functies:  ***********************************************************

void read_rot()
{
  rotary = 1;
  up = digitalRead(Rot_B);     // that's all folks...
}


// managen van de variabelen die met rotary instelbaar zijn
int rot_update(int var, int min, int max)
{
  unsigned char stap = 1;
  //if(digitalRead(TOETS)==0)stap=10;//helaas geen inputs meer beschikbaar hiervoor
  //else stap=1;

  noInterrupts();

  if (rotary)
  {
    rotary = 0;
    if (up) var += stap;
    else var -= stap;
  }
  if (var > max) var = min;
  if (var < min) var = max;
  interrupts();
  return var;
}

void show(int RX_freq) {
  lcd.setCursor(0, 1);
  lcd.print("Freq:      MHz  ");
  lcd.setCursor(6, 1);
  lcd.print(RX_freq);
}

void update_LCD(bool mode, byte fav){
  char buffer[17];
  if(mode){
    lcd.setCursor(0,1);
    lcd.print("M");
    lcd.print(fav);
    lcd.print("> ");
    strcpy (buffer,channel[fav-1]);
    lcd.print(buffer);
    
    loadFav(fav-1);//1-10 wordt 0-9
    lcd.setCursor(0, 0);
    strcpy_P(buffer, (char*)pgm_read_word(&(band_table[band_in_use])));
    lcd.print(buffer);
  }
  else show(RX_freq);
}


void set_audio(void) {
  int au_freq = actual.audio_sc_freq;
  lcd.clear();
  lcd.print(" Set audio freq.");
  lcd.setCursor(0, 1);
  lcd.print(" freq:      kHz    ");
  lcd.setCursor(7, 1);
  lcd.print(10 * au_freq);
  do {
    au_freq = rot_update(au_freq, 550, 900);
    lcd.setCursor(7, 1);
    lcd.print(10 * au_freq);
    set_tda(au_freq);
    delay(5);//is dit echt nodig?
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  actual.audio_sc_freq = au_freq;
  saveActual();
}

byte choose_mixmode(void)
{
  char buffer[17];
  byte lo_pol;
  lo_pol = get_ctrlbit(LO_POL);
  lcd.clear();
  if (band_in_use == 0)return 0;
  if (band_in_use == 3)return 0; //wegwezen, geen bovenmenging 
  strcpy_P(buffer, (char*)pgm_read_word(&(band_table[band_in_use])));
  lcd.print(buffer);
  do {
    lo_pol = rot_update(lo_pol, 0, 1);
    if (lo_pol == 0) {
      lcd.setCursor(0, 1);
      lcd.print("below:IF = RF-LO");
    }
    else {
      lcd.setCursor(0, 1);
      lcd.print("above:IF = LO-RF");
    }
    delay(50);//niet fraai..
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  return lo_pol;
}

void set_LNBPORT(void) {
  char buffer[17];
  byte lnb= get_ctrlbit(LNB_1)<<1 + get_ctrlbit(LNB_0);
  byte lnb_old=lnb;
  lcd.clear();
  strcpy_P(buffer, (char*)pgm_read_word(&(band_table[band_in_use])));  
  lcd.print(buffer);
  lcd.setCursor(0,1);
  lcd.print("on LNB Input: ");
  if(bitRead(hw_conf_reg,LNBSW)==0){
// 4-voudige LNB switch aanwezig    
  do {
    lnb = rot_update(lnb, 0, 3);
    lcd.setCursor(14,1);
    switch(lnb){
      case 0:{
       lcd.print("A");
       break; 
      }
      case 1:{
       lcd.print("B");
       break; 
      }
      case 2:{
       lcd.print("C");
       break; 
      }
      case 3:{
       lcd.print("D");
       break;  
      }              
    }
    if(lnb != lnb_old){
        set_lnbswitch(lnb);
        actual.control_register = actual.control_register & 0x3F;
        actual.control_register |= lnb<<6;
        lnb_old = lnb;
      }
    }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  saveActual();
  }  
  else{
// 2-voudige LNB keuze op tuner zelf
  do {
    lnb = rot_update(lnb, 0, 1);
    lcd.setCursor(0, 1);
    if (lnb)lcd.print("  LNB A(top)    ");
    else lcd.print(" LNB B(bottom)  ");
    if(lnb != lnb_old){
        set_ctrlbit(LNB_0, lnb&0x01);
        set_tuner(RX_freq);
        lnb_old = lnb;
      }
    }  
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  saveActual();
  }
}

void set_LO(void) {
  if(band_in_use==0)return;//23cm> geen LO nodig, wegwezen.
  int min;
  int max;
  int lo_freq;
  int lo_freq_old;
  lo_freq_old = lo_freq;
  byte lo_pol = choose_mixmode();//eerst keuze maken voor boven of ondermenging
  set_ctrlbit(LO_POL,lo_pol);
  lo_freq = actual.LO;
  lcd.clear();
  lcd.print(" Set local osc.");
  lcd.setCursor(0, 1);
  lcd.print(" LO:       MHz");

  switch (band_in_use) {
    case 0: {
        break;
      }
    case 1: {
        if (lo_pol) {
          min = 3350;
          max = 4470;
        }
        else {
          min = 250;
          max = 1370;
        }
        break;
      }
    case 2: {
        if (lo_pol) {
          min = 6500;
          max = 7500;
        }
        else {
          min = 4000;
          max = 5000;
        }
        break;
      }
    case 3: {
        min = 9000;
        max = 9500;
        break;
      }
  }

  do {
    lo_freq = rot_update(lo_freq, min, max);
    lcd.setCursor(5, 1);
    if (lo_freq < 1000)lcd.print(" ");
    if(lo_freq != lo_freq_old){
        lcd.print(lo_freq);
        actual.LO = lo_freq;
        set_tuner(RX_freq);
        lo_freq_old = lo_freq;
    }    
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);  
  saveActual();
}

void set_video(void) {
  byte gain = actual.video_gain;
  lcd.clear();
  lcd.print(" Set video gain");
  lcd.setCursor(0, 1);
  lcd.print(" gain :      ");
  lcd.setCursor(7, 1);
  lcd.print(gain);
  do {
    gain = rot_update(gain, 0, 127);
    lcd.setCursor(7, 1);
    if (gain < 100)lcd.print(" ");
    if (gain < 10)lcd.print(" ");
    lcd.print(gain);
    set_videolevel(gain);
    delay(5);//is dit echt nodig?
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  actual.video_gain = gain;
  saveActual();
}

void set_Vidpol(void) {
  byte v_pol = get_ctrlbit(V_POL);
  lcd.clear();
  lcd.print("Video polarity");
//  lcd.setCursor(0, 1);
  do {
    v_pol = rot_update(v_pol, 0, 1);
    lcd.setCursor(0, 1);
    if (v_pol)lcd.print("    Inverted    ");
    else lcd.print("     Normal     ");
    io_set_videopolariteit(v_pol);
    delay(10);
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  set_ctrlbit(V_POL, v_pol);
  saveActual();
}

void set_Vidbw(void) {
  byte v_bw = get_ctrlbit(V_BW);
  byte v_bw_old=v_bw;
  lcd.clear();
  lcd.print("Video bandwidth");
//  lcd.setCursor(0, 1);
  do {
    v_bw = rot_update(v_bw, 0, 1);
    lcd.setCursor(0, 1);
    if (v_bw)lcd.print("    27 MHz      ");
    else lcd.print("    18 MHz     ");
    if(v_bw != v_bw_old){
        set_ctrlbit(V_BW, v_bw);
        set_tuner(RX_freq);
        v_bw_old = v_bw;
    }
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  saveActual();
}

void set_LNBvolt(void) {
  byte hv = get_ctrlbit(HV);
  lcd.clear();
  lcd.print(" Set Hor/Vert   ");
  do {
    hv = rot_update(hv, 0, 1);
    lcd.setCursor(0, 1);
    if (hv)lcd.print(" Horizontal   ");
    else lcd.print("   Vertikal     ");
    io_set_rfpolariteit(hv);
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  set_ctrlbit(HV, hv);
  saveActual();
}

unsigned int set_NICAM(void){
  byte var=0;
  unsigned int standaard=0x0001;
  if(bitRead(hw_conf_reg,NICAM) != 0)return standaard; //geen NICAM chip aanwezig > wegwezen
  lcd.clear();
  lcd.print(" set NICAM norm ");
  do{
    var = rot_update(var, 0, 2);
    lcd.setCursor(0,1);
    if(var==0){
      lcd.print("   auto   ");
      set_standard(AUTO);
      standaard=0x0001;
    }
    if(var==1){
      lcd.print("system B/G");
      set_standard(BG);
      standaard=0x0008;
    }
    if(var==2){
      lcd.print("system  I ");
      set_standard(I);
      standaard=0x000A;
    }
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  return standaard;
}


void set_voorkeurtoetsen(void){
  byte kanaal = 1;
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Kies channel no>");
  lcd.setCursor(0,1);
  lcd.print("Channel :       ");
  do{
  kanaal = rot_update(kanaal,1,10);
  lcd.setCursor(10,1);
  lcd.print(kanaal);
  lcd.print(" ");
  }
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  kanaal -=1;
  name_set(kanaal);
  EEPROM_writeAnything(EE_favnames,channel);//aangepaste naam wegschrijven in de eeprom
  
  kanaal *=0x10;
  EEPROM_writeAnything((EE_favorites+kanaal), actual);  
}

void name_set(byte kanaal){
  char name[12];
  static char kar=0x41;
  static char kar_old;
  static int positie=0;
  strcpy (name,channel[kanaal]);
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("<              >");
  lcd.setCursor(2,0);
  lcd.print(name);
  setpijl(positie);
  do{
    kar =name[positie];
    kar=rot_update(kar,0x20,0x7D);//printbare karakters
    name[positie]=kar;
    if(kar != kar_old){
    lcd.setCursor(2,0);
    lcd.print(name);
    kar_old = kar;
       }   
    if (digitalRead(MENU) == 0) {
      positie++;
      if(positie>10) positie=0;
      setpijl(positie);
      kar=name[positie];
    }
    while (digitalRead(MENU) == 0);
    if (digitalRead(ESC) == 0) {
      positie--;
      if(positie<0) positie=10;
      setpijl(positie);
      kar=name[positie];
    }
    while (digitalRead(ESC) == 0);
     }    
  while (digitalRead(Rot_enter));
  while (digitalRead(Rot_enter) == 0);
  strcpy (channel[kanaal],name);
}

// functie om een aanwijspijltje onder de letter te zetten bij instellen favorieten naam
void setpijl(byte positie){
  char pijlarray[14] = "             ";
  pijlarray[positie] = 0x5E;
  lcd.setCursor(2,1);
  lcd.print(pijlarray);
}

void set_parms() {
  band_in_use=(actual.control_register & 0x30)>>4;
  RX_freq = actual.freq;
  RX_freq_old = RX_freq;
  set_tuner(RX_freq);
  if(bitRead(hw_conf_reg,LNBSW)==0){
    byte lnb = actual.control_register>>6;
    set_lnbswitch(lnb);
  }
  set_tda(actual.audio_sc_freq);
  set_videolevel(actual.video_gain);
  byte v_pol = get_ctrlbit(V_POL);
  io_set_videopolariteit(v_pol);
  byte hv = get_ctrlbit(HV);
  io_set_rfpolariteit(hv);
}

void saveActual(void) {
  EEPROM_writeAnything(EE_address + (band_in_use * 0x10), actual); //schrijf actuele band weg
}

void loadActual(void) {
  EEPROM_readAnything(EE_address + (band_in_use * 0x10), actual); //lees de actuele band in
  EEPROM.write(EE_band_in_use, band_in_use);
  set_parms();
}

void loadFav(byte channel){
  EEPROM_readAnything(EE_favorites + (channel * 0x10), actual); //set de gekozen favoriet in actual
  set_parms();//stel de ontvanger in
}

void set_ctrlbit(byte number , byte data) {
  byte temp = data << number;
  bitClear(actual.control_register, number);
  actual.control_register |= temp;
}

byte get_ctrlbit(byte number) {
  byte temp =  actual.control_register >> number & 0x01;
  return temp;
}

//    *********  Hardware driver routines ********

void io_set_videopolariteit(byte data) {
  if (data)digitalWrite(VIDEO_POL, LOW); // Normale polariteit
  else digitalWrite(VIDEO_POL, HIGH); // inverse [polariteit
}

void io_set_rfpolariteit(byte data) {
  if(bitRead(hw_conf_reg,LNBSW)==0)  //keuze is er een 4-voudige switch of niet?
  {
  if (data) digitalWrite(LNB_VOLT, LOW);//tov originele schakeling geinverteerd!
  else digitalWrite(LNB_VOLT, HIGH);
  }
  else
  { 
  if (data) digitalWrite(LNB_VOLT, HIGH);
  else digitalWrite(LNB_VOLT, LOW);
  }
}

void set_videolevel(byte level)
{
  Wire.beginTransmission(AD5246);
  Wire.write(127 - level);
  Wire.endTransmission();
}


// tunerblikje besturing
void set_tuner(int rx_freq)
{
  int syn;
  int ack;
  byte synhi;
  byte synlo;
  byte ports = 0;
  byte lo_pol;
  int lo_freq = actual.LO;
  lo_pol = get_ctrlbit(LO_POL);
  byte in_port;
  if(bitRead(hw_conf_reg,LNBSW)==0)in_port=0x00;  //keuze is er een 4-voudige switch of niet?
  else in_port=get_ctrlbit(LNB_0);
  syn = rx_freq;
  switch (band_in_use) {
    case 0: {
        syn += 480;
        break;
      }
    case 1: {
        if (lo_pol)syn = (lo_freq + 480) - syn; //bovenmenging
        else syn -= (lo_freq - 480);  //ondermenging
        break;
      }
    case 2: {
        if (lo_pol)syn = (lo_freq + 480) - syn;
        else syn -= (lo_freq - 480);
        break;
      }
    case 3: {
        syn -= (lo_freq - 480);
        break;
      }
  }
//I2C sturing (Philips tuners)  
  byte philips = hw_conf_reg>>TUNER & 0x01;
  if(philips == 0){
  syn *= 8;
  synhi = (syn / 256) & 0xff;
  synlo = ((syn - (synhi * 256)) & 0xff);
  bitWrite(ports, 0, get_ctrlbit(V_BW));
  bitWrite(ports, 7, !in_port);
  Wire.beginTransmission(SP5055);
  Wire.write(synhi);
  Wire.write(synlo);
  Wire.write(0xCE);
  Wire.write(ports);
  Wire.endTransmission();
  }

  //SPI sturing (Sharp tuners)
  else{
  synhi = (syn / 256) & 0xff;
  synlo = ((syn - (synhi * 256)) & 0xff);
  bitWrite(synhi,7,!(get_ctrlbit(V_BW)));
  bitWrite(synhi,6,in_port);
  SPI.transfer(synhi);
  SPI.transfer(synlo);
  digitalWrite(PLL, HIGH);
  delay(5);
  digitalWrite(PLL, LOW);
  SPI.endTransaction();
  }
}

// analoge audio demodulator chip besturing
void set_tda(int au_sc)
{
  unsigned char synhi;
  unsigned char synlo;
  int syn;
  syn = au_sc + 1070;
  syn = syn * 8;
  synhi = (syn / 256) & 0xff;
  synlo = ((syn - (synhi * 256)) & 0xff);
  Wire.beginTransmission(0x22);//adres audiochip
  Wire.write(synhi);
  Wire.write(synlo);
  Wire.write(0xb0);//controlbyte vaste waarde
  Wire.endTransmission();
}

// show hardware status i2c componenten Dit moet nog wat mooier......
void HW_STATUS(void)
{
  lcd.setCursor(0,1);
  lcd.print("   HW_conf: ");
  lcd.print(hw_conf_reg);
  lcd.print("  ");
//  delay(5000);
}

// Externe LNB switch besturing via Diseqc command
void set_lnbswitch(byte data){
  data_dsq[0]=0xe0;//prefix
  data_dsq[1]=0x10;//address
  data_dsq[2]=0x38;//command
  len_dsq=4;        
  switch(data){
    case 0:{
      data_dsq[3]=0xF0;
      start=TRUE;
      delay(50);
      break;
    }
    case 1:{
      data_dsq[3]=0xF4;
      start=TRUE;
      delay(50);
      break;
    }
    case 2:{
      data_dsq[3]=0xF8;
      start=TRUE;
      delay(50);
      break;
    }
    case 3:{
      data_dsq[3]=0xFC;
      start=TRUE;
      delay(50);
      break;   
    }
  }
}

void set_mspLEDs(void)//dit is geen al te fraai stukje...
{
  unsigned int Status=0;
  bool nicamled;
  bool fmled;
  unsigned int data=0x0000;
  Status = MSP_READ(STATUS);
  nicamled = bitRead(Status,5);
  fmled = !(bitRead(Status,1));
  if(nicamled)data |= 0x4000;
  if(fmled)data |= 0x8000;  
  MSP_LOAD(WR_DFP, ACB_REG, data);
}
