; FREQTRX1.ASM
; Start November 26, 2001
; Version 1.0 of December 1, 2001
; frequency counter for 01TRX
; x-tal frequency 10 MHz
; gate-time=0.5 second


; B0: A/D Capacitor in
; B1: POWER IN
; B2: TX ACTIVE IN
; B3: F-7seg led display
; B4: G-7seg led display
; B5: Free
; B6: 100Hz display if grounded
; B7: 100kHz display if grounded

; D0: A-7seg led display
; D1: B-7seg led display
; D2: C-7seg led display
; D3: D-7seg led display
; D5: E-7seg led display
; D6: Capacitor A/D converter charge/discharge 



  .device at90s1200
      .nolist
.include "1200def.inc"
      .list

; main program register variables


.def    sum0 =r2
.def    sum1 =r3
.def    sum2 =r4

.def    Zero =r5
.def    One  =r6

.def    cnt0 =r7
.def    cnt1 =r8
.def    cnt2 =r9

.def    oldsum  =r11
.def    var1    =r16
.def    var2    =r17
.def    var3    =r18
.def    flag1   =r19    ;b0=1: Frequency out of band
                        ;b1=1: Keydown during frequency count
                        ;b2=1: Key up during frequency count
                        ;b3=1: Voltage instead of Power display
                        ;b4=1: Program enable mode
                        ;b5=1: Program mode
.def    bcd0 =r20
.def    bcd1 =r21
.def    bcd2 =r22
.def    bcd3 =r23
.def    bcd4 =r24
.def    bcd5 =r25
.def    bcd6 =r26
.def    bcd7 =r27

.def    basevar  =r28
.def    bcd_cnt  =r31


; code
	rjmp  RESET ;

RESET:  ldi     var2,0b00011000 ;Set B4 B3 as output, rest input
        out     DDRB,var2
        ldi     var2,0b11111000 ;Set outputs and pull up resistors inputs
        out     PORTB,var2      ;
        ldi     var2,0b01101111 ;Set D4 as input, rest as output
        out     DDRD,var2
        ldi     var2,0b00101111 ;Set outputs and pull up resistors inputs
        out     PORTD,var2
; Comparator already default initialized
        ldi     var2,1          ;Set variable One to 1
        mov     One,var2
        clr     Zero            ;Set variable Zero to 0
        clr     flag1           ;Clear flags


Hello:
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b00001000 ;Letter A
        rcall   Display
        ldi     var1,0b00100100 ;Number 2
        rcall   Display
        ldi     var1,0b01000000 ;Letter O
        rcall   Display
        ldi     var1,0b00001001 ;Letter H
        rcall   Display
        ldi     var1,0b00001001 ;Letter H
        rcall   Display
        ldi     var1,0b01111111 ;Blank
        rcall   Display


Test_prgenable:                 ;Test for program enable mode 
        rcall   Prg_status      ;Test for Prg_status
        andi    flag1,0b11011111;Clear b5 program mode but not b4 enable bit
Test_prgenable_end:


Mainloop:
        sbrs    flag1,0         ;Skip if out of band frequency
        rjmp    Mainloop_meas   ;If in band then rjmp Mainloop_meas
        cbi     PORTB,4         ;Set led G on for out of band
        sbrs    flag1,1         ;Keydown (TX) during frequency measurement
        rjmp    Mainloop_meas   ;If RX then only led G on
        cbi     PORTD,0         ;Set led A on for out of band during TX
        cbi     PORTD,3         ;Set led D on for out of band during TX

Mainloop_meas:
        rcall   Freqmeas        ;Do a frequency measurement
        rcall   In_band         ;Check if in band frequency (b0 of flag1 set)

        sbi     PORTB,4         ;Set led G off
        sbi     PORTD,0         ;Set led A off
        sbi     PORTD,3         ;Set led D off

        sbrc    flag1,4         ;Skip if no program enable mode
        rcall   Prg_status      ;Test for Prg_status
        sbrc    flag1,5         ;Skip if no program enable mode
        rcall   Prg_mode        ;Program eeprom in-band ranges

        sbrc    flag1,2         ;Skip POWER if no keyup (flag b2=0)
        rjmp    Mainloop_freq   ;If keyup flag set then display frequency
Mainloop_power:
        andi    flag1,0b11110111;Clear Voltage flag b3
        sbic    PINB,6          ;Power if B6 grounded (100Hz switch)
        ori     flag1,0b00001000;else Voltage, set Voltage flag b3
        rcall   Powermeas       ;Do a power/Voltage measurement
        rcall   BCD_P_conversion;Do a BCD conversion
        rcall   Power_display   ;And display the Voltage/Power
        rjmp    Mainloop        ;Loop

Mainloop_freq:
        rcall   BCD_F_conversion;Do a BCD conversion
        rcall   Freq_display    ;And display the frequency
        rjmp    Mainloop        ;Loop
;------------------------------------------------------------


Prg_status:                     ;Test for program status switches/key down
        andi    flag1,0b11011111;Clear b5 program mode but not b4 enable bit
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000100 ;Enable if B7, B6 and B2 high
        cpi     var1,0b11000100 ;kHz/MHz floating, key down
        breq    Prg_status1     ;If so, then next test
        ret

Prg_status1:                    ;Next test: switch in MHz position
        cbi     PORTD,0         ;Set led A on
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        sbi     PORTD,0         ;Set led A off
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000100 ;Enable if B7, B6 and B2 high
        cpi     var1,0b01000100 ;MHz grounded, key down
        breq    Prg_status2     ;If so, then next test
        ret

Prg_status2:                    ;Next test: switch in kHz position
        cbi     PORTD,3         ;Set led D on
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        sbi     PORTD,3         ;Set led D off
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000100 ;Enable if B7, B6 and B2 high
        cpi     var1,0b10000100 ;kHz grounded, key down
        breq    Prg_status3     ;If so, then next test
        ret

Prg_status3:
        ori     flag1,0b00110000;Set program status and program enable flag
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b01111111 ;All off 
        rcall   Display

        ret


Prg_mode:                       ;Program in band ranges of eeprom
        andi    flag1,0b11011111;Clear b5 program mode but not b4 enable bit
        ldi     var3,0          ;The counter for the bands
Prg_mode_loop:
        mov     var1,var3       ;In var1 for processing
        lsr     var1            ;Divide by 2
        rcall   Display_set     ;Display the counter value

        cbi     PORTD,5         ;Set led E on
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        sbi     PORTD,5         ;Set led E off
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000000 ;Test kHz MHz switch position
        cpi     var1,0b10000000 ;kHz grounded
        brne    Prg_mode_end    ;If not in kHz position then end

        sbis    PINB,2          ;If key up then program the range
        rjmp    Prg_mode_now    ;then rjmp to that

        inc     var3            ;Increment var3
        cpi     var3,19         ;Test for last range, skip ret if not
        breq    Prg_mode_end    ;If last range done, then end

        cbi     PORTD,2         ;Set led E on
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        sbi     PORTD,2         ;Set led E off
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000000 ;Test kHz MHz switch position
        cpi     var1,0b10000000 ;kHz grounded
        brne    Prg_mode_end    ;If not in kHz position then end

        sbis    PINB,2          ;If key up then program the range
        rjmp    Prg_mode_now    ;then rjmp to that

        inc     var3            ;Increment var3
        cpi     var3,19         ;Test for last range, skip ret if not
        breq    Prg_mode_end    ;If last range done, then end
        rjmp    Prg_mode_loop   ;or loop for next range

Prg_mode_now:
        mov     basevar,var3    ;In var1 for processing
        add     basevar,var3    ;2x var3 in var1
        add     basevar,var3    ;3x var3 in var1

        mov     var1,sum2       ;Msb first for easier comparision routine
        rcall   eeprom_wrt      ;Write to eeprom
        mov     var1,sum1       ;Msb first for easier comparision routine
        rcall   eeprom_wrt      ;Write to eeprom
        mov     var1,sum0       ;Lsb last for easier comparision routine
        rcall   eeprom_wrt      ;Write to eeprom
        
        ldi     var1,0b00010010 ;Letter S Save
        rcall   Display
        ldi     var1,0b00000110 ;Letter E EEprom
        rcall   Display
        ldi     var1,0b00000110 ;Letter E
        rcall   Display
        ldi     var1,0b01111111 ;Blank
        rcall   Display

Prg_mode_end:
        ret


Freqmeas:                       ;Frequency measurement routine      
; 10 MHz xtal 0.5 sec. period :  11 + (W-1) * 17 = 5e6 (.5*10e6)
; W = 294118: 04 7c e6
        ldi     var1,0xe6
        mov     cnt0,var1
        ldi     var1,0x7c
        mov     cnt1,var1
        ldi     var1,0x04
        mov     cnt2,var1

        ldi     var1,7          ;External pin T0 (D4) rising edge
        out     TCCR0,var1      ;Counter start, T0 raising edge

Freqstart:
        clr     sum0            ;Clear frequency count variables
        clr     sum1
        clr     sum2

        out     TCNT0,Zero      ;Reset counter, start of measurement
        andi    flag1,0b11111001;Reset keydown/up flags

Freqmeas_loop1:
        sbic    PINB,2          ;Check for keydown flag (skip if keyup)
        ori     flag1,0b00000010;Set keydown flag
        sbis    PINB,2          ;Check for keyup flag
        ori     flag1,0b00000100;Set keyup flag
        sub     cnt0,One        ;Decrement measurement time
        sbc     cnt1,Zero 
        sbc     cnt2,Zero 
        brcs    Freqmeas_ready  ;The end
        mov     oldsum,sum0     ;Last timer read in oldsum for check overflow
        in      sum0,TCNT0      ;Read timer
        cp      sum0,oldsum
        brlo    Freqmeas_carry  ;If timer register overflow 255-0
        nop
        nop                     ;Time loop correction 3x nop
        nop
        rjmp    Freqmeas_loop1
Freqmeas_carry:        
        add     sum1,One        ;Increase sum1 for timer overflow sum0
        adc     sum2,Zero       ;Add carry to sum2 if sum1 overflow
        rjmp    Freqmeas_loop1
Freqmeas_ready:
        ret


Powermeas:
        sbi     PORTD,6         ;Start charging capacitor
Powermeas1:
        sbis    ACSR,5          ;Skip if capacitor high
        rjmp    Powermeas1      ;Loop till comparator switches

        ldi     var1,253        ;Init sample counter 
        sbrc    flag1,3         ;Skip next if power display
        ldi     var1,200        ;For Voltage 200 samples, 1 sample is 0.1V
        mov     cnt0,var1
        clr     var3            ;Clear var3 result

Powermeas_loop:
        ldi     var1,33         ;Short wait loop of approx 10 us
Powermeas2:
        dec     var1
        brne    Powermeas2      ;Loop for approx 10 us

        clr     var1            ;Extra, is already cleared
        sbis    ACSR,5          ;Skip if capacitor value higher than input
        ldi     var1,0b01000000 ;else set charge
        sbrc    var1,6          ;If bit6 set then
        inc     var3            ; increment result var3
        in      var2,PORTD      ;For processing in var2
        andi    var2,0b10111111 ;Clear D6 status
        or      var2,var1       ;Set new D6
        out     PORTD,var2      ;Set the port to charge or discharge
        dec     cnt0            ;Decrement loop counter
        brne    Powermeas_loop  ;Loop if not ready
        cbi     PORTD,6         ;Discharge capacitor till next time
        
        mov     sum0,var3       ;For Voltage result
        clr     sum1
        clr     sum2            ;Clear sum results for Voltage result
        sbrc    flag1,3         ;Skip next if power display
        ret                     ;Finish for voltage display

        subi    var3,-9         ;Add 9 to result for 0,7V diode voltage

Power_quadrature:               ;Quadrature voltage to get power
        mov     sum0,var3       ;Var3 in multiplier/lo byte result sum0
        clr     sum1
        clr     sum2            ;Clear sum results
        ldi     var1,8          ;Init loop counter var1
        lsr     sum0            ;Rotate multiplier/lobyte result
Power_qd1:
        brcc    Power_qd2       ;If carry set then
        add     sum1,var3       ; add multiplicant to result hibyte
Power_qd2:
        ror     sum1            ;Rotate right result hibyte
        ror     sum0            ;Rotate multiplier/lobyte result
        dec     var1            ;Decrement loop counter
        brne    Power_qd1       ;Loop until ready
                                ;Divide by 4 in bcd conversion
        ret


BCD_F_conversion:               ;Convert binary to decimal, frequency
        ldi     bcd_cnt,29      ;24 bits + /16 (+4) +0.5 to 1 sec (+1)
        rjmp    BCD_start       ;

BCD_P_conversion:               ;Convert binary to decimal, RF power
        ldi     bcd_cnt,22      ;24 bits + /4 function (-2) for Power
        sbrc    flag1,3         ;Skip next if power display
        ldi     bcd_cnt,24      ;For Voltage 24 bits
        rjmp    BCD_start       ;
                                
BCD_start:                      ;Start bcd conversion
        ldi     ZL,20           ;bcd0 = r20
BCD_clear:                      ;Clear all BCD variables
        st      Z,Zero
        inc     ZL
        cpi     ZL,28           ;bcd7+1 (bcd7=r27)
        brne    BCD_clear

BCD_loop:
        clc
        rol     sum0
        rol     sum1
        rol     sum2
        ldi     ZL,20           ;bcd0, start with lowest decimal value 
BCD_nr:                         ;now double bcd 3 digits       
        ld      var1,Z
        adc     var1,var1
        cpi     ZL,28           ;bcd7+1
        breq    BCD_next
        cpi     var1,10
        brcs    BCD_no_cor
        subi    var1,10
        sec
        rjmp    BCD_go
BCD_no_cor:
        clc
BCD_go: st      Z,var1
        inc     ZL              ;next bcd variable
        rjmp    BCD_nr
BCD_next:         
        dec     bcd_cnt
        brne    BCD_loop

        ret


Freq_display:

Out_MHz: 
        sbic    PINB,7          ;Display only if B7 grounded
        rjmp    Out_kHz
        mov     var1,bcd7
        cpse    var1,Zero       ;Do not display if bcd7=0
        rcall   Display_set
        mov     var1,bcd6
        rcall   Display_set
        mov     var1,bcd5
        rcall   Display_set
Out_kHz:
        sbic    PINB,6          ;Display only if B6 grounded
        ret
        mov     var1,bcd4
        rcall   Display_set
        mov     var1,bcd3
        rcall   Display_set
        mov     var1,bcd2
        rcall   Display_set

        ret


Power_display:
        sbrc    flag1,3         ;Skip next if power display 
        rjmp    Volt_display    ;if b3 of flag1 is set then Volt_display
        sbic    PINB,6          ;No power display if B6 not grounded (kHz pos)
        ret
        ldi     var1,0b00001100 ;Letter P at begin of power display
        rcall   Display
        mov     var1,bcd4
        cpse    var1,Zero       ;Do not display if bcd4=0
        rcall   Display_set
        mov     var1,bcd3
        rcall   Display_set
        mov     var1,bcd2
        rcall   Display_set

        ret


Volt_display:
        sbic    PINB,7          ;No power display if B7 not grounded (MHz pos)
        ret
        ldi     var1,0b01000001 ;Letter U at begin of voltage display
        rcall   Display
        mov     var1,bcd2
        cpse    var1,Zero       ;Do not display if bcd2=0
        rcall   Display_set
        mov     var1,bcd1
        rcall   Display_set
        mov     var1,bcd0
        rcall   Display_set

        ret


In_band:                        ;Check for in band frequency
        ldi     var3,0          ;Band range counter, first eeprom address=0
        ori     flag1,0b00000001;Set out of band flag, cleared if in band
In_band_loop:
        mov     basevar,var3    ;Set eeprom address of band
        rcall   Eeprom_rd
        cp      sum2,var1       ;Compare Msb with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
        breq    In_band_loop1   ;If equal, test the lsb's
        rjmp    In_band_loop3   ;Now higher, goto test for band end
In_band_loop1:                  ;Test the lsb1 as Msb's equal
        rcall   Eeprom_rd
        cp      sum1,var1       ;Compare lsb1 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
        breq    In_band_loop2   ;If equal, test the lsb's
        rjmp    In_band_loop3   ;Goto test for band end
In_band_loop2:                  ;Test the lsb2 as lsb1 equal
        rcall   Eeprom_rd
        cp      sum0,var1       ;Compare lsb2 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band

In_band_loop3:                  ;Start test of end of frequency band
        mov     basevar,var3    ;Set eeprom address of band
        inc     basevar         ;address+1
        inc     basevar         ;address+2
        inc     basevar         ;address+3 is address end of frequency band
        rcall   Eeprom_rd
        cp      var1,sum2       ;Compare Msb with end of frequency band
        brlo    In_band_next    ;If higher then try next band
        breq    In_band_loop4   ;If equal, test the lsb's
        rjmp    In_band_in      ;Now lower, In Band!
In_band_loop4:                  ;Test the lsb1 as Msb's equal
        rcall   Eeprom_rd
        cp      var1,sum1       ;Compare lsb1 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
        breq    In_band_loop5   ;If equal, test the lsb's
        rjmp    In_band_in      ;Goto test for band end
In_band_loop5:                  ;Test the lsb2 as lsb1 equal
        rcall   Eeprom_rd
        cp      var1,sum0       ;Compare lsb2 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
In_band_in:
        andi    flag1,0b11111110;Clear out of band flag
        ret

In_band_next:
        subi    var3,-6         ;Add 6 for next frequency band in eeprom
        cpi     var3,55         ;Test for last range
        brlo    In_band_loop    ;Loop if not ready

        ret


;------------ DISPLAY SUBROUTINES ----------------
Display_set:                    ;Display and make 7 segment code        
        rcall   Setcode         ;Convert var1 to 7 segment code
Display:                        ;var1 b0 - b6 is Display a - g segment
        sbrs    var1,0          ;Skip if bit in var1 set
        cbi     PORTD,0         ;else switch Display segment on
        sbrs    var1,1          ;Skip if bit in var1 set
        cbi     PORTD,1         ;else switch Display segment on
        sbrs    var1,2          ;Skip if bit in var1 set
        cbi     PORTD,2         ;else switch Display segment on
        sbrs    var1,3          ;Skip if bit in var1 set
        cbi     PORTD,3         ;else switch Display segment on
        sbrs    var1,4          ;Skip if bit in var1 set
        cbi     PORTD,5         ;else switch Display segment on
        sbrs    var1,5          ;Skip if bit in var1 set
        cbi     PORTB,3         ;else switch Display segment on
        sbrs    var1,6          ;Skip if bit in var1 set
        cbi     PORTB,4         ;else switch Display segment on

        clr     var1
        ldi     var2,13         ;13*.3e-6*65536=0.255 sec

Display_on_lus:
        dec     Zero
        brne    Display_on_lus
        dec     var1
        brne    Display_on_lus
        dec     var2
        brne    Display_on_lus   

        in      var1,PORTD      ;PORTD in var1 for Display off
        ori     var1,0b00101111 ;D5 D3 D2 D1 D0 = 1 for Display off
        out     PORTD,var1      ;Set PORTD for Display off

        in      var1,PORTB      ;PORTB in var1 for Display off
        ori     var1,0b00011000 ;B4 B3 = 1 for Display off
        out     PORTB,var1      ;Set PORTB for Display off

        out     PORTB,var1      ;7 segment display off

        clr     var1
        ldi     var2,4          ;4*.3e-6*65536=0.078 sec
Display_off_lus:        
        dec    Zero
	brne   display_off_lus
        dec    var1
	brne   display_off_lus
	dec    var2
	brne   display_off_lus

	ret


Setcode:                        ;var1 is the number to Display
        cpi     var1,0
        brne    set_n1
        ldi     var1,192        ;7seg 
        ret
set_n1: cpi     var1,1
        brne    set_n2
        ldi     var1,249        ;7seg 
        ret
set_n2: cpi     var1,2
        brne    set_n3
        ldi     var1,164        ;7seg 
        ret
set_n3: cpi     var1,3
        brne    set_n4
        ldi     var1,176        ;7seg 
        ret
set_n4: cpi     var1,4
        brne    set_n5
        ldi     var1,153        ;7seg 
        ret
set_n5: cpi     var1,5
        brne    set_n6
        ldi     var1,146        ;7seg 
        ret
set_n6: cpi     var1,6
        brne    set_n7
        ldi     var1,130        ;7seg 
        ret
set_n7: cpi     var1,7
        brne    set_n8
        ldi     var1,248        ;7seg 
        ret
set_n8: cpi     var1,8
        brne    set_n9
        ldi     var1,128        ;7seg 
        ret
set_n9: cpi     var1,9
        brne    Setcode_end
        ldi     var1,144        ;7seg 
        ret
Setcode_end:
        ldi     var1,0b00000110 ;7seg error E
        ret


;---------------------- routines for eeprom -- ---------------------------

Eeprom_rd:                      ;basevar is address, value in var1
        out     EEAR,basevar
        inc     basevar         ;inc for next read
        sbi     EECR,0
        in      var1,EEDR       ;Value of eeprom in var1
        ret

Eeprom_wrt:                     ;basevar is address, value in var1
        out     EEAR,basevar    
        inc     basevar         ;inc for next read
        out     EEDR,var1       ;Value of var1 in eeprom
        sbi     EECR,1
Eeprom_wrtwait:
        sbic    EECR,1 
        rjmp    Eeprom_wrtwait  ;Wait till write finished (app. 4 ms)
        ret

;-------------------- eeprom memory default values ----------------------
.eseg

.org 0
;default values

        .db 0xff        ;Range 0 not filled in
        .db 0xff
        .db 0xff

        .db 0xff        ;Range 0 not filled in
        .db 0xff
        .db 0xff

        .db 0x00        ;1810
        .db 0xdc
        .db 0xf2

        .db 0x00        ;1880
        .db 0xe5
        .db 0x7e

        .db 0x01        ;3500
        .db 0xab
        .db 0x3f

        .db 0x01        ;3800
        .db 0xcf
        .db 0xde

        .db 0x03        ;7000
        .db 0x56
        .db 0x7e

        .db 0x03        ;7100
        .db 0x62
        .db 0xb3

        .db 0x04        ;10100
        .db 0xd0
        .db 0xe9

        .db 0x04        ;10150
        .db 0xd7
        .db 0x03

        .db 0x06        ;14000
        .db 0xac
        .db 0xfc

        .db 0x06        ;14350
        .db 0xd7
        .db 0xb5

        .db 0x08        ;18068
        .db 0x9d
        .db 0x91

        .db 0x08        ;18168
        .db 0xa9
        .db 0xc6

        .db 0x0a        ;21000
        .db 0x03
        .db 0x7a

        .db 0x0a        ;21450
        .db 0x3a
        .db 0x68

        .db 0x0b        ;24890
        .db 0xde
        .db 0x54

        .db 0x0b        ;24990
        .db 0xea
        .db 0x89

        .db 0x0d        ;28000
        .db 0x59
        .db 0xf8

        .db 0x0e        ;29700
        .db 0x29
        .db 0x7d
