; FREQRX02.ASM
; Start October 21, 2002
; Version 1.0 of October 26, 2002
; frequency counter for 02RX
; x-tal frequency 10 MHz
; gate-time=0.5 second


; B0: Free, reserved for A/D Capacitor in
; B1: Free, reserved for A/D IN
; B2: TX TUNING ACTIVE IN
; B3: F-7seg led display
; B4: G-7seg led display
; B5: Free
; B6: 100Hz display if grounded
; B7: 100kHz display if grounded

; D0: A-7seg led display
; D1: B-7seg led display
; D2: C-7seg led display
; D3: D-7seg led display
; D5: E-7seg led display
; D6: Free, reserved for Capacitor A/D converter charge/discharge 



.device at90s1200
.nolist
.include "1200def.inc"
.list

; main program register variables


.def    sum0 =r2
.def    sum1 =r3
.def    sum2 =r4

.def    Zero =r5
.def    One  =r6

.def    cnt0 =r7
.def    cnt1 =r8
.def    cnt2 =r9

.def    oldsum  =r11
.def    var1    =r16
.def    var2    =r17
.def    var3    =r18
.def    flag1   =r19    ;b0=1: Frequency out of band
                        ;b1=1: TX tuning active during frequency count
                        ;b2=1: TX tuning inactive during frequency count
                        ;b3=1: Free
                        ;b4=1: Program enable mode
                        ;b5=1: Program mode
.def    bcd0 =r20
.def    bcd1 =r21
.def    bcd2 =r22
.def    bcd3 =r23
.def    bcd4 =r24
.def    bcd5 =r25
.def    bcd6 =r26
.def    bcd7 =r27

.def    basevar  =r28
.def    bcd_cnt  =r31


; code
	rjmp  RESET ;

RESET:  ldi     var2,0b00011000 ;Set B4 B3 as output, rest input
        out     DDRB,var2
        ldi     var2,0b11111000 ;Set outputs and pull up resistors inputs
        out     PORTB,var2      ;
        ldi     var2,0b01101111 ;Set D4 as input, rest as output
        out     DDRD,var2
        ldi     var2,0b00101111 ;Set outputs and pull up resistors inputs
        out     PORTD,var2
; Comparator already default initialized
        ldi     var2,1          ;Set variable One to 1
        mov     One,var2
        clr     Zero            ;Set variable Zero to 0
        clr     flag1           ;Clear flags


Hello:
        ldi     var1,0b01111111 ;Blank
        rcall   Display
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b00001000 ;Letter A
        rcall   Display
        ldi     var1,0b00100100 ;Number 2
        rcall   Display
        ldi     var1,0b01000000 ;Letter O
        rcall   Display
        ldi     var1,0b00001001 ;Letter H
        rcall   Display
        ldi     var1,0b00001001 ;Letter H
        rcall   Display
        ldi     var1,0b01111111 ;Blank
        rcall   Display


Test_prgenable:                 ;Test for program enable mode 
        rcall   Prg_status      ;Test for Prg_status
        andi    flag1,0b11011111;Clear b5 program mode but not b4 enable bit
Test_prgenable_end:


Mainloop:
        sbrs    flag1,0         ;Skip if out of band frequency
        rjmp    Mainloop_meas   ;If in band then rjmp Mainloop_meas
;Deleted for RX        cbi     PORTB,4         ;Set led G on for out of band
        sbrs    flag1,1         ;TX tuning active during frequency measurement
        rjmp    Mainloop_meas   ;If RX then only led G on
        cbi     PORTD,0         ;Set led A on for out of band during TX tuning
        cbi     PORTD,3         ;Set led D on for out of band during TX tuning
        cbi     PORTB,4         ;Set led G on for out of band

Mainloop_meas:
        rcall   Freqmeas        ;Do a frequency measurement

        sbi     PORTB,4         ;Set led G off
        sbi     PORTD,0         ;Set led A off
        sbi     PORTD,3         ;Set led D off

        sbrc    flag1,4         ;Skip if no program enable mode
        rcall   Prg_status      ;Test for Prg_status
        sbrc    flag1,5         ;Skip if no program enable mode
        rcall   Prg_mode        ;Program IF correction (0 Hz tuning)

        sbrs    flag1,1         ;Skip RX frequency if TX tuning active during frequency measurement
        rjmp    RX_frequency    ;RX_frequency and jump to Mainloop

        sbrs    flag1,2         ;Skip TX frequency if TX tuning inactive during frequency measurement
        rjmp    TX_frequency    ;TX_frequency and jump to Mainloop

        rjmp     Mainloop       ;If RX_frequency and TX_frequency skipped
;------------------------------------------------------------


Prg_status:                     ;Test for program status switches/key down
        andi    flag1,0b11011111;Clear b5 program mode but not b4 enable bit
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000100 ;Enable if B7, B6 high and B2 low
        cpi     var1,0b11000000 ;kHz/MHz floating, TX tuning inactive
        breq    Prg_status1     ;If so, then next test

        ret

Prg_status1:                    ;Next test: switch in MHz position
        cbi     PORTD,0         ;Set led A on
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        sbi     PORTD,0         ;Set led A off
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000100 ;Enable if B7, B6 high and B2 low
        cpi     var1,0b01000000 ;MHz grounded, TX tuning inactive
        breq    Prg_status2     ;If so, then next test

        ret

Prg_status2:                    ;Next test: switch in kHz position
        cbi     PORTD,3         ;Set led D on
        rcall   freqmeas        ;Delay 0.5 sec
        rcall   freqmeas        ;Delay 0.5 sec
        sbi     PORTD,3         ;Set led D off
        in      var1,PINB       ;PINB in var1 for Program_enable test
        andi    var1,0b11000100 ;Enable if B7, B6 high and B2 low
        cpi     var1,0b10000000 ;kHz grounded, key down
        breq    Prg_status3     ;If so, then next test

        ret

Prg_status3:
        ori     flag1,0b00110000;Set program status and program enable flag
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b00001100 ;Letter P
        rcall   Display
        ldi     var1,0b01111111 ;All off 
        rcall   Display

        ret


Prg_mode:                       ;Program IF offset (0 Hz tuning)
        andi    flag1,0b11011111;Clear b5 program mode but not b4 enable bit
        sbrc    flag1,1         ;Skip if TX tuning inactive during frequency measurement
        ret                     ;else return (if TX tuning active during frequency measurement)
Prg_mode_now:
        ldi     basevar,0       ;Write IF offset in EEprom address 0, 1, 2

        mov     var1,sum0       ;Lsb sum0 first! 
        rcall   eeprom_wrt      ;Write to eeprom
        mov     var1,sum1       ;Xsb sum1
        rcall   eeprom_wrt      ;Write to eeprom
        mov     var1,sum2       ;Msb sum2 last!
        rcall   eeprom_wrt      ;Write to eeprom
        
        ldi     var1,0b00010010 ;Letter S Save
        rcall   Display
        ldi     var1,0b00000110 ;Letter E EEprom
        rcall   Display
        ldi     var1,0b00000110 ;Letter E
        rcall   Display
        ldi     var1,0b01111111 ;Blank
        rcall   Display

Prg_mode_end:
        ret


Freqmeas:                       ;Frequency measurement routine      
; 10 MHz xtal 0.5 sec. period :  11 + (W-1) * 17 = 5e6 (.5*10e6)
; W = 294118: 04 7c e6
        ldi     var1,0xe6
        mov     cnt0,var1
        ldi     var1,0x7c
        mov     cnt1,var1
        ldi     var1,0x04
        mov     cnt2,var1

        ldi     var1,7          ;External pin T0 (D4) rising edge
        out     TCCR0,var1      ;Counter start, T0 raising edge

Freqstart:
        clr     sum0            ;Clear frequency count variables
        clr     sum1
        clr     sum2

        out     TCNT0,Zero      ;Reset counter, start of measurement
        andi    flag1,0b11111001;Reset TX tuning active/inactive flags

Freqmeas_loop1:
        sbic    PINB,2          ;Check for TX tuning active flag (skip if inactive)
        ori     flag1,0b00000010;Set TX tuning active flag
        sbis    PINB,2          ;Check for TX tuning inactive (skip if active)
        ori     flag1,0b00000100;Set TX tuning inactive flag
        sub     cnt0,One        ;Decrement measurement time
        sbc     cnt1,Zero 
        sbc     cnt2,Zero 
        brcs    Freqmeas_ready  ;The end
        mov     oldsum,sum0     ;Last timer read in oldsum for check overflow
        in      sum0,TCNT0      ;Read timer
        cp      sum0,oldsum
        brlo    Freqmeas_carry  ;If timer register overflow 255-0
        nop
        nop                     ;Time loop correction 3x nop
        nop
        rjmp    Freqmeas_loop1
Freqmeas_carry:        
        add     sum1,One        ;Increase sum1 for timer overflow sum0
        adc     sum2,Zero       ;Add carry to sum2 if sum1 overflow
        rjmp    Freqmeas_loop1
Freqmeas_ready:
        ret


RX_frequency:

        ldi     basevar,0       ;Read IF offset in EEprom address 0, 1, 2
        rcall   eeprom_rd       ;Read lsb
        sub     sum0,var1       ;Substract lsb IF offset
        sbc     sum1,Zero       ;Substract carry from xsb
        sbc     sum2,Zero       ;Substract carry from msb
        rcall   eeprom_rd       ;Read xsb
        sub     sum1,var1       ;Substract xsb IF offset
        sbc     sum2,Zero       ;Substract carry from msb
        rcall   eeprom_rd       ;Read xsb
        sub     sum2,var1       ;Substract msb IF offset
        brcc    RX_freq_ok      ;If no carry then ready, else VFO below IF

        com     sum0            ;One's complement for VFO lower than IF
        com     sum1            ;One's complement
        com     sum2            ;One's complement
        add     sum0,One        ;Two's complement
        adc     sum1,Zero       ;Add carry
        adc     sum2,Zero       ;Add carry

RX_freq_ok:

        rcall   In_band         ;Check if in band frequency (b0 of flag1 set and cleared)
        rcall   BCD_RXconvert   ;Do a BCD conversion
        rjmp   Freq_display    ;And display the frequency
        ; (end RX_frequency)

TX_frequency:
        rcall   In_band         ;Check if in band frequency (b0 of flag1 set and cleared)

        rcall   BCD_TXconvert   ;Do a BCD conversion
        rjmp    Freq_display    ;And display the frequency
        ; (end TX_frequency)


BCD_RXconvert:                  ;Convert binary to decimal, frequency plus multiply by 32
        ldi     bcd_cnt,29      ;24 bits + /16 (+4) +0.5 to 1 sec (+1)
        rjmp    BCD_start       ; 
                                
BCD_TXconvert:                  ;Convert binary to decimal, frequency plus multiply by 32
        ldi     bcd_cnt,29      ;24 bits + /16 (+4) +0.5 to 1 sec (+1)

BCD_start:                      ;Start bcd conversion
        ldi     ZL,20           ;bcd0 = r20
BCD_clear:                      ;Clear all BCD variables
        st      Z,Zero
        inc     ZL
        cpi     ZL,28           ;bcd7+1 (bcd7=r27)
        brne    BCD_clear

BCD_loop:
        clc
        rol     sum0
        rol     sum1
        rol     sum2
        ldi     ZL,20           ;bcd0, start with lowest decimal value 
BCD_nr:                         ;now double bcd 3 digits       
        ld      var1,Z
        adc     var1,var1
        cpi     ZL,28           ;bcd7+1
        breq    BCD_next
        cpi     var1,10
        brcs    BCD_no_cor
        subi    var1,10
        sec
        rjmp    BCD_go
BCD_no_cor:
        clc
BCD_go: st      Z,var1
        inc     ZL              ;next bcd variable
        rjmp    BCD_nr
BCD_next:         
        dec     bcd_cnt
        brne    BCD_loop

        ret


Freq_display:

Out_MHz: 
        sbic    PINB,7          ;Display only if B7 grounded
        rjmp    Out_kHz
        mov     var1,bcd7
        cpse    var1,Zero       ;Do not display if bcd7=0
        rcall   Display_set
        mov     var1,bcd6
        rcall   Display_set
        mov     var1,bcd5
        rcall   Display_set
Out_kHz:
        sbic    PINB,6          ;Display only if B6 grounded
        rjmp    Mainloop
        mov     var1,bcd4
        rcall   Display_set
        mov     var1,bcd3
        rcall   Display_set
        mov     var1,bcd2
        rcall   Display_set

        rjmp    Mainloop

In_band:                        ;Check for in band frequency
        ldi     var3,6          ;Band range counter, first eeprom address=6
        ori     flag1,0b00000001;Set out of band flag, cleared if in band
In_band_loop:
        mov     basevar,var3    ;Set eeprom address of band
        rcall   Eeprom_rd
        cp      sum2,var1       ;Compare Msb with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
        breq    In_band_loop1   ;If equal, test the lsb's
        rjmp    In_band_loop3   ;Now higher, goto test for band end
In_band_loop1:                  ;Test the lsb1 as Msb's equal
        rcall   Eeprom_rd
        cp      sum1,var1       ;Compare lsb1 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
        breq    In_band_loop2   ;If equal, test the lsb's
        rjmp    In_band_loop3   ;Goto test for band end
In_band_loop2:                  ;Test the lsb2 as lsb1 equal
        rcall   Eeprom_rd
        cp      sum0,var1       ;Compare lsb2 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band

In_band_loop3:                  ;Start test of end of frequency band
        mov     basevar,var3    ;Set eeprom address of band
        inc     basevar         ;address+1
        inc     basevar         ;address+2
        inc     basevar         ;address+3 is address end of frequency band
        rcall   Eeprom_rd
        cp      var1,sum2       ;Compare Msb with end of frequency band
        brlo    In_band_next    ;If higher then try next band
        breq    In_band_loop4   ;If equal, test the lsb's
        rjmp    In_band_in      ;Now lower, In Band!
In_band_loop4:                  ;Test the lsb1 as Msb's equal
        rcall   Eeprom_rd
        cp      var1,sum1       ;Compare lsb1 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
        breq    In_band_loop5   ;If equal, test the lsb's
        rjmp    In_band_in      ;Goto test for band end
In_band_loop5:                  ;Test the lsb2 as lsb1 equal
        rcall   Eeprom_rd
        cp      var1,sum0       ;Compare lsb2 with begin of frequency band
        brlo    In_band_next    ;If lower then try next band
In_band_in:
        andi    flag1,0b11111110;Clear out of band flag

        ret

In_band_next:
        subi    var3,-6         ;Add 6 for next frequency band in eeprom
        cpi     var3,55         ;Test for last range
        brlo    In_band_loop    ;Loop if not ready

        ret


;------------ DISPLAY SUBROUTINES ----------------
Display_set:                    ;Display and make 7 segment code        
        rcall   Setcode         ;Convert var1 to 7 segment code
Display:                        ;var1 b0 - b6 is Display a - g segment
        sbrs    var1,0          ;Skip if bit in var1 set
        cbi     PORTD,0         ;else switch Display segment on
        sbrs    var1,1          ;Skip if bit in var1 set
        cbi     PORTD,1         ;else switch Display segment on
        sbrs    var1,2          ;Skip if bit in var1 set
        cbi     PORTD,2         ;else switch Display segment on
        sbrs    var1,3          ;Skip if bit in var1 set
        cbi     PORTD,3         ;else switch Display segment on
        sbrs    var1,4          ;Skip if bit in var1 set
        cbi     PORTD,5         ;else switch Display segment on
        sbrs    var1,5          ;Skip if bit in var1 set
        cbi     PORTB,3         ;else switch Display segment on
        sbrs    var1,6          ;Skip if bit in var1 set
        cbi     PORTB,4         ;else switch Display segment on

        clr     var1
        ldi     var2,13         ;13*.3e-6*65536=0.255 sec

Display_on_lus:
        dec     Zero
        brne    Display_on_lus
        dec     var1
        brne    Display_on_lus
        dec     var2
        brne    Display_on_lus   

        in      var1,PORTD      ;PORTD in var1 for Display off
        ori     var1,0b00101111 ;D5 D3 D2 D1 D0 = 1 for Display off
        out     PORTD,var1      ;Set PORTD for Display off

        in      var1,PORTB      ;PORTB in var1 for Display off
        ori     var1,0b00011000 ;B4 B3 = 1 for Display off
        out     PORTB,var1      ;Set PORTB for Display off

        out     PORTB,var1      ;7 segment display off

        clr     var1
        ldi     var2,4          ;4*.3e-6*65536=0.078 sec
Display_off_lus:        
        dec    Zero
        brne   display_off_lus
        dec    var1
        brne   display_off_lus
        dec    var2
        brne   display_off_lus

        ret


Setcode:                        ;var1 is the number to Display
        cpi     var1,0
        brne    set_n1
        ldi     var1,192        ;7seg 
        ret
set_n1: cpi     var1,1
        brne    set_n2
        ldi     var1,249        ;7seg 
        ret
set_n2: cpi     var1,2
        brne    set_n3
        ldi     var1,164        ;7seg 
        ret
set_n3: cpi     var1,3
        brne    set_n4
        ldi     var1,176        ;7seg 
        ret
set_n4: cpi     var1,4
        brne    set_n5
        ldi     var1,153        ;7seg 
        ret
set_n5: cpi     var1,5
        brne    set_n6
        ldi     var1,146        ;7seg 
        ret
set_n6: cpi     var1,6
        brne    set_n7
        ldi     var1,130        ;7seg 
        ret
set_n7: cpi     var1,7
        brne    set_n8
        ldi     var1,248        ;7seg 
        ret
set_n8: cpi     var1,8
        brne    set_n9
        ldi     var1,128        ;7seg 
        ret
set_n9: cpi     var1,9
        brne    Setcode_end
        ldi     var1,144        ;7seg 
        ret
Setcode_end:
        ldi     var1,0b00000110 ;7seg error E
        ret


;---------------------- routines for eeprom -- ---------------------------

Eeprom_rd:                      ;basevar is address, value in var1
        out     EEAR,basevar
        inc     basevar         ;inc for next read
        sbi     EECR,0
        in      var1,EEDR       ;Value of eeprom in var1
        ret

Eeprom_wrt:                     ;basevar is address, value in var1
        out     EEAR,basevar    
        inc     basevar         ;inc for next read
        out     EEDR,var1       ;Value of var1 in eeprom
        sbi     EECR,1
Eeprom_wrtwait:
        sbic    EECR,1 
        rjmp    Eeprom_wrtwait  ;Wait till write finished (app. 4 ms)
        ret

;-------------------- eeprom memory default values ----------------------
.eseg

.org 0
;default values

        .db 0x88        ;36 MHz offset, LSB first!
        .db 0x2a
        .db 0x11

        .db 0xff        ;Free
        .db 0xff        ;Free
        .db 0xff        ;Free 

; Start of fixed programmed amateur bands (freq /32, MSB first!)

        .db 0x00        ;1810 (1810 /32, MSB first!)
        .db 0xdc
        .db 0xf2

        .db 0x00        ;1880
        .db 0xe5
        .db 0x7e

        .db 0x01        ;3500
        .db 0xab
        .db 0x3f

        .db 0x01        ;3800
        .db 0xcf
        .db 0xde

        .db 0x03        ;7000
        .db 0x56
        .db 0x7e

        .db 0x03        ;7100
        .db 0x62
        .db 0xb3

        .db 0x04        ;10100
        .db 0xd0
        .db 0xe9

        .db 0x04        ;10150
        .db 0xd7
        .db 0x03

        .db 0x06        ;14000
        .db 0xac
        .db 0xfc

        .db 0x06        ;14350
        .db 0xd7
        .db 0xb5

        .db 0x08        ;18068
        .db 0x9d
        .db 0x91

        .db 0x08        ;18168
        .db 0xa9
        .db 0xc6

        .db 0x0a        ;21000
        .db 0x03
        .db 0x7a

        .db 0x0a        ;21450
        .db 0x3a
        .db 0x68

        .db 0x0b        ;24890
        .db 0xde
        .db 0x54

        .db 0x0b        ;24990
        .db 0xea
        .db 0x89

        .db 0x0d        ;28000
        .db 0x59
        .db 0xf8

        .db 0x0e        ;29700
        .db 0x29
        .db 0x7d
