/*FREQPC.C*/
/* 09-07-1995 frequentie counter */
/* 15-05-1999 aangepast automatisch LPT1 zoeken; offset; keyvalue in meten */
/* 17-05-1999 keuze default gewijzigd */
/* 10-05-2001 English version */
/* 03-01-2004 Comment added */

#include <conio.h>
#include <graph.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\types.h>
#include <sys\timeb.h>

float frcorrectie, gatetijd;
float offsetfreq=0;
double reffreq;
int keyvalue;
int schermkleur=1;
int tekstkleur=7;
float gatetijdarray[]={0.1, 0.2, 0.5, 1, 2, 5, 10, 20};
int gatesel=3;                  /* 1 sec */
char freq[3][20];
int freqrange=2;
char key[100];
unsigned char Pbuf[100];
int LPT;
int LPT1;

void menu_A(void);
void uitleg(void);
void frequentiebereik(void);
void meettijd(void);
void freq_offset();
int meten(void);
float freqmeet(unsigned int);
void frcorr(void);

void Tekstkleur(void);
void Ptekstkleur(void);
void Schermkleur(void);
void Pschermkleur(void);
void Schermuit(void);

void inkey();
void Scherm(int);
void pauze(float);
void window(int, int, int, int);
int keuzebepalen(int,int,int,int);
void In_ntext(int,int,int,char*);




/****************************************************************************
 *
 * void main (int aantal, char *argum[] MAIN ROUTINE
 *
 ****************************************************************************/

void main(int aantal, char *argum[])
{
char *ptr=argum[1];
unsigned int p;


LPT = *(int _far*)0x408;
LPT1 = LPT + 1;

Scherm(25);
sprintf(Pbuf,"LPT1 adress: %xH",LPT);
_settextposition (10,10);
_outtext(Pbuf);

outp (LPT,0xff);    /* printerport LPT1 TO 0xff for optional power from LPT1 */

reffreq = 0;

if (aantal == 2)
  reffreq = atof(ptr);       /* Get the reference frequency from DOS */
  reffreq = reffreq / 1024;  /* Correction for prescaler division 1024 */

 if (reffreq == 0)           /* If not given, print message for explanation */
  {
   _clearscreen (_GCLEARSCREEN);
   printf ("syntax: PROGRAM NAME reference frequency(Hz)\n\n");
   exit(1);
  }

menu_A();

schermkleur = 0;             /* Default Screen color */
tekstkleur = 7;              /* Default Text color */
Scherm(25);                  /* Set screen resolution and colors */
}




/****************************************************************************
 *
 * void menu_A menu A routine MENUE ROUTINE
 *
 ****************************************************************************/

void menu_A(void)
{
static int keuze;
int n,x;
int windowok=0;

Scherm(25);

strcpy(&freq[0][0],"   20 Hz - 20 kHz ");
strcpy(&freq[1][0],"   2 kHz - 1  MHz ");
strcpy(&freq[2][0]," 100 kHz - 80 MHz ");

keuze = 0;
do
{
if (windowok == 0)
  {
   window (1,1,5,80);
   _settextposition(3,25);
   _outtext("       FREQUENCY COUNTER       ");
   window(13,28,24,50);
   _settextposition (14,30);
   _outtext(" Frequency range");
   _settextposition (15,30);
   _outtext(" Gate time");
   _settextposition (16,30);
   _outtext(" Measure");
   _settextposition (17,30);
   _outtext(" Offset");
   _settextposition (19,30);
   _outtext(" Textcolor");
   _settextposition (20,30);
   _outtext(" Screencolor");
   _settextposition (21,30);
   _outtext(" Explanation");
   _settextposition (23,30);
   _outtext(" End");
   window (6,1,8,22);
   _settextposition(7,3);
   _outtext(&freq[freqrange][0]);
   window (6,65,8,80);
   sprintf(Pbuf,"  %.1f sec. ", gatetijdarray[gatesel]);
   _settextposition(7,67);
   _outtext(Pbuf);

   windowok = 1;
  }
_displaycursor(_GCURSOROFF);


keuze = keuzebepalen(13,10,30,keuze);

if (keuze & 512)
  {
   windowok = 0;

   if (keuze == 513)
     frequentiebereik();
   if (keuze == 514)
     meettijd();
   if (keuze == 515)
     meten();
   if (keuze == 516)
     freq_offset();
   if (keuze == 518)
     Tekstkleur();
   if (keuze == 519)
     Schermkleur();
   if (keuze == 520)
     uitleg();
  }
}
while (keuze != 522);
}



/****************************************************************************
 *
 * void uitleg(void) EXPLANATION
 *
 ****************************************************************************/
void uitleg(void)
{
int keuze;

Scherm(25);

_displaycursor(_GCURSOROFF);

window(1,1,10,80);
_settextposition(2,3);
_outtext("EXPLANATION FOR THE USER");
_settextposition(3,3);
_outtext("========================");
_settextposition(5,3);
_outtext("CONTROL AND SELECTION IS WITH THE CURSOR KEYS (EXCEPT OFFSET).");
_settextposition(6,3);
_outtext("SELECT / CHANGE WITH CURSOR UP / DOWN.");
_settextposition(7,3);
_outtext("ACTIVATE CHOICE WITH THE RIGHT CURSOR KEY.");
_settextposition(8,3);
_outtext("RETURN BY PRESSING THE LEFT CURSOR KEY.");

window(11,1,24,80);
_settextposition(12,3);
_outtext("TECHNICAL INFORMATION.");
_settextposition(13,3);
_outtext("======================");
_settextposition(15,3);
_outtext("CONNECT THE COUNTER TO LPT1 VIA A PRINTERCABLE.");
_settextposition(16,3);
_outtext("DEPENDENT ON THE FREQUENCY RANGE, THE FREQUENCY IS MEASURED");
_settextposition(17,3);
_outtext("VIA ONE OF THE CONNECTIONS OF THE DIVIDER.");
_settextposition(18,3);
_outtext("THE REFERENCE FREQUENCY IS MEASURED TO DETERMINE THE DEVIATION OF THE ");
_settextposition(19,3);
_outtext("INTERNAL CLOCKOSCILLATOR OF THE PC.");
_settextposition(20,3);
_outtext("THEN THE FREQUENCY OF THE SIGNAL IS MEASURED AND CORRECTED FOR THE.");
_settextposition(21,3);
_outtext("INACCURACU OF THE INTERNAL CLOCKOSCILLATOR.");

do
 {
  inkey();
 }
while (keyvalue != 203);

Scherm(25);
}




/****************************************************************************
 *
 * void freq_offset(void) INPUT OF FREQUENCY OFFSET
 *
 ****************************************************************************/

void freq_offset(void)
{
Scherm(25);

window (1,1,5,80);
_settextposition(3,25);
_outtext("       FREQUENCY OFFSET       ");

sprintf(Pbuf,"Frequency offset (Hz): %.0f ",offsetfreq);
_settextposition(10,3);
_outtext(Pbuf);

_settextposition(10,43);
_outtext("New offset (Hz):  ");

In_ntext(10,60,10,Pbuf);

if (Pbuf[0] != 0 && Pbuf[0] != 27)
  offsetfreq = (float)atof(Pbuf);

Scherm(25);
}



/****************************************************************************
 *
 * void frequentiebereik(void) SELECTION OF FREQUENCY RANGE
 *
 ****************************************************************************/

void frequentiebereik(void)
{
_settextposition(7,2);
Pbuf[0] = 18;
Pbuf[1] = 0;
_outtext(Pbuf);

do
{
_displaycursor(_GCURSOROFF);

inkey();

if (keyvalue == 200)    /* Cursor key (up) */
  {
   freqrange++;
   if (freqrange > 2)
     freqrange = 2;
   _settextposition(7,3);
   _outtext(&freq[freqrange][0]);
  }

if (keyvalue == 208)   /* Cursor key (down) */
  {
   freqrange--;
   if (freqrange < 0)
     freqrange = 0;
   _settextposition(7,3);
   _outtext(&freq[freqrange][0]);
  }
}
while (keyvalue != 203 && keyvalue != 27); /* Cursor key (left) or Esc */

_settextposition(7,2);
_outtext(" ");

Scherm(25);

}


/****************************************************************************
 *
 * void meettijd(void) SELECTION OF GATE TIME (MEASURING TIME)
 *
 ****************************************************************************/

void meettijd(void)
{
   _settextposition(7,3);
   _outtext(&freq[freqrange][0]);
   window (6,65,8,80);
   sprintf(Pbuf,"  %.1f sec. ", gatetijdarray[gatesel]);
   _settextposition(7,67);
   _outtext(Pbuf);

_settextposition(7,66);
Pbuf[0] = 18;
Pbuf[1] = 0;
_outtext(Pbuf);

do
{
_displaycursor(_GCURSOROFF);

inkey();

if (keyvalue == 200)      /* Cursor key (up) */
  {
   gatesel++;
   if (gatesel > 7)
     gatesel = 7;
   sprintf(Pbuf,"  %.1f sec. ", gatetijdarray[gatesel]);
   _settextposition(7,67);
   _outtext(Pbuf);
  }

if (keyvalue == 208)      /* Cursor key (down) */
  {
   gatesel--;
   if (gatesel < 0)
     gatesel = 0;
   sprintf(Pbuf,"  %.1f sec. ", gatetijdarray[gatesel]);
   _settextposition(7,67);
   _outtext(Pbuf);
  }
}
while (keyvalue != 203 && keyvalue != 27);   /* Cursor key (left) or Esc */

_settextposition(7,66);
_outtext(" ");

Scherm(25);

}



/****************************************************************************
 *
 * int meten(void) FREQUENCY MEASUREMENT ROUTINE
 *
 ****************************************************************************/
int meten(void)
{
float f;
unsigned int lohi;

gatetijd = gatetijdarray[gatesel];

do
  {
   _settextposition(3,25);
   _outtext(" _ ");


   frcorr();  /* Measurement of the frequency inaccuracy of the PC clock */

   do
     {
      inkey();
     }
   while (keyvalue != 0 && keyvalue != 203 && keyvalue != 27);

   if (keyvalue != 203 && keyvalue != 27)  /* Cursor key (left) or Esc */
     {
      _settextposition(3,25);
      _outtext(" * ");

       f = freqmeet(freqrange);  /* Measurement of the frequency */
       f = f + offsetfreq;       /* Correction for offset (i.e. IF freq.) */
       if (f < 0)
	 f = -1 * f;             /* If negative, make positive */

       _settextposition(3,28);
       if (f < 1e4)
	 sprintf(Pbuf,"Frequency: %.3f Hz              ",f); /* If < 10 kHz */

       if (f < 1e5 && f >= 1e4)
	 sprintf(Pbuf,"Frequency: %.2f Hz              ",f); /* If < 100 kHz */

       if (f < 1e6 && f >= 1e5)
	 sprintf(Pbuf,"Frequency: %.1f Hz              ",f); /* If < 1 MHz */

       if (f >= 1e6)
	 {
	  f = f / 1e6;
	  sprintf(Pbuf,"Frequency: %.6f MHz             ",f);/* If > 1 MHz */
	 }
      _outtext(Pbuf);

      do
	{
	 inkey();
	}
      while (keyvalue != 0 && keyvalue != 203 && keyvalue != 27);
     }
  }
while (keyvalue != 203 && keyvalue != 27);  /* Cursor key (left) or Esc */

_settextposition(3,25);
_outtext("  ");

}



/****************************************************************************
 *
 * float freqmeet(unsigned int h) ASSEMBLY PART OF MEASUREMENT ROUTINE
 *
 ****************************************************************************/
float freqmeet(unsigned int h)
{
 static unsigned int t1;       /* Measured time LSB's */
 static unsigned int t2;       /* Measured time MSB's */
 static unsigned int t3;       /* Related to the gate (measuring) time */
 static unsigned int p1;       /* Overflows of the BX register period counter */
 static unsigned int k;        /* Frequency range */
 static unsigned int perioden;

 unsigned long tper;

 float f, x;

 x = gatetijd / 5.49e-2;  /* Timer overflow time is 5.49e-2 sec */
 t3 = 0xffff - x;         /* Set t3 to have the correct gate (measuring) time */
 p1 = 0;                  /* Number of measured periods of the input signal */

 if (h == 0)       /* Frequency range 1 (lowest) to pin D3 (2^3 = 8) */
    k = 8;
 if (h == 1)       /* Frequency range 2 (middle) to pin D4 (2^4 = 16) */
    k = 16;
 if (h == 2)       /* Frequency range 3 (highest) to pin D5 (2^5 = 32)*/
    k = 32;
 if (h == 3)       /* Reference Frequency to pin D6 (2^6 = 64) */
    k = 64;

 _asm
      {
      cli                /* Disable interrupts */

      mov  ax,k          /* Set Frequency range in CX register via AX reg. */
      mov  cx,ax         /* CL of CX contains the related input bit of LPT1 */
      xor  bx,bx         /* Clear the BX register (period counter overflow) */

      mov  ax,0xffff
      mov  t1,ax         /* Initialize t1 to 0xffff (count down timer) */
      mov  t2,ax         /* Initialize t2 to 0xffff (count down timer) */

      in   al,0x61       /* Port 0x61 controls PCtimer2 and Loudspeaker */
      and  al,0xfc       /* Stop counter (bit0) and loudspeaker (bit1) */
      out  0x61,al       /* by clearing b0 and b1 (other bits unchanged) */

      mov  al,0xb4       /* Initialize PCtimer2 as continuous counter */
      out  0x43,al
      mov  al,0xff       /* Set the start value to 0xffff */
      out  0x42,al
      out  0x42,al

      in   al,0x61       /* Port 0x61 controls PCtimer2 and Loudspeaker */
      or   al,0x1        /* Start counter (bit0) */
      out  0x61,al       /* by making b0 = "1"  */

      mov  dx,LPT1       /* Set the LPT1 port address into register DX */

	   /* First we check if there is an input signal,
	    * as there is no time out during the measurement
	    * routine to obtain maximum accuracy. The measurement
	    * routine will go into a continuous loop if there is
	    * no input signal.
	    */

     freqtest1:          /* Start of the check for an input signal */
      call freqmeetlatch /* Update t1, t2 and t3 for the time measurement */
      mov  ax,t3         /* If longer than gate (measuring) time, t3 = 0 */
      cmp  ax,0          /* If t3 = 0 and no change of input has ocdurred */
      jz   timeout       /* then no input signal and goto timeout routine */
      in   al,dx         /* Set LPT1 input values to AL of AX register */
      and  al,cl         /* AND with CL reg.(input bit of LPT1 of freq. range */
      jz   freqtest1     /* If input signal zero then loop to freqtest 1 */

     freqtest2:          /* Same routine as freqtest1 but now for */
      call freqmeetlatch /* when the input signal is one */
      mov  ax,t3
      cmp  ax,0
      jz   timeout
      in   al,dx
      and  al,cl
      jnz  freqtest2

	   /* If there is an input signal, we are here in the routine
	    * If not, the routine above is left via the jz timeout instrution
	    */

      in   al,0x61       /* Port 0x61 controls PCtimer2 and Loudspeaker */
      and  al,0xfc       /* Stop counter (bit0) and loudspeaker (bit1) */
      out  0x61,al       /* by clearing b0 and b1 (other bits unchanged) */

      mov  al,0xb4       /* Initialize PCtimer2 as continuous counter */
      out  0x43,al
      mov  al,0xff       /* Set the start value to 0xffff */
      out  0x42,al
      out  0x42,al

      in   al,0x61       /* Push the startvalue of Port 0x61 onto the stack for */
      or   al,0x1        /* a fast START PCtimer2 instruction later */
      push ax            /* via the AX register (Port 0x61 b0 = 1, others unchanged) */
      mov  ax,0xffff
      mov  t1,ax         /* Initialize t1 to 0xffff (count down timer) */
      mov  t2,ax         /* Initialize t2 to 0xffff (count down timer) */
      jmp  freqstart1    /* and goto the start of the frequency measurement */

     timeout:            /* The time out routine if there is no input signal */
      in   al,0x61       /* Port 0x61 controls PCtimer2 and Loudspeaker */
      and  al,0xfc       /* Stop counter (bit0) and loudspeaker (bit1) */
      out  0x61,al       /* by clearing b0 and b1 (other bits unchanged) */
      jmp  eindfrmeet    /* And goto THE END, time to frequency conversion will be 0 Hz! */

     freqstart1:         /* START OF THE ACTUAL FREQUENCY MEASUREMENT ROUTINE */
      in   al,dx         /* Store the input signal into register AL of AX */
      and  al,cl         /* AND with CL reg.(input bit of LPT1 of freq. range */
      jz   freqstart1    /* If input signal zero then loop to freqtest 1 */

     freqstart2:         /* Same routine as freqstart1 but now for */
      in   al,dx         /* when the input signal is one */
      and  al,cl
      jnz  freqstart2

      pop  ax            /* Fast start of PCtimer2 exactly at the beginning */
      out  0x61,al       /* of a period of the input signal */

      in   al,0x61       /* Push the stoptvalue of Port 0x61 onto the stack for */
      and  al,0xfc       /* a fast STOP PCtimer2 instruction later */
      push ax            /* via the AX register (Port 0x61 b0 = 1, others unchanged) */

     freqtel1:           /* Count the number of periods of the input signal */
      in   al,dx         /* during the gate (measuring) time */
      and  al,cl
      jz   freqtel1      /* Loop to freqtel1 if input signal is zero */
      call freqmeetlatch /* Update t1, t2 and t3 for the time measurement */

     freqtel2:
      in   al,dx
      and  al,cl
      jnz  freqtel2      /* Loop to freqtel2 if input signal is one */
      inc  bx            /* Here a period of the input signal has ended */
      cmp  bx,0          /* Increment the BX register and check for > 0xffff */
      jnz  freqtel3      /* If so, then BX = 0, else goto freqtel3 */
      mov  ax,p1         /* Else increment the overflow counter p1 */
      inc  ax            /* p1 is the overflow period counter (each 0xffff) */
      mov  p1,ax         /* Increment is done by using the AX register */

     freqtel3:           /* At the end of one period of the input, we are here */
      mov  ax,t3         /* And here we check of the gate (measuring time) */
      cmp  ax,0          /* has expired */
      jnz  freqtel1      /* If not, then loop to freqtel1 for period counting mode */

	   /* Here above we did the period counting during
	    * the gate (measuring) time just as an ordinary frequency counter.
	    * But now we will add the exact time of one extra period of
	    * the input signal so that we have an exact total time of an
	    * exact number of periods at the end.
	    /*

      call freqmeetlatch /* Update t1, t2 and t3 for the time measurement */

     freqlaatste1:       /* START OF THE TIME MEASUREMENT OF THE LAST EXTRA PERIOD */
      in   al,dx
      and  al,cl
      jz   freqlaatste1  /* Loop if input signal is zero */
      call freqmeetlatch /* Update t1, t2 and t3 for the time measurement */

     freqlaatste2:
      in   al,dx
      and  al,cl
      jnz  freqlaatste2  /* Loop if input signal is one */

      pop  ax            /* Fast stop of PCtimer2 exactly at the end */
      out  0x61,al       /* of a period of the input signal */
      inc  bx            /* Here a period of the input signal has ended */
      cmp  bx,0          /* Increment the BX register and check for > 0xffff */
      jnz  freqlaatste3  /* If so, then BX = 0, else goto freqlaatste3 */
      mov  ax,p1         /* Else increment the overflow counter p1 */
      inc  ax            /* p1 is the overflow period counter (each 0xffff) */
      mov  p1,ax         /* Increment is done by using the AX register */

     freqlaatste3:
      call freqmeetlatch /* Update t1, t2 and t3 for the time measurement */
      jmp  eindfrmeet    /* And goto THE END for the time to frequency conversion */

     freqmeetlatch:      /* Subroutine for updating t1, t2 and gate time t3 */
      mov  al,0x84       /* Latch the PCtimer2 values into the buffer */
      out  0x43,al       /* NOTE: PCtimer2 is a down counter, overflow=underflow! */
      in   al,0x42       /* Read the LoBytes from the buffer */
      xchg ah,al         /* Store in AH of AX register */
      in   al,0x42       /* Read the HiBytes from the buffer */
      xchg ah,al         /* Exchange AL and AH as HiBytes are in AL now */
      cmp  ax,t1         /* Compare AX (PCtimer2 value) with t1 for 0xffff over-underflow */
      jbe  freqmeetlatch2/* If no over-underflow, then goto freqmeetlatch2 */
      mov  t1,ax         /* Store PCtimer2 (AX reg. value) into t1 */
      mov  ax,t2         /* Decrement the over-underflow counter t2 */
      dec  ax            /* by using the AX register */
      mov  t2,ax         /* t2 is also a down counter */
      cmp  ax,t3         /* Check if the gate (measurement) time is expired */
      ja   freqmeetlatch1/* if not then goto freqmeetlatch1 */
      xor  ax,ax         /* Else make t3 = 0 by using the AX register */
      mov  t3,ax         /* t3 = 0 is the flag for expired measuring time */
			 /* NOTE: gate time is measured in number of PCtimer overflows */
     freqmeetlatch1:
      ret                /* return if a PCtimer2 overflow */

     freqmeetlatch2:     /* No PCtimer2 overflow */
      mov  t1,ax         /* so store value of AX register (is PCtimer2) in t1 */
      ret                /* and return */

     eindfrmeet:         /* THE END, t1 and t2 have the exact PCtimer2 clock pulses */
      mov  perioden,bx   /* and the variabele "perioden" (BX register) the periods */
      sti                /* and p1 the number of overflows of the BX register */
      }

tper = perioden + 65536 * p1; /* Calculate the total periods, store into tper */

f = 0;

if (tper != 0)           /* Calculation only if periods NOT zero */
  {
   f = 0.838095e-6 * (65536*(65535 - t2) + (65535 - t1));
			 /* One PCtimer2 clockpulse is 0.838095e-6 sec. */
   f = 1 / f;            /* Conversion time to frequency */

   f = f * tper * frcorrectie; /* Correction for PCtimer inaccuracy */

   if (h == 1)
      f = f * 64;        /* Correct for frequency range 2 prescaling */

   if (h == 2)
      f = f * 4096;      /* Correct for frequency range 3 prescaling */
  }
return f;                /* Return the frequency in Hz */

}



/****************************************************************************
 *
 * void frcorr(void) CORRECTION FOR INACCURACY OF PC CLOCK
 *
 ****************************************************************************/
void frcorr(void)
{
float fr;

frcorrectie = 1;               /* reset the correction to 1x */
fr = freqmeet(3);              /* measure reffreq (freqmeet(3)) */
if (fr != 0)
  frcorrectie = reffreq / fr;  /* frcorrectie is the correction factor */
			       /* reffreq is the reference frequency */
}





/*=========================================================================



NOW FOLLOW THE VARIOUS SUBROUTINES




=========================================================================*/








/****************************************************************************
 *
 * void Tekstkleur(void) SET THE TEXT COLOR
 *
 ****************************************************************************/
void Tekstkleur(void)
{
int n,x;

Ptekstkleur();

do
{
_displaycursor(_GCURSOROFF);

inkey();

if (keyvalue == 200)
  {
   tekstkleur++;
   tekstkleur &= 15;
   if (tekstkleur == schermkleur)
     {
      tekstkleur++;
      tekstkleur &= 15;
     }
   Ptekstkleur();
  }

if (keyvalue == 208)
  {
   tekstkleur--;
   tekstkleur &= 15;
   if (tekstkleur == schermkleur)
     {
      tekstkleur--;
      tekstkleur &= 15;
     }
   Ptekstkleur();
  }
}
while (keyvalue != 203);

Scherm(25);
}



/****************************************************************************
 *
 * void Ptekstkleur() PRINT (SHOW) THE TEXT COLOR TO THE SCREEN
 *
 ****************************************************************************/
void Ptekstkleur()
{
 char kursor[] = {18,0};
 Scherm(25);

 window (1,1,5,80);
 window(8,1,11,20);
 _settextposition(3,30);
 _outtext("SELECT TEXTCOLOR");
 _settextposition (9,2);
 sprintf(Pbuf," TEXTCOLOR %u ",tekstkleur);
 _outtext(Pbuf);
 _settextposition (10,7);
 _outtext(kursor);
}



/****************************************************************************
 *
 * void Schermkleur(void) SET THE SCREEN BACKGROUND COLOR
 *
 ****************************************************************************/
void Schermkleur(void)
{
int n,x;

Pschermkleur();

do
{
_displaycursor(_GCURSOROFF);

inkey();

if (keyvalue == 200)
  {
   schermkleur++;
   schermkleur &= 15;
   if (tekstkleur == schermkleur)
     {
      schermkleur++;
      schermkleur &= 15;
     }
   Pschermkleur();
  }

if (keyvalue == 208)
  {
   schermkleur--;
   schermkleur &= 15;
   if (tekstkleur == schermkleur)
     {
      schermkleur--;
      schermkleur &= 15;
     }
   Pschermkleur();
  }
}
while (keyvalue != 203);

Scherm(25);
}



/****************************************************************************
 *
 * void Pschermkleur() PRINT (SHOW) THE SCREEN BACKGROUND COLOR
 *
 ****************************************************************************/
void Pschermkleur()
{
 char kursor[] = {18,0};
 Scherm(25);
 window (1,1,5,80);
 window(8,1,11,20);
 _settextposition(3,30);
 _outtext("ADJUST SCREENCOLOR");
 _settextposition (9,2);
 sprintf(Pbuf," SCREENCOLOR %u ",schermkleur);
 _outtext(Pbuf);
 _settextposition (10,7);
 _outtext(kursor);
}




/****************************************************************************
 *
 * void Schermuit(void) SCREEN BLACK (NOT USED)
 *
 ****************************************************************************/
void Schermuit(void)
{
int oldtekstkleur, oldschermkleur;

oldtekstkleur = tekstkleur;
oldschermkleur = schermkleur;

tekstkleur = 0;
schermkleur = 0;


Scherm(25);

_displaycursor(_GCURSOROFF);

do
  {
   inkey();
  }
while (keyvalue != 203);

tekstkleur = oldtekstkleur;
schermkleur = oldschermkleur;

Scherm(25);

}





/****************************************************************************
 *
 * void pauze (float p) GIVES A PAUSE OF p SECONDS
 *
 ****************************************************************************/

void pauze(float p)
{
 double tijd1,tijd2;
 struct timeb tm;
 ftime(&tm);
 tijd1 = tm.time + (double)tm.millitm / 1000 + p;

 do
   {
    ftime(&tm);
    tijd2 = tm.time + (double)tm.millitm / 1000;
   }
 while(tijd2 < tijd1);
}



/****************************************************************************
 *
 * void inkey(void) GIVES IN keyvalue THE CHARACTER OF THE PRESSED KEY +128
 *
 ****************************************************************************/

void inkey(void)
{
  key[0] = 0;
  keyvalue = 0;
  if (kbhit())
  {
     key[0] = getch();
     keyvalue = (int)key[0];

     if (key[0] == 0)
	{
	 key[0] = getch();
	 keyvalue = (int)key[0];
	 keyvalue += 128;
	}
  }
}



/****************************************************************************
 *
 * void Scherm(int lijnen) SETS THE SCREEN ROWS TO THE NUMBER OF lijnen
 *                         AND SETS THE SCREEN AND TEXT COLORS
 ****************************************************************************/

void Scherm(int lijnen)
{
_settextrows(lijnen);
_displaycursor(_GCURSORON);
_settextcursor(0x0607);
_setbkcolor((long)schermkleur);
_settextcolor(tekstkleur);
_clearscreen(_GWINDOW);
}



/****************************************************************************
 *
 * void window(int r1, c1, r2, c2) DRAWS A WINDOW ON THE SCREEN
 *
 ****************************************************************************/

void window(int r1, int c1, int r2, int c2)
{
int n;
char line[2];

line[1] = 0;
line[0] = 201;
_settextposition (r1,c1);
_outtext(line);

line[0] = 187;
_settextposition (r1,c2);
_outtext(line);

line[0] = 200;
_settextposition (r2,c1);
_outtext(line);

line[0] = 188;
_settextposition (r2,c2);
_outtext(line);

line[0] = 205;

for (n = c1 + 1;n < c2;n++)
   {
    _settextposition (r1,n);
    _outtext(line);
   }

for (n = c1 + 1;n < c2;n++)
   {
    _settextposition (r2,n);
    _outtext(line);
   }

line[0] = 186;

for (n = r1 + 1;n < r2;n++)
   {
    _settextposition (n,c1);
    _outtext(line);
   }

for (n = r1 + 1;n < r2;n++)
   {
    _settextposition (n,c2);
    _outtext(line);
   }

}


/****************************************************************************
 *
 * int keuzebepalen(offsetline, maxkeuze,kolom,keuze) MENUE CHOICE WITH CURSOR KEYS
 *
 ****************************************************************************/
int keuzebepalen(int offsetline,int maxkeuze,int kolom,int keuze)
{
int n,x;
char kursor[] = {16,0};

keuze &= 255;

if (keuze < 1)
   keuze = 1;
if (keuze > maxkeuze)
   keuze = maxkeuze;

x = keuze + offsetline;
for (n = offsetline+1; n <= offsetline + maxkeuze;n++)
   {
    _settextposition(n,kolom);
    if (x == n)
      {
       sprintf(Pbuf,"%s",kursor);
       _outtext(Pbuf);
      }
    else
       _outtext(" ");
   }

inkey();

if (keyvalue == 200)  /* down */
  keuze--;
if (keyvalue == 208)
  keuze++;            /* up */

if (keuze < 1)
   keuze = 1;
if (keuze > maxkeuze)
   keuze = maxkeuze;

if (keyvalue == 203)  /* linker kursorkey */
  keuze |= 256;

if (keyvalue == 205)  /* rechter kursorkey */
  keuze |= 512;

return(keuze);
}



/****************************************************************************
 *
 * void In_ntext(int yp,int xp,int maxlen, *k) ONLY NUMERIC INPUT
 *
 ****************************************************************************/
void In_ntext(int yp,int xp,int maxlen,char *k)
{
int cnt = 0;
int accept=0;
k[cnt] = 0;


do
  {
   accept = 0;

   if (cnt < 0)
     cnt = 0;

   if (xp < 3)
     xp = 3;

   if (xp > 78)
     xp = 78;

   _settextposition(yp,xp);

   inkey();

   if (keyvalue == 27)
     {
      k[0] = 27;
      cnt = 1;
      break;
     }

   if (keyvalue == 8)
     {
      k[cnt] = 0;
      if (cnt > 0)
	{
	 cnt--;
	 xp--;
	}

      if (xp < 3)
	{
	 xp = 78;
	 yp--;
	}

      _settextposition(yp,xp);
      _outtext(" ");
     }

  if (keyvalue == (int)'.')
     accept = 1;

  if (cnt == 0 && keyvalue == (int)'+')
     accept = 1;

  if (cnt == 0 && keyvalue == (int)'-')
     accept = 1;

  if (keyvalue >= (int)'0' && keyvalue <= (int)'9')
     accept = 1;

  if (accept != 0)
    {
     accept = 0;

     if (cnt < maxlen)
       {
	k[cnt] = (char)keyvalue;
	k[cnt + 1] = 0;
	_settextposition(yp,xp);
	_outtext(&k[cnt]);

	cnt++;
	xp++;
       }

     if (cnt == maxlen)
       {
	_settextposition(yp,xp);
	_outtext(" ");
       }

     if (xp > 78)
       {
	xp = 3;
	yp++;
       }
    }

}
while (keyvalue != 13);

k[cnt] = 0;

}


