REM qrsstx01.bas 2016-10-07 qrss transmitter
tx$="___.--._.-_..---_---_...._...."
fr=1500    % Tone frequency
vdot=6000  % Dot time (ms)
mdelay=0   % Delay (min)
vstackinterval=10  % (min) 0=non-sync

vdash=3.0*vdot
vtonespace=vdot
vspace=3.0*vdot-vtonespace

WAKELOCK 1    % 2 for dimmed screen

vt=0
FOR n=1 TO LEN(tx$)
 x$=MID$(tx$,n,1)
 IF x$="." THEN
  vt=vt+vdot+vtonespace
 ENDIF
 IF x$="-" THEN
  vt=vt+vdash+vtonespace
 ENDIF
 IF x$="_" THEN
  vt=vt+vspace
 ENDIF
NEXT n
vt=ROUND(vt / 1000)
txt$="TX time (s): "+STR$(vt)
POPUP txt$,0,0,5

WHILE 1
 IF vstackinterval > 1 THEN
  PRINT "Wait for synchronisation "; vstackinterval;" minutes"
  PRINT "Delay ";mdelay; " minutes"
  DO
   PAUSE 20  % Less CPU load
   TIME vye$,vmo$,vda$,vho$,vmi$,vse$
  UNTIL(MOD(VAL(vmi$)-mdelay,vstackinterval))<>0
  DO
   PAUSE 20  % Less CPU load
   TIME vye$,vmo$,vda$,vho$,vmi$,vse$
  UNTIL(MOD(VAL(vmi$)-mdelay,vstackinterval))=0
 ENDIF
 y$=""
 FOR n=1 TO LEN(tx$)
  x$=MID$(tx$,n,1)
  y$=y$+x$
  CLS
  PRINT tx$
  PRINT y$
  IF x$="_" THEN
   PAUSE vspace
  ENDIF
  IF x$="." THEN
   TONE fr,vdot
   PAUSE vtonespace
  ENDIF
  IF x$="-" THEN
   TONE fr,vdash
   PAUSE vtonespace
  ENDIF
 NEXT n
REPEAT

ONBACKKEY:
EXIT
