# JustNoise-v01a.py (14-10-2018) JustNoise WAV file maker
# For Python version 3
# Created by Onno Hoekstra (pa2ohh)
import wave
import array
import math
import random
import time

from tkinter import *
from tkinter import messagebox
from tkinter import filedialog
from tkinter import simpledialog
from tkinter import font


# Values that can be modified
CANVASwidth = 700           # Width of the canvas
CANVASheight = 150          # Height of the canvas

SAMPLErate = 44100          # Sample rate of the WAV file

PULSEmode = False           # Pulsed on/off signal if True
NOISEtime = 10.0            # Length of signal in seconds
Repeat = 1                  # Repeat the signal if Repeat > 1
REFlevel = 100.0            # Reference level in %

# Colors that can be modified
COLORframes = "#000080"     # Color = "#rrggbb" rr=red gg=green bb=blue, Hexadecimal values 00 - ff 
COLORcanvas = "#404040"
COLORtext = "#ffffff"

# Fontsizes that can be modified
INFOfontsize = 8            # Size of info (Small=6, Large=24)

# Button sizes that can be modified
Buttonwidth1 = 30
Buttonwidth2 = 15

MSG = ""                    # Messages

# =================================== Start widgets routines ========================================
def Bnot():
    print("Routine not made yet")


def BSAMPLErate():
    global SAMPLErate
    global MSG

    s = simpledialog.askstring("Sample rate","Value: " + str(SAMPLErate) + "\n\nNew value:\n(44100, 48000, 96000)")

    if (s == None):         # If Cancel pressed, then None
        return()

    try:                    # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = int(s)
    except:
        v = 0

    if v != 0:
        SAMPLErate = v

    MSG = "Sample rate: " + str(SAMPLErate)
    UpdateScreen()          # UpdateScreen() call 
 

def BNOISEtime():
    global NOISEtime
    global MSG
    
    s = simpledialog.askstring("Noise time","Value: " + str(NOISEtime) + " sec.\n\nNew value:\n(sec.)")

    if (s == None):         # If Cancel pressed, then None
        return()

    try:                    # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = float(s)
    except:
        v = 0

    if v != 0:
        NOISEtime = v

    MSG = "Noise time (s): " + str(NOISEtime)
    UpdateScreen()          # UpdateScreen() call 


def BRepeat():
    global Repeat
    global MSG
    
    s = simpledialog.askstring("Repeat","Value: " + str(Repeat) + "x\n\nNew value:\n(>1 or 1 for none)")

    if (s == None):         # If Cancel pressed, then None
        return()

    try:                    # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = int(s)
    except:
        v = 0

    if v != 0:
        Repeat = v

    MSG = "Repeat: " + str(Repeat) + "x"
    UpdateScreen()          # UpdateScreen() call 

    

def BLevel():
    global REFlevel
    global MSG
    
    s = simpledialog.askstring("Reference level","Value: " + str(REFlevel) + " %\n\nNew value:\n(%)")

    if (s == None):         # If Cancel pressed, then None
        return()

    try:                    # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = float(s)
    except:
        v = 0

    if v > 0 and v <= 100:
        REFlevel = v

    MSG = "Reference level (%): " + str(REFlevel)
    UpdateScreen()          # UpdateScreen() call 


def BPulsing():
    global PULSEmode
    global MSG
    
    if PULSEmode == True:
        PULSEmode = False
        MSG = "Not pulsing"
    else:
        PULSEmode = True
        MSG = "Pulsing"
    
    UpdateScreen()          # UpdateScreen() call 

    
def Bmakewav():
    filename = filedialog.asksaveasfilename(filetypes=[("WAV files","*.wav"),("allfiles","*")])

    if (filename == None):  # No input, cancel pressed or an error
        filename = ""

    if (filename == ""):
        return()
    if filename[-4:] != ".wav":
        filename = filename + ".wav"
    
    MAKEwav(filename)       # Make the wav file
    
# ============================================ Main routine ====================================================
    
def Mainloop():

    UpdateScreen()              # UpdateScreen() call
    
    while(1):                   # The never ending loop
        root.update()           # Activate updated screens


def UpdateScreen():             # Update screen with text
    MakeScreen()                # Update the text
    root.update()               # Activate updated screens    
  

def MakeScreen():               # Update the text
    global SAMPLErate
    global CANVASwidth
    global CANVASheight

    global SAMPLErate
    global PULSEmode
    global NOISEtime
    global Repeat
    global REFlevel
    global MSG
 

    # Delete all items on the screen
    de = ca.find_enclosed ( 0, 0, CANVASwidth+1000, CANVASheight+1000)   
    for n in de: 
        ca.delete(n)


    # Information on the screen

    x = 10
    y = 20
    Linestep = 30

    txt = "Level (%): " + str(REFlevel) + "   Noise time (sec.): " + str(NOISEtime)

    if Repeat > 1:
        txt = txt + "   Repeat: " + str(Repeat)
    
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    if PULSEmode == False:
        txt = "Not pulsing"
    else:
        txt = "Pulsing"
    
    y = y + Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    txt =  "Sample rate: " + str(SAMPLErate)

    y = y + Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    y = y + Linestep
    idTXT = ca.create_text (x, y, text=MSG, font=INFOfont, anchor=W, fill=COLORtext)


def MAKEwav(wavfilename):
    global SAMPLErate
    global PULSEmode
    global NOISEtime
    global Repeat
    global REFlevel
    global MSG
    
    T0=time.time()

    # Create the audio samples
    MSG = "Caclulation of samples, wait"
    UpdateScreen()                                  # UpdateScreen() call

    PULSEtime = SAMPLErate / 4                      # The on or off time when pulsing
    TONEsamples = NOISEtime * SAMPLErate
   
    signal = []
    PULSEcnt = -PULSEtime
    sc = 0
    Mcount = 0
    while Mcount <= TONEsamples:
        NOISE = 2 * random.random() - 1.0                       # Get a random NOISE sample and convert to -1 / +1 range
        x = float(REFlevel) / 100.0 * NOISE * 32000.0
        
        if PULSEmode == True:
            if PULSEcnt < 0:
                signal.append(int(x))                           # Audio float takes more memory
            else:
                signal.append(0)
                
            PULSEcnt = PULSEcnt + 1
            if PULSEcnt > PULSEtime:
                PULSEcnt = -PULSEtime
        else:                                                   # No pulsing mode
            signal.append(int(x))                               # Audio float takes more memory
            
        Mcount = Mcount + 1
        sc = sc + 1

        if sc > 4999:
            sc = 0
            MSG = "Tone Samples (kb): " + str(int(Mcount/500)) + " of " + str(int(TONEsamples/500)) # 2 bytes per tone sample, so /500 instead of /1000
            UpdateScreen()                          # UpdateScreen() call


    # Conversion to WAV binary format
    s = []
    le = len(signal)
    sc = 0
    i = 0
    while i < le:
        # ssignal += struct.pack('h', signal[i])                  # transform floating point list signal to binary array
        v = signal[i]                                           # Same routine but without struct   
        if v < 0:
            v = v + 65536
        s.append(int(v % 256))
        s.append(int(v / 256))
        
        i = i + 1
        sc = sc + 1

        if sc == 500000:                                        # 2 bytes per value
            sc = 0
            MSG = "Converted (Mb): " + str(int(i/500000)) + " of " + str(int(le/500000))
            UpdateScreen()                                      # UpdateScreen() call

    signal = []                                                 # Free memory
    MSG = "Conversion to binary and save to WAV"
    UpdateScreen()                                              # UpdateScreen() call

    ssignal = ''                                                # buffer for list of binary values
    ssignal = array.array('B', s).tostring()                    # Convert int to binary string with array module


    # Extend if Repeat > 1
    if Repeat > 1:
        ss = ssignal
        n = 1
        while n < Repeat:
            ssignal = ssignal + ss
            n = n + 1
                
    OUTwavfile(wavfilename, SAMPLErate, ssignal)                # write binary list to WAV file

    T1=time.time()
    MSG = wavfilename + " = Made in " + str(int(T1-T0)) + "s ="
    UpdateScreen()                                              # UpdateScreen() call


def OUTwavfile(WAVname, samplerate, ssignal):                   # Save WAV file
    WAVf = wave.open(WAVname, 'wb')
    WAVf.setparams((1, 2, samplerate, 1, 'NONE', 'noncompressed'))
    WAVf.writeframes(ssignal)
    WAVf.close()


# ================ Make Screen ==========================

root=Tk()
root.title("Just Noise WAV file maker JustNoise-v02a.py (14-10-2018)")

root.minsize(100, 100)

frame1 = Frame(root, background=COLORframes, borderwidth=5, relief=RIDGE)
frame1.pack(side=TOP, expand=1, fill=X)

frame2 = Frame(root, background="black", borderwidth=5, relief=RIDGE)
frame2.pack(side=TOP, expand=1, fill=X)

frame3 = Frame(root, background=COLORframes, borderwidth=5, relief=RIDGE)
frame3.pack(side=TOP, expand=1, fill=X)

ca = Canvas(frame2, width=CANVASwidth, height=CANVASheight, background=COLORcanvas)
ca.pack(side=TOP)

b = Button(frame1, text="Noise time", width=Buttonwidth2, command=BNOISEtime)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame1, text="Repeat signal", width=Buttonwidth2, command=BRepeat)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame1, text="Sample Rate", width=Buttonwidth2, command=BSAMPLErate)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame3, text="Level", width=Buttonwidth2, command=BLevel)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Pulsing", width=Buttonwidth2, command=BPulsing)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Make WAV", width=Buttonwidth2, command=Bmakewav)
b.pack(side=RIGHT, padx=5, pady=5)


INFOfont = font.Font(size=INFOfontsize)
# INFOfont = font.Font(family="Helvetica", size=INFOfontsize, weight="bold")

# ================ Call main routine ===============================
Mainloop()
 


