# QRSSsimwav-v01a.py(w) (05-06-2012) QRSS simulation WAV file creator
# For Python version 2.6 or 2.7
# With external module pyaudio (for Python version 2.6 or 2.7)
# Created by Onno Hoekstra (pa2ohh)
import random
import wave
import math
import array
import time
import tkFont
from Tkinter import *
from tkFileDialog import askopenfilename
from tkFileDialog import asksaveasfilename
from tkSimpleDialog import askstring
from tkMessageBox import *


# Values that can be modified
CANVASwidth = 800           # Width of the canvas
CANVASheight = 325          # Height of the canvas

SAMPLErate = 5512           # Sample rate 5512 of the WAV file for Lopora
# SAMPLErate = 6000           # Sample rate 6000 of the WAV file for Argo and Lopora

DOTtime = 3.0               # DOT time in seconds

MORSEtext = "s.--.s.-s..---s---s....s....sss"   # Morse text
MORSE1halfshift = True      # Morse1 with 50% shift instead of 100%
MORSEmode1 = True           # FSK2 morse code enabled
MORSEmode2 = True           # FSK3 morse code enabled
MORSEmode3 = True           # CHIRP morse code enabled

LVLtone = []                # Tone height in Hz
LVL = []                    # Level in dB
MAXsignals = 5              # Maximum numbers of signals

FADINGfreq = 0.0            # Fading frequency, 0.0 = OFF
NOISElevel = 0.0            # Noise level in %, 0.0 = OFF
SIGNALlevel = 100.0         # Level of whole signal in %

# Colors that can be modified
COLORframes = "#000080"     # Color = "#rrggbb" rr=red gg=green bb=blue, Hexadecimal values 00 - ff 
COLORcanvas = "#404040"
COLORtext = "#ffffff"

# Fontsizes that can be modified
INFOfontsize = 8            # Size of info (Small=6, Large=24)

# Button sizes that can be modified
Buttonwidth1 = 11
Buttonwidth2 = 11

MSG = "-"                   # Messages to be printed to the screen
WAVfilename = ""            # The name of the WAV file
THEsignal = []              # The array with audio samples
WAVtime = 0                 # The length of the WAV file in sec.

# =================================== Start widgets routines ========================================
def Bnot():
    print "Routine not made yet"


def Bplaywav():
    PLAYwav()
    UpdateScreen()          # UpdateScreen() call
    

def BSAMPLErate():
    global SAMPLErate

    s = askstring("Sample rate","Value: " + str(SAMPLErate) + "\n\nNew value:\n(44100, 48000, 96000)")

    if (s == None):         # If Cancel pressed, then None
        return()

    try:                    # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = int(s)
    except:
        v = 0

    if v != 0:
        SAMPLErate = v

    UpdateScreen()          # UpdateScreen() call 

 
def BMORSEtext():
    global MORSEtext

    s = askstring("Morse text","Text: <" + MORSEtext + ">\n\nNew text:\n")

    if (s == None):         # If Cancel pressed, then None
        return()

    if s != "":
        MORSEtext = ""
        n = 0
        while n < len(s):
            if s[n] == "." or s[n] == "-":
                MORSEtext = MORSEtext + s[n]
            else:
                MORSEtext = MORSEtext + "s"
            n = n + 1
        
    UpdateScreen()          # UpdateScreen() call 


def BMORSEsignal():
    
    Setlevel(0)             # Set Marker level and frequency
    Setlevel(-1)            # Set Space level and frequency
    
    UpdateScreen()          # UpdateScreen() call


def BMORSEmodes():
    global MORSEmode1
    global MORSE1halfshift
    global MORSEmode2
    global MORSEmode3
    
    EN = askyesno("Enable FSK2 morse","Enable FSK2 morse", default = YES)
    if EN == True:
        MORSEmode1 = True 

        EN = askyesno("50% shift for FSK2 morse","Enable 50% shift for FSK2 morse", default = YES)
        if EN == True:
            MORSE1halfshift = True 
        else:
            MORSE1halfshift = False
    else:
        MORSEmode1 = False
        
    EN = askyesno("Enable FSK3 morse","Enable FSK3 morse", default = YES)
    if EN == True:
        MORSEmode2 = True 
    else:
        MORSEmode2 = False

    EN = askyesno("Enable CHIRP morse","Enable CHIRP morse", default = YES)
    if EN == True:
        MORSEmode3 = True 
    else:
        MORSEmode3 = False

    UpdateScreen()          # UpdateScreen() call

    
def Bfading(): 
    global FADINGfreq

    s = askstring("Fading frequency","Value: " + str(FADINGfreq) + "\n\nNew value:\n(0.01 Hz or so, 0.0 Hz is OFF!!)")

    if (s == None):             # If Cancel pressed, then None
        s = "error"

    try:                        # Error if for example no numeric characters or OK pressed without input (s = "")
        v = float(s)
    except:
        s = "error"

    if s != "error":
        FADINGfreq = v

    UpdateScreen()              # UpdateScreen() call
     
    
def Bnoise(): 
    global NOISElevel

    s = askstring("Noise level","Value (%): " + str(NOISElevel) + "\n\nNew value:\n(max 100%)")

    if (s == None):             # If Cancel pressed, then None
        s = "error"

    try:                        # Error if for example no numeric characters or OK pressed without input (s = "")
        v = float(s)
    except:
        s = "error"

    if s != "error":
        NOISElevel = v
   
    UpdateScreen()              # UpdateScreen() call
     

def Binterferer():
    global MAXsignals

    s = askstring("Interferer","Value (1 - 5):\n")

    if (s == None):             # If Cancel pressed, then None
        return()

    try:                        # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = int(s)
    except:
        v = 0

    if v > 0 and v <= MAXsignals:
        Setlevel(v)


def BDOTtime():
    global DOTtime

    s = askstring("DOT time","Value: " + str(DOTtime) + " sec.\n\nNew value:\n(sec.)")

    if (s == None):             # If Cancel pressed, then None
        return()

    try:                        # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = float(s)
    except:
        v = 0

    if v != 0:
        DOTtime = v

    UpdateScreen()              # UpdateScreen() call 


def BSAMPLErate():
    global SAMPLErate

    s = askstring("Sample rate","Value: " + str(SAMPLErate) + "\n\nNew value:\n(44100, 48000, 96000)")

    if (s == None):             # If Cancel pressed, then None
        return()

    try:                        # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = int(s)
    except:
        v = 0

    if v != 0:
        SAMPLErate = v

    UpdateScreen()              # UpdateScreen() call 
  

def Bsignallevel():
    global SIGNALlevel

    s = askstring("Signal level","Value (%): " + str(SIGNALlevel) + "\n\nNew value:")

    if (s == None):             # If Cancel pressed, then None
        s = "error"

    try:                        # Error if for example no numeric characters or OK pressed without input (s = "")
        v = float(s)
    except:
        s = "error"

    if s != "error":
        SIGNALlevel = v

    UpdateScreen()              # UpdateScreen() call 

    
def BSave():
    global MSG        
    filename = asksaveasfilename(filetypes=[("Setting","*.cfg"),("allfiles","*")])

    if (filename == None):              # No input, cancel pressed or an error
        filename = ""

    if (filename == ""):
        return()
    if filename[-4:] != ".cfg":
        filename = filename + ".cfg"
    Saveconfig(filename)                # Save the settings

    MSG = "Saved file: " + filename
    UpdateScreen()              # UpdateScreen() call 


def BRecall():
    global MSG
    filename = askopenfilename(filetypes=[("Setting","*.cfg"),("allfiles","*")])

    if (filename == None):              # No input, cancel pressed or an error
        filename = ""

    if (filename == ""):
        return()

    Recallconfig(filename)              # Load configuration

    MSG = "Recalled file: " + filename
    UpdateScreen()              # UpdateScreen() call 


def BMAKEwav():
    global MSG
    global WAVfilename
    global WAVtime
    global THEsignal
    global MORSEmode1
    global MORSEmode2
    global MORSEmode3
        
    T0=time.time()
    THEsignal = []              # Clear the signal array
    
    WAVfilename = ""
    
    filename = asksaveasfilename(filetypes=[("WAVfile","*.wav"),("allfiles","*")])

    if (filename == None):      # No input, cancel pressed or an error
        filename = ""

    if filename == "":          # If no WAV file name given, stop making it
        return()

    if filename[-4:] != ".wav":
        filename = filename + ".wav"

    WAVfilename = filename

    if MORSEmode1 == True:      # FSK2 morse
        MAKEmorse1()
    if MORSEmode2 == True:      # FSK3 morse
        MAKEmorse2()
    if MORSEmode3 == True:      # CHIRP morse
        MAKEmorse3()
    
    MAKEfading()
    MAKEnoise()
    MAKEinterferers()
    MAKEwavfile()
    
    T1=time.time()
    MSG = WAVfilename + " = Made in " + str(int(T1-T0)) + "s =  WAV time (s): " + str(WAVtime)

    UpdateScreen()              # UpdateScreen() call 

# ============================================ Main routine ====================================================
    

def Mainloop():
    global FADINGfreq
    global NOISElevel
    global LVLtone
    global LVL
    global MAXsignals

    # Initialize the levels
    n = 0
    while n < (MAXsignals+2):
        LVLtone.append(1000.0)      # Set all tones to 1000. Tones of 0 Hz will crash the program
        LVL.append(0.0)             # Set all levels to 0% (OFF)
        n = n + 1

    UpdateScreen()                  # UpdateScreen() call
    
    while(1):                       # The never ending loop
        root.update()               # Activate updated screens


def UpdateScreen():                 # Update screen with text
    MakeScreen()                    # Update the text
    root.update()                   # Activate updated screens    

    
def Setlevel(nr): 
    global LVLtone
    global LVL
    global MAXsignals

    if nr < -1 or nr > MAXsignals:   # Check if in allowed range -1 and 0 are for morse code levels
        return()

    leveltxt = "error"
    
    if nr == -1:
        leveltxt = "Space signal"
    if nr == 0:
        leveltxt = "Morse signal"

    if nr > 0:
        leveltxt = "Interferer " + str(nr)

    s = askstring("Frequency","Value " + leveltxt +  " (Hz): " + str(LVLtone[nr+1]) + "\n\nNew value: ")

    if (s == None):                 # If Cancel pressed, then None
        s = "error"

    try:                            # Error if for example no numeric characters or OK pressed without input (s = "")
        v = float(s)
    except:
        s = "error"

    if s != "error":
        if v < 1.0:                 # Min. 1 Hz
            v = 1.0
        LVLtone[nr+1] = v

    s = askstring("Level","Value " + leveltxt +  " (%): " + str(LVL[nr+1]) + "\n\nNew value (<100%): ")

    if (s == None):                 # If Cancel pressed, then None
        s = "error"

    try:                            # Error if for example no numeric characters or OK pressed without input (s = "")
        v = float(s)
    except:
        s = "error"

    if s != "error":
        LVL[nr+1] = v
    
    UpdateScreen()                  # UpdateScreen() call
     

def MakeScreen():                   # Update the text
    global MSG
    global SAMPLErate
    global CANVASwidth
    global CANVASheight
    global MORSEtext
    global MORSE1halfshift
    global MORSEmode1
    global MORSEmode2
    global MORSEmode3
    global DOTtime
    global LVLtone
    global LVL
    global MAXsignals
    global FADINGreq
    global NOISElevel
    global SIGNALlevel


    # Delete all items on the screen
    de = ca.find_enclosed ( 0, 0, CANVASwidth+1000, CANVASheight+1000)   
    for n in de: 
        ca.delete(n)

    Linestep = 15

    # General information on top of the screen
    txt = "Sample rate: " + str(SAMPLErate)
    txt = txt + "     Total signal level (%): " + str(SIGNALlevel)
    
    x = 10
    y = 20
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    txt = "Fading: "
    if FADINGfreq <= 0.0:
        txt = txt + "Inactive"
    else:
        txt = txt + "Active:"
        txt = txt + " Fading frequency (Hz): " + str(FADINGfreq)

    y = y + 2 * Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    txt = "Noise: Level (%): " + str(NOISElevel) + PCTtodB(NOISElevel)

    y = y + 2 * Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    txt = "DOT time FSK2(sec.): " + str(DOTtime)
    txt = txt + "  /  Symbol time FSK3(sec.): " + str(1.5*DOTtime)
    txt = txt + "  /  Symbol time CHIRP(sec.): " + str(3.0*DOTtime)

    y = y + 2 * Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    txt = "Morse text: " + MORSEtext + "  "
    if MORSEmode1 == True:
        if MORSE1halfshift == True:
            txt = txt + "(FSK2 50% shift) "
        if MORSE1halfshift == False:
            txt = txt + "(FSK2 100% shift) "
    if MORSEmode2 == True:
        txt = txt + "(FSK3) "
    if MORSEmode3 == True:
        txt = txt + "(CHIRP)"
        
    y = y + 2 * Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    txt = "Mark: Frequency (Hz): " + str(LVLtone[1]) + " Level (%): " + str(LVL[1]) + PCTtodB(LVL[1])

    y = y + 2 * Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)
    
    txt = "Space: Frequency (Hz): " + str(LVLtone[0]) + " Level (%): " + str(LVL[0]) + PCTtodB(LVL[0])

    y = y + Linestep
    idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)

    y = y + Linestep
    
    n = 2
    while n < (MAXsignals + 2):
        txt = "Interferer " + str(n-1) + ": Frequency (Hz): " + str(LVLtone[n]) + " Level (%): " + str(LVL[n]) + PCTtodB(LVL[n])

        y = y + Linestep
        idTXT = ca.create_text (x, y, text=txt, font=INFOfont, anchor=W, fill=COLORtext)
        n = n + 1

    y = y + 2 * Linestep
    idTXT = ca.create_text (x, y, text=MSG, font=INFOfont, anchor=W, fill=COLORtext)

   
def MAKEmorse1():                                       # FSK-1 or FSK-2 mode, Standard morse with dots and dashes
    global LVLtone
    global LVL
    global SIGNALlevel
    global SAMPLErate
    global MORSEtext
    global MORSEtone
    global MORSE1halfshift
    global DOTtime
    global MSG
    global THEsignal

    TWOPI = math.pi * 2
    deltaphase1 = TWOPI / (float(SAMPLErate) / LVLtone[1])      # delta phase per sample for mark frequency
    deltaphase2 = TWOPI / (float(SAMPLErate) / LVLtone[0])      # delta phase per sample for space frequency

    if MORSE1halfshift == True:
        deltaphase1 = (deltaphase1 + deltaphase2) / 2           # Extra instruction for 50% frequency shift instead of 100%
    
    level1 = float(LVL[1]) * SIGNALlevel / 10000.0              # Level Morse
    level2 = float(LVL[0]) * SIGNALlevel / 10000.0              # Level Space
    
    DOTsamples = DOTtime * SAMPLErate

    M1 = len(THEsignal)
    
    phase = 0.0
    Mcount = 0
    while Mcount < len(MORSEtext):
        sign = MORSEtext[Mcount]

        TONEsamples = 0
        
        if sign == ".":
            MSG = "DOT"
            UpdateScreen()                          # UpdateScreen() call
            deltaphase = deltaphase1
            level = level1
            TONEsamples = DOTsamples
            
        if sign == "-":
            MSG = "DASH"
            UpdateScreen()                          # UpdateScreen() call
            deltaphase = deltaphase1
            level = level1
            TONEsamples = 3 * DOTsamples

        if sign != "." and sign != "-":             # Pause if no dot or dash
            MSG = "PAUSE"
            deltaphase = deltaphase2
            level = level2
            TONEsamples = 2 * DOTsamples
            UpdateScreen()                          # UpdateScreen() call
            
        i = 0
        while i < TONEsamples:
            x = math.sin(phase) * 32000.0 * level   # 32000 is volume, maximum 32767 for binary 2 bytes WAV file
            THEsignal.append(float(x))              # audio float takes more memory
            phase = phase + deltaphase              # add the deltaphase1 for mark or deltaphase2 for spaces
            if (phase > TWOPI):                     # if > 360 degrees (2*pi radialls), then substract 2*pi
                phase = phase - TWOPI               # so that phase is always between 0 and 2*pi
            i = i + 1

        TONEsamples = DOTsamples
        i = 0
        while i < TONEsamples:                      # Add samples for pause between dots and dashes
            x = math.sin(phase) * 32000.0 * level2  # 32000 is volume, maximum 32767 for binary 2 bytes WAV file
            THEsignal.append(float(x))              # audio float takes more memory
            phase = phase + deltaphase2             # add the deltaphase2 for spaces
            if (phase > TWOPI):                     # if > 360 degrees (2*pi radialls), then substract 2*pi
                phase = phase - TWOPI               # so that phase is always between 0 and 2*pi
            i = i + 1

        Mcount = Mcount + 1
    M2 = len(THEsignal)
    print "Morse1: ", int((M2-M1)/SAMPLErate)


def MAKEmorse2():                                   # FSK-3 mode with 3 tones and same dotlength for dot, dash and spaces
    global LVLtone
    global LVL
    global SIGNALlevel
    global SAMPLErate
    global MORSEtext
    global MORSEtone
    global DOTtime
    global MSG
    global THEsignal

    TWOPI = math.pi * 2
    deltaphase1 = TWOPI / (float(SAMPLErate) / LVLtone[1])      # delta phase per sample for dash frequency
    deltaphase3 = TWOPI / (float(SAMPLErate) / LVLtone[0])      # delta phase per sample for space frequency
    deltaphase2 = (deltaphase1 + deltaphase3) / 2               # dotfrequency between dash and space frequency
    
    level1 = float(LVL[1]) * SIGNALlevel / 10000.0              # Level Morse
    level2 = float(LVL[0]) * SIGNALlevel / 10000.0              # Level Space
    
    DOTsamples = int(1.5 * DOTtime * SAMPLErate)

    M1 = len(THEsignal)
    
    phase = 0.0
    Mcount = 0
    while Mcount < len(MORSEtext):
        sign = MORSEtext[Mcount]

        TONEsamples = 0
        
        if sign == ".":
            MSG = "DOT"
            UpdateScreen()                          # UpdateScreen() call
            deltaphase = deltaphase2
            level = level1
            TONEsamples = DOTsamples
            
        if sign == "-":
            MSG = "DASH"
            UpdateScreen()                          # UpdateScreen() call
            deltaphase = deltaphase1
            level = level1
            TONEsamples = DOTsamples

        if sign != "." and sign != "-":             # Pause if no dot or dash
            MSG = "PAUSE"
            deltaphase = deltaphase3
            level = level2
            TONEsamples = DOTsamples
            UpdateScreen()                          # UpdateScreen() call
            
        i = 0
        while i < TONEsamples:
            x = math.sin(phase) * 32000.0 * level   # 32000 is volume, maximum 32767 for binary 2 bytes WAV file
            THEsignal.append(float(x))              # audio float takes more memory
            phase = phase + deltaphase              # add the deltaphase1 for mark or deltaphase2 for spaces
            if (phase > TWOPI):                     # if > 360 degrees (2*pi radialls), then substract 2*pi
                phase = phase - TWOPI               # so that phase is always between 0 and 2*pi
            i = i + 1

        deltaphase = deltaphase3
        TONEsamples = DOTsamples
        i = 0
        while i < TONEsamples:                      # Add samples for pause between dots and dashes
            x = math.sin(phase) * 32000.0 * level2  # 32000 is volume, maximum 32767 for binary 2 bytes WAV file
            THEsignal.append(float(x))              # audio float takes more memory
            phase = phase + deltaphase3             # add the deltaphase2 for spaces
            if (phase > TWOPI):                     # if > 360 degrees (2*pi radialls), then substract 2*pi
                phase = phase - TWOPI               # so that phase is always between 0 and 2*pi
            i = i + 1

        Mcount = Mcount + 1
    M2 = len(THEsignal)
    print "Morse2: ", int((M2-M1)/SAMPLErate)


def MAKEmorse3():                                   # Chirp mode with slash /\ backslash and - for spaces, all same dotlength
    global LVLtone
    global LVL
    global SIGNALlevel
    global SAMPLErate
    global MORSEtext
    global MORSEtone
    global DOTtime
    global MSG
    global THEsignal

    DOTsamples = 3 * DOTtime * SAMPLErate

    M1 = len(THEsignal)
    
    TWOPI = math.pi * 2
    deltaphase1 = TWOPI / (float(SAMPLErate) / LVLtone[1])      # delta phase per sample for high frequency
    deltaphase2 = TWOPI / (float(SAMPLErate) / LVLtone[0])      # delta phase per sample for low frequency
    deltaphase3 = (deltaphase1 + deltaphase2) / 2               # dotfrequency space frequency3 in between

    SWEEPphase = TWOPI / (float(SAMPLErate) / LVLtone[0]) - TWOPI / (float(SAMPLErate) / LVLtone[1])

    adddelta1 = (deltaphase1 - deltaphase2) / DOTsamples        # Slope for dot
    adddelta2 = -adddelta1                                      # Slope for dash
   
    level1 = float(LVL[1]) * SIGNALlevel / 10000.0              # Level morse
    level2 = float(LVL[0]) * SIGNALlevel / 10000.0          # Level space
    
    phase = 0.0
    Mcount = 0
    while Mcount < len(MORSEtext):
        sign = MORSEtext[Mcount]

        TONEsamples = 0
        
        if sign == ".":
            MSG = "DOT"
            UpdateScreen()                          # UpdateScreen() call
            deltaphase = deltaphase2
            adddelta = adddelta1
            level = level1
            TONEsamples = DOTsamples
            
        if sign == "-":
            MSG = "DASH"
            UpdateScreen()                          # UpdateScreen() call
            deltaphase = deltaphase1
            adddelta = adddelta2
            level = level1
            TONEsamples = DOTsamples

        if sign != "." and sign != "-":             # Pause if no dot or dash
            MSG = "PAUSE"
            deltaphase = deltaphase3
            adddelta = 0.0
            level = level2
            TONEsamples = DOTsamples
            UpdateScreen()                          # UpdateScreen() call
            
        i = 0
        while i < TONEsamples:
            x = math.sin(phase) * 32000.0 * level   # 32000 is volume, maximum 32767 for binary 2 bytes WAV file
            THEsignal.append(float(x))              # audio float takes more memory
            phase = phase + deltaphase              # add the deltaphase1 for mark or deltaphase2 for spaces
            if (phase > TWOPI):                     # if > 360 degrees (2*pi radialls), then substract 2*pi
                phase = phase - TWOPI               # so that phase is always between 0 and 2*pi
            deltaphase = deltaphase + adddelta      # Increment frequency
            i = i + 1

        Mcount = Mcount + 1

    M2 = len(THEsignal)
    print "Morse3: ", int((M2-M1)/SAMPLErate)


def MAKEfading():
    global FADINGfreq
    global SIGNALlevel
    global SAMPLErate
    global MSG
    global THEsignal

    if FADINGfreq <= 0.0:
        return()

    TWOPI = math.pi * 2
    deltaphase = TWOPI / (float(SAMPLErate) / FADINGfreq)    # /2 as fading period is half of fading frequency

    phase = 0.0

    TONEsamples = len(THEsignal)

    i = 0
    while i < TONEsamples:
        level = (math.cos(phase) + 1.0) / 2.0
        v = float(THEsignal[i])
        v = v * level
        THEsignal[i] = v
        phase = phase + deltaphase
        i = i + 1        


def MAKEnoise():
    global THEsignal
    global SIGNALlevel
    global MSG                
    global NOISElevel

    if NOISElevel <= 0.0:
        MSG = "No noise"
        UpdateScreen()                          # UpdateScreen() call
        return()
    else:
        MSG = "Noise added"
        UpdateScreen()                          # UpdateScreen() call
        
        # random.seed(0)                        # Initialize random generator
        level = float(NOISElevel) * SIGNALlevel / 10000.0

        s = len(THEsignal)
        i = 0
        while (i < s):                          # fill list signal with sample values (floating point values)
            NOISE = 2 * random.random() - 1.0   # Get a random NOISE sample and convert to -1 / +1 range
            v = level * NOISE * 32000
            THEsignal[i] = THEsignal[i] + v
            i = i + 1


def MAKEinterferers():
    global LVLtone
    global LVL
    global MAXsignals
    global SIGNALlevel
    global SAMPLErate
    global MORSEtext
    global MORSEtone
    global DOTtime
    global MSG
    global THEsignal
    
    level = False
    n = 2
    while n < (MAXsignals+2):
        if LVL[n] > 0.0:                                        # Check for interferer levels
            level = True
        n = n + 1

    if level == False:                                          # Skip routine if no interferers to save (much) time
        return()

    MSG = "Make interferers"
    UpdateScreen()                                              # UpdateScreen() call

    TWOPI = math.pi * 2
    phase =[]
    deltaphase = []

    n = 2
    while n < (MAXsignals+2):                                   # Initialize the phases
        phase.append(0.0)
        FR = LVLtone[n]
        dphase = TWOPI / (float(SAMPLErate) / FR)               # Delta phase per sample 
        deltaphase.append(dphase)
        n = n + 1

    TONEsamples = len(THEsignal)    
    i = 0
    while i < TONEsamples:
        x = 0.0
        n = 0
        while n < MAXsignals:
            phase[n] = phase[n] + deltaphase[n]
            while (phase[n] > TWOPI):                           # If > 360 degrees (2*pi radialls), then substract 2*pi
                phase[n] = phase[n] - TWOPI                     #  so that phase is always between 0 and 2*pi
            level = float(LVL[n+2]) * SIGNALlevel / 10000.0
            x = x + level * math.sin(phase[n]) * 32000.0        # 32000 is just below maximum 32767 for binary 2 bytes
            n = n + 1

        THEsignal[i] = THEsignal[i] + x
        i = i + 1


def MAKEwavfile():
    global MSG
    global WAVfilename
    global SAMPLErate
    global THEsignal
    global WAVtime

    ssignal = ''                                        # buffer for list of binary values
    s = []
    le = len(THEsignal)
    WAVtime = int(le / SAMPLErate)
    sc = 0

    clipping = False
    
    i = 0
    while i < le:
        # ssignal += struct.pack('h', THEsignal[i])     # transform floating point list signal to binary array
        v = int(THEsignal[i])                           # Same routine but without struct   

        if v < -32000:                                  # Clipping!
            v = -32000.0
            clipping = True
        if v > 32000:
            clipping = True
            v = 32000.0
            
        if v < 0:
            v = v + 65536
            
        s.append(int(v % 256))
        s.append(int(v / 256))
        
        i = i + 1
        sc = sc + 1

        if sc == 500000:                                # 2 bytes per value
            sc = 0
            MSG = "Converted (Mb): " + str(int(i/500000)) + " of " + str(int(le/500000))
            UpdateScreen()                              # UpdateScreen() call

    THEsignal = []                                      # Free memory
    MSG = "Conversion to binary and save to WAV"
    UpdateScreen()                                      # UpdateScreen() call

    if clipping == True:                                # Clipped file warning
        showwarning("WARNING","Clipped WAV file!!!") 
        
    ssignal = array.array('B', s).tostring()            # Convert int to binary string with array module
    OUTwavfile(WAVfilename, SAMPLErate, ssignal)        # Write binary list to WAV file

    UpdateScreen()                                      # UpdateScreen() call


def OUTwavfile(WAVname, samplerate, ssignal):       # Save WAV file
    WAVf = wave.open(WAVname, 'wb')
    WAVf.setparams((1, 2, samplerate, 1, 'NONE', 'noncompressed'))
    WAVf.writeframes(ssignal)
    WAVf.close()


def Saveconfig(filename):           # Save the configuration
    global MORSEtext                # Morse text
    global SAMPLErate               # Sample rate of the WAV file 5512 for Lopora
    global DOTtime                  # DOT time in seconds
    global MORSE1halfshift          # Morse1 with 50% shift instead of 100%
    global MORSEmode1               # FSK2 morse code enabled
    global MORSEmode2               # FSK3 morse code enabled
    global MORSEmode3               # CHIRP morse code enabled
    global SIGNALlevel              # Level of whole signal in %
    global NOISElevel               # Noise level in %, 0.0 = OFF
    global FADINGfreq               # Fading frequency, 0.0 = OFF
    global MAXsignals               # Maximum numbers of signals
    global LVL                      # Level in dB
    global LVLtone                  # Tone height in Hz

    Wfile = open(filename,'w')          # output file setting

    S = ""
    while len(S) < 25:
        S = S + " "

    txt = "QRSS SIMULATION CONFIGURATION FILE\n"
    Wfile.write(txt)

    # Next
    txt = MORSEtext + "\n"
    Wfile.write(txt)

    txt = str(int(SAMPLErate))
    txt = txt + S[len(txt):] + "Sample rate of WAV file\n"
    Wfile.write(txt)

    # Next
    txt = str(int(DOTtime))
    txt = txt + S[len(txt):] + "DOT time of QRSS morse\n"
    Wfile.write(txt)

    # Next
    if MORSE1halfshift == True:
        txt = "1"
    else:
        txt = "0"
    txt = txt + S[len(txt):] + "1 for FSK2 morse with 50% shift instead of 100% shift\n"
    Wfile.write(txt)

    # Next
    if MORSEmode1 == True:
        txt = "1"
    else:
        txt = "0"

    if MORSEmode2 == True:
        txt = txt + "1"
    else:
        txt = txt + "0"
    
    if MORSEmode3 == True:
        txt = txt + "1"
    else:
        txt = txt + "0"

    txt = txt + S[len(txt):] + "(FSK2) (FSK3) (CHIRP) enabled or disabled\n"
    Wfile.write(txt)

    # Next
    txt = str(SIGNALlevel)
    txt = txt + S[len(txt):] + "Level of whole signal in %\n"
    Wfile.write(txt)

    # Next
    txt = str(NOISElevel)
    txt = txt + S[len(txt):] + "Noise level in %, 0.0 = OFF\n"
    Wfile.write(txt)

    # Next
    txt = str(FADINGfreq)
    txt = txt + S[len(txt):] + "Fading frequency, 0.0 = OFF\n"
    Wfile.write(txt)

    # Next
    txt = str(MAXsignals)
    txt = txt + S[len(txt):] + "Maximum numbers of signals\n"
    Wfile.write(txt)

    # Next (All signal levels)
    n = 0
    while n < (MAXsignals+2):
        txt = str(LVL[n])
        txt = txt + S[len(txt):]
        if n == 0:
            txt = txt + "Level of space\n"
        if n == 1:
            txt = txt + "Level of Mark\n"
        if n > 1:
            txt = txt + "Level of interferer " + str(n-1) + "\n"
        Wfile.write(txt)
        n = n + 1

    # Next (All signal frequencies)
    n = 0
    while n < (MAXsignals+2):
        txt = str(LVLtone[n])
        txt = txt + S[len(txt):]
        if n == 0:
            txt = txt + "Frequency of space\n"
        if n == 1:
            txt = txt + "Frequency of Mark\n"
        if n > 1:
            txt = txt + "Frequency of interferer " + str(n-1) + "\n"
        Wfile.write(txt)
        n = n + 1

    Wfile.close()           # Close the file


def Recallconfig(filename):
    global MORSEtext                # Morse text
    global SAMPLErate               # Sample rate of the WAV file 5512 for Lopora
    global DOTtime                  # DOT time in seconds
    global MORSE1halfshift          # Morse1 with 50% shift instead of 100%
    global MORSEmode1               # FSK2 morse code enabled
    global MORSEmode2               # FSK3 morse code enabled
    global MORSEmode3               # CHIRP morse code enabled
    global SIGNALlevel              # Level of whole signal in %
    global NOISElevel               # Noise level in %, 0.0 = OFF
    global FADINGfreq               # Fading frequency, 0.0 = OFF
    global MAXsignals               # Maximum numbers of signals
    global LVL                      # Level in dB
    global LVLtone                  # Tone height in Hz

    try:
        Rfile = open(filename,'r')      # open the input file with settings
    except:
        return()

    try:
        txt = Rfile.readline()          # read the first line, do nothing with it, it is just a description
    except:
        pass
    
    # Next
    try:
        txt = Rfile.readline()          # read the next line
        MORSEtext = txt[0:-1]           # delete carriage return by [0:-1] addition
    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        SAMPLErate = int(txt[:20])
        if SAMPLErate < 1200:
            SAMPLErate = 1200
        if SAMPLErate > 48000:
            SAMPLErate = 48000
    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        DOTtime = float(txt[:20])
    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        if txt[0] == "1":
            MORSE1halfshift = True
        else:
            MORSE1halfshift = False
    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        if txt[0] == "1":
            MORSEmode1 = True
        else:
            MORSEmode1 = False

        if txt[1] == "1":
            MORSEmode2 = True
        else:
            MORSEmode2 = False

        if txt[2] == "1":
            MORSEmode3 = True
        else:
            MORSEmode3 = False

    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        SIGNALlevel = float(txt[:20])
    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        NOISElevel = float(txt[:20])
    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        FADINGfreq = float(txt[:20])
    except:
        pass

    # Next
    try:
        txt = Rfile.readline()          # read the next line
        MAXsignals = int(txt[:20])
        if MAXsignalsv < 2:
            MAXsignals = 2
    except:
        pass

    # Next
    n = 0
    while n < (MAXsignals+2):
        try:
            txt = Rfile.readline()          # read the next line
            LVL[n] = float(txt[:20])
            n = n + 1
        except:
            pass

    # Next
    n = 0
    while n < (MAXsignals+2):
        try:
            txt = Rfile.readline()          # read the next line
            LVLtone[n] = float(txt[:20])
            n = n + 1
        except:
            pass

    Rfile.close()                       # Close the file


def PCTtodB(P):                         # Convert percents in dB (0 dB is 1%) and round to 0.1
    sign = 1
      
    try:
        v = 20 * math.log10(P)
        v = v * 10
        if v < 0:
            sign = -1
            v = -v
        txt = str(int(v + 0.5))
        if len(txt) < 2:
            txt = "0" + txt
        txt = txt[0:len(txt)- 1] + "." + txt[len(txt)-1] + " dB)"
        if sign > 0:
            txt = " (+" + txt
        else:
            txt = " (-" + txt
    except:                             # Error if dB from 0%
        txt = " ( --.- dB)"

    return(txt)

    
# ================ Make Screen ==========================

root=Tk()
root.title("QRSS simulation WAV file creator QRSSsimwav-v01a.py(w) (05-06-2012) ")

root.minsize(100, 100)

frame1 = Frame(root, background=COLORframes, borderwidth=5, relief=RIDGE)
frame1.pack(side=TOP, expand=1, fill=X)

frame2 = Frame(root, background="black", borderwidth=5, relief=RIDGE)
frame2.pack(side=TOP, expand=1, fill=X)

frame3 = Frame(root, background=COLORframes, borderwidth=5, relief=RIDGE)
frame3.pack(side=TOP, expand=1, fill=X)

ca = Canvas(frame2, width=CANVASwidth, height=CANVASheight, background=COLORcanvas)
ca.pack(side=TOP)

b = Button(frame1, text="Save setting", width=Buttonwidth1, command=BSave)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame1, text="Recall setting", width=Buttonwidth1, command=BRecall)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame1, text="Make WAV", width=Buttonwidth1, command=BMAKEwav)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame1, text="Sample Rate", width=Buttonwidth1, command=BSAMPLErate)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame3, text="Morse text", width=Buttonwidth2, command=BMORSEtext)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="DOT time", width=Buttonwidth2, command=BDOTtime)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Morse modes", width=Buttonwidth2, command=BMORSEmodes)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Morse signal", width=Buttonwidth2, command=BMORSEsignal)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Fading", width=Buttonwidth2, command=Bfading)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Noise", width=Buttonwidth2, command=Bnoise)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Interferers", width=Buttonwidth2, command=Binterferer)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame3, text="Signal Level", width=Buttonwidth2, command=Bsignallevel)
b.pack(side=RIGHT, padx=5, pady=5)


# Fonts, after initialisation of the tk screen! 
INFOfont = tkFont.Font(size=INFOfontsize)
# INFOfont = tkFont.Font(family="Helvetica", size=INFOfontsize, weight="bold")

# ================ Call main routine ===============================
Mainloop()
 


