; DDS2.ASM
; Version 1.0 of March 28, 2004 
; DDS generator for phase/frequency detector with extra free pin
; Speed up/down with up/down tuning keys
; x-tal frequency 11999.55 kHz

; D0: D/A bit0
; D1: D/A bit1
; D2: D/A bit2
; D3: D/A bit3
; D4: D/A bit4
; D5: D/A bit5
; D6: D/A bit6
; B0: Display on/off switch
; B1: 7seg_a + dash paddle for freq--
; B2: 7seg_b + Display On if zero
; B3: 7seg_c + Display On if zero
; B4: 7seg_d + dot paddle for freq++
; B5: 7seg_e + speed
; B6: 7seg_f + display on
; B7: 7seg_g

.nolist
.include "1200def.inc"
.list

; main program register variables


.def    DDSreg0    =r0     ;DDS register 
.def    DDSreg1    =r1     ;DDS register 
.def    DDSreg2    =r2     ;DDS register 
.def    DDSreg3    =r3     ;DDS register 
.def    SUMreg0    =r4     ;Sum register = 36352 * frequency in kHz
.def    SUMreg1    =r5     ;Sum register
.def    SUMreg2    =r6     ;Sum register
.def    SUMreg3    =r7     ;Sum register
.def	Selcnt_lo  =r8     ;Counter-lo for selection of switches
.def	Selcnt_hi  =r9     ;Counter-hi for selection of switches


.def    SetPort    =r14    ;Input/output settings
.def    Zero       =r15    ;Zero

; >16 full instruction registers

.def    varX       =r16    ;General variable
.def    varY       =r17    ;General variable
.def    varZ       =r18    ;General variable
.def	Dispstate  =r19    ;Display status
.def	Speed      =r20    ;Tune speed
.def	Speedcnt   =r21    ;Counter for speed actions
.def	displaycnt =r22    ;Counter for display actions

.def	Display0   =r23	   ;less than 1 kHz, 0-63 is 0 - 1 kHz in 1000/64 steps
.def	Display1   =r24	   ;1 kHz
.def	Display2   =r25	   ;10 kHz
.def	Display3   =r26	   ;100 kHz
.def	Display4   =r27	   ;1 MHz
.def	Display5   =r28	   ;10 MHz
.def    Selection  =r29    ;Selection status


; code      


RESET:  

Clear_var:                       ;Clear all variables
        clr     varX             ;Make varX Zero
        ldi     ZL,29            ;From reg 29 to 0
Clear_varloop:
        st      Z,varX           ;Clear register with value in ZL (r30)
        dec     ZL               ;Decrement ZL (r30)
        brne    Clear_varloop    ;r30 not cleared, is ZL

Set_variables:
        ldi     Speed,6          ;Highest tune speed 100 kHz, lowest 15.625 Hz  
        ldi     Displaycnt,1     ;Initialize to 1

Set_ports:
        ldi     varX,0b11111111 
        mov     SetPort,varX
        out     DDRB,SetPort     ;Set B1-7 to output
        out     PORTB,Zero       ;Set outputs and pull up resistors
        out     DDRD,SetPort     ;Set D0-D7 as output

Initialize_freq:                 ;Freq = 36352 * freq (kHz) 
        ldi     varX,0x15        ;Store for 10120 MHz
        mov     SUMreg3,varX     ;MSB
        ldi     varx,0xED
        mov     SUMreg2,varX
        ldi     varx,0x70
        mov     SUMreg1,varX
        ldi     varx,0x00
        mov     SUMreg0,varX     ;LSB
	ldi	Display5,1       ;MSdigit
	ldi	Display4,0
	ldi	Display3,1
	ldi	Display2,2
	ldi	Display1,0       ;LSdigit
	ldi	Display0,0       ;Always Zero


;=============================================================================
Main_loop0:
        nop	                 ;Time correction for 13 cycli
Main_loop0a:
	nop	                 ;Time correction for 13 cycli
Main_loop:
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 
	inc     Selcnt_lo        ;Increment Selection counter_lo byte 
        brne    Main_loop0       ;If not zero then Main_loop0
        cbi     PORTB,0          ;Enable Phase detector after 256 cycles if disabled (pin0=1!) 
        nop
    
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 
        ldi     varY,20          ;Loop nX, here already initialized for Main_Sel_delay as here free cycle available
	inc     Selcnt_hi        ;Increment Selection counter_hi byte 
        brne    Main_loop0a      ;If not zero then Main_loop
        nop

Main_Selection:
        in	varZ,PORTB       ;Store PORTB
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 
	ldi     varX,0b00001101  ;Set B0, B2, B3 output, rest to input
        out     DDRB,varX
        ldi     varX,0b00001100  ;B0=0 for Phase det enable, B2-3 for display off, rest pull up resistors off
        out     PORTB,varX       ;Set 

Main_Sel_delay:	
        nop
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD
        nop	                 ;Time correction for 13 cycli 
        dec	varY             ;Decrement delay counter
        brne    Main_Sel_delay   ;Loop if not zero
	
        in	Selection,PINB   ;Input switch settings
        com     Selection        ;Invert bits as a 0 is active
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 
        out     DDRB,SetPort     ;Set B0-7 to output
        out     PORTB,varZ       ;Restore PORTB
        mov     varY,Selection   ;Store Selection in varY for selection test
   	andi	varY,0b00110010  ;Test the input bits, except display
	brne	Action

Main_testDisplay:
	add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 
        sbrs    Selection,6      ;Skip next if display not activated      
        rjmp    Main_reset_variables; Nothing selected


        dec     Displaycnt       ;Decrement Displaycnt
        brne    Main_DisplayEnd  ;If > 0 then Main_loop via DisplayEnd

        rjmp    SubDisplay       ;Only rjmp (low clock speed) if Displaycnt=0

Main_DisplayEnd:                 ;Added as the brcc was out of branch
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 
        nop                      ;Timing
        rjmp    Main_loop0       ;Main_loop with high clock speed if Displaycnt!=0



Main_reset_variables:            ;Reset variables if nothing selected
	ldi	Displaycnt,1     ;Reset displaycnt if nothing selected
        ldi     Dispstate,0      ;Reset display status if nothing selected
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 
        ldi	Speedcnt,0       ;Reset Speedcnt if nothing selected
        ldi     varX,0b11111110  ;Set B1-7 to off state for LED, B0 for phase det enabled 
        out     PORTB,varx	 ;
	rjmp	Main_loop	 ;Goto mainloop

;=======================================================================


Action:
        sbrc	Selection,5      ;Change speed
	rjmp	SubSpeed
        sbi     PORTB,0          ;Disable Phase detector (pin0=1!)
	sbrc	Selection,1      ;Tune a step down
	rcall	SubTuneL
	sbrc	Selection,4      ;Tune a step up
	rcall	SubTuneH

	rjmp	Main_loop        ;Only if there is an error!


SubTuneL:
        ldi	Speedcnt,0       ;Reset Speedcnt if tuning activated
        ldi	Displaycnt,1     ;Reset displaycnt if tuning activated
        ldi     Dispstate,0      ;Reset display status if tuning activatedd
	 
        ldi     varX,0b11111111  ;Set B1-7 to off state for LED, B0 for phase det disabled
        out     PORTB,varx	 ;

        mov     varX,Display5
        swap    varX
        or      varX,Display4        
        cpi     varX,1           ;Test for 1 MHz
        brsh    SubTuneL0
       	rjmp	Main_loop        ;Return if lower than 1 MHz
SubTuneL0:
        rcall   SubStep          ;Set the frequency step size         
        sub     SUMreg0,varX     ;Substract without carry
        sbc     SUMreg1,varY     ;Substract with carry
        sbc     SUMreg2,varZ     ;Substract with carry
        sbc     SUMreg3,Zero

        rcall   subAdd8x

        cpi     Speed,1 
        brne    SubTuneL1
        subi    Display0,1       ;Substract 15.625Hz
SubTuneL1:
        cpi     Speed,2 
        brne    SubTuneL2
        subi    Display0,2       ;Substract 31.25Hz
SubTuneL2:
        cpi     Speed,3 
        brne    SubTuneL3
        subi    Display0,4       ;Substract 63Hz
SubTuneL3:
        cpi     Speed,4 
        brne    SubTuneL4
        subi    Display1,1       ;Substract 1kHz
SubTuneL4:
        cpi     Speed,5 
        brne    SubTuneL5
        subi    Display2,1       ;Substract 10kHz
SubTuneL5:
        cpi     Speed,6 
        brne    SubTuneL6
        subi    Display3,1       ;Substract 100kHz
SubTuneL6:

SubLreg:                         ;Correct the registers
        sbrc    Display0,7       ;Correct the next registers for overflow
        dec     Display1
        sbrc    Display1,7
        dec     Display2
        sbrc    Display2,7
        dec     Display3
        sbrc    Display3,7
        dec     Display4
        sbrc    Display4,7
        dec     Display5

        sbrc    Display0,7       ;Correct the registers in range             
        subi    Display0,-64     
        sbrc    Display1,7                
        subi    Display1,-10     
        sbrc    Display2,7                
        subi    Display2,-10     
        sbrc    Display3,7                
        subi    Display3,-10     
        sbrc    Display4,7                
        subi    Display4,-10     
        sbrc    Display5,7                
        subi    Display5,-10     

        rcall   subAdd8x

        ldi     varX,15
SubLregDelay:
        dec     varX
        brne    SubLregDelay
        rjmp	Main_loop 


SubTuneH:
        ldi	Speedcnt,0       ;Reset Speedcnt if tuning activated
        ldi	Displaycnt,1     ;Reset displaycnt if tuning activated
        ldi     Dispstate,0      ;Reset display status if tuning activated
	
        ldi     varX,0b11111111  ;Set B1-7 to off state for LED, B0 for phase det disabled
        out     PORTB,varx	 ;


        mov     varX,Display5
        swap    varX
        or      varX,Display4        
        cpi     varX,57         ;Test for 39 MHz
        brlo    SubTuneH0
	rjmp	Main_loop        ;Return if higher than 39 MHz, else SubTuneH0

SubTuneH0:
        rcall   SubStep          ;Set the frequency step size         
        add     SUMreg0,varX     ;Add without carry
        adc     SUMreg1,varY     ;Add with carry
        adc     SUMreg2,varZ     ;Add with carry
        adc     SUMreg3,Zero

        rcall   subAdd8x

        subi    Display0,-192    ;Add values to be able to use carry overflow in the calculations
        subi    Display1,-246
        subi    Display2,-246
        subi    Display3,-246
        subi    Display4,-246
        subi    Display5,-246

        cpi     Speed,1 
        brne    SubTuneH1
        subi    Display0,-1       ;Add 15.625Hz
SubTuneH1:
        cpi     Speed,2 
        brne    SubTuneH2
        subi    Display0,-2       ;Add 31.25Hz
SubTuneH2:
        cpi     Speed,3 
        brne    SubTuneH3
        subi    Display0,-4       ;Add 63Hz
SubTuneH3:
        cpi     Speed,4 
        brne    SubTuneH4
        subi    Display1,-1       ;Add 1kHz
SubTuneH4:
        cpi     Speed,5 
        brne    SubTuneH5
        subi    Display2,-1       ;Add 10kHz
SubTuneH5:
        cpi     Speed,6 
        brne    SubTuneH6
        subi    Display3,-1       ;Add 100kHz
SubTuneH6:


SubHreg:                         ;Correct the registers
        sbrs    Display0,7       ;Correct the next registers for overflow
        inc     Display1
        sbrs    Display1,7
        inc     Display2
        sbrs    Display2,7
        inc     Display3
        sbrs    Display3,7
        inc     Display4
        sbrs    Display4,7
        inc     Display5

        sbrc    Display0,7       ;Correct the registers in range             
        subi    Display0,192    
        sbrc    Display1,7                
        subi    Display1,246     
        sbrc    Display2,7              
        subi    Display2,246    
        sbrc    Display3,7                
        subi    Display3,246     
        sbrc    Display4,7                
        subi    Display4,246     
        sbrc    Display5,7                
        subi    Display5,246     

        rcall   subAdd8x

        ldi     varX,12
SubHregDelay:                    ;Timing correction
        dec     varX
        brne    SubHregDelay
        rjmp	Main_loop0a



SubSpeed:
        ldi	Displaycnt,1     ;Reset displaycnt when speed is selected
        ldi     Dispstate,0      ;Reset display status when speed is selected
	rcall   subAdd8x         ;DDS 8x 
	mov	varX,Speed       ;Display the current speed 
	rcall	sub7segval       ;Set 7 segments value
        out	PORTB,varY

        mov     varY,Selection   ;Test if no key pressed 
        andi    varY,0b00010010  ;If no key pressed, set Speedcnt to 1 
        brne    SubSpeedTimeChk  ;and continue not to Main-loop but      
        ldi     Speedcnt,1       ;to SubSpeedTimeChk for easy correct timing 
        
SubSpeedTimeChk:
        cpi     Speedcnt,0
        breq    SubSpeedUpDwn    ;If 0 then test for up/down keys 
        dec     Speedcnt         ;Else decrement and exit
	
        ldi     varX,4
SubSpeed0Delay:
        dec     varX
        brne    SubSpeed0Delay

        rjmp	Main_loop0       ;return without speed change

SubSpeedUpDwn:
        ldi	Speedcnt,12      ;Set Speedcnt, next speed change if 0

SubSpeed1:
        sbrc	Selection,1      ;A step down
	dec	Speed            ;Decrement speed if down key pressed  
        sbrc	Selection,4      ;A step up
	inc	Speed            ;Increment speed if up key pressed 
	cpi	Speed,0          ;If <1 then reset to 6
	brne	SubSpeed2
	ldi	Speed,6
SubSpeed2:
	cpi	Speed,7          ;If 7 then reset to 1
	brlo	SubSpeed3
	ldi	Speed,1
        
SubSpeed3:

        ldi     varX,1
SubSpeed2Delay:
        dec     varX
        brne    SubSpeed2Delay
  
        rjmp	Main_loop        ;return with speed change



SubDisplay:
        sbi     PORTB,0          ;Disable Phase detector (pin0=1!)
        ldi	Speedcnt,0       ;Reset speedcnt when display is selected

	rcall   subAdd8x         ;DDS 8x
SubDisplayStart:
        ldi     varX,255         ;Load value above 9 for display off
	ldi     Displaycnt,1     ;Load with pause, display off for 1 period

SubDisplayStart0:
        cpi     Speed,5          ;Check speed for MHz / kHz display
        brlo    SubDisplaykHz    ;if fast, display MHz, else kHz

subDisplayMHz:
        cpi     Dispstate,1      ;State 1
	brne    SubDisplayMHz3   ;If not then skip
        mov     varX,Display5    ;Load digit 1 to display
	ldi     Displaycnt,5     ;on for N periods
subDisplayMHz3:
        cpi     Dispstate,3      ;State 3
	brne    SubDisplayMHz5   ;If not then skip
        mov     varX,Display4    ;Load digit 2 to display
	ldi     Displaycnt,3     ;on for N periods
subDisplayMHz5:
        cpi     Dispstate,5      ;State 5
	brne    SubDisplayMHz6   ;If not then skip
        mov     varX,Display3    ;Load digit 3 to display
	ldi     Displaycnt,3     ;on for N periods
subDisplayMHz6:
        rjmp    subDisplayValue  ;

subDisplaykHz:
        cpi     Dispstate,1      ;State 1
	brne    SubDisplaykHz3   ;If not then skip
        mov     varX,Display3    ;Load digit 1 to display
	ldi     Displaycnt,5     ;on for N periods
subDisplaykHz3:
        cpi     Dispstate,3      ;State 3
	brne    SubDisplaykHz5   ;If not then skip
        mov     varX,Display2    ;Load digit 2 to display
	ldi     Displaycnt,3     ;on for N periods
subDisplaykHz5:
        cpi     Dispstate,5      ;State 5
	brne    SubDisplaykHz6   ;If not then skip
        mov     varX,Display1    ;Load digit 3 to display
	ldi     Displaycnt,3     ;on for N periods
subDisplaykHz6:
        nop                      ;Time correction MHz kHz difference

subDisplayValue:
        rcall   sub7segval       ;Set value for 7 segment
        out	PORTB,varY       ;Set output port to digit

        cpi     Dispstate,6      ;State 6 is long pause
        brne    subDisplayState  ;If not then skip
        ldi     Displaycnt,50    ;Set long pause to approx N/10 sec
        nop

subDisplayState:
	inc	Dispstate        ;Increment Display state
        cpi     Dispstate,7      ;Reset from State 7 to 0
        brne    subDisplayState1 ;If not then skip
        ldi     Dispstate,0      ;Reset to 0
subDisplayState1:

subDisplayCorrection_pause:
        cpi     Displaycnt,1     ;If short pauze then extra time correction 
        brne    subDisplayCorrection;
        rjmp    SubDisplayCorrection;

subDisplayCorrection:	         ;Extra correction 
        add     DDSreg0,SUMreg0  ;Add the sumregisters to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 

        nop
        rjmp    Main_loop0        ;Goto Main_loop after display of new digit


;==============================================================================================
sub7segval:		         ; Calculate 7 segments port value
  	ldi	varY,0b11111111  ; 255=All characters off, Phase det disabled if pin0=1      
        cpi	varX,0
	brne	sub7segval1
	ldi	varY,0b10000001
sub7segval1:
	cpi	varX,1
	brne	sub7segval2
	ldi	varY,0b11110011
sub7segval2:
	cpi	varX,2
	brne	sub7segval3
	ldi	varY,0b01001001
sub7segval3:
	cpi	varX,3
	brne	sub7segval4
	ldi	varY,0b01100001
sub7segval4:
	cpi	varX,4
	brne	sub7segval5
	ldi	varY,0b00110011
sub7segval5:
	cpi	varX,5
	brne	sub7segval6
	ldi	varY,0b00100101
sub7segval6:
	cpi	varX,6
	brne	sub7segval7
	ldi	varY,0b00000101
sub7segval7:
	cpi	varX,7
	brne	sub7segval8
	ldi	varY,0b11110001
sub7segval8:
	cpi	varX,8
	brne 	sub7segval9
	ldi	varY,0b00000001
sub7segval9:
	cpi	varX,9
	brne	sub7segval10
	ldi	varY,0b00100001
sub7segval10:
	ret



subAdd8x:			 ;Add DDS 8x normal value for 1/8 of the normal speed operation
                 		 	
        lsl	SUMreg0		 ;X2 + carry
	rol	SUMreg1
	rol	SUMreg2
	rol	SUMreg3


	add     DDSreg0,SUMreg0  ;Add the sumregisters x2 to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        add     DDSreg0,SUMreg0  ;Add the sumregisters x4 to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        add     DDSreg0,SUMreg0  ;Add the sumregisters x6 to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB
        add     DDSreg0,SUMreg0  ;Add the sumregisters x8 to the DDS register 
        adc     DDSreg1,SUMreg1
        adc     DDSreg2,SUMreg2
        adc     DDSreg3,SUMreg3  ;MSB

        mov     varX,DDSreg3     ;MSByte in varX 
        sbrc    varX,7           ;Generate down ramp if bit7=1
        com     varX
        out     PORTD,varX       ;To A/D output PORTD 

        lsr	SUMreg3		 ;/2 + carry
	ror	SUMreg2
	ror	SUMreg1
	ror	SUMreg0

	ret			 



SubStep:        		 ;Set varX, varY and varZ to the step value
        cpi     Speed,1          ;568 (0x238) is 15.625 Hz step
        brne    SubStep1
        ldi     varX,0x38
        ldi     varY,0x02
        ldi     varZ,0
SubStep1:
        cpi     Speed,2          ;1136 (0x470) is 31.25 Hz step
        brne    SubStep2
        ldi     varX,0x70
        ldi     varY,0x4
        ldi     varZ,0
SubStep2:
        cpi     Speed,3          ;2272 0x8E0 is 63 Hz step
        brne    SubStep3
        ldi     varX,0xE0
        ldi     varY,0x08
        ldi     varZ,0
SubStep3:
        cpi     Speed,4          ;36352 (0x008E00) is 1 kHz step
        brne    SubStep4
        ldi     varX,0x00
        ldi     varY,0x8E
        ldi     varZ,0
SubStep4:
        cpi     Speed,5          ;363520 (0x058C00) is 10 kHz step
        brne    SubStep5
        ldi     varX,0x00
        ldi     varY,0x8C
        ldi     varZ,0x05
SubStep5:
        cpi     Speed,6          ;3635200 (0x377800) is 100 kHz step
        brne    SubStep6
        ldi     varX,0x00
        ldi     varY,0x78
        ldi     varZ,0x37
SubStep6:
        ret