VERSION 5.00
Begin VB.Form Form1 
   BackColor       =   &H8000000B&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Audio Spectrum Analyzer PA2OHH V1.1 800x600 screen"
   ClientHeight    =   8160
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   11850
   BeginProperty Font 
      Name            =   "MS Serif"
      Size            =   6
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "SpecDisplay.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   544
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   790
   StartUpPosition =   2  'CenterScreen
   Begin VB.VScrollBar scrUpdateTime 
      Height          =   855
      Left            =   3120
      Max             =   0
      Min             =   40
      TabIndex        =   38
      Top             =   7200
      Width           =   255
   End
   Begin VB.VScrollBar scrT2Offset 
      Height          =   1455
      Left            =   3120
      Max             =   60
      Min             =   -60
      TabIndex        =   34
      Top             =   3120
      Width           =   255
   End
   Begin VB.Frame frmSpecialScreens 
      Caption         =   "Special screens"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   735
      Left            =   120
      TabIndex        =   31
      Top             =   7320
      Width           =   2295
      Begin VB.CheckBox chkBW 
         Caption         =   "B/W"
         CausesValidation=   0   'False
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1320
         TabIndex        =   33
         Top             =   360
         Width           =   855
      End
      Begin VB.CheckBox chkSmall 
         Caption         =   "Small"
         CausesValidation=   0   'False
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   32
         Top             =   360
         Width           =   975
      End
   End
   Begin VB.Frame frmBrightness 
      Caption         =   "Brightness"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   120
      TabIndex        =   26
      Top             =   6000
      Width           =   2295
      Begin VB.HScrollBar scrBckBrightness 
         Height          =   255
         Left            =   120
         Max             =   255
         TabIndex        =   28
         Top             =   720
         Width           =   1335
      End
      Begin VB.HScrollBar scrGridBrightness 
         Height          =   255
         Left            =   120
         Max             =   255
         TabIndex        =   27
         Top             =   360
         Value           =   255
         Width           =   1335
      End
      Begin VB.Label Label8 
         Caption         =   "Back"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1560
         TabIndex        =   30
         Top             =   720
         Width           =   495
      End
      Begin VB.Label Label7 
         Caption         =   "Grid"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1560
         TabIndex        =   29
         Top             =   360
         Width           =   375
      End
   End
   Begin VB.Frame frmMemory 
      Caption         =   "Trace 2 Memory"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1935
      Left            =   120
      TabIndex        =   22
      Top             =   3960
      Width           =   2295
      Begin VB.CommandButton cmdTracemath 
         Caption         =   "Trace 1- Trace 2 ON"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   25
         Top             =   1320
         Width           =   1935
      End
      Begin VB.CommandButton cmdDisplaytrace 
         Caption         =   "Display Trace 2"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   24
         Top             =   840
         Width           =   1935
      End
      Begin VB.CommandButton cmdStore 
         Caption         =   "Store Trace 2"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   23
         Top             =   360
         Width           =   1935
      End
   End
   Begin VB.Frame frmTrace 
      Caption         =   "Trace"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2295
      Left            =   120
      TabIndex        =   16
      Top             =   1560
      Width           =   2295
      Begin VB.CheckBox chkOverWrite 
         Caption         =   "Overwrite"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   37
         Top             =   1920
         Width           =   1095
      End
      Begin VB.HScrollBar scrAVG 
         Height          =   255
         Left            =   240
         Max             =   100
         Min             =   1
         TabIndex        =   20
         Top             =   1440
         Value           =   10
         Width           =   1335
      End
      Begin VB.OptionButton optNormal 
         Caption         =   "Normal"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   240
         TabIndex        =   19
         Top             =   360
         Value           =   -1  'True
         Width           =   1335
      End
      Begin VB.OptionButton optAverage 
         Caption         =   "Average"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   240
         TabIndex        =   18
         Top             =   1080
         Width           =   1335
      End
      Begin VB.OptionButton optMaxhold 
         Caption         =   "Max Hold"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   240
         TabIndex        =   17
         Top             =   720
         Width           =   1335
      End
      Begin VB.Label lblAV 
         Caption         =   "Av 10"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   1680
         TabIndex        =   21
         Top             =   1440
         Width           =   495
      End
   End
   Begin VB.Frame frmSample 
      Caption         =   "Sampling"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   120
      TabIndex        =   11
      Top             =   120
      Width           =   2295
      Begin VB.ComboBox cboSRate 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         ItemData        =   "SpecDisplay.frx":000C
         Left            =   240
         List            =   "SpecDisplay.frx":001F
         TabIndex        =   14
         Text            =   "48000"
         Top             =   360
         Width           =   1215
      End
      Begin VB.ComboBox cboBins 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   240
         TabIndex        =   12
         Text            =   "2048"
         Top             =   840
         Width           =   1215
      End
      Begin VB.Label Label4 
         Caption         =   "Rate"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1560
         TabIndex        =   15
         Top             =   360
         Width           =   615
      End
      Begin VB.Label Label1 
         Caption         =   "Samples"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1560
         TabIndex        =   13
         Top             =   840
         Width           =   615
      End
   End
   Begin VB.VScrollBar scrdBdiv 
      Height          =   1215
      Left            =   3120
      Max             =   2
      Min             =   10
      TabIndex        =   8
      Top             =   5280
      Value           =   10
      Width           =   255
   End
   Begin VB.VScrollBar scrReflvl 
      Height          =   1455
      Left            =   3120
      Max             =   60
      Min             =   -60
      TabIndex        =   7
      Top             =   720
      Width           =   255
   End
   Begin VB.TextBox txtMessage 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5280
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   6
      Text            =   "SpecDisplay.frx":0045
      Top             =   7440
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.TextBox txtFMax 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   10680
      TabIndex        =   5
      Top             =   7440
      Width           =   855
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   7095
      Left            =   3600
      ScaleHeight     =   1443.077
      ScaleMode       =   0  'User
      ScaleTop        =   1000
      ScaleWidth      =   541
      TabIndex        =   4
      Top             =   240
      Width           =   8175
   End
   Begin VB.TextBox txtFMin 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   4200
      TabIndex        =   1
      Top             =   7440
      Width           =   855
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   9480
      Top             =   7560
   End
   Begin VB.CommandButton CmdSwitch 
      Caption         =   "Freeze"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6840
      TabIndex        =   0
      Top             =   7440
      Width           =   1575
   End
   Begin VB.Label lblTime 
      Alignment       =   1  'Right Justify
      Caption         =   "T= 0 ms"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   39
      Top             =   6840
      Width           =   855
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "T2 offset:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   36
      Top             =   2520
      Width           =   855
   End
   Begin VB.Label lblT2Offset 
      Alignment       =   1  'Right Justify
      Caption         =   "0 dB"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2760
      TabIndex        =   35
      Top             =   2760
      Width           =   615
   End
   Begin VB.Label lbldBdiv 
      Alignment       =   1  'Right Justify
      Caption         =   "10 dB/div"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   10
      Top             =   4920
      Width           =   855
   End
   Begin VB.Label lblReflvl 
      Alignment       =   1  'Right Justify
      Caption         =   "Ref: 0 dB"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2520
      TabIndex        =   9
      Top             =   360
      Width           =   855
   End
   Begin VB.Label Label3 
      Caption         =   "F-Min"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3600
      TabIndex        =   3
      Top             =   7440
      Width           =   495
   End
   Begin VB.Label Label2 
      Caption         =   "F-Max"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   10080
      TabIndex        =   2
      Top             =   7440
      Width           =   495
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Spectrum analyzer based on the source code of:
'email: takisfmf@yahoo.gr
'for more source code visit
'http://www.geocities.com/takisfmf/index.html
'Special version for 800x600 screen

Option Explicit

Dim dblNbins As Double          'Number of points in the DFT,
Dim REX(16384) As Double        'Real part of input
Dim IMX(16384) As Double        'Imaginary part of input
Dim DISPLAYtrc(8193) As Double  'Trace to display
Dim MEMORYtrc(8193) As Double   'Memory trace to display / calculate
Dim TRACE1_X(8193) As Double    'Trace1 to display 8192+1
Dim TRACE1_Y(8193) As Double    'Trace1 to display
Dim TRACE2_X(8193) As Double    'Trace2 to display
Dim TRACE2_Y(8193) As Double    'Trace2 to display
Dim strMemoryBins As String     'Number of bins coupled to memory trace
Dim blnMEMdisplay As Boolean
Dim blnMEMminustrc As Boolean
Dim blnCMDswitch As Boolean     'False if freezed, true if running
Dim dblSampleValue As Double
Dim lngTraceColor As Long
Dim lngGridBrightness As Long
Dim lngBckBrightness As Long
Dim sngReflvl As Single
Dim sngOffset As Single
Dim sngdBdiv As Single

Public lngSampleRate As Long


Private Sub cboBins_Click()
    If blnCMDswitch = True Then Call StopInput

    dblNbins = Val(cboBins.Text)
    BUFFER_SIZE = dblNbins * 2    'Must be at least 2 * max number of bins
 
    If blnCMDswitch = True Then Call StartInput
 End Sub

Private Sub cboSRate_Click()
    If blnCMDswitch = True Then Call StopInput

    lngSampleRate = Val(cboSRate.Text)
    
    If blnCMDswitch = True Then Call StartInput
 End Sub

Private Sub chkBW_Click()
    Call MakeDisplayTrace(dblNbins / 2)
    Call DisplayTraces(lngTraceColor)
End Sub

Private Sub chkSmall_Click()
    Call MakeDisplayTrace(dblNbins / 2)
    Call DisplayTraces(lngTraceColor)
End Sub

Private Sub cmdDisplaytrace_Click()
    If blnMEMdisplay = False Then
        blnMEMdisplay = True
        cmdDisplaytrace.Caption = "Trace 2 OFF"
    Else
        blnMEMdisplay = False
        cmdDisplaytrace.Caption = "Display Trace 2"
    End If
End Sub

Private Sub cmdStore_Click()
    Dim lngBin As Long
    Dim lngN As Long
    
    For lngBin = 0 To dblNbins / 2
            MEMORYtrc(lngBin) = DISPLAYtrc(lngBin)
    Next lngBin

    For lngN = dblNbins / 2 To 8192
        MEMORYtrc(lngN) = DISPLAYtrc(dblNbins / 2)
    Next lngN
    
End Sub

Private Sub cmdTracemath_Click()

    If blnMEMminustrc = False Then
        blnMEMminustrc = True
        cmdTracemath.Caption = "Trace 1 - Trace 2 OFF"
    Else
        blnMEMminustrc = False
        cmdTracemath.Caption = "Trace 1 - Trace 2 ON"
    End If
       
End Sub

Private Sub Form_Activate()

    sngReflvl = scrReflvl.Value
    sngdBdiv = scrdBdiv.Value
    
    lngSampleRate = Val(cboSRate.Text)
  
    txtFMin.Text = "0"
    txtFMax.Text = Str(Val(cboSRate.Text) / 2)
    
    scrAVG.Value = 10
        
    cboBins.AddItem "16384"
    cboBins.AddItem "8192"
    cboBins.AddItem "4096"
    cboBins.AddItem "2048"
    cboBins.AddItem "1024"
    cboBins.AddItem "512"
    cboBins.AddItem "256"
    cboBins.AddItem "128"
    cboBins.AddItem "64"
    
    blnMEMdisplay = False
    blnMEMminustrc = False
    blnCMDswitch = False
    
    CmdSwitch.Caption = "Start"
  
    lngGridBrightness = scrGridBrightness.Value
    lngGridBrightness = lngGridBrightness + 256 * (lngGridBrightness + 256 * lngGridBrightness)

    lngBckBrightness = scrBckBrightness.Value
    lngBckBrightness = lngBckBrightness + 256 * (lngBckBrightness + 256 * lngBckBrightness)
    
    dblNbins = Val(cboBins.Text)   'Number of samples must be  2^k  where k = integer > 1
    BUFFER_SIZE = dblNbins * 2     'Must be at least 2 * max number of bins
     
    MakeDisplay
    
    Timer1.Interval = 1
    Timer1.Enabled = True
    'Call Working  'This line or previous timer1 routine for slower update

End Sub

Private Sub MakeDisplay()
  
    Dim sngX As Single
    Dim sngY As Single
    Dim lngScaleSize As Long
    
    If chkOverWrite.Value = 1 Then Exit Sub
    lngScaleSize = 1200
    
    If chkSmall.Value = 1 Then lngScaleSize = 2400
    
    Picture1.BackColor = lngBckBrightness
    Picture1.ScaleWidth = lngScaleSize     '1000 for scale, +/- 100 for boarder
    Picture1.ScaleHeight = lngScaleSize    '1000 for scale, +/- 100 for boarder
    Picture1.ScaleLeft = -100
    Picture1.ScaleTop = -100
    
    Picture1.Cls

    'Draw grid
        
    For sngX = 0 To 1000 Step 100
        Picture1.Line (sngX, 0)-(sngX, 1000), lngGridBrightness
    Next sngX
      
    For sngY = 0 To 1000 Step 125
        Picture1.Line (0, sngY)-(1000, sngY), lngGridBrightness
    Next sngY
    
    'Extra long center lines
    Picture1.Line (500, -20)-(500, 1020), lngGridBrightness
    Picture1.Line (-20, 500)-(1020, 500), lngGridBrightness
    
End Sub

Private Sub CmdSwitch_Click()
 
    If CmdSwitch.Caption = "Start" Then
        CmdSwitch.Caption = "Freeze"
        Call MakeDisplay
        StartInput
        blnCMDswitch = True
    Else
        CmdSwitch.Caption = "Start"
        StopInput
        blnCMDswitch = False
    End If

End Sub

Private Sub scrAVG_Change()
    lblAV.Caption = "Av " & LTrim(Str(scrAVG.Value))
End Sub


Private Sub scrGridBrightness_Change()
    lngGridBrightness = scrGridBrightness.Value
    lngGridBrightness = lngGridBrightness + 256 * (lngGridBrightness + 256 * lngGridBrightness)
    Call MakeDisplayTrace(dblNbins / 2)
    Call DisplayTraces(lngTraceColor)
End Sub

Private Sub scrBckBrightness_Change()
    lngBckBrightness = scrBckBrightness.Value
    lngBckBrightness = lngBckBrightness + 256 * (lngBckBrightness + 256 * lngBckBrightness)
     Call MakeDisplayTrace(dblNbins / 2)
     Call DisplayTraces(lngTraceColor)
End Sub

Private Sub scrReflvl_Change()
   sngReflvl = scrReflvl.Value
   lblReflvl.Caption = "Ref: " & sngReflvl & " dB"
   Call MakeDisplayTrace(dblNbins / 2)
   Call DisplayTraces(lngTraceColor)
End Sub

Private Sub scrT2Offset_Change()
   sngOffset = scrT2Offset.Value
   lblT2Offset.Caption = sngOffset & " dB"
   Call MakeDisplayTrace(dblNbins / 2)
   Call DisplayTraces(lngTraceColor)
End Sub

Private Sub scrdBdiv_Change()
   sngdBdiv = scrdBdiv.Value
   lbldBdiv.Caption = sngdBdiv & " dB/div"
   Call MakeDisplayTrace(dblNbins / 2)
   Call DisplayTraces(lngTraceColor)
End Sub

Private Sub scrUpdateTime_Change()
   Timer1.Interval = 1 + 50 * scrUpdateTime.Value
   lblTime = "T= " & Str(Timer1.Interval - 1) & " ms"
End Sub

Private Sub Timer1_Timer()   ' Process timer solution with variable refresh rate
     
    If fRecording = False Or (inHdr.dwFlags And WHDR_DONE) = 0 Then Exit Sub
       
    Call GetAudio
    
    Call StopInput           'Stop input, erase memory
    Call StartInput          'Start new buffer etc.
    Call DrawSpectrum
        
End Sub

Private Sub OLDTimer1_Timer()   ' Process timer solution with variable refresh rate
     
    If fRecording = False Or (inHdr.dwFlags And WHDR_DONE) = 0 Then Exit Sub
       
    Call GetAudio
    
    rc = waveInAddBuffer(hWaveIn, inHdr, Len(inHdr))
    If (rc <> 0) Then
        waveInGetErrorText rc, msg, Len(msg)
        MsgBox msg
    End If
      
    Call DrawSpectrum
        
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    
    If (fRecording) Then
        StopInput
    End If
    
End Sub

Sub GetAudio()
     
    Dim lngSample As Long
             
    lngTraceColor = &H10FF10
      
    For lngSample = 0 To dblNbins - 1
        Call GetMono16Sample(lngSample, dblSampleValue)
        
        REX(lngSample) = dblSampleValue
        IMX(lngSample) = 0
        
        If dblSampleValue < -0.5 Or dblSampleValue > 0.5 Then lngTraceColor = &HFF
    Next lngSample
   
   Call FFT(CInt(dblNbins), REX, IMX)
   
End Sub


 Sub DrawSpectrum()
     
    Dim lngBin, lngSample As Long
    Dim dblX As Double
        
    For lngBin = 0 To dblNbins / 2
            
        dblX = Sqr(REX(lngBin) * REX(lngBin) + IMX(lngBin) * IMX(lngBin))
        dblX = 20 * Log(dblX + 0.0000001) / Log(10) 'Convert to dB's
                
        If optNormal.Value = True Then
            DISPLAYtrc(lngBin) = dblX
        End If
        
        If optMaxhold.Value = True And dblX > DISPLAYtrc(lngBin) Then
            DISPLAYtrc(lngBin) = dblX
        End If
        
        If optAverage.Value = True Then
            DISPLAYtrc(lngBin) = DISPLAYtrc(lngBin) + (dblX - DISPLAYtrc(lngBin)) / scrAVG.Value
        End If
        
    Next lngBin
    
    Call MakeDisplayTrace(dblNbins / 2)
    Call DisplayTraces(lngTraceColor)
    
End Sub

Private Sub MakeDisplayTrace(lngLength As Long)
    Dim lngBin As Long
    Dim lngTraceCount As Long
    Dim sngFreqMin, sngFreqMax, sngFreq As Single
    Dim dblX, dblY As Double
        
    sngFreqMin = Val(txtFMin)
    sngFreqMax = Val(txtFMax)
    
    If sngFreqMax <= sngFreqMin Then Exit Sub
 
    lngTraceCount = 0
    
    For lngBin = 0 To lngLength
   
        If blnMEMminustrc = False Then
            dblY = DISPLAYtrc(lngBin)
            dblY = 50 + sngReflvl - dblY  '50 is a good value for max dynamic range
        Else
            dblY = MEMORYtrc(lngBin) - DISPLAYtrc(lngBin)
            dblY = sngReflvl + dblY
        End If

        dblY = 125 * (dblY / sngdBdiv)              '125 per div vertical
           
        If dblY < -50 Then dblY = -50
        If dblY > 1000 Then dblY = 1000
       
        TRACE1_Y(lngTraceCount) = dblY
      
        If blnMEMdisplay = True Then
           dblY = MEMORYtrc(lngBin)
           dblY = 50 + sngReflvl - dblY  '50 is a good value for max dynamic range
           dblY = dblY + sngOffset       'Add offset between traces
           dblY = 125 * (dblY / sngdBdiv)             '125 per div vertical
           
           If dblY < -50 Then dblY = -50
           If dblY > 1000 Then dblY = 1000
      
           TRACE2_Y(lngTraceCount) = dblY
        End If
      
        sngFreq = CSng(lngBin) / dblNbins * lngSampleRate
             
        If sngFreq < sngFreqMin Then
            dblX = 0
         End If
        
        If sngFreq >= sngFreqMin And sngFreq <= sngFreqMax Then
            dblX = 1000 * (sngFreq - sngFreqMin) / (sngFreqMax - sngFreqMin)
        End If
        
        If sngFreq > sngFreqMax Then Exit For  'Finish
        
        TRACE1_X(lngTraceCount) = dblX
        TRACE1_X(lngTraceCount + 1) = 9999 'End of array
        
        TRACE2_X(lngTraceCount) = dblX
        TRACE2_X(lngTraceCount + 1) = 9999 'End of array
        
        If sngFreq >= sngFreqMin And sngFreq <= sngFreqMax Then
            lngTraceCount = lngTraceCount + 1
        End If
        
    Next lngBin
    
End Sub

Private Sub DisplayTraces(ByVal lngTheColor)
   Dim intN, intX, intY As Integer
      
   Dim lngTrace1Color As Long
   Dim lngTrace2Color As Long
      
   
   'Set the trace colors
   If chkBW = 1 Then       'Black & White display
       If scrGridBrightness.Value > 127 Then
           lngTheColor = &HFFFFFF
       Else
           lngTheColor = &H0
       End If
   End If
   
   lngTrace1Color = lngTheColor
   
   If chkBW <> 1 Then
       lngTrace2Color = &H1080FF
   Else
       lngTrace2Color = lngTheColor
   End If
           
   Call MakeDisplay

   'First memory trace 2 then the normal trace1
   For intN = 1 To 16384
       
       If blnMEMdisplay = True Then
          If TRACE2_X(intN) <> 9999 Then
              Picture1.Line (TRACE2_X(intN - 1), TRACE2_Y(intN - 1))-(TRACE2_X(intN), TRACE2_Y(intN)), lngTrace2Color
          Else
              TRACE2_X(intN + 1) = 9999
          End If
       End If
       
      If TRACE1_X(intN) = 9999 Then Exit For
      
      Picture1.Line (TRACE1_X(intN - 1), TRACE1_Y(intN - 1))-(TRACE1_X(intN), TRACE1_Y(intN)), lngTrace1Color
   Next intN
  
 End Sub

Private Sub PrintMessage(ByVal strText As String)
     
    strText = Chr$(13) & Chr$(10) & strText
    txtMessage.Text = txtMessage.Text & strText
    If Len(txtMessage.Text) > 30000 Then txtMessage.Text = Mid$(txtMessage.Text, 1, 29000)
    
End Sub


