Attribute VB_Name = "Module1"
'email: takisfmf@yahoo.gr
'for more source code visit
'http://www.geocities.com/takisfmf/index.html

'Following code more or less generic from MSDN

Option Explicit

Public Const WHDR_DONE = &H1         '  done bit

Type WAVEHDR
   lpData As Long
   dwBufferLength As Long
   dwBytesRecorded As Long
   dwUser As Long
   dwFlags As Long
   dwLoops As Long
   lpNext As Long
   Reserved As Long
End Type
   
Type WAVEFORMAT
   wFormatTag As Integer
   nChannels As Integer
   nSamplesPerSec As Long
   nAvgBytesPerSec As Long
   nBlockAlign As Integer
   wBitsPerSample As Integer
   cbSize As Integer
End Type

Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Declare Function GlobalLock Lib "kernel32" (ByVal hmem As Long) As Long
Declare Function GlobalFree Lib "kernel32" (ByVal hmem As Long) As Long
Declare Sub CopyStructFromPtr Lib "kernel32" Alias "RtlMoveMemory" (struct As Any, ByVal ptr As Long, ByVal cb As Long)
Declare Function waveInOpen Lib "winmm.dll" (lphWaveIn As Long, ByVal uDeviceID As Long, lpFormat As WAVEFORMAT, ByVal dwCallback As Long, ByVal dwInstance As Long, ByVal dwFlags As Long) As Long
Declare Function waveInStart Lib "winmm.dll" (ByVal hWaveIn As Long) As Long
Declare Function waveInStop Lib "winmm.dll" (ByVal hWaveIn As Long) As Long
Declare Function waveInAddBuffer Lib "winmm.dll" (ByVal hWaveIn As Long, lpWaveInHdr As WAVEHDR, ByVal uSize As Long) As Long
Declare Function waveInReset Lib "winmm.dll" (ByVal hWaveIn As Long) As Long
Declare Function waveInPrepareHeader Lib "winmm.dll" (ByVal hWaveIn As Long, lpWaveInHdr As WAVEHDR, ByVal uSize As Long) As Long
Declare Function waveInGetErrorText Lib "winmm.dll" Alias "waveInGetErrorTextA" (ByVal err As Long, ByVal lpText As String, ByVal uSize As Long) As Long
Declare Function waveInClose Lib "winmm.dll" (ByVal hWaveIn As Long) As Long
Declare Function waveInUnprepareHeader Lib "winmm.dll" (ByVal hWaveIn As Long, lpWaveInHdr As WAVEHDR, ByVal uSize As Long) As Long

Public i As Integer, j As Integer, rc As Long, msg As String * 200, hWaveIn As Long
Public format As WAVEFORMAT
Public hmem As Long
Public inHdr As WAVEHDR
Public Const DEVICEID = 0
Public fRecording As Boolean
Public BUFFER_SIZE As Long

'When the number of FFT points is < 512 and samplerates
'are < 22050 are used the program has to wait for input.
'A circular buffer of sufficient size may be of value
'but I don't know how to implement it.

Function StartInput() As Boolean

    If fRecording Then
        StartInput = True
        Exit Function
    End If

    format.wFormatTag = 1
    format.nChannels = 1
    format.wBitsPerSample = 16
    format.nSamplesPerSec = Val(Form1.cboSRate.Text)    'Gets the sample rate from the main form
    format.nBlockAlign = format.nChannels * format.wBitsPerSample / 8
    format.nAvgBytesPerSec = format.nSamplesPerSec * format.nBlockAlign
    format.cbSize = 0

    hmem = GlobalAlloc(&H40, BUFFER_SIZE)
    inHdr.lpData = GlobalLock(hmem)
    inHdr.dwBufferLength = BUFFER_SIZE
    inHdr.dwBytesRecorded = 0                'Ook extra toegevoegd
    inHdr.dwFlags = 0
    inHdr.dwLoops = 0

    rc = waveInOpen(hWaveIn, DEVICEID, format, 0, 0, 0)
    If rc <> 0 Then
      waveInGetErrorText rc, msg, Len(msg)
      MsgBox msg
      StartInput = False
      Exit Function
    End If

    rc = waveInPrepareHeader(hWaveIn, inHdr, Len(inHdr))
    If (rc <> 0) Then
       waveInGetErrorText rc, msg, Len(msg)
       MsgBox msg
    End If
    rc = waveInStart(hWaveIn)
    
    'First reading to start the process
    rc = waveInAddBuffer(hWaveIn, inHdr, Len(inHdr))
    If (rc <> 0) Then
       waveInGetErrorText rc, msg, Len(msg)
      MsgBox msg
    End If

    fRecording = True
    StartInput = True

End Function

' Stop receiving audio input on the soundcard
Sub StopInput()
    fRecording = False
    waveInReset hWaveIn
    waveInStop hWaveIn
    waveInUnprepareHeader hWaveIn, inHdr, Len(inHdr)
    GlobalFree hmem
    waveInClose hWaveIn
End Sub

Sub GetMono16Sample(ByVal sample As Long, ByRef leftVol As Double)
   Dim sample16 As Integer
   Dim ptr As Long
   
   ptr = sample * format.nBlockAlign + inHdr.lpData
   CopyStructFromPtr sample16, ptr, 2
   leftVol = sample16 / 32768

End Sub

'The following code may be from the original program author
'but it appears to be a relatively generic adaptation.
'This routine imposes a speed bottleneck when the number
'of FFT points is > 512.

'THE FAST FOURIER TRANSFORM
'Upon entry, N% contains the number of points in the DFT,
'REX[ ] and IMX[ ] contain the real and imaginary parts of the input.
'Upon return, REX[ ] and IMX[ ] contain the DFT output.
'All signals run from 0 to N-1.

Sub FFT(N As Integer, REX() As Double, IMX() As Double)

    Const Pi = 3.14159
    Dim NM1 As Integer
    Dim ND2 As Integer
    Dim M As Integer
    Dim j As Integer
    Dim K As Integer
    Dim L As Integer
    Dim LE As Integer
    Dim LE2 As Integer
    Dim JM1 As Integer
    Dim i As Integer
    Dim IP As Integer
    Dim TR As Double
    Dim TI As Double
    Dim UR As Double
    Dim UI As Double
    Dim SR As Double
    Dim SI As Double
    
    NM1 = N - 1
    ND2 = N / 2
    M = CInt(Log(N) / Log(2))
    j = ND2

    For i = 1 To N - 2                    'Bit reversal sorting
      If i >= j Then GoTo S1
      TR = REX(j)
      TI = IMX(j)
      REX(j) = REX(i)
      IMX(j) = IMX(i)
      REX(i) = TR
      IMX(i) = TI
S1:   K = ND2
S2:   If K > j Then GoTo S3
      j = j - K
      K = K / 2
      GoTo S2
S3:   j = j + K
    Next

    For L = 1 To M                          'Loop for each stage
        LE = CInt(2 ^ L)
        LE2 = LE / 2
        UR = 1
        UI = 0
        SR = Cos(Pi / LE2)                 'Calculate sine & cosine values
        SI = -Sin(Pi / LE2)
      
        For j = 1 To LE2                    'Loop for each sub DFT
             JM1 = j - 1
             For i = JM1 To NM1 Step LE     'Loop for each butterfly
                   IP = i + LE2
                   TR = REX(IP) * UR - IMX(IP) * UI   'Butterfly calculation
                   TI = REX(IP) * UI + IMX(IP) * UR
                   REX(IP) = REX(i) - TR
                   IMX(IP) = IMX(i) - TI
                   REX(i) = REX(i) + TR
                   IMX(i) = IMX(i) + TI
             Next
             TR = UR
             UR = TR * SR - UI * SI
             UI = TR * SI + UI * SR
        Next
    Next

End Sub



