#include <stdio.h>
#include <alloc.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>

#define  EPROMSize    0x00003FFF
#define  ProgramType  FastProgram
#define  TitleMessage "27C128 Fast. Make sure VPP switch in up posistion"


void DataDirection(char InOut);
char ProgramPulse(char Time);
void BlankCheck(void);
void WriteEprom(void);
void ReadEprom(void);
void VerifyEprom(void);

#include <c:\epinc.c>

void main(void)
{
int  KeyPressed;

Init();

do
    {
     puts("\nPress any key");
     while(!kbhit());
     getch();
     PrintMenu();
     while(!kbhit());
     KeyPressed = getche();
     KeyPressed = toupper(KeyPressed);
     DoMenu(KeyPressed);
     ClearPins();
    }
while (KeyPressed != 'E');


Exit(0);
}


/*
27C128, 27C256 and 27C512 EPROMs have different pin assignments
Therefore the following routines are EPROM type specific.
*/

void DataDirection(char InOut)
/*
Sets either Data IN to EPROM or OUT of EPROM
*/
{
if(InOut)
    {
     OEEpromA15(HI);
     OEData(LO);
    }
else
    {
     OEData(HI);
     OEEpromA15(LO);
    }
}


char ProgramPulse(char Time)
/*
Applies a program pulse of Time milliseconds
*/
{
char CheckData;

DataDirection(OUT);
CheckData = ReadData();

DataDirection(IN);

CEPGM(LO);
A14PGM(HI);
VCC(6);
VPP(12);
A14PGM(LO);
delay(Time);
A14PGM(HI);

VPP(0);
VCC(5);
CEPGM(LO);

DataDirection(OUT);
if (CheckData != ReadData())
    {
     return(LO);
    }
else
    {
     return(HI);
    }
}


void BlankCheck(void)
/*
Make Sure EPROM is blank
*/
{
long int  Address;
     int  Overflow;

VCC(5);
CEPGM(LO);

ResetCounter();
for (Address = 0; Address <= MaxCount; Address++)
    {
     printf("%4X", Address);
     BackSpace(4);

     DataDirection(OUT);

     if (!Verify(0xFF))
	 {
	  puts("EPROM Not Blank");
	  return;
	 }

     DataDirection(IN);
     Overflow = AddressClock();
     if ((Address == MaxCount) && !Overflow)
	 {
	  puts("Error counter fail");
	  Exit(4);
	 }
    }
puts("EPROM Blank OK");
}

void WriteEprom(void)
/*
Write All Data To Eprom
*/
{
long int  NonFF;
long int  Address;
     int  ByteToProg;
     int  Overflow;

NonFF = 0;
puts("Now Writing EPROM");

VCC(5);
VPP(0);

ResetCounter();
for (Address = 0; Address <= MaxCount; Address++)
    {
     printf("%4X", Address);
     BackSpace(4);

     ByteToProg = EPROM[Jumble(Address)];
     if (ByteToProg != 0xFF)
	 {
	  NonFF++;
	  SetData(ByteToProg);
	  ProgramType();
	 }

     DataDirection(IN);
     Overflow = AddressClock();
     if ((Address == MaxCount) && !Overflow)
	 {
	  puts("Error counter fail");
	  Exit(4);
	 }
    }
printf("%4ld Non FF Bytes written to EPROM\n", NonFF);
}


void ReadEprom(void)
/*
Read All Data from EPROM
*/
{
long int  NonFF;
long int  Address;
     int  Overflow;

NonFF = 0;
puts("Now Reading");

VCC(5);
VPP(0);
CEPGM(LO);

ResetCounter();

for (Address = 0; Address <= MaxCount; Address++)
    {
     printf("%4X", Address);
     BackSpace(4);

     DataDirection(OUT);

     if ((EPROM[Jumble(Address)]
	     = ReadData()) != 0xFF)
	 {
	  NonFF++;
	 }

     DataDirection(IN);
     Overflow = AddressClock();
     if ((Address == MaxCount) && !Overflow)
	 {
	  puts("Error counter fail");
	  Exit(4);
	 }
    }
printf("%4ld non blank locations read\n", NonFF);
}


void VerifyEprom(void)
/*
Verify All Data On EPROM
*/
{
long int  TotErrors = 0;
long int  Address;
     char ByteRead;
     char ByteToCheck;
     int  Overflow;

puts("Now Verifying");


VCC(5);
VPP(0);
CEPGM(LO);

ResetCounter();
for (Address = 0; Address <= MaxCount; Address++)
    {
     printf("%4X", Address);
     BackSpace(4);

     DataDirection(OUT);

     ByteToCheck = EPROM[Jumble(Address)];
     if (!Verify(ByteToCheck))
	 {
	  TotErrors++;
	 }

     DataDirection(IN);
     Overflow = AddressClock();
     if ((Address == MaxCount) && !Overflow)
	 {
	  puts("Error counter fail");
	  Exit(4);
	 }
    }
printf("Total Errors = %4ld\n", TotErrors);
if (TotErrors == 0)
   {
    puts("EPROM Verify OK");
   }
}

