/*
 * Decompiled with CFR 0.152.
 */
package rascal;

import dc3com.Telemetry;
import dcgs.TelemetryCollector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.util.Date;
import java.util.Vector;
import rascal.AuthenticationManager;
import rascal.GUI;
import rascal.PendingTelemetry;
import rascal.SettingsControl;
import rascal.TelemetryRepository;

public class TelemetrySubmitter
extends Thread {
    private SettingsControl settings;
    private TelemetryRepository telemetryrepository;
    private AuthenticationManager authmgr;
    private TelemetryCollector telemetrycollector = null;
    private String serverhostname;
    private String serverport;
    private String repositorystring;
    private String repositorypath;
    private int submitcount;
    private boolean is_primary_repository;
    private long last_data_received;
    private boolean write_required = false;
    private boolean guiwarning_connect = false;

    public TelemetrySubmitter(SettingsControl settingsctrl, boolean is_primary) {
        this.settings = settingsctrl;
        this.is_primary_repository = is_primary;
        this.repositorypath = System.getProperty("java.class.path");
        int lastslash = this.repositorypath.lastIndexOf("/");
        this.repositorypath = lastslash < 0 ? "" : this.repositorypath.substring(0, lastslash + 1);
        this.repositorypath = this.repositorypath + "repository";
        this.repositorystring = is_primary ? this.repositorypath + "\\repository" : this.repositorypath + "\\backup_repository";
        this.getServerConnectionInfo();
        this.submitcount = 0;
        this.authmgr = new AuthenticationManager(settingsctrl);
        this.createRepository();
    }

    public void run() {
        while (true) {
            try {
                TelemetrySubmitter.sleep(10000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.submitPendingTelemetry();
            GUI.updateRepositoryData();
            if (!this.write_required || System.currentTimeMillis() - this.last_data_received <= 60000L) continue;
            String primary_string = "primary";
            if (!this.is_primary_repository) {
                primary_string = "secondary";
            }
            GUI.setStatusMessage("Saving " + primary_string + " repository data to disk");
            this.storeRepository();
            this.write_required = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRepository() {
        try {
            FileInputStream f = new FileInputStream(this.repositorystring);
            ObjectInputStream ois = new ObjectInputStream(f);
            this.telemetryrepository = (TelemetryRepository)ois.readObject();
            f.close();
        }
        catch (Exception e) {
            this.telemetryrepository = new TelemetryRepository();
        }
        finally {
            String primary_string = "primary";
            if (!this.is_primary_repository) {
                primary_string = "secondary";
            }
            GUI.setStatusMessage("Loaded " + primary_string + " repository data: " + this.getRepositorySize() + " frames");
        }
    }

    private void storeRepository() {
        new File(this.repositorypath).mkdir();
        try {
            FileOutputStream f = new FileOutputStream(this.repositorystring);
            ObjectOutputStream ois = new ObjectOutputStream(f);
            ois.writeObject(this.telemetryrepository);
            f.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getServerConnectionInfo() {
        if (this.is_primary_repository) {
            this.serverhostname = this.settings.getSettingValue("Internet", "hostname_1").toString();
            this.serverport = this.settings.getSettingValue("Internet", "port_1").toString();
        } else {
            this.serverhostname = this.settings.getSettingValue("Internet", "hostname_2").toString();
            this.serverport = this.settings.getSettingValue("Internet", "port_2").toString();
        }
    }

    private boolean locateTelemetryCollector() {
        this.getServerConnectionInfo();
        try {
            this.telemetrycollector = (TelemetryCollector)Naming.lookup("rmi://" + this.serverhostname + ":" + this.serverport + "/TelemetryCollectorService");
            this.authmgr.setColllector(this.telemetrycollector);
            GUI.setStatusMessage("Connected to server " + this.serverhostname);
            this.guiwarning_connect = false;
            return this.authmgr.login();
        }
        catch (Exception e) {
            if (!this.guiwarning_connect) {
                GUI.setStatusMessage("Unable to connect to server " + this.serverhostname);
                this.guiwarning_connect = true;
            }
            this.telemetrycollector = null;
            this.authmgr.setColllector(this.telemetrycollector);
            return false;
        }
    }

    public void submitPendingTelemetry() {
        if (this.telemetryrepository.isEmpty().booleanValue()) {
            return;
        }
        Vector<PendingTelemetry> ptlms = this.telemetryrepository.getPendingTelemetry();
        if (this.telemetrycollector == null && !this.locateTelemetryCollector()) {
            return;
        }
        while (ptlms.size() != 0) {
            PendingTelemetry ptlm = ptlms.firstElement();
            if (this.submit(ptlm, 2)) {
                ++this.submitcount;
                ptlms.remove(ptlm);
                this.write_required = true;
                GUI.updateRepositoryData();
                continue;
            }
            return;
        }
    }

    private boolean submit(PendingTelemetry ptlm, int login_retries) {
        try {
            return this.telemetrycollector.submit((String)this.settings.getSettingValue("Internet", "username"), ptlm.getTelemetry(), ptlm.getDate(), new Date());
        }
        catch (ServerException auth_ex) {
            if (login_retries > 0) {
                this.authmgr.login();
                return this.submit(ptlm, login_retries - 1);
            }
            return false;
        }
        catch (NoSuchObjectException nso_ex) {
            this.locateTelemetryCollector();
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void submit(Telemetry tlm) {
        this.telemetryrepository.store(tlm);
        this.last_data_received = System.currentTimeMillis();
        this.write_required = true;
    }

    public int getRepositorySize() {
        return this.telemetryrepository.getRepositorySize();
    }

    public int getSubmitCount() {
        return this.submitcount;
    }

    public AuthenticationManager getAuthmgr() {
        return this.authmgr;
    }

    public void forceRepositoryWrite() {
        this.storeRepository();
    }

    public String getRepositorypath() {
        return this.repositorypath;
    }
}

