/*
 * Decompiled with CFR 0.152.
 */
package rascal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import rascal.GUI;
import rascal.Rascal;
import rascal.Setting;
import rascal.SettingsControl;
import rascal.SettingsGroup;

public class SettingsEditor
implements ActionListener {
    private SettingsControl settings;
    private JDialog dialog;
    private Hashtable<String, JComponent> comps = new Hashtable();
    Map fields = new HashMap();
    static Enumeration portlist;
    private boolean restart = false;
    Rascal rascal;
    private static final boolean MODIFIABLE = true;
    private static final boolean UNMODIFIABLE = false;
    private static final boolean RESTART = true;
    private static final boolean NORESTART = false;

    public SettingsEditor(SettingsControl settingscontrol, Rascal rascal) {
        this.rascal = rascal;
        this.settings = settingscontrol;
        this.dialog = new JDialog();
        this.dialog.setTitle("Settings");
        this.dialog.setSize(420, 270);
        this.dialog.setLocation(100, 200);
        this.dialog.setResizable(false);
        this.dialog.setModal(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                SettingsEditor.this.dialog.dispose();
                SettingsEditor.this.dialog.getOwner().dispose();
            }
        });
        this.dialog.setLayout(new BorderLayout());
        JTabbedPane tabpane = new JTabbedPane();
        Hashtable<String, SettingsGroup> groups = this.settings.getGroups();
        Enumeration<String> groupkeys = groups.keys();
        while (groupkeys.hasMoreElements()) {
            String groupname = groupkeys.nextElement();
            SettingsGroup group = groups.get(groupname);
            JPanel panel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbcl = new GridBagConstraints();
            GridBagConstraints gbcv = new GridBagConstraints();
            panel.setLayout(gbl);
            gbcl.gridx = 0;
            gbcv.gridx = 1;
            gbcv.gridy = 0;
            gbcl.gridy = 0;
            gbcv.anchor = 18;
            gbcl.anchor = 18;
            gbcl.weightx = 1.5;
            gbcv.weightx = 0.0;
            gbcv.weighty = 0.0;
            gbcl.weighty = 0.0;
            gbcl.insets = new Insets(1, 1, 1, 1);
            gbcv.insets = new Insets(1, 1, 1, 1);
            gbcv.fill = 1;
            gbcl.fill = 1;
            int ypos = 5;
            LinkedHashMap<String, Setting> settings = group.getSettings();
            Set<String> keys = settings.keySet();
            Object[] settingkeys = keys.toArray();
            for (int i = 0; i < settingkeys.length; ++i) {
                JComponent field;
                String settingname = (String)settingkeys[i];
                Setting setting = settings.get(settingname);
                if (!setting.isUserModifiable()) continue;
                JLabel label = new JLabel(setting.getDescription());
                panel.add((Component)label, gbcl);
                Object val = setting.getValue();
                if (val instanceof Boolean) {
                    field = new JCheckBox();
                    field.setName(setting.getDescription().toString());
                    this.fields.put(groupname + "." + settingname, field);
                    ((AbstractButton)field).setSelected((Boolean)val);
                    panel.add((Component)field, gbcv);
                } else if (val instanceof String) {
                    field = new JTextField(setting.getValue().toString());
                    this.fields.put(groupname + "." + settingname, field);
                    panel.add((Component)field, gbcv);
                } else if (val instanceof Integer) {
                    field = new JSpinner();
                    ((JSpinner)field).setValue(setting.getValue());
                    this.fields.put(groupname + "." + settingname, field);
                    panel.add((Component)field, gbcv);
                }
                gbcl.gridy = gbcv.gridy = gbcl.gridy + 1;
            }
            if (groupname.equals("Protocol")) continue;
            gbcv.weighty = 1.0;
            JPanel filler = new JPanel();
            filler.setPreferredSize(new Dimension(200, 0));
            panel.add((Component)filler, gbcv);
            tabpane.addTab(groupname, new JScrollPane(panel));
        }
        tabpane.setPreferredSize(new Dimension(300, 200));
        this.dialog.add((Component)tabpane, "North");
        JButton cancelButton = new JButton("Close");
        JButton acceptButton = new JButton("Accept");
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        acceptButton.setActionCommand("accept");
        acceptButton.addActionListener(this);
        this.dialog.add((Component)acceptButton, "West");
        this.dialog.add((Component)cancelButton, "East");
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "cancel") {
            this.dialog.dispose();
            this.dialog.getOwner().dispose();
        } else {
            this.applyModifications();
            this.dialog.dispose();
            this.dialog.getOwner().dispose();
        }
    }

    private void applyModifications() {
        Hashtable<String, SettingsGroup> groups = this.settings.getGroups();
        Enumeration<String> groupkeys = groups.keys();
        while (groupkeys.hasMoreElements()) {
            String groupname = groupkeys.nextElement();
            SettingsGroup group = groups.get(groupname);
            LinkedHashMap<String, Setting> settings = group.getSettings();
            Set<String> keys = settings.keySet();
            Object[] settingkeys = keys.toArray();
            for (int i = 0; i < settingkeys.length; ++i) {
                JComponent text;
                Setting tempsetting;
                String settingname = (String)settingkeys[i];
                Setting temp = settings.get(settingname);
                Object field = this.fields.get(groupname + "." + settingname);
                if (field instanceof JCheckBox) {
                    JCheckBox box = (JCheckBox)field;
                    tempsetting = new Setting(new Boolean(box.isSelected()), temp.isUserModifiable(), temp.requiresRestart(), temp.getDescription());
                    if ((Boolean)temp.getValue() != (Boolean)tempsetting.getValue() && tempsetting.requiresRestart()) {
                        this.restart = true;
                    }
                    group.set(settingname, tempsetting);
                    continue;
                }
                if (field instanceof JTextField) {
                    text = (JTextField)field;
                    tempsetting = new Setting(((JTextComponent)text).getText(), temp.isUserModifiable(), temp.requiresRestart(), temp.getDescription());
                    if (!((String)temp.getValue()).equals((String)tempsetting.getValue()) && tempsetting.requiresRestart()) {
                        this.restart = true;
                    }
                    group.set(settingname, tempsetting);
                    continue;
                }
                if (field instanceof JSpinner) {
                    text = (JSpinner)field;
                    tempsetting = new Setting(((JSpinner)text).getValue(), temp.isUserModifiable(), temp.requiresRestart(), temp.getDescription());
                    if ((Integer)temp.getValue() != (Integer)tempsetting.getValue() && tempsetting.requiresRestart()) {
                        this.restart = true;
                    }
                    group.set(settingname, tempsetting);
                    continue;
                }
                if (!(field instanceof JComboBox)) continue;
                text = (JComboBox)field;
                tempsetting = new Setting((String)((JComboBox)text).getSelectedItem(), temp.isUserModifiable(), temp.requiresRestart(), temp.getDescription());
                if (!((String)temp.getValue()).equals((String)tempsetting.getValue()) && tempsetting.requiresRestart()) {
                    this.restart = true;
                }
                group.set(settingname, tempsetting);
            }
            groups.put(groupname, group);
        }
        this.settings.save();
        if (this.restart) {
            // empty if block
        }
        GUI.setStatusMessage("Saving settings");
    }
}

