/*
 * Decompiled with CFR 0.152.
 */
package rascal;

import dc3com.TelemetryDef;
import dc3com.TelemetryDefIVCurve;
import dc3com.TelemetryDefValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import rascal.GUI;
import rascal.Setting;
import rascal.SettingsGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsControl {
    private Hashtable<String, SettingsGroup> groups;
    static Enumeration portlist;
    private static final boolean MODIFIABLE = true;
    private static final boolean UNMODIFIABLE = false;
    private static final boolean RESTART = true;
    private static final boolean NORESTART = false;
    private String path = System.getProperty("java.class.path");

    public SettingsControl() throws Exception {
        int lastslash = this.path.lastIndexOf("/");
        this.path = lastslash < 0 ? "" : this.path.substring(0, lastslash + 1);
        this.path = this.path + "config";
        this.groups = new Hashtable();
        boolean oneormoredefault = false;
        try {
            FileInputStream f = new FileInputStream(this.path + "\\internet.conf");
            ObjectInputStream ois = new ObjectInputStream(f);
            this.groups.put("Internet", (SettingsGroup)ois.readObject());
            f.close();
            GUI.setStatusMessage("Loaded program settings");
        }
        catch (IOException e) {
            this.defaultInitInternet();
            oneormoredefault = true;
        }
        this.defaultInitProtocol();
        oneormoredefault = true;
        if (oneormoredefault) {
            this.save();
        }
    }

    private void defaultInitInternet() {
        SettingsGroup group = new SettingsGroup();
        group.set("hostname_1", new Setting("83.138.144.157", true, false, "Primary Server hostname"));
        group.set("port_1", new Setting(new Integer(1099), true, false, "Primary Server port"));
        group.set("hostname_2", new Setting("131.180.117.51", true, false, "Secondary Server hostname"));
        group.set("port_2", new Setting(new Integer(1099), true, false, "Secondary Server port"));
        group.set("username", new Setting("guest", true, false, "Username"));
        group.set("password", new Setting("guest", true, false, "Password"));
        this.groups.put("Internet", group);
    }

    private void defaultInitProtocol() {
        LinkedList<TelemetryDef> payload = new LinkedList<TelemetryDef>();
        payload.add(new TelemetryDefValue("Payload_nothing", 1, 6));
        payload.add(new TelemetryDefIVCurve("IVcurve_ZpXp", 1, 8, 8));
        payload.add(new TelemetryDefIVCurve("IVcurve_ZpXm", 1, 8, 8));
        payload.add(new TelemetryDefIVCurve("IVcurve_ZmYm", 1, 8, 8));
        payload.add(new TelemetryDefIVCurve("IVcurve_ZmYp", 1, 8, 8));
        payload.add(new TelemetryDefValue("TFSC_ZpXp_T", 1, 8));
        payload.add(new TelemetryDefValue("TFSC_ZpXm_T", 1, 8));
        payload.add(new TelemetryDefValue("TFSC_ZmYm_T", 1, 8));
        payload.add(new TelemetryDefValue("TFSC_ZmYp_T", 1, 8));
        payload.add(new TelemetryDefValue("RD_Xp_V", 1, 8));
        payload.add(new TelemetryDefValue("RD_Xm_V", 1, 8));
        payload.add(new TelemetryDefValue("RD_Xp_I", 1, 8));
        payload.add(new TelemetryDefValue("RD_Xm_I", 1, 8));
        payload.add(new TelemetryDefValue("RD_Ym_V", 1, 8));
        payload.add(new TelemetryDefValue("RD_Yp_V", 1, 8));
        payload.add(new TelemetryDefValue("RD_Ym_I", 1, 8));
        payload.add(new TelemetryDefValue("RD_Yp_I", 1, 8));
        payload.add(new TelemetryDefValue("AWSS Zm Sun Presence", 1, 1));
        payload.add(new TelemetryDefValue("AWSS Zm Sample Number", 1, 2));
        payload.add(new TelemetryDefValue("AWSS Zm Receiver Status", 1, 1));
        payload.add(new TelemetryDefValue("AWSS Zm Sensor Status", 1, 1));
        payload.add(new TelemetryDefValue("AWSS Zm Sensor ID", 1, 3));
        payload.add(new TelemetryDefValue("AWSS Zm Transmission Errors", 1, 8));
        payload.add(new TelemetryDefValue("AWSS Zm Suply Voltage", 1, 8));
        payload.add(new TelemetryDefValue("AWSS Zm Temperature", 1, 8));
        payload.add(new TelemetryDefValue("AWSS Zm ADC Value Q1", 1, 12));
        payload.add(new TelemetryDefValue("AWSS Zm ADC Value Q2", 1, 12));
        payload.add(new TelemetryDefValue("AWSS Zm ADC Value Q3", 1, 12));
        payload.add(new TelemetryDefValue("AWSS Zm ADC Value Q4", 1, 12));
        payload.add(new TelemetryDefValue("AWSS Zp Sun Presence", 1, 1));
        payload.add(new TelemetryDefValue("AWSS Zp Sample Number", 1, 2));
        payload.add(new TelemetryDefValue("AWSS Zp Receiver Status", 1, 1));
        payload.add(new TelemetryDefValue("AWSS Zp Sensor Status", 1, 1));
        payload.add(new TelemetryDefValue("AWSS Zp Sensor ID", 1, 3));
        payload.add(new TelemetryDefValue("AWSS Zp Transmission Errors", 1, 8));
        payload.add(new TelemetryDefValue("AWSS Zp Suply Voltage", 1, 8));
        payload.add(new TelemetryDefValue("AWSS Zp Temperature", 1, 8));
        payload.add(new TelemetryDefValue("AWSS Zp ADC Value Q1", 1, 12));
        payload.add(new TelemetryDefValue("AWSS Zp ADC Value Q2", 1, 12));
        payload.add(new TelemetryDefValue("AWSS Zp ADC Value Q3", 1, 12));
        payload.add(new TelemetryDefValue("AWSS Zp ADC Value Q4", 1, 12));
        payload.add(new TelemetryDefValue("TimeStamp Z-", 1, 4));
        payload.add(new TelemetryDefValue("TimeStamp Z+", 1, 4));
        LinkedList<TelemetryDefValue> housekeeping = new LinkedList<TelemetryDefValue>();
        housekeeping.add(new TelemetryDefValue("Boot counter", 1, 12));
        housekeeping.add(new TelemetryDefValue("LastRxdCmd_RXid", 1, 1));
        housekeeping.add(new TelemetryDefValue("EMP", 1, 1));
        housekeeping.add(new TelemetryDefValue("AWP", 1, 1));
        housekeeping.add(new TelemetryDefValue("RCP2", 1, 1));
        housekeeping.add(new TelemetryDefValue("RCP1", 1, 1));
        housekeeping.add(new TelemetryDefValue("RBP2", 1, 1));
        housekeeping.add(new TelemetryDefValue("RBP1", 1, 1));
        housekeeping.add(new TelemetryDefValue("MDP2", 1, 1));
        housekeeping.add(new TelemetryDefValue("MDP1", 1, 1));
        housekeeping.add(new TelemetryDefValue("CEP", 1, 1));
        housekeeping.add(new TelemetryDefValue("REP2", 1, 1));
        housekeeping.add(new TelemetryDefValue("REP1", 1, 1));
        housekeeping.add(new TelemetryDefValue("MEP2", 1, 1));
        housekeeping.add(new TelemetryDefValue("MEP1", 1, 1));
        housekeeping.add(new TelemetryDefValue("ADP4", 1, 1));
        housekeeping.add(new TelemetryDefValue("ADP3", 1, 1));
        housekeeping.add(new TelemetryDefValue("ADP2", 1, 1));
        housekeeping.add(new TelemetryDefValue("ADP1", 1, 1));
        housekeeping.add(new TelemetryDefValue("LastRxdCmd_cmd", 1, 64));
        housekeeping.add(new TelemetryDefValue("LastExeCmd_cmd", 1, 64));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_SP_ZmYp", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_SP_ZmYm", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZmXm", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZmYm", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZmXp", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZmYp", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_SP_ZpXp", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_SP_ZpXm", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZpYm", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZpXp", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZpYp", 1, 1));
        housekeeping.add(new TelemetryDefValue("deployStatusVector_MAB_ZpXm", 1, 1));
        housekeeping.add(new TelemetryDefValue("operationalMode", 1, 4));
        housekeeping.add(new TelemetryDefValue("bus_V_sys", 1, 8));
        housekeeping.add(new TelemetryDefValue("bus_V_dep", 1, 8));
        housekeeping.add(new TelemetryDefValue("OBC_T", 1, 8));
        housekeeping.add(new TelemetryDefValue("GaAsCurrent_ZpXp", 1, 8));
        housekeeping.add(new TelemetryDefValue("GaAsCurrent_ZmYm", 1, 8));
        housekeeping.add(new TelemetryDefValue("GaAsCurrent_ZpXm", 1, 8));
        housekeeping.add(new TelemetryDefValue("GaAsCurrent_ZmYp", 1, 8));
        housekeeping.add(new TelemetryDefValue("FM340 I", 1, 10));
        housekeeping.add(new TelemetryDefValue("MeBo ZpI", 1, 10));
        housekeeping.add(new TelemetryDefValue("MeBo ZmI", 1, 10));
        housekeeping.add(new TelemetryDefValue("ComBo I", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP1 Rx I", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP1 Tx I", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP2 Rx I", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP2 Tx I", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP1 fwd.P", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP2 fwd.P", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP1 refl. P", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP2 refl. P", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP1 RSSI", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP2 RSSI", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP1 dopplerV", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP2 dopplerV", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP1_T", 1, 10));
        housekeeping.add(new TelemetryDefValue("RAP2_T", 1, 10));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Sun Presence", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Sample Number", 1, 2));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Receiver Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Sensor Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Sensor ID", 1, 3));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Transmission Errors", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Suply Voltage", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm Temperature", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm ADC Value Q1", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm ADC Value Q2", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm ADC Value Q3", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zm ADC Value Q4", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Sun Presence", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Sample Number", 1, 2));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Receiver Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Sensor Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Sensor ID", 1, 3));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Transmission Errors", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Suply Voltage", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp Temperature", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp ADC Value Q1", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp ADC Value Q2", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp ADC Value Q3", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ AWSS Zp ADC Value Q4", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK+ TimeStamp Z-", 1, 4));
        housekeeping.add(new TelemetryDefValue("HK+ TimeStamp Z+", 1, 4));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Sun Presence", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Sample Number", 1, 2));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Receiver Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Sensor Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Sensor ID", 1, 3));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Transmission Errors", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Suply Voltage", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm Temperature", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm ADC Value Q1", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm ADC Value Q2", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm ADC Value Q3", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zm ADC Value Q4", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Sun Presence", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Sample Number", 1, 2));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Sensor Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Receiver Status", 1, 1));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Sensor ID", 1, 3));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Transmission Errors", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Suply Voltage", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp Temperature", 1, 8));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp ADC Value Q1", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp ADC Value Q2", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp ADC Value Q3", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- AWSS Zp ADC Value Q4", 1, 12));
        housekeeping.add(new TelemetryDefValue("HK- TimeStamp Z-", 1, 4));
        housekeeping.add(new TelemetryDefValue("HK- TimeStamp Z+", 1, 4));
        housekeeping.add(new TelemetryDefValue("RD_Xp_V", 1, 8));
        housekeeping.add(new TelemetryDefValue("RD_Xm_V", 1, 8));
        housekeeping.add(new TelemetryDefValue("RD_Xp_I", 1, 8));
        housekeeping.add(new TelemetryDefValue("RD_Xm_I", 1, 8));
        housekeeping.add(new TelemetryDefValue("RD_Ym_V", 1, 8));
        housekeeping.add(new TelemetryDefValue("RD_Yp_V", 1, 8));
        housekeeping.add(new TelemetryDefValue("RD_Ym_I", 1, 8));
        housekeeping.add(new TelemetryDefValue("RD_Yp_I", 1, 8));
        SettingsGroup group = new SettingsGroup();
        group.set("payload", new Setting(payload, false, false, "Payload frame"));
        group.set("housekeeping", new Setting(housekeeping, false, false, "Housekeeping frame"));
        this.groups.put("Protocol", group);
    }

    public SettingsGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public Object getSettingValue(String groupname, String settingname) {
        return this.groups.get(groupname).get(settingname).getValue();
    }

    public void setSettingValue(String groupname, String settingname) {
    }

    public Hashtable<String, SettingsGroup> getGroups() {
        return this.groups;
    }

    public void save() {
        new File(this.path).mkdir();
        Enumeration<String> e = this.groups.keys();
        while (e.hasMoreElements()) {
            try {
                String name = e.nextElement();
                FileOutputStream f = new FileOutputStream(this.path + "\\" + name.toLowerCase() + ".conf");
                ObjectOutputStream oos = new ObjectOutputStream(f);
                SettingsGroup group = this.groups.get(name);
                oos.writeObject(group);
                oos.close();
                f.close();
            }
            catch (Exception exception) {}
        }
    }

    public Boolean isModified() {
        Enumeration<SettingsGroup> e = this.groups.elements();
        while (e.hasMoreElements()) {
            if (!e.nextElement().isModified().booleanValue()) continue;
            return true;
        }
        return false;
    }
}

