/*
 * Decompiled with CFR 0.152.
 */
package rascal;

import ax25lib.Control;
import ax25lib.FrameEvent;
import ax25lib.FrameEventListener;
import javax.sound.sampled.TargetDataLine;
import rascal.FrameHandler;
import rascal.GUI;
import rascal.SettingsControl;

public class Rascal {
    private SettingsControl settingscontrol;
    public Control listenercontrol;
    private FrameHandler framehandler;
    public static final boolean RADIO_AMATEUR_VERSION = true;

    public Rascal() {
        try {
            GUI.setStatusMessage("Starting RASCAL");
            this.settingscontrol = new SettingsControl();
            this.listenercontrol = new Control(this);
            this.framehandler = new FrameHandler(this.settingscontrol, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCollecting(TargetDataLine line) {
        this.listenercontrol.startListening(line);
        this.listenercontrol.addFrameEventListener(new FrameEventListener(){

            public void frameEventOccurred(FrameEvent evt) {
                try {
                    Rascal.this.framehandler.handle(Rascal.this.listenercontrol.getFrame());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void stopCollecting() {
        if (this.listenercontrol != null) {
            this.listenercontrol.stopListening();
            this.framehandler.forceRepositoryWrite();
        }
    }

    public void tuningCallBack(int freq, int level, boolean locked) {
        this.framehandler.updateTuningGUI(freq, level, locked);
    }
}

