/*
 * Decompiled with CFR 0.152.
 */
package rascal;

import ax25lib.AX25Frame;
import dc3com.Telemetry;
import dc3com.TelemetryIVCurve;
import dc3com.TelemetryIVElement;
import dc3com.TelemetryStringValue;
import dc3com.TelemetryValue;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import rascal.Rascal;
import rascal.SettingsControl;
import rascal.SettingsEditor;
import rascal.TelemetrySubmitter;
import rascal.WarningLabel;

public class GUI
extends JFrame {
    public static SettingsControl settings;
    private SettingsEditor settingsdditor;
    private static TelemetrySubmitter primary_submitter;
    private static TelemetrySubmitter secondary_submitter;
    private Rascal rascal;
    private ChartPanel[] curves;
    private JFrame curve_frame;
    private static final Font plainfont;
    private static final Font boldfont;
    private Color defaultbackgroundcolor;
    private JFrame IVframe = null;
    private final int samplerate = 38400;
    private final int MONO = 1;
    private AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 38400.0f, 16, 1, 2, 38400.0f, true);
    private Vector<TargetDataLine> linelist = new Vector();
    private JLabel status_packetsrx;
    private JLabel status_updatetime;
    private static JLabel status_rep1_ondisk;
    private static JLabel status_rep1_sent;
    private static JLabel status_rep2_ondisk;
    private static JLabel status_rep2_sent;
    private JLabel tuning_lockstate;
    private JLabel tuning_freqlabel;
    private JSlider tuning_freqslider;
    private JProgressBar tuning_audiolevel;
    private JComboBox soundcardselect;
    private WarningLabel system_packetcount;
    private WarningLabel system_bootattempt;
    private WarningLabel system_bootsuccess;
    private WarningLabel system_opmode;
    private WarningLabel system_cmdrxrap;
    private WarningLabel system_lastrxcmd;
    private WarningLabel system_lastexecmd;
    private WarningLabel obc_temp;
    private WarningLabel obc_sysbus;
    private WarningLabel obc_depbus;
    private WarningLabel obc_current;
    private WarningLabel combo_cepmode;
    private WarningLabel combo_awpmode;
    private WarningLabel combo_current;
    private WarningLabel eps_empmode;
    private WarningLabel eps_zpxp;
    private WarningLabel eps_zpxm;
    private WarningLabel eps_zmyp;
    private WarningLabel eps_zmym;
    private WarningLabel mebozp_mepmode;
    private WarningLabel mebozp_mdpmode;
    private WarningLabel mebozp_current;
    private WarningLabel mebozm_mepmode;
    private WarningLabel mebozm_mdpmode;
    private WarningLabel mebozm_current;
    private WarningLabel rap1_repmode;
    private WarningLabel rap1_rbpmode;
    private WarningLabel rap1_rcpmode;
    private WarningLabel rap1_temp;
    private WarningLabel rap1_rxi;
    private WarningLabel rap1_txi;
    private WarningLabel rap1_fwd;
    private WarningLabel rap1_refl;
    private WarningLabel rap1_rssi;
    private WarningLabel rap1_doppler;
    private WarningLabel rap2_repmode;
    private WarningLabel rap2_rbpmode;
    private WarningLabel rap2_rcpmode;
    private WarningLabel rap2_temp;
    private WarningLabel rap2_rxi;
    private WarningLabel rap2_txi;
    private WarningLabel rap2_fwd;
    private WarningLabel rap2_refl;
    private WarningLabel rap2_rssi;
    private WarningLabel rap2_doppler;
    private WarningLabel icbzp_adp1mode;
    private WarningLabel icbzp_adp2mode;
    private WarningLabel icbzp_spzpxp;
    private WarningLabel icbzp_spzpxm;
    private WarningLabel icbzp_mabzpxp;
    private WarningLabel icbzp_mabzpxm;
    private WarningLabel icbzp_mabzpyp;
    private WarningLabel icbzp_mabzpym;
    private WarningLabel icbzm_adp3mode;
    private WarningLabel icbzm_adp4mode;
    private WarningLabel icbzm_spzmyp;
    private WarningLabel icbzm_spzmym;
    private WarningLabel icbzm_mabzmxp;
    private WarningLabel icbzm_mabzmxm;
    private WarningLabel icbzm_mabzmyp;
    private WarningLabel icbzm_mabzmym;
    private JTextArea terminal_area;
    private static JTextArea status_msgarea;
    private static int packets_received;
    private Telemetry tlm;
    private JMenuBar menuBar;

    public GUI(SettingsControl settingsctrl, Rascal rascal, TelemetrySubmitter submitter_1, TelemetrySubmitter submitter_2) {
        settings = settingsctrl;
        this.rascal = rascal;
        primary_submitter = submitter_1;
        secondary_submitter = submitter_2;
        this.initComponents();
        this.initAudioPanels();
        this.initSystemVitalsPanel();
        this.initOBCPanel();
        this.initComBoPanel();
        this.initEPSPanel();
        this.initMeboZpPanel();
        this.initMeboZmPanel();
        this.initRAP1Panel();
        this.initRAP2Panel();
        this.initICBZpPanel();
        this.initICBZmPanel();
        this.initTerminalPanel();
        this.initStatusPanel();
        this.initMenuBar();
        this.initIVCurveCharts();
        this.setTitle("Delfi-C3 RASCAL");
        this.setBounds(50, 50, 897, 710);
        this.setResizable(false);
        this.setVisible(true);
        if (this.linelist.size() > 0) {
            rascal.startCollecting(this.linelist.elementAt(0));
            GUI.setStatusMessage("Sampling " + this.soundcardselect.getItemAt(0).toString());
        }
    }

    private JPanel newPanel(String bordername) {
        JPanel panel = new JPanel();
        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        panel.setBorder(new TitledBorder(bordername));
        return panel;
    }

    private WarningLabel addInfoLabels(String name, int name_size, String unit, JPanel parentpanel, int y_pos) {
        JLabel label = new JLabel(name);
        label.setFont(boldfont);
        parentpanel.add(label);
        label.setBounds(10, y_pos, name_size, 20);
        WarningLabel returnlabel = new WarningLabel("n/a");
        returnlabel.setFont(plainfont);
        parentpanel.add(returnlabel);
        if (unit == null) {
            int width = Math.min(98, parentpanel.getWidth() - 4 - (name_size + 10));
            if (name.indexOf("Command") != -1) {
                returnlabel.setHorizontalAlignment(11);
                returnlabel.setBounds(name_size - 10, y_pos, width + 20, 20);
            } else {
                returnlabel.setBounds(name_size + 10, y_pos, width, 20);
            }
        } else {
            returnlabel.setBounds(name_size + 10, y_pos, 40, 20);
            label = new JLabel(unit);
            label.setFont(plainfont);
            parentpanel.add(label);
            label.setBounds(name_size + 10 + 50, y_pos, 40, 20);
        }
        return returnlabel;
    }

    private void initIVCurveCharts() {
        this.curves = new ChartPanel[4];
        for (int n = 1; n <= 4; ++n) {
            String chartlabel = "Curve ";
            switch (n) {
                case 1: {
                    chartlabel = chartlabel + " Z+ X+";
                    break;
                }
                case 2: {
                    chartlabel = chartlabel + " Z+ X-";
                    break;
                }
                case 3: {
                    chartlabel = chartlabel + " Z- Y-";
                    break;
                }
                case 4: {
                    chartlabel = chartlabel + " Z- Y+";
                }
            }
            JFreeChart chart = ChartFactory.createXYLineChart(chartlabel, "mV", "mA", null, PlotOrientation.VERTICAL, false, false, false);
            XYPlot temp = (XYPlot)chart.getPlot();
            temp.getDomainAxis().setRange(0.0, 2048.0);
            temp.getRangeAxis().setRange(0.0, 1024.0);
            this.curves[n - 1] = new ChartPanel(chart);
        }
    }

    private void initAudioPanels() {
        JPanel panel = this.newPanel("Audio level");
        this.add(panel);
        panel.setBounds(0, 0, 300, 100);
        JProgressBar bar = new JProgressBar();
        bar.setMaximum(32768);
        panel.add(bar);
        bar.setBounds(30, 30, 240, 15);
        this.tuning_audiolevel = bar;
        JComboBox<String> soundcardbox = new JComboBox<String>();
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixers.length; ++i) {
            try {
                TargetDataLine line = AudioSystem.getTargetDataLine(this.format, mixers[i]);
                soundcardbox.addItem(mixers[i].getName());
                this.linelist.add(line);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.linelist.size() != 0) {
            soundcardbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GUI.this.soundcardselectActionPerformed(evt);
                }
            });
        } else {
            soundcardbox.setEnabled(false);
        }
        soundcardbox.setBounds(30, 60, 240, 20);
        panel.add(soundcardbox);
        this.soundcardselect = soundcardbox;
        panel = this.newPanel("Frequency");
        this.add(panel);
        panel.setBounds(300, 0, 300, 100);
        JSlider freqslider = new JSlider(1400, 1800, 1600);
        freqslider.setMajorTickSpacing(100);
        freqslider.setMinorTickSpacing(10);
        freqslider.setPaintLabels(true);
        freqslider.setPaintTicks(true);
        freqslider.setBounds(10, 20, 280, 50);
        freqslider.setEnabled(false);
        panel.add(freqslider);
        this.tuning_freqslider = freqslider;
        JLabel synclabel = new JLabel("No sync");
        synclabel.setForeground(new Color(255, 0, 0));
        synclabel.setBounds(200, 75, 100, 20);
        synclabel.setHorizontalAlignment(10);
        panel.add(synclabel);
        this.tuning_lockstate = synclabel;
        JLabel freqlabel = new JLabel("1600");
        JLabel frequnitlabel = new JLabel(" Hz");
        freqlabel.setBounds(40, 75, 50, 20);
        freqlabel.setHorizontalAlignment(11);
        frequnitlabel.setBounds(90, 75, 20, 20);
        panel.add(frequnitlabel);
        panel.add(freqlabel);
        this.tuning_freqlabel = freqlabel;
        ImageIcon logo = new ImageIcon("lib/delfi.dat");
        if (logo.getImageLoadStatus() == 8) {
            JLabel logolabel = new JLabel(logo);
            this.add(logolabel);
            logolabel.setBounds(625, 0, 250, 100);
        }
    }

    private void initSystemVitalsPanel() {
        JPanel panel = this.newPanel("Satellite");
        panel.setBounds(0, 100, 250, 160);
        this.add(panel);
        int infolabelsize = 140;
        this.system_packetcount = this.addInfoLabels("Packet counter", infolabelsize, "packets", panel, 15);
        this.system_bootattempt = this.addInfoLabels("Bootcounter attempt", infolabelsize, "boots", panel, 35);
        this.system_bootsuccess = this.addInfoLabels("Bootcounter succes", infolabelsize, "boots", panel, 55);
        this.system_opmode = this.addInfoLabels("Operational mode", infolabelsize, null, panel, 75);
        this.system_cmdrxrap = this.addInfoLabels("Last Rx Cmd RAP", infolabelsize, null, panel, 95);
        this.system_lastrxcmd = new WarningLabel();
        this.system_lastexecmd = new WarningLabel();
    }

    private void initOBCPanel() {
        JPanel panel = this.newPanel("OBC");
        this.add(panel);
        panel.setBounds(250, 100, 220, 80);
        int infolabelsize = 120;
        this.obc_temp = this.addInfoLabels("OBC temperature", infolabelsize, "deg. C", panel, 15);
        this.obc_temp.setWarningLevels(-5.0, 30.0);
        this.obc_temp.setErrorLevels(-30.0, 60.0);
        this.obc_sysbus = this.addInfoLabels("System bus voltage", infolabelsize, "V", panel, 35);
        this.obc_sysbus.setWarningLevels(10.0, 12.5);
        this.obc_sysbus.setErrorLevels(8.0, 12.5);
        this.obc_current = this.addInfoLabels("OBC current", infolabelsize, "mA", panel, 55);
        this.obc_current.setWarningLevels(2.0, 4.0);
        this.obc_current.setErrorLevels(1.0, 6.0);
    }

    private void initComBoPanel() {
        JPanel panel = this.newPanel("ComBo");
        this.add(panel);
        panel.setBounds(250, 180, 220, 80);
        int infolabelsize = 120;
        this.combo_cepmode = this.addInfoLabels("CEP mode", infolabelsize, null, panel, 15);
        this.combo_awpmode = this.addInfoLabels("AWP mode", infolabelsize, null, panel, 35);
        this.combo_current = this.addInfoLabels("ComBo Current", infolabelsize, "mA", panel, 55);
        this.combo_current.setWarningLevels(3.0, 10.0);
        this.combo_current.setErrorLevels(1.0, 15.0);
    }

    private void initEPSPanel() {
        JPanel panel = this.newPanel("EPS");
        this.add(panel);
        panel.setBounds(470, 100, 210, 160);
        int infolabelsize = 120;
        this.eps_empmode = this.addInfoLabels("EMP op. mode", infolabelsize, null, panel, 15);
        this.eps_zpxp = this.addInfoLabels("GaAs Z+ X+ current", infolabelsize, "mA", panel, 35);
        this.eps_zpxm = this.addInfoLabels("GaAs Z+ X- current", infolabelsize, "mA", panel, 55);
        this.eps_zmyp = this.addInfoLabels("GaAs Z- Y+ current", infolabelsize, "mA", panel, 75);
        this.eps_zmym = this.addInfoLabels("GaAs Z- Y- current", infolabelsize, "mA", panel, 95);
    }

    private void initMeboZpPanel() {
        JPanel panel = this.newPanel("MeBo Z+");
        this.add(panel);
        panel.setBounds(680, 100, 210, 80);
        int infolabelsize = 120;
        this.mebozp_mepmode = this.addInfoLabels("MEP Z+ op. mode", infolabelsize, null, panel, 15);
        this.mebozp_mdpmode = this.addInfoLabels("MDP Z+ op. mode", infolabelsize, null, panel, 35);
        this.mebozp_current = this.addInfoLabels("MeBo Z+ current", infolabelsize, "mA", panel, 55);
        this.mebozp_current.setWarningLevels(1.0, 5.0);
        this.mebozp_current.setErrorLevels(0.5, 7.0);
    }

    private void initMeboZmPanel() {
        JPanel panel = this.newPanel("MeBo Z-");
        this.add(panel);
        panel.setBounds(680, 180, 210, 80);
        int infolabelsize = 120;
        this.mebozm_mepmode = this.addInfoLabels("MEP Z- op. mode", infolabelsize, null, panel, 15);
        this.mebozm_mdpmode = this.addInfoLabels("MDP Z- op. mode", infolabelsize, null, panel, 35);
        this.mebozm_current = this.addInfoLabels("MeBo Z- current", infolabelsize, "mA", panel, 55);
        this.mebozm_current.setWarningLevels(1.0, 5.0);
        this.mebozm_current.setErrorLevels(0.5, 7.0);
    }

    private void initRAP1Panel() {
        JPanel panel = this.newPanel("RAP 1");
        this.add(panel);
        panel.setBounds(0, 260, 245, 220);
        int infolabelsize = 135;
        this.rap1_repmode = this.addInfoLabels("REP1 op. mode", infolabelsize, null, panel, 15);
        this.rap1_rcpmode = this.addInfoLabels("RCP1 op. mode", infolabelsize, null, panel, 35);
        this.rap1_rbpmode = this.addInfoLabels("RBP1 op. mode", infolabelsize, null, panel, 55);
        this.rap1_temp = this.addInfoLabels("RAP 1 temperature", infolabelsize, "deg. C", panel, 75);
        this.rap1_temp.setWarningLevels(-5.0, 40.0);
        this.rap1_temp.setErrorLevels(-30.0, 60.0);
        this.rap1_rxi = this.addInfoLabels("RAP 1 Rx current", infolabelsize, "mA", panel, 95);
        this.rap1_rxi.setWarningLevels(20.0, 30.0);
        this.rap1_rxi.setErrorLevels(0.0, 40.0);
        this.rap1_txi = this.addInfoLabels("RAP 1 Tx current", infolabelsize, "mA", panel, 115);
        this.rap1_txi.setWarningLevels(110.0, 130.0);
        this.rap1_txi.setErrorLevels(100.0, 140.0);
        this.rap1_fwd = this.addInfoLabels("RAP 1 fwd. power", infolabelsize, "mW", panel, 135);
        this.rap1_fwd.setWarningLevels(60.0, 150.0);
        this.rap1_fwd.setErrorLevels(40.0, 175.0);
        this.rap1_refl = this.addInfoLabels("RAP 1 refl. power", infolabelsize, "mW", panel, 155);
        this.rap1_refl.setWarningLevels(-1.0, 10.0);
        this.rap1_refl.setErrorLevels(-1.0, 20.0);
        this.rap1_rssi = new WarningLabel();
        this.rap1_doppler = new WarningLabel();
    }

    private void initRAP2Panel() {
        JPanel panel = this.newPanel("RAP 2");
        this.add(panel);
        panel.setBounds(245, 260, 245, 220);
        int infolabelsize = 135;
        this.rap2_repmode = this.addInfoLabels("REP2 op. mode", infolabelsize, null, panel, 15);
        this.rap2_rcpmode = this.addInfoLabels("RCP2 op. mode", infolabelsize, null, panel, 35);
        this.rap2_rbpmode = this.addInfoLabels("RBP2 op. mode", infolabelsize, null, panel, 55);
        this.rap2_temp = this.addInfoLabels("RAP 2 temperature", infolabelsize, "deg. C", panel, 75);
        this.rap2_temp.setWarningLevels(-5.0, 40.0);
        this.rap2_temp.setErrorLevels(-30.0, 60.0);
        this.rap2_rxi = this.addInfoLabels("RAP 2 Rx current", infolabelsize, "mA", panel, 95);
        this.rap2_rxi.setWarningLevels(20.0, 30.0);
        this.rap2_rxi.setErrorLevels(0.0, 40.0);
        this.rap2_txi = this.addInfoLabels("RAP 2 Tx current", infolabelsize, "mA", panel, 115);
        this.rap2_txi.setWarningLevels(110.0, 130.0);
        this.rap2_txi.setErrorLevels(100.0, 140.0);
        this.rap2_fwd = this.addInfoLabels("RAP 2 fwd. power", infolabelsize, "mW", panel, 135);
        this.rap2_fwd.setWarningLevels(60.0, 150.0);
        this.rap2_fwd.setErrorLevels(40.0, 175.0);
        this.rap2_refl = this.addInfoLabels("RAP 2 refl. power", infolabelsize, "mW", panel, 155);
        this.rap2_refl.setWarningLevels(-1.0, 10.0);
        this.rap2_refl.setErrorLevels(-1.0, 20.0);
        this.rap2_rssi = new WarningLabel();
        this.rap2_doppler = new WarningLabel();
    }

    private void initICBZpPanel() {
        JPanel panel = this.newPanel("ICB Z+");
        this.add(panel);
        panel.setBounds(490, 260, 200, 220);
        int infolabelsize = 110;
        this.icbzp_adp1mode = this.addInfoLabels("ADP 1 op. mode", infolabelsize, null, panel, 15);
        this.icbzp_adp2mode = this.addInfoLabels("ADP 2 op. mode", infolabelsize, null, panel, 35);
        this.icbzp_spzpxp = this.addInfoLabels("Solar Panel Z+ X+", infolabelsize, null, panel, 55);
        this.icbzp_spzpxm = this.addInfoLabels("Solar Panel Z+ X-", infolabelsize, null, panel, 75);
        this.icbzp_mabzpxp = this.addInfoLabels("Antenna Z+ X+", infolabelsize, null, panel, 95);
        this.icbzp_mabzpxm = this.addInfoLabels("Antenna Z+ X-", infolabelsize, null, panel, 115);
        this.icbzp_mabzpyp = this.addInfoLabels("Antenna Z+ Y+", infolabelsize, null, panel, 135);
        this.icbzp_mabzpym = this.addInfoLabels("Antenna Z+ Y-", infolabelsize, null, panel, 155);
    }

    private void initICBZmPanel() {
        JPanel panel = this.newPanel("ICB Z-");
        this.add(panel);
        panel.setBounds(690, 260, 200, 220);
        int infolabelsize = 110;
        this.icbzm_adp3mode = this.addInfoLabels("ADP3 op. mode", infolabelsize, null, panel, 15);
        this.icbzm_adp4mode = this.addInfoLabels("ADP4 op. mode", infolabelsize, null, panel, 35);
        this.icbzm_spzmyp = this.addInfoLabels("Solar Panel Z- Y+", infolabelsize, null, panel, 55);
        this.icbzm_spzmym = this.addInfoLabels("Solar Panel Z- Y-", infolabelsize, null, panel, 75);
        this.icbzm_mabzmxp = this.addInfoLabels("Antenna Z- X+", infolabelsize, null, panel, 95);
        this.icbzm_mabzmxm = this.addInfoLabels("Antenna Z- X-", infolabelsize, null, panel, 115);
        this.icbzm_mabzmyp = this.addInfoLabels("Antenna Z- Y+", infolabelsize, null, panel, 135);
        this.icbzm_mabzmym = this.addInfoLabels("Antenna Z- Y-", infolabelsize, null, panel, 155);
    }

    private void initTerminalPanel() {
        JPanel panel = this.newPanel("Terminal");
        this.add(panel);
        panel.setBounds(0, 480, 490, 175);
        JScrollPane pane = new JScrollPane();
        JTextArea area = new JTextArea();
        area.setFont(new Font("Courier New", 0, 10));
        area.setBackground(new Color(0, 0, 0));
        area.setForeground(new Color(255, 255, 255));
        area.setAutoscrolls(true);
        area.setLineWrap(false);
        area.setEditable(false);
        this.terminal_area = area;
        pane.setViewportView(area);
        panel.add(pane);
        pane.setBounds(8, 20, 475, 150);
    }

    private void initStatusPanel() {
        JPanel panel = this.newPanel("Status messages");
        this.add(panel);
        panel.setBounds(490, 480, 400, 175);
        JLabel label = new JLabel("Packets received:");
        panel.add(label);
        label.setFont(boldfont);
        label.setBounds(10, 15, 110, 20);
        label = new JLabel("0");
        panel.add(label);
        label.setFont(plainfont);
        label.setHorizontalAlignment(11);
        label.setBounds(120, 15, 30, 20);
        this.status_packetsrx = label;
        label = new JLabel("Last packet received:");
        panel.add(label);
        label.setFont(boldfont);
        label.setBounds(170, 15, 120, 20);
        label = new JLabel("never");
        panel.add(label);
        label.setFont(plainfont);
        label.setHorizontalAlignment(11);
        label.setBounds(285, 15, 110, 20);
        this.status_updatetime = label;
        label = new JLabel("Primary repository");
        panel.add(label);
        label.setFont(boldfont);
        label.setHorizontalAlignment(0);
        label.setBounds(10, 35, 190, 20);
        label = new JLabel("Secondary repository");
        panel.add(label);
        label.setFont(boldfont);
        label.setHorizontalAlignment(0);
        label.setBounds(200, 35, 190, 20);
        label = new JLabel("Disk:");
        panel.add(label);
        label.setFont(boldfont);
        label.setBounds(15, 55, 35, 20);
        label = new JLabel("0");
        panel.add(label);
        label.setFont(plainfont);
        label.setHorizontalAlignment(11);
        label.setBounds(50, 55, 40, 20);
        status_rep1_ondisk = label;
        label = new JLabel("Sent:");
        panel.add(label);
        label.setFont(boldfont);
        label.setBounds(105, 55, 40, 20);
        label = new JLabel("0");
        panel.add(label);
        label.setFont(plainfont);
        label.setHorizontalAlignment(11);
        label.setBounds(145, 55, 40, 20);
        status_rep1_sent = label;
        label = new JLabel("Disk:");
        panel.add(label);
        label.setFont(boldfont);
        label.setBounds(205, 55, 35, 20);
        label = new JLabel("0");
        panel.add(label);
        label.setFont(plainfont);
        label.setHorizontalAlignment(11);
        label.setBounds(240, 55, 40, 20);
        status_rep2_ondisk = label;
        label = new JLabel("Sent:");
        panel.add(label);
        label.setFont(boldfont);
        label.setBounds(295, 55, 40, 20);
        label = new JLabel("0");
        panel.add(label);
        label.setFont(plainfont);
        label.setHorizontalAlignment(11);
        label.setBounds(340, 55, 40, 20);
        status_rep2_sent = label;
        JSeparator sep = new JSeparator();
        panel.add(sep);
        sep.setForeground(Color.BLACK);
        sep.setBounds(5, 35, 1, 40);
        sep.setOrientation(1);
        sep = new JSeparator();
        panel.add(sep);
        sep.setForeground(Color.BLACK);
        sep.setBounds(200, 35, 1, 40);
        sep.setOrientation(1);
        sep = new JSeparator();
        panel.add(sep);
        sep.setForeground(Color.BLACK);
        sep.setBounds(395, 35, 1, 40);
        sep.setOrientation(1);
        sep = new JSeparator();
        panel.add(sep);
        sep.setForeground(Color.BLACK);
        sep.setBounds(5, 35, 391, 1);
        sep.setOrientation(0);
        sep = new JSeparator();
        panel.add(sep);
        sep.setForeground(Color.GRAY);
        sep.setBounds(5, 55, 391, 1);
        sep.setOrientation(0);
        sep = new JSeparator();
        panel.add(sep);
        sep.setForeground(Color.BLACK);
        sep.setBounds(5, 75, 391, 1);
        sep.setOrientation(0);
        this.updateRepositoryData();
        JScrollPane pane = new JScrollPane();
        if (status_msgarea == null) {
            GUI.createStatusMessageTextArea();
        }
        pane.setViewportView(status_msgarea);
        panel.add(pane);
        pane.setBounds(5, 80, 390, 90);
    }

    private void initMenuBar() {
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("About RASCAL");
        item.setActionCommand("about");
        item.addActionListener(new MenuActionListener());
        menu.add(item);
        item = new JMenuItem("Exit");
        item.setActionCommand("exit");
        item.addActionListener(new MenuActionListener());
        menu.add(item);
        this.menuBar.add(menu);
        menu = new JMenu("Options");
        item = new JMenuItem("Settings");
        item.setActionCommand("settings");
        item.addActionListener(new MenuActionListener());
        menu.add(item);
        item = new JMenuItem("Copy terminal to clipboard");
        item.setActionCommand("termtoclipboard");
        item.addActionListener(new MenuActionListener());
        menu.add(item);
        item = new JMenuItem("Show IV curves");
        item.setActionCommand("curves");
        item.addActionListener(new MenuActionListener());
        menu.add(item);
        this.menuBar.add(menu);
    }

    private static void createStatusMessageTextArea() {
        JTextArea area = new JTextArea();
        area.setFont(new Font("Courier New", 0, 10));
        area.setBackground(new Color(0, 0, 0));
        area.setForeground(new Color(255, 255, 255));
        area.setAutoscrolls(true);
        area.setLineWrap(true);
        area.setEditable(false);
        status_msgarea = area;
    }

    public static void setStatusMessage(String message) {
        if (status_msgarea == null) {
            GUI.createStatusMessageTextArea();
        }
        String messagestring = "[";
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("kk:mm:ss");
        messagestring = messagestring + format.format(date) + "] " + message + "\n";
        status_msgarea.append(messagestring);
        status_msgarea.setCaretPosition(status_msgarea.getDocument().getLength());
    }

    private void soundcardselectActionPerformed(ActionEvent evt) {
        this.rascal.startCollecting(this.linelist.elementAt(this.soundcardselect.getSelectedIndex()));
        GUI.setStatusMessage("Sampling " + this.soundcardselect.getSelectedItem().toString());
    }

    public static void updateRepositoryData() {
        status_rep1_ondisk.setText(String.valueOf(primary_submitter.getRepositorySize()));
        status_rep1_sent.setText(String.valueOf(primary_submitter.getSubmitCount()));
        status_rep2_ondisk.setText(String.valueOf(secondary_submitter.getRepositorySize()));
        status_rep2_sent.setText(String.valueOf(secondary_submitter.getSubmitCount()));
    }

    private void addFrameToTerminal(AX25Frame frame) {
        int i;
        String framestring = frame.toString();
        String outputstring = "from: ";
        int[] dest = frame.getDestination();
        int[] src = frame.getSource();
        for (i = 0; i < 6; ++i) {
            outputstring = outputstring + (char)(src[i] >> 1);
        }
        outputstring = outputstring + " to: ";
        for (i = 0; i < 6; ++i) {
            outputstring = outputstring + (char)(dest[i] >> 1);
        }
        this.terminal_area.append(outputstring + " " + framestring + "\n");
        this.terminal_area.setCaretPosition(this.terminal_area.getDocument().getLength());
    }

    public void handle(Telemetry telemetry, AX25Frame frame) {
        this.tlm = telemetry;
        this.status_packetsrx.setText(packets_received++ + "");
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy kk:mm:ss");
        this.status_updatetime.setText(format.format(date));
        this.updateRepositoryData();
        this.system_bootattempt.setText(this.tlm.attbootcounter);
        this.system_packetcount.setText(this.tlm.seq);
        this.addFrameToTerminal(frame);
        switch (this.tlm.getType()) {
            case Housekeeping: {
                int value = ((TelemetryValue)this.tlm.getField("Boot counter")).getValue();
                this.system_bootsuccess.setText(value);
                value = ((TelemetryValue)this.tlm.getField("operationalMode")).getValue();
                switch (value) {
                    case 0: {
                        this.system_opmode.setText(" idle");
                        break;
                    }
                    case 1: {
                        this.system_opmode.setText(" deployment");
                        break;
                    }
                    case 2: {
                        this.system_opmode.setText(" basic");
                        break;
                    }
                    case 3: {
                        this.system_opmode.setText(" science");
                        break;
                    }
                    case 4: {
                        this.system_opmode.setText(" transponder");
                    }
                }
                value = ((TelemetryValue)this.tlm.getField("LastRxdCmd_RXid")).getValue();
                if (value == 0) {
                    this.system_cmdrxrap.setText(" RAP 1");
                } else if (value == 1) {
                    this.system_cmdrxrap.setText(" RAP 2");
                }
                this.system_lastexecmd.setText(((TelemetryStringValue)this.tlm.getField("LastExeCmd_cmd")).toString());
                this.system_lastrxcmd.setText(((TelemetryStringValue)this.tlm.getField("LastRxdCmd_cmd")).toString());
                value = ((TelemetryValue)this.tlm.getField("OBC_T")).getValue();
                this.obc_temp.setText((double)value * 0.685 - 55.0);
                value = ((TelemetryValue)this.tlm.getField("bus_V_sys")).getValue();
                this.obc_sysbus.setText((double)value * 0.049);
                value = ((TelemetryValue)this.tlm.getField("FM340 I")).getValue();
                this.obc_current.setText((double)value * 0.395);
                this.setPICMode("CEP", this.combo_cepmode);
                this.setPICMode("AWP", this.combo_awpmode);
                value = ((TelemetryValue)this.tlm.getField("ComBo I")).getValue();
                this.combo_current.setText((double)value * 0.395);
                this.setPICMode("EMP", this.eps_empmode);
                value = ((TelemetryValue)this.tlm.getField("GaAsCurrent_ZpXp")).getValue();
                this.eps_zpxp.setText((double)value * 1.953);
                value = ((TelemetryValue)this.tlm.getField("GaAsCurrent_ZpXm")).getValue();
                this.eps_zpxm.setText((double)value * 1.953);
                value = ((TelemetryValue)this.tlm.getField("GaAsCurrent_ZmYp")).getValue();
                this.eps_zmyp.setText((double)value * 1.953);
                value = ((TelemetryValue)this.tlm.getField("GaAsCurrent_ZmYm")).getValue();
                this.eps_zmym.setText((double)value * 1.953);
                this.setPICMode("MEP1", this.mebozp_mepmode);
                this.setPICMode("MDP1", this.mebozp_mdpmode);
                value = ((TelemetryValue)this.tlm.getField("MeBo ZpI")).getValue();
                this.mebozp_current.setText((double)value * 0.395);
                this.setPICMode("MEP2", this.mebozm_mepmode);
                this.setPICMode("MDP2", this.mebozm_mdpmode);
                value = ((TelemetryValue)this.tlm.getField("MeBo ZmI")).getValue();
                this.mebozm_current.setText((double)value * 0.395);
                this.setPICMode("REP1", this.rap1_repmode);
                this.setPICMode("RBP1", this.rap1_rbpmode);
                this.setPICMode("RCP1", this.rap1_rcpmode);
                value = ((TelemetryValue)this.tlm.getField("RAP1_T")).getValue();
                this.rap1_temp.setText((double)value * 0.213 - 68.1);
                value = ((TelemetryValue)this.tlm.getField("RAP1 Rx I")).getValue();
                this.rap1_rxi.setText((double)value * 0.395);
                value = ((TelemetryValue)this.tlm.getField("RAP1 Tx I")).getValue();
                this.rap1_txi.setText((double)value * 0.395);
                value = ((TelemetryValue)this.tlm.getField("RAP1 fwd.P")).getValue();
                this.rap1_fwd.setText((double)(value * value) * 4.78E-4);
                value = ((TelemetryValue)this.tlm.getField("RAP1 refl. P")).getValue();
                this.rap1_refl.setText((double)(value * value) * 4.78E-4);
                value = ((TelemetryValue)this.tlm.getField("RAP1 RSSI")).getValue();
                this.rap1_rssi.setText((double)value * 3.23 * -0.32 + 905.08);
                value = ((TelemetryValue)this.tlm.getField("RAP1 dopplerV")).getValue();
                this.rap1_doppler.setText((double)value * 3.23 * -23.81686 + 4.35687771E8 - 4.35659E8);
                this.setPICMode("REP2", this.rap2_repmode);
                this.setPICMode("RBP2", this.rap2_rbpmode);
                this.setPICMode("RCP2", this.rap2_rcpmode);
                value = ((TelemetryValue)this.tlm.getField("RAP2_T")).getValue();
                this.rap2_temp.setText((double)value * 0.213 - 68.1);
                value = ((TelemetryValue)this.tlm.getField("RAP2 Rx I")).getValue();
                this.rap2_rxi.setText((double)value * 0.395);
                value = ((TelemetryValue)this.tlm.getField("RAP2 Tx I")).getValue();
                this.rap2_txi.setText((double)value * 0.395);
                value = ((TelemetryValue)this.tlm.getField("RAP2 fwd.P")).getValue();
                this.rap2_fwd.setText((double)(value * value) * 4.78E-4);
                value = ((TelemetryValue)this.tlm.getField("RAP2 refl. P")).getValue();
                this.rap2_refl.setText((double)(value * value) * 4.78E-4);
                value = ((TelemetryValue)this.tlm.getField("RAP2 RSSI")).getValue();
                this.rap2_rssi.setText((double)value * 3.23 * -0.461538 + 1174.7692);
                value = ((TelemetryValue)this.tlm.getField("RAP2 dopplerV")).getValue();
                this.rap2_doppler.setText((double)value * 3.23 * -20.2703 + 4.35626047E8 - 4.356E8);
                this.setPICMode("ADP1", this.icbzp_adp1mode);
                this.setPICMode("ADP2", this.icbzp_adp2mode);
                this.setDeployStatus("deployStatusVector_SP_ZpXp", this.icbzp_spzpxp);
                this.setDeployStatus("deployStatusVector_SP_ZpXm", this.icbzp_spzpxm);
                this.setDeployStatus("deployStatusVector_MAB_ZpXp", this.icbzp_mabzpxp);
                this.setDeployStatus("deployStatusVector_MAB_ZpXm", this.icbzp_mabzpxm);
                this.setDeployStatus("deployStatusVector_MAB_ZpYp", this.icbzp_mabzpyp);
                this.setDeployStatus("deployStatusVector_MAB_ZpYm", this.icbzp_mabzpym);
                this.setPICMode("ADP3", this.icbzm_adp3mode);
                this.setPICMode("ADP4", this.icbzm_adp4mode);
                this.setDeployStatus("deployStatusVector_SP_ZmYp", this.icbzm_spzmyp);
                this.setDeployStatus("deployStatusVector_SP_ZmYm", this.icbzm_spzmym);
                this.setDeployStatus("deployStatusVector_MAB_ZmXp", this.icbzm_mabzmxp);
                this.setDeployStatus("deployStatusVector_MAB_ZmXm", this.icbzm_mabzmxm);
                this.setDeployStatus("deployStatusVector_MAB_ZmYp", this.icbzm_mabzmyp);
                this.setDeployStatus("deployStatusVector_MAB_ZmYm", this.icbzm_mabzmym);
                break;
            }
            case Payload: {
                for (int n = 1; n <= 4; ++n) {
                    String chartlabel = "Curve ";
                    String panelname = "";
                    String TFSC_temp_value = "";
                    switch (n) {
                        case 1: {
                            chartlabel = chartlabel + " Z+ X+";
                            panelname = "ZpXp";
                            int value = ((TelemetryValue)this.tlm.getField("TFSC_" + panelname + "_T")).getValue();
                            TFSC_temp_value = String.valueOf(-235.0 + (double)value * 1.389);
                            break;
                        }
                        case 2: {
                            chartlabel = chartlabel + " Z+ X-";
                            panelname = "ZpXm";
                            int value = ((TelemetryValue)this.tlm.getField("TFSC_" + panelname + "_T")).getValue();
                            TFSC_temp_value = String.valueOf(-235.0 + (double)value * 1.492);
                            break;
                        }
                        case 3: {
                            chartlabel = chartlabel + " Z- Y-";
                            panelname = "ZmYm";
                            int value = ((TelemetryValue)this.tlm.getField("TFSC_" + panelname + "_T")).getValue();
                            TFSC_temp_value = String.valueOf(-235.0 + (double)value * 1.445);
                            break;
                        }
                        case 4: {
                            chartlabel = chartlabel + " Z- Y+";
                            panelname = "ZmYp";
                            int value = ((TelemetryValue)this.tlm.getField("TFSC_" + panelname + "_T")).getValue();
                            TFSC_temp_value = String.valueOf(-235.0 + (double)value * 1.445);
                        }
                    }
                    TelemetryIVCurve iv_curve = (TelemetryIVCurve)this.tlm.getField("IVcurve_" + panelname);
                    TelemetryIVElement[] curve = iv_curve.getCurve();
                    XYSeries series = new XYSeries((Comparable)((Object)""));
                    series.add(0.0, curve[0].getI() * 4);
                    for (int i = 0; i < curve.length; ++i) {
                        series.add((double)(curve[i].getV() * 8), curve[i].getI() * 4);
                    }
                    XYSeriesCollection collection = new XYSeriesCollection(series);
                    JFreeChart chart = ChartFactory.createXYLineChart(chartlabel, "mV", "mA", collection, PlotOrientation.VERTICAL, false, false, false);
                    XYPlot temp = (XYPlot)chart.getPlot();
                    temp.getDomainAxis().setRange(0.0, 2048.0);
                    temp.getRangeAxis().setRange(0.0, 1024.0);
                    TFSC_temp_value = TFSC_temp_value.substring(0, Math.min(6, TFSC_temp_value.length())) + " C";
                    XYTextAnnotation textannotation = new XYTextAnnotation(TFSC_temp_value, 1750.0, 900.0);
                    temp.addAnnotation(textannotation);
                    this.curves[n - 1].setChart(chart);
                }
                break;
            }
            case Auxiliary: {
                break;
            }
        }
    }

    private void setPICMode(String fieldname, JLabel textlabel) {
        int value = ((TelemetryValue)this.tlm.getField(fieldname)).getValue();
        if (value == 0) {
            textlabel.setText(" OBM");
        } else if (value == 1) {
            textlabel.setText(" OBC");
            textlabel.setBackground(this.defaultbackgroundcolor);
        }
    }

    private void setDeployStatus(String fieldname, JLabel textlabel) {
        int value = ((TelemetryValue)this.tlm.getField(fieldname)).getValue();
        if (value == 0) {
            textlabel.setText(" undeployed");
        } else if (value == 1) {
            textlabel.setText(" deployed");
            textlabel.setBackground(this.defaultbackgroundcolor);
        }
    }

    public void updatetuning(int frequency, int level, boolean lockstate) {
        this.tuning_freqlabel.setText("" + frequency);
        this.tuning_audiolevel.setValue(level);
        if (level > 20000) {
            this.tuning_audiolevel.setForeground(new Color(255, 0, 0));
        } else {
            this.tuning_audiolevel.setForeground(new Color(0, 255, 0));
        }
        this.tuning_freqslider.setValue(frequency);
        if (lockstate) {
            this.tuning_lockstate.setEnabled(true);
            this.tuning_lockstate.setText("Sync");
            this.tuning_lockstate.setForeground(new Color(0, 255, 0));
        } else {
            this.tuning_lockstate.setEnabled(false);
            this.tuning_lockstate.setText("No Sync");
        }
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GUI.this.formWindowClosing(evt);
            }
        });
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1056, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 626, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeRASCAL();
    }

    private void closeRASCAL() {
        GUI.setStatusMessage("Closing RASCAL");
        this.setVisible(false);
        this.rascal.stopCollecting();
        System.exit(0);
    }

    static {
        plainfont = new Font("Verdana Plain", 0, 11);
        boldfont = new Font("Verdana Plain", 1, 11);
        packets_received = 0;
    }

    private class MenuActionListener
    implements ActionListener {
        private MenuActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String actioncommand = ((JMenuItem)actionEvent.getSource()).getActionCommand();
            if (actioncommand == "settings") {
                SettingsEditor edit = new SettingsEditor(settings, GUI.this.rascal);
            }
            if (actioncommand == "about") {
                this.showAboutDialog();
            }
            if (actioncommand == "exit") {
                GUI.this.closeRASCAL();
            }
            if (actioncommand == "termtoclipboard") {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection select = new StringSelection(GUI.this.terminal_area.getText());
                clip.setContents(select, null);
                GUI.setStatusMessage("Terminal data copied to clipboard");
            }
            if (actioncommand == "curves") {
                if (GUI.this.IVframe != null) {
                    GUI.this.IVframe.setVisible(true);
                    return;
                }
                JFrame frame = new JFrame("IV Curves");
                frame.setDefaultCloseOperation(2);
                GridLayout grid = new GridLayout(2, 2);
                frame.setLayout(grid);
                frame.setBounds(30, 30, 700, 700);
                frame.add(GUI.this.curves[0]);
                frame.add(GUI.this.curves[1]);
                frame.add(GUI.this.curves[2]);
                frame.add(GUI.this.curves[3]);
                frame.setResizable(false);
                frame.setVisible(true);
                GUI.this.IVframe = frame;
            }
        }

        private void showAboutDialog() {
            JDialog aboutdialog = new JDialog();
            aboutdialog.setBounds(200, 200, 300, 410);
            aboutdialog.setModal(true);
            aboutdialog.setDefaultCloseOperation(2);
            aboutdialog.setTitle("About Delfi-C3 RASCAL");
            ImageIcon logo = new ImageIcon("lib/delfi.dat");
            JLabel label = new JLabel(logo);
            label.setBounds(25, 10, 250, 100);
            aboutdialog.add(label);
            JSeparator sep = new JSeparator();
            sep.setBounds(0, 110, 300, 1);
            aboutdialog.add(sep);
            label = new JLabel("Delfi-C3 RASCAL");
            label.setBounds(0, 110, 300, 40);
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            label.setFont(new Font("Verdana Plain", 1, 25));
            aboutdialog.add(label);
            label = new JLabel("Version 1.0.1");
            label.setFont(new Font("Verdana Plain", 0, 12));
            label.setBounds(0, 150, 300, 20);
            label.setHorizontalAlignment(0);
            aboutdialog.add(label);
            label = new JLabel("released April 26 2008");
            label.setFont(new Font("Verdana Plain", 0, 12));
            label.setBounds(0, 170, 300, 20);
            label.setHorizontalAlignment(0);
            aboutdialog.add(label);
            sep = new JSeparator();
            sep.setBounds(0, 195, 300, 1);
            aboutdialog.add(sep);
            label = new JLabel("Development leads");
            label.setFont(new Font("Verdana Plain", 1, 13));
            label.setBounds(10, 200, 300, 20);
            aboutdialog.add(label);
            label = new JLabel("<html>&nbsp;Gerard Aalbers<br />&nbsp;Wouter Jan Ubbels (PE4WJ)</html>");
            label.setFont(new Font("Verdana Plain", 0, 12));
            label.setVerticalAlignment(1);
            label.setBounds(25, 222, 200, 40);
            aboutdialog.add(label);
            label = new JLabel("Developers");
            label.setFont(new Font("Verdana Plain", 1, 13));
            label.setBounds(10, 265, 300, 20);
            aboutdialog.add(label);
            String developers = "<html>";
            developers = developers + "&nbsp;Imran Khan<br />";
            developers = developers + "&nbsp;Maarten van den Oever<br />";
            developers = developers + "&nbsp;Roel Reijerse<br />";
            developers = developers + "&nbsp;Vikko Smit<br />";
            developers = developers + "&nbsp;Dani\u00ebl Versluys";
            developers = developers + "</html>";
            label = new JLabel(developers);
            label.setBounds(25, 287, 300, 80);
            label.setFont(new Font("Verdana Plain", 0, 12));
            label.setVerticalAlignment(1);
            aboutdialog.add(label);
            aboutdialog.add(new JLabel());
            aboutdialog.setResizable(false);
            aboutdialog.setVisible(true);
        }
    }
}

