/*
 * Decompiled with CFR 0.152.
 */
package rascal;

import ax25lib.AX25Frame;
import dc3com.Telemetry;
import java.io.IOException;
import rascal.GUI;
import rascal.Rascal;
import rascal.SettingsControl;
import rascal.TelemetrySubmitter;

public class FrameHandler {
    private SettingsControl settings;
    private GUI gui;
    private TelemetrySubmitter telemetrysubmitter;
    private TelemetrySubmitter telemetrysubmitter_backup;
    private static final int[] source_addr = new int[]{136, 152, 140, 146, 134, 102};
    private static final int[] dest_addr = new int[]{168, 152, 154, 64, 64, 64};

    public FrameHandler(SettingsControl settingsctrl, Rascal rascal) {
        this.settings = settingsctrl;
        this.telemetrysubmitter = new TelemetrySubmitter(this.settings, true);
        this.telemetrysubmitter_backup = new TelemetrySubmitter(this.settings, false);
        this.gui = new GUI(this.settings, rascal, this.telemetrysubmitter, this.telemetrysubmitter_backup);
        try {
            this.telemetrysubmitter.start();
            this.telemetrysubmitter_backup.start();
        }
        catch (Exception e) {
            System.exit(0);
        }
    }

    public void handle(AX25Frame frame) throws IOException {
        if (this.isValid(frame)) {
            Telemetry tlm = new Telemetry(frame, this.settings, this.gui);
            this.gui.handle(tlm, frame);
            this.telemetrysubmitter.submit(tlm);
            this.telemetrysubmitter_backup.submit(tlm);
        }
    }

    private boolean isValid(AX25Frame frame) {
        int[] ax25_source = frame.getSource();
        boolean equal = true;
        for (int i = 0; equal && i < 6; equal &= ax25_source[i] == source_addr[i], ++i) {
        }
        return equal;
    }

    public void updateTuningGUI(int freq, int level, boolean locked) {
        this.gui.updatetuning(freq, level, locked);
    }

    public void forceRepositoryWrite() {
        this.telemetrysubmitter.forceRepositoryWrite();
        this.telemetrysubmitter_backup.forceRepositoryWrite();
    }
}

