/*
 * Decompiled with CFR 0.152.
 */
package rascal;

import dcgs.Challenge;
import dcgs.TelemetryCollector;
import java.math.BigInteger;
import java.security.MessageDigest;
import rascal.GUI;
import rascal.SettingsControl;

public class AuthenticationManager {
    private SettingsControl settings;
    private Boolean loggedin;
    private TelemetryCollector telemetrycollector;
    MessageDigest messageDigest;
    private boolean guiwarning_login;

    public AuthenticationManager(SettingsControl settingsctrl) {
        this.settings = settingsctrl;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setColllector(TelemetryCollector telemetrycollector) {
        this.telemetrycollector = telemetrycollector;
    }

    private String calculateResponse(Challenge c, String pass) {
        String pass_salt1 = pass + c.getSalt1();
        String hash2 = new BigInteger(1, this.messageDigest.digest(pass_salt1.getBytes())).toString(16);
        String hash2_salt2 = hash2 + c.getSalt2();
        String hash3 = new BigInteger(1, this.messageDigest.digest(hash2_salt2.getBytes())).toString(16);
        return hash3;
    }

    public boolean login() {
        String username = (String)this.settings.getSettingValue("Internet", "username");
        String password = (String)this.settings.getSettingValue("Internet", "password");
        try {
            Challenge c = this.telemetrycollector.getChallenge(username);
            String response = this.calculateResponse(c, password);
            this.loggedin = this.telemetrycollector.setResponse(username, response);
        }
        catch (Exception e) {
            GUI.setStatusMessage("Error logging in");
            this.loggedin = false;
        }
        if (!this.guiwarning_login && !this.loggedin.booleanValue()) {
            GUI.setStatusMessage("User " + username + " failed to login");
            this.guiwarning_login = true;
        }
        if (this.loggedin.booleanValue()) {
            GUI.setStatusMessage("User " + username + " logged in");
            this.guiwarning_login = false;
        }
        return this.isLoggedIn();
    }

    public void logout() {
        String username = (String)this.settings.getSettingValue("Internet", "username");
        String password = (String)this.settings.getSettingValue("Internet", "password");
    }

    public boolean isLoggedIn() {
        return this.loggedin;
    }
}

