/*
 * Decompiled with CFR 0.152.
 */
package dcgs;

import dc3com.Telemetry;
import dcgs.AuthenticationException;
import dcgs.AuthenticationInfo;
import dcgs.Challenge;
import dcgs.DataManager;
import dcgs.Logger;
import dcgs.TelemetryCollector;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;

public class TelemetryCollectorImpl
extends UnicastRemoteObject
implements TelemetryCollector {
    private DataManager datamgr;
    private ArrayList<AuthenticationInfo> authinfos = new ArrayList();
    private long timeout = 10L;
    private long start = System.currentTimeMillis();

    public TelemetryCollectorImpl(int listenport) throws RemoteException {
        super(listenport);
        this.datamgr = new DataManager();
    }

    public boolean submit(String username, Telemetry tlm, Date clreception, Date clsubmission) throws RemoteException {
        if (!this.isAuthorized(username)) {
            Logger.write("host: " + this.getHostname() + ", name: " + username + " not autorized");
            throw new AuthenticationException("not authorized");
        }
        try {
            Date now = new Date();
            this.datamgr.store(username, now, clreception, clsubmission, tlm);
            Logger.write("Submit tlm: " + username + ", " + (Object)((Object)tlm.getType()));
            return true;
        }
        catch (Exception e) {
            Logger.writeException(e);
            Logger.write("For user: " + username + " on " + this.getHostname());
            return false;
        }
    }

    public Challenge getChallenge(String username) throws RemoteException {
        try {
            Logger.write("Login attempt: " + username + " on " + TelemetryCollectorImpl.getClientHost());
            AuthenticationInfo auth = this.addAuthenticationInfo(username);
            return auth.getChallenge();
        }
        catch (Exception e) {
            Logger.writeException(e);
            Logger.write("For user: " + username + " on " + this.getHostname());
            return null;
        }
    }

    public boolean setResponse(String username, String response) throws RemoteException {
        try {
            AuthenticationInfo a = this.getAuthInfo(username);
            if (a != null) {
                a.verifyResponse(response);
            }
            if (this.isAuthorized(username)) {
                Logger.write("User logged in: " + username);
            } else {
                Logger.write("User login failed: " + username);
            }
            return this.isAuthorized(username);
        }
        catch (Exception e) {
            Logger.writeException(e);
            Logger.write("For user: " + username + " on " + this.getHostname());
            return false;
        }
    }

    public boolean logOut(String username) {
        AuthenticationInfo authinfo = this.getAuthInfo(username);
        if (authinfo != null) {
            this.authinfos.remove(authinfo);
            Logger.write("User log out: " + username);
            return true;
        }
        return false;
    }

    private boolean isAuthorized(String user) {
        AuthenticationInfo nfo = this.getAuthInfo(user);
        if (nfo == null) {
            return false;
        }
        return nfo.isAuthorized();
    }

    private AuthenticationInfo getAuthInfo(String username) {
        for (AuthenticationInfo a : this.authinfos) {
            if (!a.getUsername().equals(username) || !a.getHostname().equals(this.getHostname())) continue;
            if (a.getPassword() == null) {
                return null;
            }
            return a;
        }
        return null;
    }

    private AuthenticationInfo addAuthenticationInfo(String username) {
        AuthenticationInfo a = this.getAuthInfo(username);
        if (a != null) {
            this.authinfos.remove(a);
        }
        a = new AuthenticationInfo(username, this.getHostname(), this.datamgr.getPassword(username), this.datamgr.getSalt(username));
        this.authinfos.add(a);
        return a;
    }

    private String getHostname() {
        try {
            return TelemetryCollectorImpl.getClientHost();
        }
        catch (Exception e) {
            Logger.writeException(e);
            return null;
        }
    }
}

