/*
 * Decompiled with CFR 0.152.
 */
package dcgs;

import dcgs.Logger;
import dcgs.TelemetryCollectorImpl;
import java.rmi.Naming;

public class Server {
    public Server(int rmiport, int listenport) {
        Logger.initializeLogger();
        try {
            Logger.write("Server starting...");
            this.setupRMI(rmiport, listenport);
        }
        catch (Exception e) {
            Logger.writeException(e);
        }
    }

    private void setupRMI(int rmiport, int listenport) throws Exception {
        TelemetryCollectorImpl r = new TelemetryCollectorImpl(listenport);
        Naming.rebind("rmi://127.0.0.1:" + rmiport + "/TelemetryCollectorService", r);
        Logger.write("TelemetryCollectorService running...");
    }

    public static void main(String[] args) {
        try {
            int rmiport = Integer.valueOf(args[0]);
            int listenport = Integer.valueOf(args[1]);
            new Server(rmiport, listenport);
        }
        catch (Exception e) {
            Logger.write("RMI port or listen port not specified!");
            Logger.writeException(e);
            System.exit(0);
        }
    }
}

