/*
 * Decompiled with CFR 0.152.
 */
package dcgs;

import dcgs.Challenge;
import dcgs.DataManager;
import java.math.BigInteger;
import java.security.MessageDigest;

public class AuthenticationInfo {
    private String username;
    private String hostname;
    private String password;
    private String salt1;
    private long lastactivity;
    private Boolean authorized = false;
    private Challenge challenge;
    private DataManager datamgr;
    private MessageDigest messageDigest;

    public AuthenticationInfo(String username, String hostname, String password, String salt1) {
        this.username = username;
        this.hostname = hostname;
        this.password = password;
        this.salt1 = salt1;
        this.authorized = false;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateLastActivity();
    }

    public void updateLastActivity() {
        this.lastactivity = System.currentTimeMillis();
    }

    public Challenge getChallenge() {
        this.challenge = new Challenge(this.salt1);
        return this.challenge;
    }

    public boolean verifyResponse(String response) {
        String pass_salt2 = this.password + this.challenge.getSalt2();
        String hash = new BigInteger(1, this.messageDigest.digest(pass_salt2.getBytes())).toString(16);
        if (response.equals(hash)) {
            this.authorized = true;
            this.updateLastActivity();
        } else {
            this.authorized = false;
        }
        return this.isAuthorized();
    }

    public boolean isAuthorized() {
        long end = System.currentTimeMillis() - this.lastactivity;
        if (end > 36000000L) {
            return false;
        }
        return this.authorized;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getLastActivity() {
        return this.lastactivity;
    }
}

