/*
 * Decompiled with CFR 0.152.
 */
package dc3com;

import ax25lib.AX25Frame;
import dc3com.BitStreamReader;
import dc3com.TelemetryDef;
import dc3com.TelemetryDefIVCurve;
import dc3com.TelemetryDefValue;
import dc3com.TelemetryField;
import dc3com.TelemetryIVCurve;
import dc3com.TelemetryIVElement;
import dc3com.TelemetryStringValue;
import dc3com.TelemetryValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import rascal.GUI;
import rascal.SettingsControl;
import rascal.SettingsGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Telemetry
implements Serializable {
    public int nullbits;
    public int attbootcounter;
    public int seq;
    private int typeraw;
    private int datalength;
    private Hashtable<String, TelemetryField> tlmfields = new Hashtable(50);
    private byte[] signature = null;
    private byte[] auxdata = null;
    public boolean valid_crc;
    private TelemetryType tlmtype;
    private static int TLMTYPE_INVALID = 0;
    private static int TLMTYPE_PAYLOAD = 1;
    private static int TLMTYPE_HOUSEKEEPING = 2;
    private static int TLMTYPE_AUXILIARY = 3;

    public Telemetry(AX25Frame ax25data, SettingsControl settings, GUI gui) throws IOException {
        BitStreamReader b = new BitStreamReader(ax25data.dataToStream());
        this.attbootcounter = b.readBitsAsInt(12);
        this.nullbits = b.readBitsAsInt(4);
        this.seq = b.readBitsAsInt(16);
        this.valid_crc = ax25data.valid_crc;
        this.typeraw = b.readBitsAsInt(2);
        assert (this.typeraw != TLMTYPE_INVALID);
        switch (this.typeraw) {
            case 1: {
                this.tlmtype = TelemetryType.Payload;
                break;
            }
            case 2: {
                this.tlmtype = TelemetryType.Housekeeping;
                break;
            }
            case 3: {
                this.tlmtype = TelemetryType.Auxiliary;
                break;
            }
            default: {
                return;
            }
        }
        this.readTelemetry(b, settings, gui);
    }

    private void readTelemetry(BitStreamReader b, SettingsControl settings, GUI gui) throws IOException {
        SettingsGroup protocol = settings.getGroup("GUI");
        SettingsGroup group = settings.getGroup("Protocol");
        String frametype = "";
        switch (this.tlmtype) {
            case Payload: {
                frametype = "payload";
                break;
            }
            case Housekeeping: {
                frametype = "housekeeping";
                break;
            }
            case Auxiliary: {
                frametype = "auxiliary";
            }
        }
        if (this.tlmtype == TelemetryType.Auxiliary) {
            int bits = b.getNumberOfBitsRemaining();
            b.readBitsAsInt(6);
            String auxdata = b.readBitsAsString(bits);
            this.tlmfields.put("AUX", new TelemetryStringValue(auxdata, "", "AUX"));
            return;
        }
        LinkedList frame = (LinkedList)group.get(frametype).getValue();
        int listlength = frame.size();
        int counter = 0;
        while (counter < listlength) {
            TelemetryDef temp;
            TelemetryDef def = (TelemetryDef)frame.get(counter++);
            String def_name = def.getName();
            if (def instanceof TelemetryDefValue) {
                temp = (TelemetryDefValue)def;
                String value = b.readBitsAsString(temp.getRes());
                int int_value = 0;
                if (temp.getSourcecount() == 1) {
                    if (def_name != "LastExeCmd_cmd" && def_name != "LastRxdCmd_cmd") {
                        int_value = Integer.parseInt(value, 16);
                    }
                    if (def_name == "LastExeCmd_cmd" || def_name == "LastRxdCmd_cmd") {
                        this.tlmfields.put(def_name, new TelemetryStringValue(value, ((TelemetryDefValue)temp).getUnit(), def_name));
                    } else {
                        this.tlmfields.put(def_name, new TelemetryValue(int_value, ((TelemetryDefValue)temp).getUnit(), def_name));
                    }
                } else {
                    for (int i = 0; i < temp.getSourcecount(); ++i) {
                        if (def_name != "LastExeCmd_cmd" && def_name != "LastRxdCmd_cmd") {
                            int_value = Integer.parseInt(value, 16);
                        }
                        this.tlmfields.put(def_name, new TelemetryValue(int_value, ((TelemetryDefValue)temp).getUnit(), def_name));
                    }
                }
            }
            if (!(def instanceof TelemetryDefIVCurve)) continue;
            temp = (TelemetryDefIVCurve)def;
            for (int i = 0; i < temp.getSourcecount(); ++i) {
                TelemetryIVElement[] telem_element = new TelemetryIVElement[((TelemetryDefIVCurve)temp).getnPoints()];
                for (int n = 0; n < ((TelemetryDefIVCurve)temp).getnPoints(); ++n) {
                    telem_element[n] = new TelemetryIVElement(b.readBitsAsInt(temp.getRes()), b.readBitsAsInt(temp.getRes()));
                }
                this.tlmfields.put(temp.getName(), new TelemetryIVCurve(telem_element, temp.getName()));
            }
        }
    }

    public TelemetryField getField(String name) throws IllegalArgumentException {
        if (!this.tlmfields.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        return this.tlmfields.get(name);
    }

    public TelemetryType getType() {
        return this.tlmtype;
    }

    public Enumeration<String> getEnum() {
        return this.tlmfields.keys();
    }

    public String toString() {
        String result = "type: ";
        if (this.tlmtype != null) {
            switch (this.tlmtype) {
                case Payload: {
                    result = result + "Payload";
                    break;
                }
                case Housekeeping: {
                    result = result + "Housekeeping";
                    break;
                }
                case Auxiliary: {
                    result = result + "Auxliarly";
                    break;
                }
                default: {
                    result = result + "INVALID";
                }
            }
        }
        result = result + "\n";
        result = result + "seq.nr.bootcntr: " + this.attbootcounter + "\n";
        result = result + "seq.nr.perbootcntr: " + this.seq + "\n";
        Enumeration<String> s = this.tlmfields.keys();
        while (s.hasMoreElements()) {
            String name = s.nextElement();
            TelemetryField tlmfield = this.tlmfields.get(name);
            if (!(tlmfield instanceof TelemetryValue)) continue;
            result = result + name + ": " + tlmfield + "\n";
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TelemetryType {
        Housekeeping,
        Payload,
        Auxiliary;

    }
}

