/*
 * Decompiled with CFR 0.152.
 */
package ax25lib;

import ax25lib.AX25Frame;
import ax25lib.Control;
import ax25lib.FrameEvent;
import ax25lib.FrameEventListener;
import java.io.IOException;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.swing.event.EventListenerList;

public class Demodulator
extends Thread {
    private boolean demodulator_active;
    protected EventListenerList listenerList = new EventListenerList();
    LinkedList<AX25Frame> framebuffer = new LinkedList();
    private Control controlparent;
    private final int samplerate = 38400;
    private final int MONO = 1;
    private AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 38400.0f, 16, 1, 2, 38400.0f, true);
    private TargetDataLine mike;

    protected void fireFrameEvent(FrameEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != FrameEventListener.class) continue;
            ((FrameEventListener)listeners[i + 1]).frameEventOccurred(evt);
        }
    }

    public void stopDemodulator() {
        this.demodulator_active = false;
        if (this.mike != null) {
            this.mike.flush();
            this.mike.stop();
            this.mike.close();
        }
    }

    public static int deNrzi(boolean databit, boolean databitminusone) {
        int denrzidata = 0;
        denrzidata = databit != databitminusone ? 0 : 1;
        return denrzidata;
    }

    public static int sinetoSquare(double sine) {
        int square = sine >= 0.0 ? 1 : -1;
        return square;
    }

    public static double sin(double phasein) {
        double c = 0.75;
        double pi = Math.PI;
        double sinout = 0.0;
        double xg = 0.0;
        if (phasein >= 0.0 && phasein < pi / 2.0) {
            xg = phasein * 2.0 / pi - 0.5;
            sinout = (2.0 - 4.0 * c) * xg * xg + c + xg;
        } else if (phasein >= pi / 2.0 && phasein < pi) {
            xg = (phasein - pi / 2.0) * 2.0 / pi - 0.5;
            sinout = -1.0 * (xg - ((2.0 - 4.0 * c) * xg * xg + c));
        } else if (phasein >= pi && phasein < 1.5 * pi) {
            xg = (phasein - pi) * 2.0 / pi - 0.5;
            sinout = -1.0 * ((2.0 - 4.0 * c) * xg * xg + c + xg);
        } else if (phasein >= 1.5 * pi && phasein < 2.0 * pi) {
            xg = (phasein - 1.5 * pi) * 2.0 / pi - 0.5;
            sinout = xg - ((2.0 - 4.0 * c) * xg * xg + c);
        }
        return sinout;
    }

    public static double cos(double phasein) {
        double c = 0.75;
        double pi = Math.PI;
        double cosout = 0.0;
        double xg = 0.0;
        if (phasein >= 0.0 && phasein < pi / 2.0) {
            xg = phasein * 2.0 / pi - 0.5;
            cosout = (2.0 - 4.0 * c) * xg * xg + c - xg;
        } else if (phasein >= pi / 2.0 && phasein < pi) {
            xg = (phasein - pi / 2.0) * 2.0 / pi - 0.5;
            cosout = -1.0 * (xg + ((2.0 - 4.0 * c) * xg * xg + c));
        } else if (phasein >= pi && phasein < 1.5 * pi) {
            xg = (phasein - pi) * 2.0 / pi - 0.5;
            cosout = -1.0 * ((2.0 - 4.0 * c) * xg * xg + c - xg);
        } else if (phasein >= 1.5 * pi && phasein < 2.0 * pi) {
            xg = (phasein - 1.5 * pi) * 2.0 / pi - 0.5;
            cosout = xg + ((2.0 - 4.0 * c) * xg * xg + c);
        }
        return cosout;
    }

    public static int bytestoInt(byte a, byte b) {
        int longvalueab = (a + 128) * 255 + (b + 128) - 32768;
        return longvalueab;
    }

    public static double solveWrap(double in) {
        if (in > Math.PI * 2) {
            in -= Math.PI * 2;
        }
        return in;
    }

    public Demodulator(Control parent, TargetDataLine line) {
        super("Demodulator thread");
        this.controlparent = parent;
        try {
            this.mike = line;
            this.mike.open(this.format, this.mike.getBufferSize());
            this.mike.start();
        }
        catch (LineUnavailableException e) {
            return;
        }
    }

    public void run() {
        int updatecounter = 0;
        int initialfcarrier = 1600;
        int window = 400;
        int clockfrequency = 1200;
        double alpha = 0.035;
        double alphaclock = -0.16;
        this.demodulator_active = true;
        int batchsize = 512;
        byte[] dataw = new byte[batchsize];
        double[] samples = new double[batchsize / 2];
        int order = 64;
        double filteredmagnitude = 0.0;
        double magnitude = 0.0;
        double steepness = 0.0;
        double[] a = new double[order];
        double charge = 0.0;
        double chargeminusone = 0.0;
        boolean databit = false;
        int decision = 1;
        boolean v = false;
        boolean out = false;
        int freqout = 0;
        int flagcounter = 0;
        double beta = 3.0625000000000004E-4;
        double betaclock = 0.0;
        double thetacarrier = 0.0;
        double icarrierosc = 0.0;
        double qcarrierosc = 0.0;
        double pi = Math.PI;
        double isample = 0.0;
        double qsample = 0.0;
        double sample = 0.0;
        double isamplefilt = 0.0;
        double qsamplefilt = 0.0;
        double wcarrier = 2.0 * pi * 1600.0 / 38400.0;
        double ncocontrolcarrier = 0.0;
        double[] isamplefilterbuffer = new double[order];
        double[] qsamplefilterbuffer = new double[order];
        double thetaclock = 0.0;
        double thetaclockminusone = 0.0;
        double wclock = 2.0 * pi * 1200.0 / 38400.0;
        double ncocontrolclockminusone = 0.0;
        double sinclockosc = 0.0;
        int clock = 0;
        int clockminusone = 0;
        double ncocontrolclock = 0.0;
        double qsamplefiltminusthree = 0.0;
        double qsamplefiltminustwo = 0.0;
        double qsamplefiltminusone = 0.0;
        boolean databitminusone = false;
        int denrzidata = 0;
        boolean lockstate = false;
        double gaincontrol = 1.0;
        boolean flagreceived = false;
        double gaincontrolledsample = 0.0;
        int[] octetbuffer = new int[3000];
        int[] destuffedbuffer = new int[3000];
        int packetcounter = 0;
        double filteredphase = 0.0;
        int numBytesRead = 0;
        boolean flagcountermult = false;
        int gaincontrolout = 0;
        int tel = 0;
        int numberofoctets = 0;
        double locki = 0.0;
        double lockq = 0.0;
        double lock = 0.0;
        double lock_lp = 0.0;
        boolean pidok = false;
        boolean fcsok = false;
        double lowerafclimit = 2800.0 * pi / 38400.0;
        double upperafclimit = 3600.0 * pi / 38400.0;
        int[] crc16 = new int[17];
        int[] fcs = new int[17];
        int tg = 0;
        crc16[0] = 1;
        crc16[1] = 0;
        crc16[2] = 0;
        crc16[3] = 0;
        crc16[4] = 0;
        crc16[5] = 1;
        crc16[6] = 0;
        crc16[7] = 0;
        crc16[8] = 0;
        crc16[9] = 0;
        crc16[10] = 0;
        crc16[11] = 0;
        crc16[12] = 1;
        crc16[13] = 0;
        crc16[14] = 0;
        crc16[15] = 0;
        crc16[16] = 1;
        for (int tablefiller = 0; tablefiller < order; ++tablefiller) {
            double dest = ((double)tablefiller - (double)(order - 1) / 2.0) / (double)order;
            a[tablefiller] = (0.5 + Math.cos(dest * 2.0 * pi) / 2.0) * 2.0 / (double)order;
        }
        AudioInputStream sound = new AudioInputStream(this.mike);
        while (this.demodulator_active && numBytesRead != -1) {
            int i;
            try {
                numBytesRead = sound.read(dataw, 0, dataw.length);
            }
            catch (IOException ex) {
                // empty catch block
            }
            magnitude = 0.0;
            for (i = 0; i < numBytesRead; i += 2) {
                gaincontrol = (magnitude += (double)Math.abs((dataw[i] << 8) + dataw[i + 1])) / (double)(numBytesRead / 2);
            }
            freqout = (int)(wcarrier * 38400.0 / (2.0 * pi));
            gaincontrolout = (int)gaincontrol;
            if (updatecounter++ > 20) {
                this.controlparent.tuningCallBack(freqout, gaincontrolout, lockstate);
                updatecounter = 0;
            }
            locki = 0.0;
            lockq = 0.0;
            for (i = 0; i < numBytesRead; i += 2) {
                sample = (dataw[i] << 8) + dataw[i + 1];
                icarrierosc = Demodulator.cos(thetacarrier %= Math.PI * 2);
                qcarrierosc = Demodulator.sin(thetacarrier);
                gaincontrolledsample = sample / gaincontrol;
                isample = icarrierosc * gaincontrolledsample;
                qsample = qcarrierosc * gaincontrolledsample;
                isamplefilterbuffer[0] = isample;
                qsamplefilterbuffer[0] = qsample;
                isamplefilt = 0.0;
                qsamplefilt = 0.0;
                for (int j = 0; j < order; ++j) {
                    isamplefilt += a[j] * isamplefilterbuffer[j];
                    qsamplefilt += a[j] * qsamplefilterbuffer[j];
                }
                System.arraycopy(isamplefilterbuffer, 0, isamplefilterbuffer, 1, isamplefilterbuffer.length - 1);
                System.arraycopy(qsamplefilterbuffer, 0, qsamplefilterbuffer, 1, qsamplefilterbuffer.length - 1);
                locki = isamplefilt * isamplefilt;
                lockq = qsamplefilt * qsamplefilt;
                filteredphase = qsamplefilt * isamplefilt;
                thetacarrier += (wcarrier += beta * ncocontrolcarrier) + 0.035 * ncocontrolcarrier;
                ncocontrolcarrier = filteredphase;
                if (wcarrier < lowerafclimit) {
                    wcarrier = lowerafclimit;
                }
                if (wcarrier > upperafclimit) {
                    wcarrier = upperafclimit;
                }
                thetaclock = thetaclockminusone + wclock + -0.16 * ncocontrolclock;
                sinclockosc = Demodulator.sin(thetaclock %= Math.PI * 2);
                wclock += betaclock * ncocontrolclock;
                clock = Demodulator.sinetoSquare(sinclockosc);
                if (thetaclockminusone < pi && thetaclock >= pi) {
                    decision = qsamplefiltminusone > 0.0 ? 1 : -1;
                    steepness = qsamplefilt - qsamplefiltminusthree;
                    ncocontrolclockminusone = ncocontrolclock;
                    ncocontrolclock = (double)decision * steepness;
                }
                charge += qsample;
                if (clock == 1 && clockminusone == -1) {
                    if (charge > 0.0) {
                        databit = true;
                    }
                    if (charge < 0.0) {
                        databit = false;
                    }
                    charge = 0.0;
                    octetbuffer[0] = denrzidata = Demodulator.deNrzi(databit, databitminusone);
                    ++flagcounter;
                    if (octetbuffer[0] == 0 && octetbuffer[1] == 1 && octetbuffer[2] == 1 && octetbuffer[3] == 1 && octetbuffer[4] == 1 && octetbuffer[5] == 1 && octetbuffer[6] == 1 && octetbuffer[7] == 0) {
                        if (flagcounter > 39 && flagcounter < 3000) {
                            int y;
                            int n;
                            int destuffindex = flagcounter - 1;
                            int destuffcount = 0;
                            for (n = flagcounter - 1; n > 7; --n) {
                                destuffedbuffer[destuffindex--] = octetbuffer[n];
                                if ((destuffcount += octetbuffer[n]) > 0 && octetbuffer[n] == 0) {
                                    destuffcount = 0;
                                }
                                if (destuffcount != 5) continue;
                                --n;
                                ++tel;
                                destuffcount = 0;
                            }
                            for (n = 0; n < 16; ++n) {
                                fcs[n] = 1;
                            }
                            int bewaar = 0;
                            for (n = flagcounter - 1; n > 23 + tel; --n) {
                                bewaar = fcs[15];
                                for (tg = 14; tg > -1; --tg) {
                                    fcs[tg + 1] = fcs[tg];
                                }
                                fcs[0] = 0;
                                if (destuffedbuffer[n] == bewaar) continue;
                                for (tg = 0; tg < 16; ++tg) {
                                    fcs[tg] = fcs[tg] ^ crc16[tg];
                                }
                            }
                            for (tg = 0; tg < 16; ++tg) {
                                fcs[tg] = 1 - fcs[tg];
                            }
                            numberofoctets = (flagcounter + 8 - tel) / 8;
                            int calcfcs = 0;
                            for (n = 1; n > -1; --n) {
                                for (y = 0; y < 8; ++y) {
                                    calcfcs += fcs[n * 8 + y] << 7 - y;
                                }
                            }
                            int rxfcs = 0;
                            for (n = 2; n > 0; --n) {
                                for (y = 0; y < 8; ++y) {
                                    rxfcs += destuffedbuffer[n * 8 + tel + y] << 7 - y;
                                }
                            }
                            fcsok = calcfcs == rxfcs;
                            int toseriallength = flagcounter + 8 - tel - 32;
                            if (toseriallength > 127 && toseriallength % 8 == 0 || toseriallength == 16) {
                                int loopcount;
                                int[] toserial = new int[toseriallength];
                                for (n = flagcounter - 1; n > 7 + tel + 16; --n) {
                                    toserial[flagcounter - 1 - n] = destuffedbuffer[n];
                                }
                                int[] ax25bytes = new int[toserial.length / 8];
                                for (loopcount = 0; loopcount < ax25bytes.length; ++loopcount) {
                                    ax25bytes[loopcount] = 0;
                                    for (int innerloopcount = 0; innerloopcount < 8; ++innerloopcount) {
                                        int n2 = loopcount;
                                        ax25bytes[n2] = ax25bytes[n2] + (toserial[loopcount * 8 + innerloopcount] << innerloopcount);
                                    }
                                }
                                if (fcsok && ax25bytes.length > 16) {
                                    int[] source_address = new int[7];
                                    int[] dest_address = new int[7];
                                    int[] data = new int[ax25bytes.length - 16];
                                    for (loopcount = 0; loopcount < 7; ++loopcount) {
                                        dest_address[loopcount] = ax25bytes[loopcount];
                                        source_address[loopcount] = ax25bytes[loopcount + 7];
                                    }
                                    for (loopcount = 0; loopcount < data.length; ++loopcount) {
                                        data[loopcount] = ax25bytes[loopcount + 16];
                                    }
                                    AX25Frame frame = new AX25Frame(dest_address, source_address, data);
                                    this.framebuffer.add(frame);
                                    this.fireFrameEvent(new FrameEvent(this));
                                    ++packetcounter;
                                }
                            }
                            fcsok = false;
                            tel = 0;
                            flagcounter = 0;
                        } else {
                            flagcounter = 0;
                        }
                    }
                    System.arraycopy(octetbuffer, 0, octetbuffer, 1, octetbuffer.length - 1);
                }
                thetaclockminusone = thetaclock;
                qsamplefiltminusthree = qsamplefiltminustwo;
                qsamplefiltminustwo = qsamplefiltminusone;
                qsamplefiltminusone = qsamplefilt;
                clockminusone = clock;
                databitminusone = databit;
            }
            lock = locki / lockq;
            if ((lock_lp = lock < lock_lp ? lock_lp * 0.9 + lock * 0.1 : lock_lp * 0.99 + lock * 0.01) < 0.4 && gaincontrolout > 50) {
                lockstate = true;
            }
            if (!(lock_lp >= 1.0)) continue;
            lockstate = false;
        }
    }
}

