/*
 * Decompiled with CFR 0.152.
 */
package ax25lib;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AX25Frame {
    public Boolean valid_crc = true;
    public static final int FLAG = 126;
    public static int controlbyte = 3;
    public static int pidbyte = 240;
    public int[] data;
    public int[] s_address;
    public int[] d_address;
    public int[] FCS;

    public AX25Frame(int[] dest, int[] source, int[] data) {
        this.data = data;
        this.s_address = source;
        this.d_address = dest;
        this.FCS = this.crc(this);
    }

    public int[] getSource() {
        return this.s_address;
    }

    public int[] getDestination() {
        return this.d_address;
    }

    public int[] getData() {
        return this.data;
    }

    public int[] getFCS() {
        return this.FCS;
    }

    public int getLength() {
        int lengte = 6;
        lengte += this.s_address.length;
        lengte += this.d_address.length;
        return lengte += this.data.length;
    }

    public int[] crc(AX25Frame frame) {
        int n = 0;
        int[] temp = new int[16 + frame.data.length];
        int i = 0;
        while (i < frame.d_address.length) {
            temp[n] = frame.d_address[i];
            ++i;
            ++n;
        }
        i = 0;
        while (i < frame.s_address.length) {
            temp[n] = frame.s_address[i];
            ++i;
            ++n;
        }
        int n2 = n++;
        temp[n2] = controlbyte;
        int n3 = n++;
        temp[n3] = pidbyte;
        i = 0;
        while (i < frame.data.length) {
            temp[n] = frame.data[i];
            ++i;
            ++n;
        }
        int[] fcs = new int[2];
        int poly = 4129;
        int crc = 65535;
        n = 0;
        while (n < temp.length) {
            int c = temp[n++];
            for (int i2 = 0; i2 < 8; ++i2) {
                boolean c15 = (crc >> 15 & 1) == 1;
                boolean bit = (c >> 7 - i2 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= poly;
            }
            crc %= 65536;
        }
        fcs[0] = crc >> 8;
        fcs[1] = crc - fcs[0] * 256;
        return fcs;
    }

    public String toString() {
        int i;
        String framestring = new String();
        framestring = "";
        int[] frame = new int[16];
        int counter = 14;
        for (i = 0; i < 7; ++i) {
            frame[i] = this.d_address[i];
            frame[i + 7] = this.s_address[i];
        }
        int n = counter++;
        frame[n] = controlbyte;
        int n2 = counter++;
        frame[n2] = pidbyte;
        for (i = 0; i < 16; ++i) {
            if (frame[i] < 16) {
                framestring = framestring + "0";
            }
            framestring = framestring + Integer.toHexString(frame[i]) + " ";
        }
        for (i = 0; i < this.data.length; ++i) {
            int byte_value = this.data[i];
            if (byte_value < 16) {
                framestring = framestring + "0";
            }
            framestring = framestring + Integer.toHexString(byte_value) + " ";
        }
        return framestring;
    }

    public InputStream dataToStream() {
        byte[] data_byte_array = new byte[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            data_byte_array[i] = (byte)this.data[i];
        }
        return new ByteArrayInputStream(data_byte_array);
    }
}

