# NAVTEXtest-v01.py (24-11-2024)
import math
import wave
import array
import pyaudio
import sys
import struct
import random

from tkinter import *
from tkinter import messagebox
from tkinter import filedialog
from tkinter import simpledialog
from tkinter import font

Nchar = []          # Character definitions
PHASING = ""        # The phasing pattern DX-RX
SLn = 1415          # Low shift (Hz)
SHn = 1585          # High shift (Hz)
SPn = 20.0          # Navtex signal level (%)
NPn = 0.0           # Noise level (%)
FFn = 0.5           # Navtex fading frequency (Hz)
FPn = 0.0           # Navtex fading level (%)
TFn = 1500          # Interference tone (Hz)
TPn = 0.0           # Interference tone level (%)
BRn = 100           # Bitrate of the NAVTEX signal in Baud
PHn = 72            # Phasing length (nx DX-RX pattern) 72 = 10 seconds
MAXwav = 32000      # MAX level for WAV output
Samplerate = 48000  # Sample rate in Hz


# ============== Start widgets routines =====================

def Configuration():
    global SLn      # Low shift (Hz) "Y"
    global SHn      # High shift (Hz) "B"
    global SPn      # Navtex signal level (%)
    global NPn      # Noise level (%)
    global FFn      # Navtex fading frequency (Hz)
    global FPn      # Navtex fading level (%)
    global TFn      # Interference tone (Hz)
    global TPn      # Interference tone level (%)
    global BRn      # Bitrate of the NAVTEX signal in Baud
    global PHn      # Phasing length (nx DX-RX pattern)

    S = "PH72"      # Example
    while(True):
        DisplayConfig()
        S = simpledialog.askstring("Configuration",S,parent = root)

        if (S == None): # No input, cancel or error
            break

        if len(S) < 3:  # If length of input < 3
            break
        S = S.upper()   # Upper case conversion
        C = S[0:2]      # The item that has to be changed

        try:            # Test if a value
            V = abs(float(S[2:]))
        except:
            break

        if C == "SL":
            SLn = V
        if C == "SH":
            SHn = V
        if C == "SP":
            SPn = V
        if C == "NP":
            NPn = V
        if C == "FF":
            FFn = V
        if C == "FP":
            FPn = V
        if C == "TF":
            TFn = V
        if C == "TP":
            TPn = V
        if C == "BR":
            BRn = V
        if C == "PH":
            PHn = int(abs(V))
            

def MAKEpattern():
    pattern = simpledialog.askstring("Make Pattern","Pattern YBYY...")
    pattern = pattern.upper()
    
    if (pattern == None):  # No input, cancel or an error
        pattern = ""

    if (pattern == ""):
        PrintData("Pattern, task cancelled")   
        return()

    wavfilename = pattern + ".wav"
    txt = "WAV file: " + wavfilename  
    PrintData(txt)

    S = simpledialog.askstring("Repeat N times","Value (1 - 10000):")

    if (S == None):  # No input, cancel or an error
        S = "0"
      
    try:            # Test if a value
        count = int(S)
    except:
        count = 0
        
    if (count < 1) or (count > 10000):
        PrintData("Pattern repetition value > 10000 out of range")   
        return()
    
    msge = CREATEpattern(pattern, count)

    SAVEwav(wavfilename, msge)
    txt = "WAV file made: " + wavfilename + "\nBits: " + str(len(msge))   
    PrintData(txt)


def MAKEyby():
    filename = filedialog.askopenfilename(filetypes=[("msg files","*.msg"),("allfiles","*")])

    if (filename == None):  # No input, cancel or an error
        filename = ""

    if (filename == ""):
        PrintData("Make YBY file cancelled")    
        return()

    ConvertMSG(filename)   # Call MSG to YBY routine


def MAKEwav():
    filename = filedialog.askopenfilename(filetypes=[("yby files","*.yby"),("allfiles","*")])

    if (filename == None): # No input, cancel or an error
        filename = ""

    if (filename == ""):
        PrintData("Make WAV file cancelled")   
        return()
    
    wavfilename = filename[0:-4] +".wav"
    msge = Readybyfile(filename)

    if (msge == ""):
        return()
    
    SAVEwav(wavfilename, msge)
    txt = "WAV file made: " + wavfilename + "  Bits: " + str(len(msge))   
    PrintData(txt)


def PLAYwav():
    chunk = 9600
    WAVoutfilename = filedialog.askopenfilename(filetypes=[("wav files","*.wav"),("allfiles","*")])

    if (WAVoutfilename == None):  # No input, cancel or an error
        WAVoutfilename = ""

    if (WAVoutfilename == ""):
        PrintData("Play WAV file cancelled")   
        return()
    
    txt = "\nPlaying: " + WAVoutfilename   
    PrintInfo(txt)    
    root.update() # update screens
    
    wf = wave.open(WAVoutfilename, 'rb')

    PA = pyaudio.PyAudio()

    # open stream
    stream = PA.open(format =
                PA.get_format_from_width(wf.getsampwidth()),
                channels = wf.getnchannels(),
                rate = wf.getframerate(),
                output = True)

    # read data
    data = wf.readframes(chunk)

    # play stream
    while len(data) != 0:
        stream.write(data)
        data = wf.readframes(chunk)

    stream.close()
    PA.terminate()
    PrintInfo("Done!")   


def test(): # Testroutine
    PrintInfo("Testroutine!")    
    n = 0

        
def CLRscreens():
    text1.delete(1.0, END)
    text2.delete(1.0, END)


# ================== Start various routines =======================

def Readybyfile(filename):            
    ybyfile = open(filename,'r')
    
    S = ybyfile.readline()                      # read the first remark line
    PrintData(S)
    PrintData("WAIT! PROCESSING WAV FILE MAY TAKE LONG!")
    root.update_idletasks()

    yby = ""
    
    while (S != ""):
        S = ybyfile.readline()                  # Read a line from the yby file
        if S == "":
            break                               # End of file
        if (S[0] != "Y") and (S[0] != "B"):     # No Y and B characters anymore
            break

        n = 0
        while (n < len(S)):                     # Add the Y and B to msge 
            if (S[n] == "Y") or (S[n] == "B"):
                yby = yby + S[n]
            else:
                break                           # End of all the Y and B characters in this line
            n = n + 1

    ybyfile.close()
    # PrintData(yby)
    # root.update_idletasks()
    return(yby)


def CREATEpattern(k, count):  # Make a pattern (Y, B or YB in k) in msge, length count
    msge = ""                 # Initialize msge as string 
    i = 0
    
    while (i < count):
        msge = msge + k       # Add count * k patterns
        i = i + 1
        
    return(msge)

    
def SAVEwav(wavfilename, msge):
    global SLn      # Low shift (Hz) "Y"
    global SHn      # High shift (Hz) "B"
    global SPn      # Navtex signal level (%)
    global NPn      # Noise level (%)
    global FFn      # Navtex fading frequency (Hz)
    global FPn      # Navtex fading level (%)
    global TFn      # Interference tone (Hz)
    global TPn      # Interference tone level (%)
    global BRn      # Bitrate of the NAVTEX signal in Baud
    global PHn      # Phasing length (nx DX-RX pattern)
    
    global MAXwav
    global Samplerate
    global Bitrate
    

    MINwav = -1 * MAXwav                    # Minimum WAV level can be made asymmetrical (MINwav = 0)

    bitsamples = Samplerate / BRn           # audio samples per bit
    samples = bitsamples * len(msge)        # required number of samples for WAV file

    TWOPI = math.pi * 2

    DeltaPhi1 = TWOPI / (Samplerate / SLn)  # Delta Phi per sample for (lowest) frequency "Y"
    DeltaPhi2 = TWOPI / (Samplerate / SHn)  # Delta Phi per sample for (highest) frequency "B"
    DeltaPhiF = TWOPI / (Samplerate / FFn)  # Delta Phi per sample for fading
    DeltaPhiT = TWOPI / (Samplerate / TFn)  # Delta Phi per sample for interferer tone
    
    PhiS = 0.0                              # Phi Navtex signal
    PhiF = 0.0                              # Phi fading
    PhiT = 0.0                              # Phi interferer tone
    
    signal = []                             # The final WAV signal that has to be saved
    
    i = 0
    while (i < Samplerate / 10):            # add trailer of zero's of 0.1 seconds  
        signal.append(0.0)                  # audio left channel
        signal.append(0.0)                  # audio right channel
        i = i + 1
        
    i = 0                                                   # i = sample counter
    while (i < samples):                                    # fill list signal with sample values
        Vs = float(SPn) / 100 * math.sin(PhiS)              # The Navtex sample value
        Vt = float(TPn) / 100 * math.sin(PhiT)              # The Tone sample value
        Vn = float(NPn) / 100 * random.uniform(-1.0, 1.0)   # The noise
        
        mi = int(float(i) / float(bitsamples))              # Pointer in YBY message

        if (msge[mi] == "Y"):
            PhiS = PhiS + DeltaPhi1                             # "Y" = low frequency
            Vs = Vs + float(FPn) / 100 * math.sin(PhiF) * Vs    # Add sine fading
        else:
            PhiS = PhiS + DeltaPhi2                             # "B" = high frequency
            Vs = Vs + float(FPn) / 100 * math.cos(PhiF) * Vs    # Add cosine fading

        if (PhiS > TWOPI):              # if > 360 degrees (2*pi radialls), then substract 2*pi
            PhiS = PhiS - TWOPI         # so that hoek is always between 0 and 2*pi

        PhiF = PhiF + DeltaPhiF         # Fading frequency
        if (PhiF > TWOPI):              # if > 360 degrees (2*pi radialls), then substract 2*pi
            PhiF = PhiF - TWOPI         # so that hoek is always between 0 and 2*pi

        PhiT = PhiT + DeltaPhiT         # interferer tone frequency
        if (PhiT > TWOPI):              # if > 360 degrees (2*pi radialls), then substract 2*pi
            PhiT = PhiT - TWOPI         # so that hoek is always between 0 and 2*pi


        V = (Vs + Vt + Vn) * MAXwav     # Convert to -32000 to +32000 range    

        if V > MAXwav:
            V = MAXwav
        if V < MINwav:
            V = MINwav

        signal.append(int(V))           # Audio left channel 1

        i = i + 1

    s = []                              # buffer for list of binary values

    # Conversion to WAV binary format
    s = []
    i = 0
    while i < len(signal):
        # ssignal += struct.pack('h', signal[i])                  # transform floating point list signal to binary array
        v = signal[i]                                           # Same routine but without struct   
        if v < 0:
           v = v + 65536
        s.append(int(v % 256))
        s.append(int(v / 256))
        
        i = i + 1

    signal = []                                                 # Free memory
    ssignal = ''                                                # buffer for list of binary values
    ssignal = array.array('B', s).tobytes()                     # Convert int to binary string with array module
    OUTwavfile(wavfilename, Samplerate, ssignal)                # write binary list to WAV file


def OUTwavfile(WAVname, Samplerate, ssignal):                   # Save WAV file
    WAVf = wave.open(WAVname, 'wb')
    WAVf.setparams((1, 2, Samplerate, 1, 'NONE', 'noncompressed'))
    WAVf.writeframes(ssignal)
    WAVf.close()


# ... Message file MSG to YBY file routines ...
def ConvertMSG(filename):
    global PHn      # Phasing length (nx DX-RX pattern)
    global PHASING  # The phasing pattern DX-RX
    
    PrintData(filename)   
    
    ybyfilename = filename[0:-4] +".yby"

    msgfile = open(filename,'r')                # input file message
    ybyfile = open(ybyfilename,'w')             # output file yby file

    Msg = []
    TXT = msgfile.readline()                    # Read the first line
    PrintData(TXT)
    ybyfile.write(TXT)                          # Write the first remark line to the yby file

    while (TXT != ""):
        TXT = msgfile.readline()                # Read a line from the msg file

        if (TXT != ""):                         # TXT == "" is end of file!
            n = 0
            while n < len(TXT):                 # Minus 1 to delete line feed
                S = TXT[n]
                if S != "\n" and S != "\r":     # Not a CR and not a LF at the end
                    YBY = FindChar(S)
                    Msg.append(YBY)
                n = n + 1

    # Add phasing signals
    n = 0
    while n < PHn:                              # Write phasing nx
        ybyfile.write(PHASING + "(Phasing)\n")  # Write the phasing string to the yby file
        n = n + 1
        
    n = 0
    while n < len(Msg):
        ybyfile.write(Msg[n] + "\n")            # Write the string to the yby file
        m = n - 2                               # RX transmissions 4 lower incl RX = 2 DX
        if m < 0:
            ybyfile.write(FindChar("p") + " (RX)\n")  # Write the Phasing1 RX string to the yby file
        else:
            ybyfile.write(Msg[m] + " (RX)\n")  # Write the RX string to the yby file            

        n = n + 1

    msgfile.close()                             # Close all the files
    ybyfile.close()
    txt = "YBY file made: " + ybyfilename  
    PrintData(txt)                              # Print a message to the data screen


# ================== Various specific routines for Message file MSG to YBY file routine =====================

# ... Print a string to the Info Textbox 1 and add a line feed ...
def PrintInfo(txt):
    global AUTOscroll
    txt = txt + "\n"
    text1.insert(END, txt)
    text1.yview(END)


# ... Print a string to the Data Textbox 2 and add a line feed ...
def PrintData(txt):
    global AUTOscroll
    txt = txt + "\n"
    text2.insert(END, txt)
    text2.yview(END)


# ... Fill the Character Code lists ...
def FindChar(S):
    global Nchar

    R = "YYBBBYB ERROR space"     # Default if not found
    n = 0
    while n < len(Nchar):
        T = Nchar[n]
        if S == T[0]:
            R = T[2:]
            break
        n = n + 1
    return(R)    


# ... Display the Configuration ...
def DisplayConfig():
    global SLn      # Low shift (Hz)
    global SHn      # High shift (Hz)
    global SPn      # Navtex signal level (%)
    global NPn      # Noise level (%)
    global FFn      # Navtex fading frequency (Hz)
    global FPn      # Navtex fading level (%)
    global TFn      # Interference tone (Hz)
    global TPn      # Interference tone level (%)
    global BRn      # Bitrate of the NAVTEX signal in Baud
    global PHn      # Phasing length (nx DX-RX pattern)

    PrintData("=== CONFIGURATION ===")
    PrintData("(SLn) Low shift (Hz): " + str(SLn))
    PrintData("(SHn) High shift (Hz): " + str(SHn))
    PrintData("(SPn) Navtex signal level (%): " + str(SPn))
    PrintData("(NPn) Noise level (%): " + str(NPn))
    PrintData("(FFn) Navtex fading frequency (Hz): " + str(FFn))
    PrintData("(FPn) Navtex fading level (%): " + str(FPn))
    PrintData("(TFn) Interference tone (Hz): " + str(TFn))
    PrintData("(TPn) Interference tone level (%): " + str(TPn))
    PrintData("(BRn) Bitrate of the NAVTEX signal in Baud: " + str(BRn))
    PrintData("(PHn) Phasing length (nx DX-RX pattern): " + str(PHn))
    PrintData("===")


# ... Fill the Character Code lists ...
def FillChar():
    global Nchar
    global PHASING

    Nchar = []
    # Column 1
    Nchar.append("A-BBBYYYB A")
    Nchar.append("B-YBYYBBB B")
    Nchar.append("C-BYBBBYY C")
    Nchar.append("D-BBYYBYB D")
    Nchar.append("E-YBBYBYB E")
    Nchar.append("F-BBYBBYY F")
    Nchar.append("G-BYBYBBY G")
    Nchar.append("H-BYYBYBB H")
    Nchar.append("I-BYBBYYB I")
    Nchar.append("J-BBBYBYY J")
    Nchar.append("K-YBBBBYY K")   
    Nchar.append("L-BYBYYBB L")   
    Nchar.append("M-BYYBBBY M")
    Nchar.append("N-BYYBBYB N")
    Nchar.append("O-BYYYBBB O")
    Nchar.append("P-BYBBYBY P")
    Nchar.append("Q-YBBBYBY Q")
    Nchar.append("R-BYBYBYB R")
    Nchar.append("S-BBYBYYB S")
    Nchar.append("T-YYBYBBB T")
    Nchar.append("U-YBBBYYB U")
    Nchar.append("V-YYBBBBY V")
    Nchar.append("W-BBBYYBY W")
    Nchar.append("X-YBYBBBY X")
    Nchar.append("Y-BBYBYBY Y")
    Nchar.append("Z-BBYYYBB Z")

    # Column 2
    Nchar.append("--BBBYYYB -")
    Nchar.append("?-YBYYBBB ?")
    Nchar.append(":-BYBBBYY :")
    Nchar.append("x-BBYYBYB x")
    Nchar.append("3-YBBYBYB 3")
    Nchar.append("_-BBYBBYY _")
    Nchar.append("_-BYBYBBY _")
    Nchar.append("_-BYYBYBB _")
    Nchar.append("8-BYBBYYB 8")
    Nchar.append("b-BBBYBYY bell")
    Nchar.append("(-YBBBBYY (")   
    Nchar.append(")-BYBYYBB )")   
    Nchar.append(".-BYYBBBY .")
    Nchar.append(",-BYYBBYB ,")
    Nchar.append("9-BYYYBBB 9")
    Nchar.append("0-BYBBYBY 0")
    Nchar.append("1-YBBBYBY 1")
    Nchar.append("4-BYBYBYB 4")
    Nchar.append("\'-BBYBYYB \'")
    Nchar.append("5-YYBYBBB 5")
    Nchar.append("7-YBBBYYB 7")
    Nchar.append("=-YYBBBBY =")
    Nchar.append("2-BBBYYBY 2")
    Nchar.append("/-YBYBBBY /")
    Nchar.append("6-BBYBYBY 6")
    Nchar.append("+-BBYYYBB +")

    # Shared characters
    Nchar.append(" -YYBBBYB space")
    Nchar.append("s-YYBBBYB space")
    Nchar.append("p-BBBBYYY phasing1")
    Nchar.append("q-YBBYYBB phasing2")
    Nchar.append("c-YYYBBBB carriage return")
    Nchar.append("l-YYBBYBB line feed")
    Nchar.append("a-YBYBBYB letter shift")
    Nchar.append("n-YBBYBBY figure shift")
    Nchar.append("u-YBYBYBB unperforated tape")

    # Phasing signal DX-RX pattern phasing2 + phasing1
    PHASING = "YBBYYBB" + "BBBBYYY"

    
# ================ Start Make Screen ==========================

root=Tk()
root.title("NAVTEXtest-v01.py (24-11-2024): NAVTEX test messages")

root.minsize(100, 100)

frame1 = Frame(root, background="blue", borderwidth=5, relief=RIDGE)
frame1.pack(side=TOP, expand=1, fill=X)

frame1a = Frame(root, background="blue", borderwidth=5, relief=RIDGE)
frame1a.pack(side=TOP, expand=1, fill=X)

frame2 = Frame(root, background="black", borderwidth=5, relief=RIDGE)
frame2.pack(side=TOP, expand=1, fill=X)

frame3 = Frame(root, background="red", borderwidth=5, relief=RIDGE)
frame3.pack(side=TOP, expand=1, fill=X)

scrollbar1 = Scrollbar(frame1)
scrollbar1.pack(side=RIGHT, expand=YES, fill=BOTH)

text1 = Text(frame1, height=5, width=120, yscrollcommand=scrollbar1.set)
text1.pack(side=TOP, expand=1, fill=X)

scrollbar1.config(command=text1.yview)

b = Button(frame1a, text="MAKEyby", width=12, command=MAKEyby)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame1a, text="MAKEwav", width=12, command=MAKEwav)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame1a, text="Configuration", width=12, command=Configuration)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame1a, text="PLAYwav", width=12, command=PLAYwav)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame1a, text="MAKEpattern", width=12, command=MAKEpattern)
b.pack(side=RIGHT, padx=5, pady=5)

scrollbar2 = Scrollbar(frame2)
scrollbar2.pack(side=RIGHT, expand=YES, fill=BOTH)

text2 = Text(frame2, height=30, width=120, yscrollcommand=scrollbar2.set)
text2.pack(side=TOP, expand=1, fill=X)

scrollbar2.config(command=text2.yview)

b = Button(frame3, text="CLEAR SCREEN", width=15, command=CLRscreens)
b.pack(side=TOP, expand=1, fill=X, padx=2, pady=2)

FillChar()

n = 0
while n < len(Nchar):
    print(Nchar[n])
    # S = Nchar[n]
    # print(S[2:9])
    n = n + 1

mainloop()



