# AudioWAV-v01.py (21-11-2012)
import math
import time
import array
import wave
import pyaudio
import sys
import struct

from time import gmtime, strftime
from Tkinter import *
from tkFileDialog import askopenfilename
from tkFileDialog import asksaveasfilename
from tkSimpleDialog import askstring
from tkMessageBox import *

############################################################################################################################################
# Settings that can be modified
AUDIOdevin = None           # Audio device for input. None = Windows default. Can be modified with the Audio device button.
AUDIOdevout = None          # Audio device for output. None = Windows default. Can be modified with the Audio device button.

SAMPLERATE = 4800           # DEFAULT=4800

############################################################################################################################################
# Initialisation of global variables required in various routines (DO NOT MODIFY THEM!)

STOP = False                # Stop key pressed
AUDIOstatus = False         # Audio on or off
############################################################################################################################################

# ============== Start widgets routines =====================
def Bnot():
    print "Routine not made yet"


def Bstop():
    global STOP
    STOP = True


def BSetup():
    global SAMPLERATE
    
    s = askstring("Sample rate","Value: " + str(SAMPLERATE) + "\n\nNew value:\n(4800, 6000, 44100, 48000)")

    if (s == None):         # If Cancel pressed, then None
        return()

    try:                    # Error if for example no numeric characters or OK pressed without input (s = ""), then v = 0
        v = int(s)
    except:
        v = 0

    if v != 0:
        SAMPLERATE = v

        s = "\n\nSample rate of soundcard changed: " + str(SAMPLERATE)   
        text1.insert(END, s)


def BAudiostatus():
    global AUDIOstatus
    
    if (AUDIOstatus == False):
        AUDIOstatus = True
        s = "\n\nAudio on"   
    else:
        AUDIOstatus = False
        s = "\n\nAudio off"   

    text1.insert(END, s)    


def BRECORDwav():        # Record
    global STOP

    filename = ASKWAVsavefilename()

    if filename == "":
        s = "\n\nRecord WAV file cancelled"   
        text1.insert(END, s)    
        return()

    s = askstring("Record seconds","Value (1 - 1000):")

    if (s == None):     # No input, cancel or error
        s = "0"
      
    try:                # Error if no numeric characters
        count = int(s)
    except:
        count = 0
        
    if (count < 1) or (count > 1000):
        s = "\n\nRecording time out of range, cancelled"   
        text1.insert(END, s)    
        return()

    STOP = False
    RECORDwav(filename, count)


def BPLAYwav():         # Play
    global STOP
    
    filename = ASKWAVinfilename()

    if (filename == ""):
        s = "\n\nPlay WAV file cancelled"   
        text1.insert(END, s)    
        return()

    STOP = False
    PLAYwav(filename)


# =================================================================================

def RECORDwav(filename, count):
    global STOP
    global AUDIOdevin
    global AUDIOdevout
    global AUDIOstatus
    global SAMPLERATE

    FORMAT = pyaudio.paInt16
    CHANNELS = 1
    RATE = int(SAMPLERATE)
    RECORD_SECONDS = int(count)
    WAVrecordfilename = filename
    
    PA = pyaudio.PyAudio()

    stream = PA.open(format = FORMAT,
                channels = CHANNELS,
                rate = RATE,
                input = True,
                output = True,
                frames_per_buffer = RATE,
                input_device_index = AUDIOdevin,
                output_device_index = AUDIOdevout)

    s = "\n\nRecording: " + WAVrecordfilename   
    text1.insert(END, s)    

    root.update() # update screens
    
    all = []
    n = 0
    while n < RECORD_SECONDS and STOP == False:
        data = stream.read(RATE)
        if AUDIOstatus == True:
            stream.write(data, RATE)
        all.append(data)
        root.update_idletasks()
        root.update()
        n = n + 1

    stream.close()
    PA.terminate()

    # write data to WAV file
    s = "\n\nSave: " + WAVrecordfilename   
    text1.insert(END, s)    

    root.update() # update screens

    data = ''.join(all)
    wf = wave.open(WAVrecordfilename, 'wb')
    wf.setnchannels(CHANNELS)
    wf.setsampwidth(PA.get_sample_size(FORMAT))
    wf.setframerate(RATE)
    wf.writeframes(data)
    wf.close()

    s = "\nDone!"
    text1.insert(END, s)    


def PLAYwav(filename):
    global STOP
    global AUDIOdevout

    WAVplayfilename = filename
    chunk = 12000                               # Buffer size
   
    wf = wave.open(WAVplayfilename, 'rb')

    PA = pyaudio.PyAudio()

    # open stream
    stream = PA.open(format =
                PA.get_format_from_width(wf.getsampwidth()),
                channels = wf.getnchannels(),
                rate = wf.getframerate(),
                output = True,
                output_device_index = AUDIOdevout)

    # read data
    data = wf.readframes(chunk)

    s = "\n\nPlaying: " + WAVplayfilename   
    text1.insert(END, s)    

    # play stream
    while data != '' and STOP == False:
        stream.write(data)
        data = wf.readframes(chunk)
        root.update_idletasks()
        root.update()

    stream.close()
    PA.terminate()

    s = "\nDone!"
    text1.insert(END, s)    


def CLRscreens():
    text1.delete(1.0, END)
    s = "Log screen"  
    text1.insert(END, s)    



def OUTwavfile(WAVname, samplerate, ssignal):           # Save WAV file
    WAVf = wave.open(WAVname, 'wb')
    WAVf.setparams((1, 2, samplerate, 1, 'NONE', 'noncompressed'))
    WAVf.writeframes(ssignal)
    WAVf.close()



def ASKWAVinfilename():
    filename = askopenfilename(filetypes=[("WAVfile","*.wav"),("allfiles","*")])

    if (filename == None):              # No input, cancel pressed or an error
        filename = ""

    if (filename == ""):
        return(filename)
    
    if filename[-4:] != ".wav":
        filename = filename + ".wav"

    return(filename)


def ASKWAVsavefilename():
    filename = asksaveasfilename(filetypes=[("wav files","*.wav"),("allfiles","*")])

    if (filename == None):              # No input, cancel pressed or an error
        filename = ""

    if (filename == ""):
        return(filename)
    
    if filename[-4:] != ".wav":
        filename = filename + ".wav"

    return(filename)


def SELECTaudiodevice():        # Select an audio device
    global AUDIOdevin
    global AUDIOdevout

    PA = pyaudio.PyAudio()
    ndev = PA.get_device_count()

    n = 0
    ai = ""
    ao = ""
    while n < ndev:
        s = PA.get_device_info_by_index(n)
        # print n, s
        if s['maxInputChannels'] > 0:
            ai = ai + str(s['index']) + ": " + s['name'] + "\n"
        if s['maxOutputChannels'] > 0:
            ao = ao + str(s['index']) + ": " + s['name'] + "\n"
        n = n + 1
    PA.terminate()

    AUDIOdevin = None
    
    s = askstring("Device","Select audio INPUT device:\nPress Cancel for Windows Default\n\n" + ai + "\n\nNumber: ")
    if (s != None):             # If Cancel pressed, then None
        try:                    # Error if for example no numeric characters or OK pressed without input (s = "")
            v = int(s)
        except:
            s = "error"

        if s != "error":
            if v < 0 or v > ndev:
                v = 0
            AUDIOdevin = v

    AUDIOdevout = None

    s = askstring("Device","Select audio OUTPUT device:\nPress Cancel for Windows Default\n\n" + ao + "\n\nNumber: ")
    if (s != None):             # If Cancel pressed, then None
        try:                    # Error if for example no numeric characters or OK pressed without input (s = "")
            v = int(s)
        except:
            s = "error"

        if s != "error":
            if v < 0 or v > ndev:
                v = 0
            AUDIOdevout = v


# ================ Start Make Screen ==========================

root=Tk()
root.title("AudioWAV-v01.py (21-11-2012): Audio WAV file recorder and player")

root.minsize(10, 10)

frame1 = Frame(root, background="blue", borderwidth=5, relief=RIDGE)
frame1.pack(side=TOP, expand=1, fill=X)

frame2 = Frame(root, background="blue", borderwidth=5, relief=RIDGE)
frame2.pack(side=TOP, expand=1, fill=X)

frame3 = Frame(root, background="red", borderwidth=5, relief=RIDGE)
frame3.pack(side=TOP, expand=1, fill=X)

scrollbar1 = Scrollbar(frame1)
scrollbar1.pack(side=RIGHT, expand=YES, fill=BOTH)

text1 = Text(frame1, height=20, width=130, yscrollcommand=scrollbar1.set)
text1.pack(side=TOP, expand=1, fill=X)

scrollbar1.config(command=text1.yview)

b = Button(frame2, text="RECORDwav", width=25, command=BRECORDwav)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame2, text="PLAYwav", width=25, command=BPLAYwav)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame2, text="STOP", width=25, background="red", command=Bstop)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame2, text="Setup", width=15, command=BSetup)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame2, text="Audio on/off", width=15, command=BAudiostatus)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame3, text="CLEAR SCREEN", width=15, command=CLRscreens)
b.pack(side=TOP, expand=1, fill=X, padx=2, pady=2)


# ================ Main routine ================================================
s = "Log screen"  
text1.insert(END, s)    
root.update_idletasks()
root.update()

SELECTaudiodevice()         # Select an audio device

mainloop()



