# WAVviewer-v02.py (13-10-2018) Simple WAV file viewer
# For Python version 3
# Created by Onno Hoekstra (pa2ohh)

import time
import math
import wave
import struct

from tkinter import *
from tkinter import filedialog
from tkinter import simpledialog

WAVframes = 0
WAVchannels = 1
WAVsamplewidth = 1
WAVframerate = 1

WAVsignal1 = []
WAVsignal2 = []

WAVfilename = "Load WAV file"

X0L = 20            # Left top X value
Y0T = 20            # Left top Y value
SCW = 1000          # Screenwidth
SCH = 500           # Screenheight

SCstart = int(0)    # Start at sample
SHOWsamples = SCW   # Number of samples on the screen
SHOWchannel = 1     # Display channel 1

Ygain = 1
ymaxgain = 1024
Ylevels = 65536
Yoffset = 0


# ============== Start widgets routines =====================

def BStartat1():
    global SCstart
    global WAVframes

    SCstart = SCstart - SHOWsamples / 2
    MaxSCstart = WAVframes - SHOWsamples / 2
    if (SCstart > MaxSCstart):
        SCstart = MaxSCstart 
    if (SCstart < 0):
        SCstart = 0
    UpdateTrace()

def BStartat2():
    global SCstart
    # global SCpixels
    global WAVframes

    SCstart = SCstart + SHOWsamples / 2
    MaxSCstart = WAVframes - SHOWsamples / 2
    if (SCstart > MaxSCstart):
        SCstart = MaxSCstart 
    if (SCstart < 0):
        SCstart = 0
    UpdateTrace()
        
def BSamples1():
    global SHOWsamples
    if (SHOWsamples == 100):
        SHOWsamples = 10
    if (SHOWsamples == 1000):
        SHOWsamples = 100
    if (SHOWsamples == 10000):
        SHOWsamples = 1000
    if (SHOWsamples == 100000):
        SHOWsamples = 10000
    if (SHOWsamples == 1000000):
        SHOWsamples = 100000
    UpdateTrace()

def BSamples2():
    global SHOWsamples
    if (SHOWsamples == 100000):
        SHOWsamples = 1000000
    if (SHOWsamples == 10000):
        SHOWsamples = 100000
    if (SHOWsamples == 1000):
        SHOWsamples = 10000
    if (SHOWsamples == 100):
        SHOWsamples = 1000
    if (SHOWsamples == 10):
        SHOWsamples = 100
    UpdateTrace()        
  
def BYoffset():
    global Yoffset
    s = simpledialog.askstring("BYoffset","Value (-32767 to +32767):")

    if (s == None): # Geen input, cancel gedrukt of een error
        s = "0"
      
    try:            # Fout indien b.v. geen numerieke karakters, dan count = 0
        Yoffset = int(s)
    except:
        Yoffset = 0
        
    if (Yoffset < -32767):
        Yoffset = -32767
    if (Yoffset > 32767):
        Yoffset = 32767
    UpdateTrace()
    
def BYgain1():
    global Ygain
    if (Ygain < Ymaxgain):
        Ygain = Ygain * 2
        UpdateTrace()

def BYgain2():
    global Ygain
    if (Ygain > 1):
        Ygain = Ygain / 2
        UpdateTrace()

def BSELECTchannel():
    global SHOWchannel
    global WAVchannels
    if (WAVchannels < 2):
        SHOWchannel == 1
        return()
    if (SHOWchannel == 1):
        SHOWchannel = 2
    else:
        SHOWchannel = 1
    UpdateTrace()
    
def BWAVin():   # Read the WAV file and store the data into the arrays
    global WAVframes
    global WAVchannels
    global WAVsamplewidth
    global WAVframerate
    global WAVsignal1
    global WAVsignal2
    global WAVfilename
    global Ygain
    global Ymaxgain
    global Ylevels
    global Yoffset
    global SCstart
    global SHOWsamples   # Number of samples on the screen
    global SHOWchannel
    
    WAVfilename = filedialog.askopenfilename(filetypes=[("WAV files","*.wav"),("allfiles","*")])

    if (WAVfilename == None): # Geen input, cancel gedrukt of een error
        WAVfilename = ""

    if (WAVfilename == ""):
        return()
    
    WAVf = wave.open(WAVfilename, 'rb')
    WAVframes = WAVf.getnframes()
    # print "frames: ", WAVframes
    WAVchannels = WAVf.getnchannels()
    # print "channels: ", WAVchannels
    WAVsamplewidth = WAVf.getsampwidth()
    # print "samplewidth: ", WAVsamplewidth
    WAVframerate = WAVf.getframerate()
    # print "framerate: ", WAVframerate

    signals = WAVf.readframes(WAVframes)
    
    i = 0
    f = 0
    s = ""

    WAVsignal1 = []
    WAVsignal2 = []

    if (WAVsamplewidth == 1) and (WAVchannels == 1):
        while (f < WAVframes):
            s = str(struct.unpack('B', signals[i:(i+1)]))
            v = int(s[1:-2]) - 128
            WAVsignal1.append(v) 
            WAVsignal2.append(0) 
            i = i + 1
            f = f + 1
        Ygain = 1
        Ymaxgain = 8
        Ylevels = 256
        Yoffset = 0
        
    if (WAVsamplewidth == 1) and (WAVchannels == 2):
        while (f < WAVframes):
            s = str(struct.unpack('B', signals[i:(i+1)]))
            v = int(s[1:-2]) - 128
            WAVsignal1.append(v) 
            s = str(struct.unpack('B', signals[(i+1):(i+2)]))
            v = int(s[1:-2])
            WAVsignal2.append(v) 
            i = i + 2
            f = f + 1
        Ygain = 1
        Ymaxgain = 8
        Ylevels = 256
        Yoffset = 0

    if (WAVsamplewidth == 2) and (WAVchannels == 1):
        while (f < WAVframes):
            s = str(struct.unpack('h', signals[i:(i+2)]))
            v = int(s[1:-2])
            WAVsignal1.append(v) 
            WAVsignal2.append(0) 
            i = i + 2
            f = f + 1
        Ygain = 1
        Ymaxgain = 1024
        Ylevels = 65536
        Yoffset = 0

    if (WAVsamplewidth == 2) and (WAVchannels == 2):
        while (f < WAVframes):
            s = str(struct.unpack('h', signals[i:(i+2)]))
            v = int(s[1:-2])
            WAVsignal1.append(v) 
            s = str(struct.unpack('h', signals[(i+2):(i+4)]))
            v = int(s[1:-2])
            WAVsignal2.append(v) 
            i = i + 4
            f = f + 1
        Ygain = 1
        Ymaxgain = 1024
        Ylevels = 65536
        Yoffset = 0

    SCstart = 0
    SHOWsamples = SCW   # Number of samples on the screen
    SHOWchannel = 1

    UpdateTrace()


def UpdateTrace():  # Update the Whole screen with new trace and text
    global WAVframes
    global WAVchannels
    global WAVsamplewidth
    global WAVframerate

    de = ca.find_enclosed ( 0, 0, 1050, 620) # Delete all items on the screen    
    for n in de: 
        ca.delete(n)

    # Create blue square
    x0 = X0L-5
    y0 = Y0T-5
    x1 = X0L+SCW+5
    y1 = Y0T-5
    x2 = X0L+SCW+5
    y2 = Y0T+SCH+5
    x3 = x0
    y3 = y2
    
    Dline = [x0,y0,x1,y1,x2,y2,x3,y3,x0,y0]
    ca.create_line(Dline, fill="blue")
    
    # Draw horizontal grid lines
    i = 0
    x1 = X0L
    x2 = X0L + SCW
    while (i < 11):
        y = Y0T + i * SCH/10
        Dline = [x1,y,x2,y]
        ca.create_line(Dline, fill="black")
        i = i + 1

    # Draw vertical grid lines
    i = 0
    y1 = Y0T
    y2 = Y0T + SCH
    while (i < 11):
        x = X0L + i * SCW/10
        Dline = [x,y1,x,y2]
        ca.create_line(Dline, fill="black")
        i = i + 1
    
     # Make Trace line
    Yy = int (Ylevels / 2)
    Yconv = float(SCH) / Ylevels
    
    if (SHOWsamples <= SCW):
        Xstep = SCW / SHOWsamples
        Tstep = 1

    if (SHOWsamples > SCW):
        Xstep = 1
        Tstep = SHOWsamples / SCW
        
    Ymin = Y0T
    Ymax = Y0T + SCH
    
    Tline = []
    x1 = 0
    y1 = 0.0
    t = SCstart
    x = 0    
    while (x < SCW+1):
        if (t < WAVframes):
            x1 = x + X0L
            if (SHOWchannel == 1):
                y1 = WAVsignal1[int(t)]
            else:
                y1 = WAVsignal2[int(t)]            
                
            y1 = Ygain * (y1 + Yoffset)
            y1 = Yy - y1
            y1 = int(y1 * Yconv) + Y0T
            if (y1 < Ymin):
                y1 = Ymin
            if (y1 > Ymax):
                y1 = Ymax
            Tline.append(int(x1))
            Tline.append(int(y1))        
        t = t + Tstep
        x = x + Xstep

    ca.create_line(Tline, fill="red") # Write the trace

    # Print the text on the screen
    x = X0L
    y = Y0T+SCH+12
    txt = "Samples: " + str(SCstart) + " to " + str(SCstart + SHOWsamples)
    idTXT = ca.create_text (x, y, text=txt, anchor=W)

    x = X0L
    y = Y0T+SCH+24
    txt = "Channel: " + str(SHOWchannel)
    idTXT = ca.create_text (x, y, text=txt, anchor=W)

    x = X0L
    y = Y0T+SCH+36
    txt = "Ygain: " + str(Ygain) + "   Ylevels: " + str(Ylevels / Ygain) + "   Yoffset: " + str(Yoffset)
    idTXT = ca.create_text (x, y, text=txt, anchor=W)
    
    txt = WAVfilename
    idTXT = ca.create_text (X0L, 600, text=txt, anchor=W)
    
    txt = "Frames: " + str(WAVframes) + "   Channels: " + str(WAVchannels)
    txt = txt + "   Samplewidth: " + str(WAVsamplewidth) + "   Framerate: " + str(WAVframerate) 
    idTXT = ca.create_text (X0L, 612, text=txt, anchor=W)

    root.update() # update screens    
           

# ================ Start Make Screen ==========================

root=Tk()
root.title("WAVviewer-v02.py v01 (13-10-2018): Simple WAV file viewer")

root.minsize(100, 100)

frame1 = Frame(root, background="black", borderwidth=5, relief=RIDGE)
frame1.pack(side=TOP, expand=1, fill=X)

ca = Canvas(frame1, width=1050, height=620)
ca.pack(side=TOP)

frame2 = Frame(root, background="blue", borderwidth=5, relief=RIDGE)
frame2.pack(side=TOP, expand=1, fill=X)

b = Button(frame2, text="-Start At", width=12, command=BStartat1)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame2, text="+Start At", width=12, command=BStartat2)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame2, text="-Samples", width=12, command=BSamples1)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame2, text="+Samples", width=12, command=BSamples2)
b.pack(side=LEFT, padx=5, pady=5)

b = Button(frame2, text="LoadWAV", width=12, command=BWAVin)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame2, text="Channel", width=12, command=BSELECTchannel)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame2, text="Yoffset", width=12, command=BYoffset)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame2, text="+Ygain", width=15, command=BYgain1)
b.pack(side=RIGHT, padx=5, pady=5)

b = Button(frame2, text="-Ygain", width=12, command=BYgain2)
b.pack(side=RIGHT, padx=5, pady=5)



# ================== Start various routines =======================



mainloop()



