/*
 *        tmp_file.cpp  -  Temporrary file managment
 *			   part of OMAC project
 *	  (C)2001 Michal Karas OM4AA <om4aa@qsl.net>
 *
 *
 *	  Copying policy: GNU GPL
 */


#include <string.h>
#include <dos.h>
#include <unistd.h>
#include <ctype.h>

#include "tmp_file.h"

int TempFile::setName(const char *prg_dir)
{
	strcpy(Name, prg_dir);
	strcat(Name, TEMP_FILE);

	ftmp = fopen(Name, "w");
	strcpy(Name, tmpnam(NULL));
	fprintf(ftmp, "%s", Name);

	if (fclose(ftmp))
        	return 0;
        return 1;
}

int TempFile::lock() // Zamkne docasny subor, tak aby nedoslo k zmene jeho
{ // obsahu inym programom (napr. zmazanie suboru) v multitaskingovom systeme
	if (locked)
		return 1;

	locked = 0;
	lock_tmpf = fopen(Name, "r");
	if (lock_tmpf)
		locked = 1;

	return locked;
}

int TempFile::unlock()
{
	if (locked) {
		fclose(lock_tmpf);
	        locked = 0;
    		return 1;
        }
	return 0;
}

unsigned TempFile::checkFreeSpace(unsigned int max_qso)
{
	char		cwd[1024];
	struct dfree 	df_log, df_tmp;
  	static unsigned free = 0;
  	static char 	logd = 0, tmpd = 0;

  	if (logd == 'a' || logd == 'b') {
		if (tmpd != 'a' && tmpd != 'b') {
			getdfree(tmpd - 96, &df_tmp);
		        if (df_tmp.df_avail * df_tmp.df_sclus * df_tmp.df_bsec < free)
			        return free = df_tmp.df_avail * df_tmp.df_sclus * df_tmp.df_bsec;
		        else
			        return free;
		}
	}

        getcwd(cwd, sizeof(cwd));
	logd = tolower(cwd[0]);
	tmpd = tolower(Name[0]);
	getdfree(0, &df_log);
	if (logd == tmpd) {
		if ((df_log.df_avail * df_log.df_sclus * df_log.df_bsec) / 75 > max_qso * 2)
			free = max_qso;
    		else
      			free = (df_log.df_avail * df_log.df_sclus * df_log.df_bsec) / (2 * 75) - 2;
  	} else {
		getdfree(tmpd - 96, &df_tmp);
		if (df_log.df_avail * df_log.df_sclus * df_log.df_bsec < df_tmp.df_avail * df_tmp.df_sclus * df_tmp.df_bsec)
      			if ((df_log.df_avail * df_log.df_sclus * df_log.df_bsec) / 75 > max_qso)
        			free = max_qso;
      			else
        			free = (df_log.df_avail * df_log.df_sclus * df_log.df_bsec) / 75 - 2;
    		else
      			if ((df_tmp.df_avail * df_tmp.df_sclus * df_tmp.df_bsec) / 75 > max_qso)
 		        	free = max_qso;
      			else
        			free = (df_tmp.df_avail * df_tmp.df_sclus * df_tmp.df_bsec) / 75 - 2;
  	}

        return free;
}

