/*
 *        sumary.cpp  -  sumary of points, QSO#, mults ...
 *			 part of OMAC project
 *	  (C)2001 Michal Karas OM4AA <om4aa@qsl.net>
 *
 *
 *	  Copying policy: GNU GPL
 */



#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <dos.h>

#include "sumary.h"



char *strnset(char *s, int ch, int n)
{
       for (i = 0; i <= n; i ++)
               s[i] = ch;

       return s;
}


Sumary::Sumary()
{
	QSO[0] = QSO[1] = QSO[2] = Points[0] = Points[1] = Points[2] = Points[3] = Mults = APoints = 0;

        for (n = 0; n < 26; n ++)
		MultsNo[n] = 'A' + n;
	MultsNo[26] = 0;
}

void Sumary::getQSOnum(const char *call, const char *tmp_name)
{
       char     mode[5], mult;
       int      points;

       modMults(MultsNo, MultsNo, call);
       Mults ++;
       ftmp = fopen(tmp_name, "r");
       if (ftmp) {
               while (1) {
                       fscanf(ftmp, "%s", mode);
                       for (i = 0; i < 8; i ++)
                               fscanf(ftmp, "%s", ln);
                       mult = *ln;
                       if (isalpha(mult)) {
                               if (MultsNo[mult - 'A'] != 0x20)	{
                                       MultsNo[mult - 'A'] = 0x20;
                                       Mults ++;
                               }
                               fscanf(ftmp, "%u", &points);
                       } else
                               points = atoi(ln);

                       if (!fgets(ln, 80, ftmp))
                               break;

                       if (!strcmp(mode, CW)) {
                               QSO[0] ++;
                               if (points < 2)
                                       Points[0] += points;
                               else {
                                       Points[0] += points - 1;
                                       Points[2] ++;
                               }
                       }

                       if (!strcmp(mode, SSB)) {
                               QSO[1] ++;
                               if (points < 2)
                                       Points[1] += points;
                               else {
                                       Points[1] += points - 1;
                                       Points[2] ++;
                               }
                       }

               }
               fclose(ftmp);
       }

       QSO[2] = QSO[0] + QSO[1];
       Points[3] = Points[0] + Points[1];
       APoints = (Points[3] + Points[2]) * Mults;
}

void Sumary::wkdModes(char* mode)
{
       *mode = 0;

       if (QSO[0])
               strcpy(mode, CW);

       if (QSO[1])
               strcpy(mode, SSB);

       if (QSO[0] && QSO[1])
               strcpy(mode, CW_SSB);
}

void Sumary::getSum(char mult, int dupe, int* point, int mode)
{
       QSO[mode - 1] ++;
       QSO[2] = QSO[0] + QSO[1];
       if (mode - 1) {
               if (dupe < 1) {
                       Points[1] ++;
                       *point = 1;
               }
       } else
               if (dupe < 1) {
                       Points[0] ++;
                       *point = 1;
               }
       if (dupe < 0) {
               Points[2] ++;
               (*point) ++;
       }

       Points[3] = Points[0] + Points[1];
       if (mult != 0x20 && isalpha(mult)) {
               MultsNo[mult - 'A'] = 0x20;
               Mults ++;
       }

       APoints = (Points[3] + Points[2]) * Mults;
}

int Sumary::modMults(char* mMults, const char* Mults, const char* Call)
{
       const char* p;

       strcpy(mMults, Mults);
       if ((p = strchr(Call, '/')) != NULL) {
               p --;

               if ( *(Mults + (toupper(*p) - 'A')) != 0x20) {
                       *(mMults + (toupper(*p) - 'A')) = 0x20;
                       return 1;
               }
       } else {
              int Lastchr = toupper(*(Call + strlen(Call) - 1)) - 'A';

              if ( *(Mults + Lastchr) != 0x20) {
                       *(mMults + Lastchr) = 0x20;
                       return 1;
              }
       }

       return 0;
}

int Sumary::genReport(struct date* date, const char *call, const char *qth, const char *name, int month, int year, int category)
{
       FILE    *frprt;
       char    callx[13], space[22], mode[9], mult[5], nomults[52];
       int     wrt;

       wrt = 0;
       if (!(frprt = fopen(RprtFile, "w")))
               return 0;

       strcpy(callx, "           ");
       strcpy(callx, call);
       callx[strlen(call)] = 0x20;
       wkdModes(mode);

       for (n = 0; n < (signed)sizeof(space);)
               space[n ++] = 0x20;
       space[21] = 0;
       strnset(space, 0x20, 21);
       space[9 - strlen(mode)] = 0;

       fprintf(frprt, "       ͻ\n");
       fprintf(frprt, "                              HLASENIE z OMAC                        \n");
       fprintf(frprt, "                             mesiac:  %s/%i                       \n", mon_name[month], year);
       fprintf(frprt, "         Vol.znak: %s                  Kategoria:      %s  \n", callx, Kategoria[category]);
       fprintf(frprt, "         Mod:      %s%s                                         \n", mode, space);
       fprintf(frprt, "                   Pocet QSO CW:  %3u           Pocet QSO SSB:  %3u  \n", QSO[0], QSO[1]);
       fprintf(frprt, "                   Pocet bodov CW:%3u           Pocet bodov SSB:%3u  \n", Points[0], Points[1]);
       fprintf(frprt, "         Pocet dodatkovych bodov :%3u                   SPOLU: %4u  \n", Points[2], Points[2] + Points[3]);
       fprintf(frprt, "         Pocet nasobicov: %2u        VYSLEDOK : (%3u x %3u)    %5u  \n", Mults, Points[2] + Points[3], Mults, APoints);
       fprintf(frprt, "         Chybajuce nasobice:        ===============================  \n");
       fprintf(frprt, "                  ");

       for (n = 0; n < (signed)sizeof(nomults);)
               nomults[n ++] = 0x20;
       *nomults = 0;
       *mult = 0;
       for (i = 0; i < 26; i ++)
               if (MultsNo[i] != 0x20 && wrt) {
                       sprintf(mult, ",%c", MultsNo[i]);
                       strcat(nomults, mult);
               } else if (MultsNo[i] != 0x20 && !wrt) {
                       sprintf(mult, "%c", MultsNo[i]);
                       strcat(nomults, mult);
                       wrt = 1;
               }

       nomults[strlen(nomults)] = 0x20;
       nomults[51] = 0;

       fprintf(frprt, "%s\n", nomults);
       fprintf(frprt, "         Vyhlasujem na svoju cest,ze som dodrzal podmienky preteku,  \n");
       fprintf(frprt, "         ako aj povolovacie podmienky a vysledok suhlasi s dennikom  \n");
       fprintf(frprt, "         a so skutocnostou. Rozhodnutie sutaznej komisie povazujem   \n");
       fprintf(frprt, "         za konecne.                                                 \n");

       space[9 - strlen(mode)] = 0x20;
       strnset(space, 0x20, 21);
       space[20 - strlen(qth)] = 0;

       fprintf(frprt, "         %s %02u.%02u.%u%s       %20s  \n", qth, date->da_day, date->da_mon, date->da_year, space, name);
       fprintf(frprt, "       ͼ\n");

        if (fclose(frprt))
               return 0;
        return 1;
}

void Sumary::deleteQSO(const char *qso)
{
       char     mode[4], call[13], s_rst[4], r_rst[4], r_nr[4], mlt;
       int      day, mon, year, hour, min, num, point;

       sscanf(qso, "%s %u-%u-%u %u:%u %u %s %s %s %s %c %u\n", mode, &day, &mon, &year, &hour, &min, &num, call, s_rst, r_rst, r_nr, &mlt, &point);

       if (!isalpha(mlt)) {
               point = mlt - '0';
               mlt = 0x20;
       }

       if (!strcmp(mode, CW)) {
               QSO[0] --;
               Points[0] --;
       }

       if (!strcmp(mode, SSB)) {
               QSO[1] --;
               Points[1] --;
       }

       QSO[2] --;
       if (mlt != 0x20) {
               MultsNo[mlt - 'A'] = mlt;
               Mults --;
       }

       if (point > 1)
               Points[2] --;

       Points[3] -= point;
       APoints = (Points[3] + Points[2]) * Mults;
}

int Sumary::checkDupe(const char* call, const char *tmp_name, int Mode)
{
       char     mode[5];
       int      result = 0;

       ftmp = fopen(tmp_name, "r");
       if (!ftmp)
               return 0;

       for (;;) {
               fscanf(ftmp, "%s", mode);
               for (n = 0; n < 4; n ++)
                       fscanf(ftmp, "%s", ln);

               if ((!(Mode - 1) && !strcmp(mode, CW) && !strcmp(ln, call)) || (Mode - 1 && !strcmp(mode, SSB) && !strcmp(ln, call))) {
                       result = 1;
                       break;
               }

               if ((!(Mode - 1) && strcmp(mode, CW) && !strcmp(ln, call)) || (Mode && strcmp(mode, SSB) && !strcmp(ln, call)))
                       result = -1;

               if (fgets(ln, 80, ftmp) == NULL)
                       break;
       }

       fclose(ftmp);
       return result;
}

char Sumary::checkMult(const char* call)
{
       const char* p;

       if ((p = strchr(call, '/')) != NULL) {
               if (isalpha(call[p - (call + 1)]) && MultsNo[call[p - (call + 1)] - 'A'] != 0x20)
                       return call[p - (call + 1)];
       } else if (isalpha(call[strlen(call) - 1]) && MultsNo[call[strlen(call) - 1] - 'A'] != 0x20)
               return call[strlen(call) - 1];

       return 0x20;
}


