#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <io.h>
#include "version.h"

#define NONE "NONE\0"
#define SLD  "################################ LOG data ####################################"
#define SLDn "################################ LOG data ####################################\n"

FILE *ftmp, *flog;
char tmpname[1024], line[80];

void getCall(char* cs)
{
  int c;
  int n;

  n = 0;
  while (((c = toupper(getch())) != 0x0D || n < 4) && c != 0x1B)
  {
    if (!c)
    {
      getch();
      continue;
    }
    if (isalnum(c) && n < 11)
    {
      printf("%c", c);
      *(cs + n ++) = c;
    } else
      switch(c)
      {
	case 0x08:  // BackSpace
	  if (n)
	  {
	    *(cs + -- n) = 0;
	    printf("\b \b");
	  }
	  break;
	case 0x2F:  // '/'
	  if (n < 11)
	  {
	     printf("/");
	     *(cs + n ++) = 0x2F;
	  }
      }
  }
  if (c == 0x0D)
    *(cs + n) = 0;
  else
    *cs = 0;
}

int getQthName(char* qn)
{
  int c, n;

  n = 0;
  while ((c = getch()) != 0x0D && c != 0x1B)
  {
    if (!c)
    {
      getch();
      continue;
    }
    if ((isalpha(c) || c == '.') && n < 20)
    {
      printf("%c", c);
      *(qn + n ++) = c;
      continue;
    }
    switch (c)
    {
      case 0x08: // BackSpace
	if (n)
	{
	  *(qn + -- n) = 0;
	  printf("\b \b");
	}
	break;
      case 0x20: // Space
	if (n < 20)
	{
	  printf(" ");
	  *(qn + n ++) = 0x20;
	};
    }
  }
  *(qn + n) = 0;
  if (c == 0x1B)
    return 0;
  return 1;
}

int getInt(int len)
{
  int c;
  int n;
  char s[5];

  n = 0;
  while ((c = getch()) != 0x0D && c != 0x1B)
  {
    if (!c)
    {
      getch();
      continue;
    }
    if (isdigit(c) && n < len)
    {
      printf("%c", c);
      *(s + n ++) = c;
      *(s + n) = 0;
    }
    if (c == 0x08 && n)
    {
      printf("\b \b");
      *(s + -- n) = 0;
    }
  }
  *(s + n) = 0;
  if (c == 0x1B)
    return -1;
  return atoi(s);
}

void help()
{
  printf("\n\n\n\nOMAC-%s -=- Restore LOG v1.0  (c)2000 Michal Karas\n\n", VERSION);
  printf("Opravi data v poskodenom denniku (subor \"LOG.oma\"). Moznosti:\n");
  printf("  restlog -q    Pripise k poskodenemu LOGu spojenia zo zavodu;\n");
  printf("                tato chyba vznikne ak je na pracovnom disku nedostatok\n");
  printf("                miesta; podmienkou pre spravne opravenie LOGu je existenicia\n");
  printf("                suboru omac.swp a suboru v nom uvedeneho!\n");
  printf("  restlog -c    Opravi konfiguracne data v LOGu;\n");
  printf("                tato chyba moze vzniknut ak boli z nejakeho dovodu prepisane\n");
  printf("                pociatocne riadky v subore.\n");
  printf("  restlog -h    vypis tejto obrazovky\n");
  printf("  restlog -i    licencia programu\n");
  printf("UPOZORNENIE: pred vykonanim opravy sa povodny subor zalohuje do suboru\n");
  printf("\"LOG.bak\". Pokial oprava nebude prevedena uspesne, odporucam precitat si subor\n");
  printf("\"omac.txt\" a zamerat sa na stat o formatoch suborov dennika.\n");
  printf("Ak sa problem nevyriesi kontaktujte autora.\n");
  exit(0);
}

void license()
{
  printf("                 OM Activity Contest LOG v%s\n", VERSION);
  printf("            Copyright (C) 2000  Michal Karas, OM4AA\n\n");
  printf("      modul: restlog.exe\n\n");
  printf("      Tento program je volne programove vybavenie; mozete ho sirit a\n");
  printf("   modifikovat podla ustanoveni Obecnej verejnej licencie GNU, vydavanej\n");
  printf("   Free Software Foundation; a to bud verzie 2 tejto licencie alebo\n");
  printf("   (podla vaseho uvazenia) ktorejkolvek novsej verzie.\n\n");
  printf("      Tento program je rozsirovany v nadeji, ze bude uzitocny, avsak BEZ\n");
  printf("   AKEJKOLVEK ZARUKY; neposkytuju sa ani odvodene zaruky PREDAJNOSTI alebo\n");
  printf("   VHODNOSTI PRE URCITY UCEL.\n");
  printf("   Dalsie podrobnosti hladajte v Obecnej verejnej licencii GNU(license.txt).\n\n");
  printf("      Kopiu Obecnej verejnej licencie GNU ste mal obdrzat spolu s tymto\n");
  printf("   programom; pokial sa tak nestalo, napiste o nu Free Software Foundation,\n");
  printf("   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n\n");
  printf("   Autor: mkaras@pobox.sk\n");
  printf("          OM4AA@OM0PBC.SVK.EU\n");
  exit(0);
}

void restore_cfg(int qso = 1)
{
  char call[13], name[22], qth[22], c;
  int year, month, kateg;

  if (flog = fopen("LOG.oma", "rt"))
  {
    if (!(ftmp = fopen("LOG.bak", "wt")))
    {
      fprintf(stderr, "Chyba pri vytvarani suboru LOG.bak (disk je plny)!\n");
      exit(3);
    }
    while (fgets(line, 80, flog))
      fputs(line, ftmp);
    fclose(flog);
    if (fclose(ftmp))
    {
      fprintf(stderr, "Chyba pri zapise do suboru LOG.bak (disk je plny)!\n");
      exit(3);
    }
  }
  if (!(flog = fopen("LOG.oma", "wt")))
  {
    fprintf(stderr, "Chyba pri vytvarani suboru LOG.oma (disk je plny)!\n");
    exit(3);
  }

  printf("\nZnacka stanice: ");
  getCall(call);
  if (!strlen(call))
  {
    fclose(flog);
    exit(1);
  }
  printf("\nMeno op.: ");
  if (!getQthName(name))
  {
    fclose(flog);
    exit(1);
  }
  printf("\nQTH: ");
  if (!getQthName(qth))
  {
    fclose(flog);
    exit(1);
  }
  printf("\nRok: ");
  year = getInt(4);
  if (year < 1993 || year > 2099)
  {
    fclose(flog);
    exit(1);
  }
  printf("\nMesiac: ");
  month = getInt(2);
  if (month < 1 || month > 12)
  {
    fclose(flog);
    exit(1);
  }
  printf("\nKategoria (1-QRO;2-QRP): ");
  while ((c = tolower(getch())) != 49 && c != 50 && c != 0x1B);
  if (c == 0x1B)
  {
    fclose(flog);
    exit(1);
  }
  kateg = c - 48;
  printf("%u", kateg);

  if (!(*name))
    strcpy(name, NONE);
  if (!(*qth))
    strcpy(qth, NONE);
  fprintf(flog, "%s\n", call);
  fprintf(flog, "%s\n", name);
  fprintf(flog, "%s\n", qth);
  fprintf(flog, "%u.%u\n", month, year);
  fprintf(flog, "%u 1\n", kateg);
  if (qso)
  {
    printf("\nSpojenia: ");
    if (!(ftmp = fopen("LOG.bak", "rt")))
    {
      fprintf(stderr, "Chyba pri otvarani suboru LOG.bak (?)!\n");
      exit(2);
    }
    while (fgets(line, 80, ftmp))
      if (!strcmp(line, SLDn))
      {
        printf("zapis");
        fprintf(flog, "\n%s\n", SLD);
        while (fgets(line, 80, ftmp))
          fputs(line, flog);
        break;
      }
    fclose(ftmp);
  }
  if (fclose(flog))
  {
    fprintf(stderr, "Chyba pri zapise do dennika LOG.oma (disk je plny)!\n");
    exit(4);
  }
}

void restore_qso()
{

  if (!(ftmp = fopen("omac.swp", "rt")))
  {
    fprintf(stderr, "Nemozno otvorit subor omac.swp (subor sa nenachadza v tomto adresari)!\n");
    exit(2);
  }
  fscanf(ftmp, "%s", tmpname);
  fclose(ftmp);
  if (!(flog = fopen("LOG.oma", "rt")) || !filelength(fileno(flog)))
    restore_cfg(0);
  else
  {
    if (!(ftmp = fopen("LOG.bak", "wt")))
    {
      fprintf(stderr, "Chyba pri vytvarani suboru LOG.bak (nedostatok miesta na disku)!\n");
      exit(3);
    }
    while (fgets(line, 80, flog))
      fputs(line, ftmp);
    fclose(flog);
    if (fclose(ftmp))
    {
      fprintf(stderr, "Chyba pri zapise do zalozneho suboru LOG.bak (nedostatok miesta na disku)!\n");
      exit(4);
    }
  }
  if (!(flog = fopen("LOG.oma", "at")))
  {
    fprintf(stderr, "Chyba pri otvarani suboru LOG.oma (?)!\n");
    exit(2);
  }
  if (ftmp = fopen(tmpname, "rt"))
  {
    fprintf(flog, "\n%s\n", SLD);
    while (fgets(line, 80, ftmp))
      fputs(line, flog);
    fclose(ftmp);
  }
  else
  {
    fprintf(stderr, "Subor %s neexistuje, opravu dennika nie je mozne vykonat!\n", tmpname);
    exit(5);
  }
  if (fclose(flog))
  {
    fprintf(stderr, "Chyba pri zapise do dennika LOG.oma (nedostatok miesta na disku)!\n");
    exit(4);
  }
}


int main(int argc, char *argv[])
{
  if (argc != 2 || !strcmp(argv[1], "-h"))
    help();
  if (!strcmp(argv[1], "-i"))
    license();
  if (!strcmp(argv[1], "-q"))
    restore_qso();
  if (!strcmp(argv[1], "-c"))
    restore_cfg();
  return 0;
}
