/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*      OM Activity Contest LOG v1.3                                         */
/*      Copyright (C) 2000  Michal Karas, OM4AA                              */
/*                                                                           */
/*      subor: defines.h                                                     */
/*                                                                           */
/*      Tento program je volne programove vybavenie; mozete ho sirit a       */
/*  modifikovat podla ustanoveni Obecnej verejnej licencie GNU, vydavanej    */
/*  Free Software Foundation; a to bud verzie 2 tejto licencie alebo         */
/*  (podla vaseho uvazenia) ktorejkolvek novsej verzie.                      */
/*                                                                           */
/*      Tento program je rozsirovany v nadeji, ze bude uzitocny, avsak BEZ   */
/*  AKEJKOLVEK ZARUKY; neposkytuju sa ani odvodene zaruky PREDAJNOSTI alebo  */
/*  VHODNOSTI PRE URCITY UCEL.                                               */
/*  Dalsie podrobnosti hladajte v Obecnej verejnej licencii GNU.             */
/*                                                                           */
/*     Kopiu Obecnej verejnej licencie GNU ste mal obdrzat spolu s tymto     */
/*  programom; pokial sa tak nestalo, napiste o nu Free Software Foundation, */
/*  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                            */
/*                                                                           */
/*  Autor: om4aa@qsl.net                                                     */
/*         OM4AA@OM0PBC.SVK.EU                                               */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef OMAC_H
#define OMAC_H

#ifndef __GNUC__
#error You need GNU C compiler (g++) to compile this!
#endif


#define LogFile          "LOG.oma"
#define LOG_MASK         "*.oal"
#define LOG_EXT          ".oal"
#define RPRT_EXT         ".sum"
#define TEXT_EXT         ".txt"
#define TextFile         "LOG.txt"
#define EDITOR           "ted.com"
#define TITLE            "OM Activity Contest"
#define SLD      "################################ LOG data ####################################"
#define NONE     "NONE"
#define NONEn    "NONE\n"
#define RST      "599"
#define RS       "59"
#define RST_SEND "5NN"
#define RS_SEND  "5N"

#define MAX_QSO  999

#define LOGRerr  -11
#define LOGWerr  -13
#define TMPRerr  -12
#define TMPWerr  -14
#define RPRTerr  -22


const char *mon_name[] =
{
  "", "JAN", "FEB", "MAR", "APR", "MAJ", "JUN", "JUL", "AUG", "SEP", "OKT",
  "NOV", "DEC"
};

const char *month[] =
{
  "", "Janur", "Februr", "Marec", "Aprl", "Mj", "Jn", "Jl", "August",
  "September", "Oktber", "November", "December"
};

const char *Kategoria[] =
{
  "", "QRO", "QRP"
};

const char *Prevadzka[] =
{
  "", "CW", "SSB"
};


struct info_line {
        char  item[20];
        char  value[30];
};


class LOG                             // Trieda obsahuje funkcie pre LOG
{                                     // a o zavode
private:

  struct info_line      *info;        // informacie z dennika

  int  confirmSave();                 // Opyta sa na akceptovanie zmeny
  void getCall(char *);               // Nacita znacku
  int  getQthName(char *);            // Nacita meno alebo QTH
  int  getDate(int *, int *, int *);  // Nacita cislo s urcenym poctom cifier
  int  getCateg();                    // Zisti sutaznu kategoriu
//  int  createInfoItems(struct info_line *);

public:
  char Call[13];                      // Znacka stanice
  char QTH[22];                       // QTH stanice
  char Name[22];                      // Cele meno operatora
  int  Day;                           // Den konania OMAC
  int  Month;                         // Mesiac konania OMAC
  int  Year;                          // Rok konania OMAC
  int  UTC_cor;                       // Korekcia system. casu na UTC
  int  Category;                      // Sutazna kategoria
  int  Mode;                          // Prevadzka
  int  save_cfg;                      // Rozhoduje o ulozeni udajov
  char        *log_name;              // Nazov LOGu


  LOG();
  ~LOG();
  void getOperatorInfo();             // Zisti potrebne info o operatorovi
  void saveCfg(int = 1);              // Ulozi konfiguraciu
  void setMode();                     // Zmeni druh prevadzky (CW, SSB)
  void setConfig();                   // Zmena konfiguracie
  int  writeQSO(const char *, const char *, const char *, const char *,
                struct time *, char, int);     // Zapise spojenie do dennika
  void deleteQSO(int *);              // Zmaze spojenie z dennika
  void export2Txt();                  // Vypise dennik do textoveho suboru
} log;

class Screen                          // Trieda obsahuje metody na pracu s
{                                     // grafickym prostredim programu
private:
        int     insert;

        void showLogPart(int = 0);          // Zobrazi cast dennika
        void setFirstLogPart(int = 0);      // Zobrazi prvu cast dennika
        void setLastLogPart(int = 0);       // Zobrazi poslednu cast dennika

public:
  int clear_msg;

  Screen();
  ~Screen();
  void setScreen();                   // Vykresli cast obrazovky
  void updateScreen();                // Obnovi cast obrazovky programu
  void putInfoScreen();               // Zobrzazi info o systeme
  void putErrMsg(int);                // Vypise chybove hlasenie
  void clearScreen();                 // Zmaze obrazovku a ponecha sadu fontov
  void putBox(int, int, int, int, int, int); // Vykresli tabulku s tienmi
  void putMessage(char*, char*, int = 1); // Vypise spravu
  int  confirmExit();                 // Ukoncenie programu
  void showHelp();                    // Vypise napovedu
  void viewLog();                     // Zobrazi obsah dennika
  void deleteQSO();                   // Vyber QSO pre zmazanie
  void putWriteMode();                // Zobrazi sposob zapisu znakov
  void setWriteMode();                // Nastavi sposob zapisu znakov
  int  getWriteMode();
} scr;


void beep();                      // Pipne, FREQ = 1750, LEN = 50
void halt(int = 0);               // Ukonci cinnost programu
void get_prg_dir(const char *, char *); // Zisti adresar programu
void addchr(char *, int, char);   // Prida znak na urcenu poziciu v retazci
char delchr(char *, unsigned int);// Zmaze znak na urcenej pozicii v retazci
void msgsplit(const char *, char *, char *); // Rozdeli dva retazce
void ready();                     // Ovladenie programu


#endif // OMAC_H
