/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*      OM Activity Contest LOG v1.3                                         */
/*      Copyright (C) 2000  Michal Karas, OM4AA                              */
/*                                                                           */
/*      modul: omac.cpp                                                      */
/*                                                                           */
/*      Tento program je volne programove vybavenie; mozete ho sirit a       */
/*  modifikovat podla ustanoveni Obecnej verejnej licencie GNU, vydavanej    */
/*  Free Software Foundation; a to bud verzie 2 tejto licencie alebo         */
/*  (podla vaseho uvazenia) ktorejkolvek novsej verzie.                      */
/*                                                                           */
/*      Tento program je rozsirovany v nadeji, ze bude uzitocny, avsak BEZ   */
/*  AKEJKOLVEK ZARUKY; neposkytuju sa ani odvodene zaruky PREDAJNOSTI alebo  */
/*  VHODNOSTI PRE URCITY UCEL.                                               */
/*  Dalsie podrobnosti hladajte v Obecnej verejnej licencii GNU.             */
/*                                                                           */
/*     Kopiu Obecnej verejnej licencie GNU ste mal obdrzat spolu s tymto     */
/*  programom; pokial sa tak nestalo, napiste o nu Free Software Foundation, */
/*  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                            */
/*                                                                           */
/*  Autor: om4aa@qsl.net                                                     */
/*         OM4AA@OM0PBC.SVK.EU                                               */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#include <signal.h>
#include <process.h>
//#include <allegro.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>

#include "version.h"
#include "cw_keyer.h"
#include "tmp_file.h"
#include "sumary.h"
#include "omac.h"


char         call[13], ln[80], prg_dir[1024], my_prg[1024];
int          get = 0, n, i, x, y, c;
FILE         *flog, *ftmp;
CW_keyer     cw_keyer;
Sumary       sum;
TempFile     tmp_file;

//////////////////////////////////////////////////////////////////////////////
//                          metody triedy LOG                               //
//////////////////////////////////////////////////////////////////////////////
LOG::LOG()
{
        UTC_cor = 0;
        save_cfg = 1;

//      createInfoItems(info);
}

LOG::~LOG()
{
        tmp_file.unlock();

        if (save_cfg)
                saveCfg();
}
/* New LogFile format */
/*
int LOG::createInfoItems(struct info_line *log_info)
{
        char *items[12] = {"START-OF-LOG:", "CALLSIGN:", "DATE:", "CATEGORY:",
             "QTH:", "OPERATOR:", "NAME:", "ADDRESS:", "ADDRESS:", "ADDRESS:",
             "ADDRESS:", "ADDRESS:"};
        log_info = new struct info_line[12];

        for (n = 0; n < 12; n++)
               strcpy(log_info[n].item, items[n]);
}
*/
void LOG::getOperatorInfo()
{
  struct date d;

  scr.putBox(4, 18, 77, 23, 10, 6);
  gotoxy(35, 18);
  cprintf(" Npoveda ");
  gotoxy(6, 19);
  cprintf("Zvodn znaka stanice:");
  gotoxy(6, 20);
  cprintf("  Znaka me ma minimlne 4 a maximlne 11 znakov. V znake mu");
  gotoxy(6, 21);
  cprintf("by pouit znaky \"A\" a \"Z\", \"0\" a \"9\" a \"/\".");
  gotoxy(6, 22);
  cprintf("Program ukon klvesa ESC.");
  scr.putBox(24, 12, 55, 14, 4, 2);
  gotoxy(26, 13);
  cprintf("Znaka stanice: ");
  textbackground(5);
  textcolor(14);
  cprintf("            ");
  gotoxy(42, 13);
  getCall(Call);
  if (!strlen(Call))
  {
    fclose(flog);
    remove(LogFile);
    halt(1);
  }
  window(1, 10, 80, 25);
  textbackground(1);
  clrscr();
  scr.putBox(4, 18, 77, 23, 10, 6);
  gotoxy(35, 18);
  cprintf(" Npoveda ");
  gotoxy(6, 19);
  cprintf("Meno opertora stanice:");
  gotoxy(6, 20);
  cprintf("  Pouije sa pri vypisovan hlsenia. Meno me ma max. 20 znakov");
  gotoxy(6, 21);
  cprintf("abecedy, prpadne bodky a medzery. Meno sa zadva nemus, sta");
  gotoxy(6, 22);
  cprintf("stlai iba ENTER. ESC ukon program.");
  scr.putBox(17, 12, 62, 14, 4, 2);
  gotoxy(19, 13);
  cprintf("Cel meno opertora: ");
  textcolor(14);
  textbackground(5);
  cprintf("                     ");
  gotoxy(40, 13);
  if (!getQthName(Name))
  {
    fclose(flog);
    remove(LogFile);
    halt(1);
  }
  window(1, 10, 80, 25);
  textbackground(1);
  clrscr();
  scr.putBox(4, 18, 77, 23, 10, 6);
  gotoxy(35, 18);
  cprintf(" Npoveda ");
  gotoxy(6, 19);
  cprintf("Zvodn stanovisko stanice:");
  gotoxy(6, 20);
  cprintf("  Pouije sa pri vypisovan hlsenia. Stanovisko me ma max. 20");
  gotoxy(6, 21);
  cprintf("znakov abecedy,prpadne bodky a medzery.Stanovisko sa zadva nemus,");
  gotoxy(6, 22);
  cprintf("sta stlai len ENTER. Program ukon klvesa ESC.");
  scr.putBox(18, 12, 62, 14, 4, 2);
  gotoxy(20, 13);
  cprintf("Stanovisko stanice: ");
  textcolor(14);
  textbackground(5);
  cprintf("                     ");
  gotoxy(40, 13);
  if (!getQthName(QTH))
  {
    fclose(flog);
    remove(LogFile);
    halt(1);
  }
  window(1, 10, 80, 25);
  textbackground(1);
  clrscr();
  scr.putBox(4, 18, 77, 23, 10, 6);
  gotoxy(35, 18);
  cprintf(" Npoveda ");
  gotoxy(6, 19);
  cprintf("Dtum konania etapy zvodu:");
  gotoxy(6, 20);
  cprintf("  Tvar dtumu je [dd.mm.yyyy]. Vetky daje musia by v rozsahu dd:0");
  gotoxy(6, 21);
  cprintf("a 31; mm:0 a 12; yyyy:1993 a 9999. Ak je vypsan dtum vporiadku,");
  gotoxy(6, 22);
  cprintf("sta stlai len ENTER. ESC ukon program.");
  scr.putBox(18, 12, 62, 14, 4, 2);
  gotoxy(20, 13);
  getdate(&d);
  cprintf("Dtum konania etapy:   -  -");
  textcolor(14);
  textbackground(5);
  gotoxy(41, 13);
  cprintf("%02d", Day = d.da_day);
  gotoxy(44, 13);
  cprintf("%02d", Month = d.da_mon);
  gotoxy(47, 13);
  cprintf("%d", Year = d.da_year);
  gotoxy(41, 13);
  if (!getDate(&Day, &Month, &Year))
  {
    fclose(flog);
    remove(LogFile);
    halt(1);
  }
  if (Year < 1993 || Year > 9999)
  {
    Year = d.da_year;
    gotoxy(47, 13);
    cprintf("%d", Year);
  }
  if (Month < 1 || Month > 12)
  {
    Month = d.da_mon;
    gotoxy(44, wherey());
    cprintf("%02d", Month);
  }
  if (Day < 1 || Day > 31)
  {
    Day = d.da_day;
    gotoxy(41, wherey());
    cprintf("%02d", Day);
  }
  window(1, 10, 80, 25);
  textbackground(1);
  clrscr();
  scr.putBox(4, 18, 77, 23, 10, 6);
  gotoxy(35, 18);
  cprintf(" Npoveda ");
  gotoxy(6, 19);
  cprintf("San kategria: ");
  gotoxy(6, 20);
  cprintf("  Pomocou kurzorovch klves %c%c vyber kategriu, v ktorej sa bude", 0x18, 0x19);
  gotoxy(6, 21);
  cprintf("sai a stla ENTER. ");
  gotoxy(6, 22);
  cprintf("ESC ukon program.");
  scr.putBox(18, 12, 62, 15, 4, 2);
  gotoxy(23, 13);
  Category = getCateg();
  if (!Category)
  {
    fclose(flog);
    remove(LogFile);
    halt(1);
  }
  window(1, 10, 80, 25);
  textbackground(1);
  clrscr();
  Mode = 1;
}

void LOG::saveCfg(int deleteTmp)
{
        if (!(flog = fopen(LogFile, "w")))
                scr.putErrMsg(LOGWerr);
        else {
                if (*Name == 0)
                        strcpy(Name, NONE);
                if (*QTH == 0)
                        strcpy(QTH, NONE);

                fprintf(flog, "%s\n", Call);
                fprintf(flog, "%s\n", Name);
                fprintf(flog, "%s\n", QTH);
                fprintf(flog, "%u.%u.%u\n", Day, Month, Year);
                fprintf(flog, "%u %u\n", Category, Mode);

                if ((ftmp = fopen(tmp_file.Name, "r")) != NULL) {
                        fprintf(flog, "\n%s\n", SLD);
                        while (fgets(ln, 80, ftmp))
                                fputs(ln, flog);

                        fclose(ftmp);
                }

                if (fclose(flog)) {
                        scr.putErrMsg(LOGWerr);
                        gotoxy(24, 1);
                        cprintf("\n\rSpojenia zo zvodu s v sbore %s (spusti \"restlog.exe -q\").\n\r", tmp_file.Name);
                        getch();
                } else if (deleteTmp)
                        remove(tmp_file.Name);

                if (!strcmp(Name, NONE))
                        *Name = 0;
                if (!strcmp(QTH, NONE))
                        *QTH = 0;
        }
}

void LOG::setMode()
{
        if (Mode - 1)
                Mode --;
        else
                Mode ++;

        gotoxy(2, 20);
        textcolor(0);
        textbackground(3);
        cprintf("%3s", Prevadzka[Mode]);
}

void LOG::setConfig()
{
        int             item = 1;
        int             year, mon, day, categ;
        char            name[22], qth[22];
        struct date     d;

        scr.putMessage("", "Nastavenia LOGu. Pre vobu poloky poui KeyUp/KeyDwn a Enter.");
        window(1, 2, 80, 18);
        textcolor(0);
        textbackground(3);
        clrscr();

        printf("* Znaka         %s\n", Call);
        printf("  Meno op.       %s\n", Name);
        printf("  QTH            %s\n", QTH);
        printf("  Dtum          %02d-%02d-%d\n", Day, Month, Year);
        printf("  Kategria      %s\n", Kategoria[Category]);

        window(1, 1, 80, 25);
        for (;;) {
                c = getch();
                if (!c)
                        switch(getch()) {
                                case 0x48:  // Up
                                        if (item > 1) {
                                                gotoxy(1, item + 1);
                                                printf(" ");
                                                gotoxy(1, --item + 1);
                                                printf("*");
                                        }
                                        break;
                                case 0x50:  // Dwn
                                        if (item < 5) {
                                                gotoxy(1, item + 1);
                                                printf(" ");
                                                gotoxy(1, ++item + 1);
                                                printf("*");
                                        }
                                        break;
                        }
                else if (c == 0x0d) // Enter
                        switch (item) {
                                case 1:  // Set Call
                                        scr.putMessage("", "Zadaj znaku");

                                        gotoxy(18, 2);
                                        printf("                   ");
                                        gotoxy(18, 2);
                                        getCall(call);
                                        if (strlen(call) > 3) {
                                                strcpy(Call, call);
                                                saveCfg(0);
                                        }

                                        gotoxy(18, 2);
                                        printf(Call);
                                        break;

                                case 2:  // set op. name
                                        scr.putMessage("", "Zadaj meno opertora");

                                        gotoxy(18, 3);
                                        printf("                           ");
                                        gotoxy(18, 3);
                                        if (getQthName(name)) {
                                                strcpy(Name, name);
                                                saveCfg(0);
                                        }

                                        gotoxy(18, 3);
                                        printf(Name);
                                        break;

                                case 3:  // set QTH
                                        scr.putMessage("", "Zadaj QTH stanice");

                                        gotoxy(18, 4);
                                        printf("                           ");
                                        gotoxy(18, 4);
                                        if (getQthName(qth)) {
                                                strcpy(QTH, qth);
                                                saveCfg(0);
                                        }

                                        gotoxy(18, 4);
                                        printf(QTH);
                                        break;

                                case 4:  // set date
                                        scr.putMessage("", "Zadaj dtum");

                                        gotoxy(18, 5);
                                        printf("  -  -     ");
                                        gotoxy(18, 5);
                                        getdate(&d);
                                        if (getDate(&day, &mon, &year)) {
                                                if (year < 1993 || year > 9999)
                                                        year = d.da_year;
                                                if (mon < 1 || mon > 12)
                                                        mon = d.da_mon;
                                                if (day < 1 || day > 31)
                                                        day = d.da_day;

                                                Year = year;
                                                Month = mon;
                                                Day = day;
                                                saveCfg(0);
                                        }

                                        gotoxy(18, 5);
                                        printf("%02d-%02d-%d", Day, Month, Year);
                                        break;

                                case 5:  // set category
                                        scr.putMessage("", "Vyber kategriu");

                                        gotoxy(18, 6);
                                        if ((categ = getCateg()) > 0) {
                                                Category = categ;
                                                saveCfg(0);
                                        }

                                        textcolor(0);
                                        textbackground(3);
                                        gotoxy(18, 6);
                                        cprintf("%s                               ", Kategoria[Category]);
                                        gotoxy(18, 7);
                                        cprintf("                                  ");
                                        break;


                        }
                else if (c == 0x1b) {
	                window(1, 1, 80, 25);
	                gotoxy(1, 23);
	                textcolor(15);
	                textbackground(1);
                        clreol();
	                textcolor(0);
	                textbackground(7);
                        gotoxy(1, 1);
	                clreol();
	                gotoxy(17, 1);
	                cprintf("%s %s %s %i %s", TITLE, Call, month[Month], Year, Kategoria[Category]);
	                window(1, 2, 80, 18);
	                scr.updateScreen();
	                return;
                }
                scr.putMessage("", "Nastavenia LOGu. Pre vobu poloky poui KeyUp/KeyDwn a Enter.");
        }
}

void LOG::export2Txt()
{
  char msg[60];

  flog = fopen(TextFile, "w");
  if (!flog)
    return;
  ftmp = fopen(tmp_file.Name, "r");
  if (!ftmp)
  {
    fclose(flog);
    scr.putErrMsg(TMPRerr);
    return;
  }
  fprintf(flog, "%s %s %s %i %s\n\n\n", TITLE, log.Call, mon_name[log.Month],
	  log.Year, Kategoria[log.Category]);
  fprintf(flog, " Mod    Datum    Cas  QSO#   Znacka STN    RSTs   RSTr  NRr    Nasob  Bod\n");
  fprintf(flog, " ---    -----    ---  ----   ----------    ----   ----  ---    -----  ---\n");
  while (fgets(ln, 81, ftmp))
    fputs(ln, flog);
  fclose(ftmp);
  if (fclose(flog))
    scr.putErrMsg(LOGWerr);
  else
  {
    sprintf(msg, "Dennk bol vypsan do sboru \"%s\".", TextFile);
    scr.putMessage("", msg);
  }
}

int LOG::writeQSO(const char* call, const char* sent, const char* rst,
		  const char* rprt, struct time* tim, char mult, int point)
{
  int write;
  char msg[80];

  if (!(ftmp = fopen(tmp_file.Name, "a")))
    return 0;
  write = 1;
  sprintf(msg, " %3s %02d-%02d-%d %02d:%02d  %03d   %s", Prevadzka[Mode],
    Day, Month, Year, tim->ti_hour + UTC_cor, tim->ti_min,
    sum.QSO[2], call);
  if ((unsigned)fprintf(ftmp, msg) != strlen(msg))
    write = 0;
  for (n = 0; n < (15 - (signed)strlen(call)); n ++)
    if (fputc(' ', ftmp) == EOF)
      write = 0;
  sprintf(msg, "%3s    %3s  %3s      %c     %d \n", sent, rst, rprt, mult,
    point);
  if ((unsigned)fprintf(ftmp, msg) != strlen(msg))
    write = 0;
  if (fclose(ftmp))
    write = 0;
  tmp_file.lock();
  return write;
}

void LOG::deleteQSO(int *qso2del)
{
  char lline[80], del_qso[80];

  flog = fopen(tmp_file.Name, "r");
  ftmp = fopen("omac.swp", "w");
  if (!flog || !ftmp)
    scr.putErrMsg(LOGRerr);
  else
  {
    while (fgets(ln, 80, flog))
      fputs(ln, ftmp);
    fclose(flog);
    if (fclose(ftmp))
    {
      scr.putErrMsg(TMPWerr);
      *qso2del = 0;
      return;
    }
    flog = fopen(tmp_file.Name, "w");
    ftmp = fopen("omac.swp", "r");
    for (n = 0; n < *qso2del - 1; n ++)
    {
      fgets(ln, 80, ftmp);
      fputs(ln, flog);
    }
    fgets(del_qso, 80, ftmp);              // Skip deleted QSO & save info
      char mode[4], call[13], callx[13], s_rst[4], r_rst[4], r_nr[4], mlt;
      int day, mon, year, hour, min, num, point;
      while (fgets(ln, 80, ftmp))
      {
        sscanf(ln, " %s %u-%u-%u %u:%u %u %s %s %s %s %c %u\n", mode,
          &day, &mon, &year, &hour, &min, &num, call, s_rst, r_rst, r_nr, &mlt,
          &point);
        if (!isalpha(mlt))
        {
          point = mlt - '0';
          mlt = 0x20;
        }
        strcpy(callx, "           ");
        strcpy(callx, call);
        callx[strlen(call)] = 0x20;
        sprintf(lline, " %3s %02d-%02d-%d %02d:%02d  %3d   %s  ", mode,
          day, mon, year, hour, min, num - 1, callx);
        sprintf(ln, "  %3s    %3s  %3s      %c     %d \n", s_rst,
          r_rst, r_nr, mlt, point);
        strcat(lline, ln);
        fprintf(flog, lline);
      }
      if (fclose(flog))
      {
        scr.putErrMsg(LOGWerr);
        *qso2del = 0;
        return;
      }
      fclose(ftmp);
      remove("omac.swp");
      sum.deleteQSO(del_qso);
      return;
  }
  *qso2del = 0;
}

void LOG::getCall(char* cs)
{
  int pos, len;
  int startx = wherex();
  int starty = wherey();

  pos = len = 0;
  for (n = 0; n < (signed)sizeof(cs);)
    cs[n ++] = 0;
  while (((c = toupper(getch())) != 0x0D || len < 4) && c != 0x1B)
  {
    if (!c)
    {
      c = getch();
      switch (c)
      {
        case 0x47: // Home
          pos = 0;
          break;
        case 0x4F: // End
          pos = len;
          break;
	case 0x4B: // <--
	  if (pos)
	    pos --;
	  break;
	case 0x4D: // -->
	  if (pos < len)
	    pos ++;
	  break;
        case 0x53: // Del
	  if (len && pos < len)
	  {
	    delchr(cs, pos);
	    gotoxy(startx, starty);
	    cprintf("            ");
	    gotoxy(startx, starty);
	    cprintf("%s", cs);
	    len --;
	  }
          break;
      }
      gotoxy(startx + pos, starty);
      continue;
    }
    if ((isalnum(c) || c == '/') && len < 11)
    {
      addchr(cs, pos ++, c);
      gotoxy(startx, starty);
      len ++;
      cprintf("%s", cs);
    }
    if (c == 0x08 && pos) // BackSpace
    {
      delchr(cs, -- pos);
      gotoxy(startx, starty);
      cprintf("            ");
      gotoxy(startx, starty);
      cprintf("%s", cs);
      len --;
    }
    gotoxy(startx + pos, starty);
  }
  if (c == 0x1B)
    *cs = 0;
}

int LOG::getQthName(char* qn)
{
  int pos, len;
  int startx = wherex();
  int starty = wherey();

  pos = len = 0;
  for (n = 0; n < (signed)sizeof(qn);)
    qn[n ++] = 0;
  while ((c = getch()) != 0x0D && c != 0x1B)
  {
    if (!c)
    {
      c = getch();
      switch (c)
      {
        case 0x47: // Home
          pos = 0;
          break;
        case 0x4F: // End
          pos = len;
          break;
	case 0x4B: // <--
	  if (pos)
	    pos --;
	  break;
	case 0x4D: // -->
	  if (pos < len)
	    pos ++;
	  break;
        case 0x53: // Del
	  if (len && pos < len)
	  {
	    delchr(qn, pos);
	    gotoxy(startx, starty);
	    cprintf("                    ");
	    gotoxy(startx, starty);
	    cprintf("%s", qn);
	    len --;
	  }
          break;
      }
      gotoxy(startx + pos, starty);
      continue;
    }
    if ((isalpha(c) || c == '.' || c == ' ') && len < 20)
    {
      addchr(qn, pos ++, c);
      gotoxy(startx, starty);
      len ++;
      cprintf("%s", qn);
    }
    if (c == 0x08 && pos) // BackSpace
    {
      delchr(qn, -- pos);
      gotoxy(startx, starty);
      cprintf("                    ");
      gotoxy(startx, starty);
      cprintf("%s", qn);
      len --;
    }
    gotoxy(startx + pos, starty);
  }
  if (c == 0x1B)
    return 0;
  return 1;
}

int LOG::getDate(int* day, int* month, int* year)
{
  int startx = wherex();
  int starty = wherey();
  int pos[3], part, spos[] = {startx, startx + 3, startx + 6}, mlen[] = {2, 2, 4};
  char s[3][5] = {{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};

  pos[0] = pos[1] = pos[2] = 0;
  part = 0;
  sprintf(s[0], "%02d", *day);
  sprintf(s[1], "%02d", *month);
  sprintf(s[2], "%d", *year);
  while ((c = getch()) != 0x0D && c != 0x1B)
  {
    if (!c)
    {
      c = getch();
      switch (c)
      {
        case 0x47: // Home
          pos[part] = 0;
          break;
        case 0x4F: // End
          pos[part] = mlen[part] - 1;
          break;
	case 0x4B: // <--
	  if (pos[part])
	    pos[part] --;
          else
            if (part)
            {
              part --;
              pos[part] = mlen[part] - 1;
            }
	  break;
	case 0x4D: // -->
	  if (pos[part] < mlen[part] - 1)
	    pos[part] ++;
          else
            if (part < 2)
            {
              part ++;
              pos[part] = 0;
            }
	  break;
      }
      gotoxy(spos[part] + pos[part], starty);
      continue;
    }
    if (isdigit(c) && pos[part] < mlen[part])
    {
      s[part][pos[part] ++] = c;
      gotoxy(spos[part], starty);
      cprintf("%s", s[part]);
      if (pos[part] == mlen[part] && part < 2)
      {
        part ++;
        pos[part] = 0;
      }
      if (part == 2 && pos[part] == mlen[part])
        pos[part] --;
    }
    gotoxy(spos[part] + pos[part], starty);
  }
  if (c == 0x1B)
    return 0;
  *day = atoi(s[0]);
  *month = atoi(s[1]);
  *year = atoi(s[2]);
  return 1;
}

int LOG::getCateg()
{
  int k = 1;
  int startx = wherex();
  int starty = wherey();

  textcolor(14);
  textbackground(5);
  gotoxy(startx, starty);
  cprintf("   1. QRO - maximlny vkon 100W  ");
  textcolor(4);
  textbackground(2);
  gotoxy(startx, starty + 1);
  cprintf("   2. QRP - maximlny vkon 5W    ");
  while ((c = getch()) != 0x1B && c != 0x0D)
  {
    if (c)
      continue;
    c = getch();
    if (c == 0x48) // UP
    {
      k = 1;
      textcolor(14);
      textbackground(5);
      gotoxy(startx, starty);
      cprintf("   1. QRO - maximlny vkon 100W  ");
      textcolor(4);
      textbackground(2);
      gotoxy(startx, starty + 1);
      cprintf("   2. QRP - maximlny vkon 5W    ");
    }
    if (c == 0x50) // DOWM
    {
      k = 2;
      textcolor(4);
      textbackground(2);
      gotoxy(startx, starty);
      cprintf("   1. QRO - maximlny vkon 100W  ");
      textcolor(14);
      textbackground(5);
      gotoxy(startx, starty + 1);
      cprintf("   2. QRP - maximlny vkon 5W    ");
    }
  }

  if (c == 0x1B)
    return 0;
  return k;
}

//////////////////////////////////////////////////////////////////////////////
//                        metody triedy Screen                              //
//////////////////////////////////////////////////////////////////////////////
Screen::Screen()
{
        insert = 1;
}

Screen::~Screen()
{
        textcolor(7);
        textbackground(0);
        clearScreen();

        putInfoScreen();
}

void Screen::setScreen()
{
  char title[81];

  textcolor(15);
  textbackground(1);
  clrscr();
  textcolor(0);
  textbackground(7);
  gotoxy(1, 1);
  clreol();
  sprintf(title, "%s %s %s %i %s", TITLE, log.Call, month[log.Month],
    log.Year, Kategoria[log.Category]);
  gotoxy(40 - (strlen(title) + 1) / 2, 1);
  cprintf("%s", title);
  gotoxy(1, 24);
  clreol();
  cprintf("F1-CQ  F2-RPRT  F3-TU  F4-CFM  F5-CALL  F6-NR  F7-RCVD_CALL  F8-?  F10-klvesy");
  gotoxy(1, 23);
  textbackground(1);
  textcolor(15);
  insline();
  gotoxy(1, 20);
  textcolor(0);
  textbackground(3);
  cprintf("                      ");
  gotoxy(2, 20);
  cprintf("%3s", Prevadzka[log.Mode]);
  gotoxy(24, 20);
  cprintf("%03d", sum.QSO[2] + 1);
  gotoxy(30, 20);
  textcolor(14);
  textbackground(5);
  cprintf("            ");
}

void Screen::updateScreen()
{
        window(1, 2, 80, 7);
        textcolor(15);
        textbackground(1);
        clrscr();

        gotoxy(1, 1);
        printf("           CW SSB Spolu\n");
        printf("QSO       %4u%4u%4u\n", sum.QSO[0], sum.QSO[1], sum.QSO[2]);
        printf("Bodov     %4u%4u%4u\n", sum.Points[0], sum.Points[1] + sum.Points[2], sum.Points[3] + sum.Points[2]);
        printf("Nsobiov           %4u", sum.Mults);

        gotoxy(30, 5);
        printf("VSLEDOK: %7u", sum.APoints);
        gotoxy(30, 6);
        printf("");

        gotoxy(47, 2);
        printf("Chbajce nsobie: ");
        window(50, 4, 75, 6);
        gotoxy(1, 1);
        textcolor(15);
        textbackground(1);
        for (n = 0; n < 26; n++)
                if (sum.MultsNo[n] == 0x20) {
                        textcolor(0);
                        cprintf("%c ", 'A' + n);
                        textcolor(15);
                } else
                        cprintf("%c ", sum.MultsNo[n]);

        window(1, 1, 80, 25);
        window(1, 8, 80, 18);
        textbackground(3);
        textcolor(0);
        clrscr();

        if ((ftmp = fopen(tmp_file.Name, "r")) != NULL) {
                if (filelength(fileno(ftmp)) < 825)
                        setFirstLogPart();
                else
                        setLastLogPart();

                fclose(ftmp);
        }
        window(1, 1, 80, 25);

        gotoxy(1, 24);
        unsigned space = tmp_file.checkFreeSpace(MAX_QSO);
        if (space == MAX_QSO)
                space -= sum.QSO[2] + 1;
        printf("mem=%u QSO", space);

        gotoxy(69, 24);
        int auto_msg = cw_keyer.getAutoMesg();
        if (auto_msg == 1)
                printf("CQ  ");
        else if (auto_msg == 2)
                printf("CALL");
        else
                printf("    ");

        gotoxy(78, 24);
        if (cw_keyer.isEnabled())
                printf("%c", cw_keyer.isInverted() ? 'L' : 'R');

        putWriteMode();

        if (!get)
                putMessage("", "Zadaj znaku. Alt-H Npoveda.");
        else
                putMessage("", "Zadaj prijat sprvu. ENTER zpis QSO. ESC zruenie zpisu.");
}

void Screen::putInfoScreen()
{
        printf("\nOMAC-%s  (C)2000 Michal Karas, OM4AA\n", VERSION);
        printf("           %s  %s\n", __DATE__, __TIME__);
}

void Screen::putErrMsg(int errnum)
{
  char msg[80];

  switch (errnum)
  {
    case LOGWerr:
      sprintf(msg, "pri zpise konfigurcie do sboru \"%s\"!", LogFile);
      break;
    case LOGRerr:
      sprintf(msg, "pri tan konfigurcie zo sboru \"%s\"!", LogFile);
      break;
    case TMPWerr:
      sprintf(msg, "pri zpise do doasnho sboru! (nedostatok miesta na disku)");
      break;
    case TMPRerr:
      sprintf(msg, "pri tan z doasnho sboru! (LOG je przdny)");
      break;
    case RPRTerr:
      sprintf(msg, "pri zpise do sboru \"%s\"!", RprtFile);
      break;
    default:
      sprintf(msg, "slo %d.", errnum);
  }
  beep();
  putMessage("CHYBA", msg);
}

void Screen::clearScreen()
{
	textcolor(7);
	textbackground(0);
	clrscr();
}

void Screen::putBox(int x1, int y1, int x2, int y2, int frcolor, int bkcolor)
{
  textcolor(frcolor);
  textbackground(bkcolor);
  window(x1, y1, x2, y2);
  clrscr();
  window(1, 1, 80, 25);
  gotoxy(x1, y1);
  cprintf(".");
  gotoxy(x1, y2);
  cprintf("`");
  for (x = x1 + 1; x < x2;)
  {
    gotoxy(x, y1);
    cprintf("-");
    gotoxy(x ++, y2);
    cprintf("-");
  }
  cprintf("'");
  gotoxy(x2, y1);
  cprintf(".");
  for (y = y1 + 1; y < y2;)
  {
    gotoxy(x1, y);
    cprintf("|");
    gotoxy(x2, y ++);
    cprintf("|");
  }
  textbackground(0);
  for (x = x1 + 2; x < x2 + 3; x ++)
    if (y2 < 25 && x <= 80)
    {
      gotoxy(x, y2 + 1);
      cprintf(" ");
    }
  for (y = y1 + 1; y < y2 + 1; y ++)
    if (x2 + 2 <= 80 && y <= 25)
    {
      gotoxy(x2 + 1, y);
      cprintf("  ");
    }
  textbackground(bkcolor);
}

void Screen::putMessage(char *title, char *msg, int clr_msg)
{
        x = wherex(); y = wherey();
        gotoxy(1, 23);
        textbackground(1);
        clreol();
        textbackground(7);
        gotoxy(40 - (strlen(title) + strlen(msg) + 1) / 2, 23);

        if (strlen(title)) {
                blinkvideo();
                textcolor(132);
                cprintf(" %s", title);
        }
        textcolor(1);
        cprintf(" %s ", msg);

        clear_msg = clr_msg;
        gotoxy(x, y);
}

void Screen::showHelp()
{
        window(1, 2, 80, 18);
        textcolor(0);
        textbackground(3);
        clrscr();

        printf("Alt-A - AutoMsg: CQ/CALL mod        Alt-M - Druh prevdzky\n");
        printf("Alt-C - Nastavenia                  Alt-R - Hlsenie do hlasenie.txt\n");
        printf("Alt-E - Zmaza QSO                  Alt-T - Konvertova LOG do log.txt\n");
        printf("Alt-I - Invertova pastiku         Alt-W - Upravi LOG\n");
        printf("Alt-H - Npoveda                    Alt-X - Koniec\n");
        printf("Alt-K - Zapn/Vypn keyer         PgDwn/Up - Zni/Zvi rchlos\n");
        printf("Alt-L - Prezrie LOG                -/+   - Zni/Zvi tn\n");
        printf("\n");
        printf("\n\n");
        printf("  OM Activity LOG je ABSOLTNE BEZ ZRUKY. Ide o von programov vybavenie\n");
        printf("a jeho renie za istch podmienok je vtan; podrobnosti s uveden\n");
        printf("v sbore \"COPYING\".\n");
        printf("  Program sli pre zpis spojen z preteku OM Activity(\"OMACpodm.txt\").\n");
        printf("Popis programu sa nachdza v sbore \"OMAC.txt\".\n\n");
        printf("Nvrat - ESC                                          Verzia programu: %s", VERSION);

        while (getch() != 0x1B);
        updateScreen();
}

void Screen::viewLog()
{
  int loglen;

  textcolor(1);
  textbackground(7);
  if (!(ftmp = fopen(tmp_file.Name, "r")))
  {
    scr.putErrMsg(TMPRerr);
    return;
  }
  window(1, 2, 80, 7);
  textcolor(15);
  textbackground(1);
  clrscr();
  cprintf("\n\n\n\n\r");
  cprintf(" Md    Dtum    as  QSO#   Znaka STN    RSTs   RSTr  NRr    Nasob  Bod\n\r");
  cprintf(" ---    -----    ---  ----   ----------    ----   ----  ---    -----  ---");
  window(1, 1, 80, 25);
  putMessage("", "Vpis LOGu. Pre listovanie poui PageUP/DOWN, HOME, END. Koniec ESC.");
  window(1, 8, 80, 18);
  textbackground(3);
  textcolor(0);
  clrscr();
  loglen = filelength(fileno(ftmp));
  showLogPart();
  while ((c = getch()) != 0x1B)
  {
    if (!c)
      c = getch();
    else
      continue;
    switch (c)
    {
      case 0x47: // Home
	clrscr();
	setFirstLogPart();
      break;
      case 0x4F: // End
	clrscr();
	if (loglen < 825)
	  setFirstLogPart();
	else
	  setLastLogPart();
      break;
      case 0x49: // PgUp
	clrscr();
	if (ftell(ftmp) < 825 * 2)
	  setFirstLogPart();
	else
	{
	  fseek(ftmp, -825 * 2, SEEK_CUR);
	  showLogPart();
	}
      break;
      case 0x51: // PgDn
	clrscr();
	if (loglen < 825)
	  setFirstLogPart();
	if (loglen - ftell(ftmp) < 825)
	  setLastLogPart();
	else
	  showLogPart();
    }
  }
  fclose(ftmp);
  updateScreen();
}

void Screen::deleteQSO()
{
#define READ_QSO {\
  fgets(qso[n], 80, ftmp);\
  if (qso[n][strlen(qso[n]) - 1] == '\n')\
    qso[n][strlen(qso[n]) - 1] = 0;\
}
  unsigned pos, slen, qson = sum.QSO[2], qsop = qson;
  unsigned long flen;
  char qso[11][80];

  if (!qson)
    return;
  if (qson <= 11)
    pos = qson;
  else
    pos = 11;
  for (n = 0; n < (signed)sizeof(qso) / 80;)
    *qso[n ++] = 0;
  sprintf(ln, "Mazanie QSO. Pomocou %c%c vyber QSO. ENTER mae. ESC koniec.", 0x18, 0x19);
  putMessage("", ln);
  window(1, 8, 80, 18);
  if ((ftmp = fopen(tmp_file.Name, "r")) != NULL)
  {
    fgets(ln, 80, ftmp);
    flen = filelength(fileno(ftmp));
    slen = strlen(ln) + 1;
    fseek(ftmp, - slen * (qson < 11 ? qson : 11), SEEK_END);
    for (n = 0; n < 11; n ++)
            READ_QSO
    textcolor(0);
    textbackground(3);
    if (qson < 11)
      for (n = 0; n < (signed)qson - 1; n ++)
        cprintf("%s\n\r", qso[n]);
    else
      for (n = 0; n < 10; n ++)
        cprintf("%s\n\r", qso[n]);
    textcolor(3);
    textbackground(0);
    clreol();
    cprintf("%s", qso[qson < 11 ? qson - 1 : 10]);
  }
  else
  {
    scr.putErrMsg(TMPRerr);
    return;
  }
  while ((c = getch()) != 0x1B)
  {
    if (!c)
    {
      c = getch();
      switch (c) {
        case 0x49: // PgUp
          if (qsop - pos >= 11)
          {
            fseek(ftmp, -(2 * 11 * slen), SEEK_CUR);
            qsop -= 11;
          }
          else
          {
            rewind(ftmp);
            if (qsop <= 11)
              qsop = pos = 1;
            else
              qsop = pos;
          }
          textcolor(0);
          textbackground(3);
          clrscr();
          for (n = 0; n < 11; n ++)
          {
            READ_QSO
            if (n == (signed)pos - 1)
            {
              textcolor(3);
              textbackground(0);
              clreol();
              cprintf("%s", qso[n]);
              textcolor(0);
              textbackground(3);
            }
            else
              cprintf("%s", qso[n]);
            if (n < 10)
              cprintf("\n\r");
          }
          break;
        case 0x51: // PgDn
          if ((flen - ftell(ftmp) < slen * 11) && qson > 11)
            fseek(ftmp, -11 * slen, SEEK_END);
          if (qson <= 11)
            rewind(ftmp);
          if (qson - qsop <= 11)
          {
            qsop = qson;
            if (qson < 11)
              pos = qson;
            else
              pos = 11;
          }
          else
            qsop += 11;
          textcolor(0);
          textbackground(3);
          clrscr();
          for (n = 0; n < 11; n ++)
          {
            READ_QSO
            if (n == (signed)pos - 1)
            {
              textcolor(3);
              textbackground(0);
              clreol();
              cprintf("%s", qso[n]);
              textcolor(0);
              textbackground(3);
            }
            else
              cprintf("%s", qso[n]);
            if (n < 10)
              cprintf("\n\r");
          }
          break;
        case 0x47: // Home
          rewind(ftmp);
          for (n = 0; n < (signed)(qson <= 11 ? qson : 11); n ++) READ_QSO
          pos = qsop = 1;
          textcolor(0);
          textbackground(3);
          clrscr();
          textcolor(3);
          textbackground(0);
          clreol();
          cprintf("%s\n\r", *qso);
          textcolor(0);
          textbackground(3);
          for (n = 1; n < (signed)(qson <= 10 ? qson : 10);)
            cprintf("%s\n\r", qso[n ++]);
          if (qson > 10)
            cprintf("%s", qso[10]);
          break;
        case 0x4F: // End
          if (qson <= 11)
          {
            gotoxy(1, pos);
            textcolor(0);
            textbackground(3);
            clreol();
            cprintf("%s", qso[pos - 1]);
            pos = qsop = qson;
            textcolor(3);
            textbackground(0);
            gotoxy(1, pos);
            clreol();
            cprintf("%s", qso[pos - 1]);
          }
          else
          {
            fseek(ftmp, -11 * slen, SEEK_END);
            qsop = qson;
            pos = 11;
            textcolor(0);
            textbackground(3);
            clrscr();
            for (n = 0; n < 11; n ++)
            {
              READ_QSO
              if (n < 10)
                cprintf("%s\n\r", qso[n]);
              else
              {
                textcolor(3);
                textbackground(0);
                clreol();
                cprintf("%s", qso[n]);
                textcolor(0);
                textbackground(3);
              }
            }
          }
          break;
        case 0x48: // UP
          if (qsop > 1)
          {
            if (pos == 1)
            {
              gotoxy(1, 1);
              insline();
              if (ftell(ftmp) < 12 * (signed)slen)
                rewind(ftmp);
              else
                fseek(ftmp, -12 * slen, SEEK_CUR);
              for (n = 0; n < 11; n ++) READ_QSO
            }
            textcolor(3);
            textbackground(0);
            gotoxy(1, pos - 1 ? --pos : pos);
            clreol();
            cprintf("%s\n\r", qso[pos - 1]);
            textcolor(0);
            textbackground(3);
            clreol();
            cprintf("%s", qso[pos]);
            qsop --;
          }
          break;
        case 0x50: // DWN
          if (qsop < qson)
          {
            if (pos == 11 && flen - ftell(ftmp) >= slen)
            {
              fseek(ftmp, -10 * slen, SEEK_CUR);
              for (n = 0; n < 11; n ++) READ_QSO
              pos --;
              gotoxy(1, 1);
              delline();
            }
            gotoxy(1, pos);
            textcolor(0);
            textbackground(3);
            clreol();
            cprintf("%s\r\n", qso[pos - 1]);
            textcolor(3);
            textbackground(0);
            clreol();
            cprintf("%s", qso[pos]);
            if (pos < 11)
              pos ++;
            qsop ++;
          }
          break;
      }
    }
    if (c == 0x0D)
    {
      int qso2del = qsop;
      window(1, 1, 80, 25);
      sprintf(ln, "Naozaj chce zmaza spojenie . %03u ? (A/N):", qso2del);
      putMessage("VAROVANIE", ln);
      gotoxy(68, 23);
      if (toupper(getch()) == 'A')
      {
        fclose(ftmp);
        log.deleteQSO(&qso2del);
        ftmp = fopen(tmp_file.Name, "r");
        flen = filelength(fileno(ftmp));
      }
      else
        qso2del = 0;
      sprintf(ln, "Mazanie QSO. Pomocou %c%c vyber QSO. ENTER mae. ESC koniec.", 0x18, 0x19);
      putMessage("", ln);
      window(1, 8, 80, 18);
      if (qso2del)
      {
        textcolor(0);
        textbackground(3);
        clrscr();
        qson = sum.QSO[2];
        if (!qson)
          break;
        if (pos > qson)
          pos --;
        if (qsop > qson)
          qsop --;
        for (n = 0; n < (signed)sizeof(qso) / 80;)
          *qso[n ++] = 0;
        if (qson <= 11)
        {
          rewind(ftmp);
          for (n = 0; n < (signed)qson; n ++) READ_QSO
        }
        else
        {
          if (pos < 11)
            qsop -= (((qson - qsop) <= 11) && (qson - (qsop - 1)) ? 1 : 0);
          for (n = 0; n < (signed)(qsop - pos); n ++)
            fgets(ln, 80, ftmp);
          for (n = 0; n < 11; n ++) READ_QSO
        }
        for (n = 0; n < (signed)(qson > 10 ? 10 : qson); n ++)
          if (n == (signed)pos - 1)
          {
            textcolor(3);
            textbackground(0);
            clreol();
            cprintf("%s\n\r", qso[n]);
            textcolor(0);
            textbackground(3);
          }
          else
            cprintf("%s\n\r", qso[n]);
        if (qson > 10)
          if (pos == 11)
          {
            textcolor(3);
            textbackground(0);
            clreol();
            cprintf("%s", qso[n]);
          }
          else
            cprintf("%s", qso[n]);
      }
    }
  }
  fclose(ftmp);
  updateScreen();
}

void Screen::putWriteMode()
{
        gotoxy(80, 24);
        textbackground(1);
        textcolor(15);
        cprintf("%c", insert ? 'I' : 'O');
        textcolor(14);
        textbackground(5);
}

void Screen::setWriteMode()
{
        insert = !insert;
        putWriteMode();
}

int Screen::getWriteMode()
{
        return insert;
}

void Screen::showLogPart(int lightline)
{
  for (n = 0; n < 11; n ++)
  {
    *ln = 0;
    fgets(ln, 80, ftmp);
    if (lightline && n == lightline - 1)
    {
      textcolor(3);
      textbackground(0);
      clreol();
    }
    else
    {
      textcolor(0);
      textbackground(3);
    }
    if (n < 10)
      cprintf("%s\r", ln);
    else
    {
      if (ln[strlen(ln) - 1] == '\n')
	ln[strlen(ln) - 1] = 0;
      cprintf("%s", ln);
    }
    if (feof(ftmp))
      break;
  }
}

void Screen::setFirstLogPart(int lightline)
{
        rewind(ftmp);
        showLogPart(lightline);
}

void Screen::setLastLogPart(int lightline)
{
        fseek(ftmp, -825, SEEK_END);
        showLogPart(lightline);
}

//////////////////////////////////////////////////////////////////////////////
//                          funckie programu                                //
//////////////////////////////////////////////////////////////////////////////
void beep()
{
        sound(1750);
        delay(50);
        nosound();
}

void halt(int errnum)
{
        textcolor(7);
        textbackground(0);
        scr.clearScreen();
        exit(errnum);
}

void get_prg_dir(char *dir)
{
        if (!strchr(my_prg, '\\') && !strchr(my_prg, '/'))
                return;

        for (i = strlen(my_prg); i >= 0; i --)
                if (my_prg[i] == '\\' || my_prg[i] == '/')
                        break;

        strcpy(dir, my_prg);
        dir[i + 1] = 0;
}

void addchr(char* s, int pos, char c)
{
        for (n = strlen(s); n >= pos; n --)
                s[n + 1] = s[n];

        s[pos] = c;
}

char delchr(char* s, unsigned int pos)
{
        char    delc = s[pos];

        for (n = pos; n < (signed)strlen(s); n++)
                s[n] = s[n + 1];

        return delc;
}

void msgsplit(const char* msg, char* rst, char* rprt)
{
        const char*     p;

        if ((p = strchr(msg, 0x20)) != NULL) {
                for (n = 0; n < p - msg; n ++)
                        rst[n] = msg[n];

                for (i = n = (p - msg) + 1; n < (signed)strlen(msg); n ++)
                        rprt[n - i] = msg[n];
        }
}

void oldmsg()
{
	if (scr.clear_msg)
		if (get)
			scr.putMessage("", "Zadaj prijat sprvu. ENTER zpis QSO. ESC zruenie zpisu.");
		else
			scr.putMessage("", "Zadaj znaku. Alt-H Npoveda.");
}

void create_msg2send(const char *call, const char *rst, const char *rprt, unsigned num)
{
        struct		qso_info qso;

        strcpy(qso.my_call, log.Call);
        strcpy(qso.his_call, call);
        strcpy(qso.his_rst, log.Mode == 1 ? RST_SEND : RS_SEND);
        strcpy(qso.my_rst, rst);
        strcpy(qso.his_nr, itoa(sum.QSO[2] + 1, NULL, 10));
        strcpy(qso.my_nr, rprt);

        scr.putMessage("CW:", cw_keyer.getMessage(num, &qso));
        scr.clear_msg = 1;
        cw_keyer.sendMessage(num, &qso);

        oldmsg();
}


void ready()
{
	struct time 	time;
	struct date	date;
	int		imin, cpos, clen, rpos, rlen, rcvd, point, nrx;
	char		rst[4], rprt[4], sent[4], msg[8], mult, c, mssg[60];

	imin = 255;
	get = cpos = clen = rpos = rlen = rcvd = point = nrx = 0;
	scr.updateScreen();
	for (n = 0; n < 8;)
		msg[n++] = 0;

        for (;;) {
		textbackground(3);
		textcolor(0);
		if (get)
			gotoxy(30 + rpos, 22);
		else
			gotoxy(30 + cpos, 20);
    while (!kbhit())
    {
      getdate(&date);
      gettime(&time);
      /* This may be not found, because I don't know if it work on SPP */
//	cw_keyer.scanPaddle();
      if (time.ti_min != imin)
      {
	gotoxy(6, 20);
	cprintf("%02d-%02d-%d ", log.Day, log.Month, log.Year);
	cprintf("%02d:%02d", time.ti_hour + log.UTC_cor, time.ti_min);
	cprintf("  %03d", sum.QSO[2] + 1);
	if (get)
	  gotoxy(30 + rpos, 22);
	else
	  gotoxy(30 + cpos, 20);
	imin = time.ti_min;
      }
    }
    oldmsg();
    textcolor(14);
    textbackground(5);
    c = toupper(getch());
    if (!c)
    {
      c = getch();
      switch (c)
      {
        case 0x1e: // Alt-A  /* Enable/Disable AutoMessages */
        	gotoxy(69, 24);
        	if (cw_keyer.setAutoMesg() == 1)
                	printf("CALL");
                else if (cw_keyer.getAutoMesg() == 2)
                        printf("CQ  ");
                else
                	printf("    ");
                break;

	case 0x2e: // Alt-C  /* Configure */
		log.setConfig();
	  	break;

        case 0x12: // Ald-E  /* Erase QSO from LOG */
          	scr.deleteQSO();
          	gotoxy(24, 20);
          	textbackground(3);
          	textcolor(0);
  	  	cprintf("%03d", sum.QSO[2] + 1);
          	break;

	case 0x23: // Alt-H  /* Help */
	  	scr.showHelp();
	  	break;

        case 0x17: // Alt-I  /* Invert paddle dit/dat */
        	if (cw_keyer.isEnabled()) {
	        	gotoxy(78, 24);
                        printf("%c", cw_keyer.invert() ? 'L' : 'R');
                }
                break;

        case 0x25: // Alt-K
        	if (log.Mode == 1) // Enable/Disable CW keyer support
                	if (cw_keyer.isEnabled()) {
                        	cw_keyer.disable();
                                gotoxy(78, 24);
                                printf(" ");
                        } else {
                        	cw_keyer.enable();
                                gotoxy(78, 24);
                                if (cw_keyer.isEnabled())
	                                printf("%c", cw_keyer.isInverted() ? 'L' : 'R');
                        }
                break;

	case 0x26: // Alt-L  /* View LOG */
	  	scr.viewLog();
	  	break;

	case 0x32: // Alt-M  /* Set CW/SSB Mode */
		log.setMode();
		break;

	case 0x13: // Alt-R  /* Generate Report of OMAC */
                char rprt_msg[50];
	  	if (sum.genReport(&date, log.Call, log.QTH, log.Name, log.Month, log.Year, log.Category)) {
                        sprintf(rprt_msg, "Hlsenie bolo vypsan do sboru \"%s\".", RprtFile);
                        scr.putMessage("", rprt_msg);
                } else
                        scr.putErrMsg(RPRTerr);
    	  	break;

        case 0x14: // Alt-T  /* Export LOG to txt format */
          	log.export2Txt();
          	break;

        case 0x11: // Alt-W  /* Edit LOG */
        	tmp_file.unlock();
        	spawnl(P_WAIT, EDITOR, EDITOR, tmp_file.Name, 0);
                tmp_file.lock();
                scr.clearScreen();
                scr.setScreen();
                scr.updateScreen();
  	        textbackground(3);
	        textcolor(0);
	        gotoxy(6, 20);
   	        cprintf("%02d-%02d-%d ", log.Day, log.Month, log.Year);
	        cprintf("%02d:%02d", time.ti_hour + log.UTC_cor, time.ti_min);
	        cprintf("  %03d", sum.QSO[2] + 1);
 	        textbackground(5);
	        textcolor(14);
	        gotoxy(30, 20);
	        cprintf("            ");
                gotoxy(30, 20);
                cprintf(call);
                if (!get)
                	gotoxy(30 + cpos, 20);
                else {
	      		gotoxy(30, 22);
			cprintf("        ");
	        	gotoxy(30, 22);
                        cprintf(msg);
                }
                break;

	case 0x2D: // Alt-X  /* Exit program */
		return;
		break;

        case 0x49: // PgUp
        	cw_keyer.SpeedUp();
                break;

        case 0x51: // PgDwn
        	cw_keyer.SpeedDwn();
                break;

	case 0x47: // Home
		if (get)
			rpos = 0;
		else
	    		cpos = 0;
	  	break;

	case 0x4F: // End
	  	if (get)
	    		rpos = rlen;
	  	else
	    		cpos = clen;
	  	break;

	case 0x52: // Ins
	  	scr.setWriteMode();
	  	break;

	case 0x53: // Del
	  if (!get && clen && cpos < clen)
	  {
	    delchr(call, cpos);
	    gotoxy(30, 20);
	    cprintf("            ");
	    gotoxy(30, 20);
	    cprintf("%s", call);
	    gotoxy(30 + cpos, 20);
	    clen --;
	  }
	  if (get && rlen && rpos < rlen)
	  {
	    char cd = delchr(msg, rpos);
	    if (rcvd && cd == 0x20)
	      rcvd = 0;
	    gotoxy(30, 22);
	    cprintf("        ");
	    gotoxy(30, 22);
	    cprintf("%s", msg);
	    gotoxy(30 + rpos, 22);
	    rlen --;
	  }
	  break;
	case 0x48: // UP
	case 0x50: // DOWN
	  if (get)
	  {
	    nrx = 1;
	    get = 0;
            sprintf(mssg, "Zme znaku. V zpise QSO pokrauj ENTERom alebo %c%c.", 0x18, 0x19);
            scr.putMessage("", mssg);
	  }
	  else
	    if (nrx)
	    {
	      get = 1;
	      if (clen > 3 && sum.checkDupe(call, tmp_file.Name, log.Mode) > 0)
	      {
		beep();
  	        if (rlen)
	        {
                  scr.putMessage("DUPLICITN QSO!", "V zpise QSO pokrauj zadanm RPRT alebo ENTERom.");
		  gotoxy(30 + rpos, 22);
	        }
	        else
	        {
                  scr.putMessage("DUPLICITN QSO!", "V zpise QSO pokrauj zadanm RPRT.");
		  textcolor(14);
		  textbackground(5);
		  gotoxy(30, 22);
		  cprintf("        ");
		  gotoxy(30, 22);
	        }
	      }
              else
              {
                scr.putMessage("", "Zadaj prijat sprvu. ENTER zpis QSO. ESC zruenie zpisu.");
	        gotoxy(30 + rpos, 23);
              }
	    }
	  break;
	case 0x4B: // <--
	  if (get && rpos)
	    rpos --;
	  if (!get && cpos)
	    cpos --;
	  break;
	case 0x4D: // -->
	  if (get && rpos < rlen)
	    rpos ++;
	  if (!get && cpos < clen)
	    cpos ++;
	  break;
        case 0x3b:	// F1
        case 0x3c:	// F2
        case 0x3d:	// F3
        case 0x3e:	// F4
        case 0x3f:	// F5
        case 0x40:	// F6
        case 0x41:	// F7
        case 0x42:	// F8
        	if (log.Mode == 1)
                        create_msg2send(call, rst, rprt, c - 0x3a);
               	break;

	case 0x44:	// F10 - Send text from keyboard
		scr.putMessage("", "Text z klvesnice; Poui 'A' - 'Z', '1' - '0', '/', '?'; ESC - koniec.");
		scr.clear_msg = 1;
		while ((c = getch()) != 0x1b)
			if (log.Mode == 1)
				cw_keyer.sendKey(c);
                oldmsg();
		break;

      }
    } else
    {
      switch (c)
      {
	case 'A': case 'B': case 'C': case 'D': case 'E': case 'F': case 'G':
	case 'H': case 'I': case 'J': case 'K': case 'L': case 'M': case 'N':
	case 'O': case 'P': case 'Q': case 'R': case 'S': case 'T': case 'U':
	case 'V': case 'W': case 'X': case 'Y': case 'Z':
	case '0': case '1': case '2': case '3': case '4': case '5': case '6':
	case '7': case '8': case '9':
	case '/': case ' ':
	  if (!get && c != 0x20)
	  {
	    textcolor(14);
	    textbackground(5);
	    if (!scr.getWriteMode() && cpos < (signed)sizeof(call) - 2)
	    {
	      *(call + cpos ++) = c;
              gotoxy(30, 20);
              cprintf("%s", call);
              gotoxy(30 + cpos, 20);
	    }
	    else
	      if (clen < (signed)sizeof(call) - 2)
	      {
		addchr(call, cpos ++, c);
		gotoxy(30, 20);
		clen ++;
		cprintf("%s", call);
		gotoxy(30 + cpos, 20);
	      }
	    if (cpos > clen)
	      clen = cpos;
	  }
	  if ((c == 0x20 || (c >= '0' && c <= '9')) && get)
	  {
	    if (c == 0x20 && !rcvd)
	    {
	      if (!scr.getWriteMode() && rpos < 7)
	      {
		rcvd = 1;
		putchar(c);
		*(msg + rpos ++) = c;
	      } else
		if (rlen < 7)
		{
		  rcvd = 1;
		  addchr(msg, rpos ++, c);
		  rlen ++;
		  gotoxy(30, 22);
		  cprintf("%s", msg);
		  gotoxy(30 + rpos, 22);
		}
	    }
	    if (c != 0x20)
	    {
	      if (!scr.getWriteMode() && rpos < 7)
	      {
		if (rcvd && *(msg + rpos) == 0x20)
		  rcvd = 0;
		*(msg + rpos ++) = c;
		gotoxy(30, 22);
		cprintf("%s", msg);
		gotoxy(30 + rpos, 22);
	      }
	      else
		if (rlen < 7)
		{
		  addchr(msg, rpos ++, c);
		  rlen ++;
		  gotoxy(30, 22);
		  cprintf("%s", msg);
		  gotoxy(30 + rpos, 22);
		}
	    }
	    if (rpos > rlen)
	      rlen = rpos;
	  }
	  break;
        case '+':
        	cw_keyer.ToneUp();
                break;
        case '-':
        	cw_keyer.ToneDwn();
                break;
	case 0x08:  // BackSpace
	  if (!get && cpos)
	  {
	    delchr(call, -- cpos);
	    gotoxy(30, 20);
	    cprintf("            ");
	    gotoxy(30, 20);
	    cprintf("%s", call);
	    gotoxy(30 + cpos, 20);
	    clen --;
	  }
	  if (get && rpos)
	  {
	    char cd = delchr(msg, --rpos);
	    if (rcvd && cd == 0x20)
	      rcvd = 0;
	    gotoxy(30, 22);
	    cprintf("        ");
	    gotoxy(30, 22);
	    cprintf("%s", msg);
	    gotoxy(30 + rpos, 22);
	    rlen --;
	  }
	  break;
	case 0x0D:  // Enter
	  if (clen > 3 && !get)
	  {
	    if (!rlen)
	    {
	      gotoxy(1, 23);
	      textbackground(1);
	      clreol();
	      textcolor(14);
	      textbackground(5);
	      gotoxy(30, 22);
	      cprintf("        ");
	      gotoxy(30, 22);
	      get = 1;
	      rcvd = 0;
	      nrx = 1;
	      for (n = 0; n < 8;)
		msg[n ++] = 0;
              scr.putMessage("", "Zadaj prijat sprvu. ENTER zpis QSO. ESC zruenie zpisu.");
	    }
	    if (sum.checkDupe(call, tmp_file.Name, log.Mode) > 0)
	    { // duplicitne QSO
	      beep();
	      if (rlen)
	      { // RST alebo NR je uz zadane
                scr.putMessage("DUPLICITN QSO!", "V zpise QSO pokrauj zadanm RPRT alebo ENTERom.");
		textcolor(14);
		textbackground(5);
		gotoxy(30 + rpos, 22);
	      }
	      else
	      {
                scr.putMessage("DUPLICITN QSO!", "V zpise QSO pokrauj zadanm RPRT.");
		textcolor(14);
		textbackground(5);
		gotoxy(30, 22);
		cprintf("        ");
		gotoxy(30, 22);
	      }
	      get = 1;
              break;
	    }
	    get = 1;
            if (log.Mode == 1 && cw_keyer.getAutoMesg())
                    create_msg2send(call, rst, rprt, cw_keyer.getAutoMesg() == 1 ? 5 : 2);
            if (scr.clear_msg)
              scr.putMessage("", "Zadaj prijat sprvu. ENTER zpis QSO. ESC zruenie zpisu.");
            else
              scr.clear_msg = 1;
	    gotoxy(30 + rpos, 23);
	    break;
	  }
	  if ((get || nrx) && rlen)
	  {
	    for (n = 0; n < 4; n ++)
	      rst[n] = rprt[n] = sent[n] = 0;
	    if (!rcvd && rlen < 4)
	    { // nie je zadany RST
	      strcpy(rprt, msg);
	      strcpy(rst, log.Mode - 1 ? RS : RST);
	    }
	    else
	    if (rcvd)
	    {
	      msgsplit(msg, rst, rprt);
	      if (!strlen(rprt))
	        break;
              if ((signed)strlen(rst) != (log.Mode - 1 ? 2 : 3) && strlen(rst))
              {
                if (!(log.Mode - 1) && strlen(rst) == 2)
                {  // Ak RST obsahuje dva znaky => CITATELNOST, SILA
                  *(rst + 2) = '9';
                  *(rst + 3) = 0;
                }
                if (strlen(rst) == 1)
                {   // Ak RST obsahuje iba jeden znak => SILA
                  mult = *rst;
                  strcpy(rst, log.Mode - 1 ? RS : RST);
                  *(rst + 1) = mult;
                }
                if (strlen(rst) > 3)
                  *(rst + 3) = 0;
	      }
              else
              if (!strlen(rst))
                strcpy(rst, log.Mode - 1 ? RS : RST);
            }
	    if (!rcvd && rlen > 3)
	      break;
            if (log.Mode == 1 && cw_keyer.getAutoMesg())
                    create_msg2send(call, rst, rprt, cw_keyer.getAutoMesg() == 1 ? 4 : 3);
	    strcpy(sent, log.Mode - 1 ? RS : RST);
	    mult = sum.checkMult(call);
	    point = 0;
	    nrx = 0;
	    sum.getSum(mult, sum.checkDupe(call, tmp_file.Name, log.Mode), &point, log.Mode);
	    if (!point) // duplicitne QSO
	      mult = '!';
            sprintf(rprt, "%03d", atoi(rprt));
	    if (!log.writeQSO(call, sent, rst, rprt, &time, mult, point))
	    {
	      gotoxy(30 + rpos, 22);
              scr.putErrMsg(TMPWerr);
              scr.clear_msg = 0;
	      textcolor(14);
	    }
	  case 0x1B:
            if (!clen)
              break;
            if (scr.clear_msg)
            {
              scr.updateScreen();
   	      textbackground(1);
	      gotoxy(30, 22);
	      cprintf("            ");
	      textbackground(3);
	      textcolor(0);
	      gotoxy(6, 20);
   	      cprintf("%02d-%02d-%d ", log.Day, log.Month, log.Year);
	      cprintf("%02d:%02d", time.ti_hour + log.UTC_cor, time.ti_min);
	      cprintf("  %03d", sum.QSO[2] + 1);
	      textbackground(5);
	      textcolor(14);
	      gotoxy(30, 20);
	      cprintf("            ");
              scr.putMessage("", "Zadaj znaku. Alt-H Npoveda.");
  	      get = nrx = cpos = clen = rpos = rlen = 0;
	      for (i = 0; i < (signed)sizeof(call); i++)
	        call[i] = 0;
            }
            else
              scr.clear_msg = 1;
	  }
      }
    }
  }
}


//////////////////////////////////////////////////////////////////////////////
//                            funkcia main()                                //
//////////////////////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
	signal(SIGINT, SIG_IGN);
        signal(SIGTERM, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
        signal(SIGSEGV, SIG_IGN);

	strcpy(my_prg, argv[0]);
	get_prg_dir(prg_dir);

	for (n = 0; n < (signed)sizeof(call);)
		call[n++] = 0;

	scr.clearScreen();
	textbackground(1);
	textcolor(14);
	clrscr();
	gotoxy(25, 1);
	textcolor(3);

	scr.putBox(4, 2, 77, 8, 0, 3);
	window(5, 3, 76, 7);
	gotoxy(1, 1);
	cprintf("   ͻ\n\r");
	cprintf("      /\\          OM Activity Contest LOG  v%s\n\r", VERSION);
	cprintf("       ܱ    \n\r");
	cprintf("             Copyright (C) 2000  Michal Karas, OM4ANM\n\r");
	cprintf("   ͼ");

	window(1, 1, 80, 25);
	gotoxy(1, 12);
	textbackground(1);
	textcolor(10);
	cprintf("Zlohovac sbor:         ");
	if (!tmp_file.setName(prg_dir)) {
		scr.putErrMsg(TMPWerr);
		log.save_cfg = 0;
		getch();
		halt(1);
        }
	textcolor(13);
	cprintf("    [  %s  ]\n\r", tmp_file.Name);

	textcolor(10);
	cprintf("Kontrola vonho miesta:  ");
	textcolor(13);
	cprintf("    [  %u QSO  ]\n\r", tmp_file.checkFreeSpace(MAX_QSO));

	textcolor(10);
	cw_keyer.init();

	cprintf("Natavanie dennka:      ");
	if (!(flog = fopen(LogFile, "r"))) {
		delay(500);
		window(1, 12, 80, 24);
		clrscr();
		window(1, 1, 80, 25);
		scr.putBox(3, 11, 78, 18, 15, 7);
		gotoxy(26, 11);
		cprintf(" renie a modifikovanie programu ");
		window(4, 12, 77, 17);
		cprintf("\n\r       OM Activity LOG je ABSOLTNE BEZ ZRUKY. Ide o von programov\n\r");
		cprintf("    vybavenie a jeho renie za istch podmienok je vtan;\n\r\n\r");
		cprintf("    podrobnosti sa nachdzaj v sbore \"license.txt\".\n\r");
		window(1, 1, 80, 25);
		scr.putBox(16, 21, 65, 24, 14, 4);
		gotoxy(18, 22);
		cprintf("V aktulnom adresri neexistuje iaden dennk.");
		gotoxy(18, 23);
		cprintf("Vytvori nov stanin dennk ?(A/N): ");
		textcolor(10);
		while ((c = tolower(getch())) != 'n' && c != 'a');
		cprintf("%c", c);
		if (c == 'n') {
			log.save_cfg = 0;
			exit(0);
		}
		window(1, 10, 80, 25);
		textbackground(1);
		clrscr();
		window(1, 1, 80, 25);
		if (!(flog = fopen(LogFile, "wt"))) {
			scr.putErrMsg(LOGWerr);
			getch();
			log.save_cfg = 0;
			halt(1);
		} else {
			log.save_cfg = 0;
			log.getOperatorInfo();
			textcolor(10);
			cprintf("\n\nZapisujem informcie do dennka...");
			if (*log.Name == 0)
				strcpy(log.Name, NONE);
			if (*log.QTH == 0)
				strcpy(log.QTH, NONE);
			fprintf(flog, "%s\n", log.Call);
			fprintf(flog, "%s\n", log.Name);
			fprintf(flog, "%s\n", log.QTH);
			fprintf(flog, "%u.%u.%u\n", log.Day, log.Month, log.Year);
			fprintf(flog, "%u 1\n", log.Category);
			if (fclose(flog)) {
				scr.putErrMsg(LOGWerr);
				getch();
				halt(1);
			}
			log.save_cfg = 1;
			if (!strcmp(log.Name, NONE))
				*log.Name = 0;
			if (!strcmp(log.QTH, NONE))
				*log.QTH = 0;
			sum.modMults(sum.MultsNo, sum.MultsNo, log.Call);
			sum.Mults++;
			textcolor(13);
			cprintf("    [  OK  ]\n\r");
			textcolor(10);
		}
	} else {
		fscanf(flog, "%s\n", log.Call);
		fgets(log.Name, 21, flog);
		fscanf(flog, "\n");
		fgets(log.QTH, 21, flog);
		fscanf(flog, "\n%u.%u.%u\n", &log.Day, &log.Month, &log.Year);
		fscanf(flog, "%u %u\n\n", &log.Category, &log.Mode);
		sum.MultsNo[26] = 0;
		fgets(ln, 80, flog);
		if (ln[strlen(ln) - 1] == '\n')
			ln[strlen(ln) - 1] = 0;
		else
			fscanf(flog, "\n");
		if (!strcmp(ln, SLD)) {
			if ((ftmp = fopen(tmp_file.Name, "w")) != NULL) {
				while (fgets(ln, 80, flog))
					fputs(ln, ftmp);
				if (fclose(ftmp)) {
					scr.putErrMsg(TMPWerr);
					fclose(flog);
					getch();
					log.save_cfg = 0;
					halt(1);
				}
				tmp_file.lock();
			} else {
				scr.putErrMsg(TMPWerr);
				fclose(flog);
			        getch();
				log.save_cfg = 0;
			        halt(1);
			}
		}
		fclose(flog);
		if (!strcmp(log.Name, NONEn))
			*log.Name = 0;
		if (strlen(log.Name) && log.Name[strlen(log.Name) - 1] == '\n')
			log.Name[strlen(log.Name) - 1] = 0;
		if (!strcmp(log.QTH, NONEn))
			*log.QTH = 0;
		if (strlen(log.QTH) && log.QTH[strlen(log.QTH) - 1] == '\n')
			log.QTH[strlen(log.QTH) - 1] = 0;
		sum.getQSOnum(call, tmp_file.Name);
		textcolor(13);
		cprintf("    [  OK  ]\n\r");
		textcolor(10);
	}
	delay(1000);
	window(1, 1, 80, 25);

	scr.setScreen();
	ready();

        scr.clearScreen();
	return 0;
}

