/*
 *        cw_keyer.h  -  cw_keyer support
 *			 part of OMAC project
 *	  (C)2001 Michal Karas OM4AA <om4aa@qsl.net>
 *
 *
 *	  Copying policy: GNU GPL
 */


#ifndef CW_KEYER_H
#define CW_KEYER_H


/* special symbols in messages */
#define MY_CALL		'!'
#define HIS_CALL	'@'
#define MY_RST		'$'
#define HIS_RST		'^'
#define HIS_NR		'#'
#define MY_NR		'%'
#define SPEED_UP	'+'
#define SPEED_DWN	'-'

/* default values for CW keyer */
#define DEFAULT_SPEED	230
#define DEFAULT_TONE	750
#define DEFAULT_PORT	COM1
#define DEFAULT_MSG1	"CQ TEST ! ! TEST"
#define DEFAULT_MSG2	"@ GM ^ #"
#define DEFAULT_MSG3	"TU ! TEST"
#define DEFAULT_MSG4	"CFM ^ #"
#define DEFAULT_MSG5	"!"
#define DEFAULT_MSG6	"#"
#define DEFAULT_MSG7	"@"
#define DEFAULT_MSG8	"?"

/* Ports names */
#define COM		0x0f
#define LPT		0x07
#define COM1		"COM1"
#define COM2		"COM2"
#define COM3		"COM3"
#define COM4		"COM4"
#define LPT1		"LPT1"
#define LPT2		"LPT2"
#define LPT3		"LPT3"
#define LPT4		"LPT4"

/* CW keyer config file name */
#define CW_CONFIG	"cw_keyer.cfg"
#define TEST_CHAR	'v'
#define MESSAGES_COUNT	8
#define MESSAGE_LENGTH	31
#define TX_DELAY	50


struct qso_info {
	char	my_call[15];
        char	his_call[15];
        char	my_rst[4];
        char	his_rst[4];
        char	his_nr[4];
        char	my_nr[4];
};

/* cw_keyer class */
class CW_keyer {
	int		speed;
        int		tone;
        unsigned short  port;
        char		message[MESSAGES_COUNT][MESSAGE_LENGTH];
        int		config_saved;
        char		port_name[5];
        int		port_type;
        int		to_port;
        int		enabled;
        int		inverted;
        int		auto_msg;

        void	getPortAddr(const char *);
        void	openPort();
        void	closePort();
        void	KeyDwn();
        void	KeyUp();
        void	PttOn();
        void	PttOff();
        void	sendChar(char, struct qso_info * = NULL);
        void	ti();
        void	ta();
        void	qrx(int = 1);

public:
        ~CW_keyer();
        void	init();
        void	deinit();
        void	scanPaddle();
        void	SpeedUp(int = 1);
        void	SpeedDwn(int = 1);
        int	getSpeed();
        void	ToneUp(int = 1);
        void	ToneDwn(int = 1);
        int	getTone();
        char	*getPortName();
        char	*getMessage(int, struct qso_info *);
        void	sendMessage(int, struct qso_info *);
        void	sendKey(char);
        int	invert();
        int	isInverted();
        void	enable();
        void	disable();
        int	isEnabled();
        int	setAutoMesg();
        int	getAutoMesg();
};

#endif /* CW_KEYER_H */

